/****************************************************************************/
/*
 * MODULE              JN-AN-1162 JenNet-IP Smart Home
 *
 * DESCRIPTION         BulbScene MIB Interface
 */
/****************************************************************************/
/*
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2014. All rights reserved
 */
/****************************************************************************/
#ifndef  MIBBULBSCENE_H_INCLUDED
#define  MIBBULBSCENE_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
/* SDK includes */
#include <jendefs.h>
/* JenOS includes */
#include <os.h>
#include <pdm.h>
/* Application common includes */
#include "DeviceDefs.h"
#include "Table.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
/* Bulb configuration temporary data */
typedef struct
{
	/* Config MIB variable data */
	uint16  u16AddSceneId;
	uint16  u16DelSceneId;
	/* Config MIB variable data */
   	uint8   au8SceneMode[DEVICE_SCENES];
   	uint8   au8SceneLumTarget[DEVICE_SCENES];
   	uint16 au16SceneId[DEVICE_SCENES];

} tsMibBulbSceneTemp;

/* Bulb configuration mib */
typedef struct
{
	/* Config Mib flash variable handles */
   	tsTable sSceneId;
   	tsTable sSceneMode;
   	tsTable sSceneLumTarget;

	/* Data pointers */
	tsMibBulbSceneTemp 	sTemp;

	/* Other data */
	uint32	u32NotifyChanged;

} tsMibBulbScene;

/****************************************************************************/
/***        Public Function Prototypes                                     ***/
/****************************************************************************/
PUBLIC void 			MibBulbScene_vInit(void);
PUBLIC void 			MibBulbScene_vRegister(void);
PUBLIC void 			MibBulbScene_vTick(void);
PUBLIC teJIP_Status	 	MibBulbScene_eSetAddSceneId(uint16 u16Val, void *pvCbData);
PUBLIC teJIP_Status     MibBulbScene_eSetDelSceneId(uint16 u16Val, void *pvCbData);


#if defined __cplusplus
}
#endif

#endif  /* MIBBULBSCENE_H_INCLUDED */
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
