/*****************************************************************************
 *
 * MODULE:             JN-AN-1158 (Remote)
 *
 * COMPONENT:          ZID.c
 *
 * AUTHOR:             JV
 *
 * DESCRIPTION:        ZigBee Input Device profile functionalities
 *
 * $HeadURL $
 *
 * $Revision: 9934 $
 *
 * $LastChangedBy: nxp46755 $
 *
 * $LastChangedDate: 2012-11-15 05:11:17 +0000 (Thu, 15 Nov 2012) $
 *
 * $Id: ZID.c 9934 2012-11-15 05:11:17Z nxp46755 $
 *
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142,
 * JN5139]. You, and any third parties must reproduce the copyright and
 * warranty notice and any other legend of ownership on each copy or partial
 * copy of the software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2012. All rights reserved
 *
 ***************************************************************************/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
#include "ZID.h"
/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/


/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/


/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/
HIDDMouseInputReport MouseReport;
/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/

/**
 * Sends Report Data ZID command frame to u8ReceiverPairingRef.
 * Support a single ReportDataRecord of fixed size.
 */
PUBLIC void vZID_SendReportData(uint8 u8ReceiverPairingRef, uint8 u8ReportSize,\
        teZID_ReportType eReportType, teZID_ReportID eReportId, teZID_ReportData eReportData)
{
    uint8 au8Nsdu[10];
    uint8 u8DataLen;
    uint8 u8TxOptions;

    if(eReportData == E_ZID_ReportData_MOUSE){
        au8Nsdu[0] = E_ZID_CMD_REPORT_DATA;
        au8Nsdu[1] = 5; //u8ReportSize
        au8Nsdu[2] = eReportType;
        au8Nsdu[3] = eReportId;

        au8Nsdu[4] = MouseReport.bmButtons;
        au8Nsdu[5] = MouseReport.bX;
        au8Nsdu[6] = MouseReport.bY;
        u8DataLen = 7;
    }

    u8TxOptions = RF4CE_TX_OPT_ACKNOWLEDGE | RF4CE_TX_OPT_SINGLE_CHAN;

    vRF4CE_NldeDataReq(u8ReceiverPairingRef, ZID_PROFILE_ID, 0x0000,
                       u8DataLen, au8Nsdu, u8TxOptions);

    // Keep compiler happy!
    u8ReportSize=u8ReportSize;
}


/**
 * Sends Get Report ZID command frame to u8ReceiverPairingRef.
 */
PUBLIC void vZID_SendGetReport(uint8 u8ReceiverPairingRef, teZID_ReportType eReportType, uint8 u8ReportId)
{
    uint8 au8Nsdu[10];
    uint8 u8DataLen;
    uint8 u8TxOptions;

    au8Nsdu[0] = E_ZID_CMD_GET_REPORT;
    au8Nsdu[1] = eReportType;
    au8Nsdu[2] = u8ReportId;
    u8DataLen = 3;

    u8TxOptions = RF4CE_TX_OPT_ACKNOWLEDGE | RF4CE_TX_OPT_SINGLE_CHAN;

    vRF4CE_NldeDataReq(u8ReceiverPairingRef, ZID_PROFILE_ID, 0x0000,
                       u8DataLen, au8Nsdu, u8TxOptions);
}
/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
