/*****************************************************************************
 *
 * MODULE:             JN-AN-1158 (Remote)
 *
 * COMPONENT:          Config.h
 *
 * AUTHOR:             JMB
 *
 * DESCRIPTION:        Configuration file
 *
 * $HeadURL $
 *
 * $Revision: 9957 $
 *
 * $LastChangedBy: nxp46755 $
 *
 * $LastChangedDate: 2012-11-23 06:49:47 +0000 (Fri, 23 Nov 2012) $
 *
 * $Id: Config.h 9957 2012-11-23 06:49:47Z nxp46755 $
 *
 *
 ****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142,
 * JN5139]. You, and any third parties must reproduce the copyright and
 * warranty notice and any other legend of ownership on each copy or partial
 * copy of the software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2012. All rights reserved
 *
 ***************************************************************************/

#include "ZRC.h"

/* Keypad setup*/
#define ROW_DIO 0x0003E000          /* Keypad Row Dio Setup */
#define COL_DIO 0x00001F00          /* Keypad Col Dio Setup */
#define ROWS 7                      /* Number of rows on the keypad */
#define COLS 5                      /* Number of colums on the keypad */
#define ERR 0xFF                    /* Key press Error Value*/

/* Pair Defines */
#define PAIR_BUTTONS             0x5000 /* PAUSE AND PLAY TOGETHER*/
#define PAIR                     0xFE   /* Pair Value*/
#define    SET_REC_AUTO_DISC     0xFD

/* Screen Pos direction defines */
#define DIRECTION_DOWN          0
#define DIRECTION_UP            1

/* Screen options */
#define SETUP_SCREEN            5

/* Debounce key pad */
#if defined(EK020)
    #define CONFIGDEBOUNCE      80000
#elif defined(EK001)
    #define CONFIGDEBOUNCE      40000
#endif

/* Timer */
#define TICK_PERIOD_ms                  1UL
#define CPU_CLOCK_FREQ_HZ               16000000UL
#define TICK_TIMER_TICK_PERIOD_COUNT    (16000UL * TICK_PERIOD_ms)
/* Timer clocked at (16MHz / (2^TIMER_PRESCALE)) */
#define TIMER_PRESCALE                  0UL


