/*****************************************************************************
 *
 * MODULE:             JN5148
 *
 * DESCRIPTION:        Linker command file for an application using JN5148
 *                     
 *****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5148, JN5142,
 * JN5139]. You, and any third parties must reproduce the copyright and
 * warranty notice and any other legend of ownership on each copy or partial
 * copy of the software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2012. All rights reserved
 *
 *****************************************************************************
 *
 * $HeadURL: http://svn/sware/Projects/Chip/Modules/JN5148/Tags/CHIP_JN5148_1v2_RC2/Build/AppBuild_JN5148.ld $
 *
 * $Revision: 22071 $
 *
 * $LastChangedBy: mwild $
 *
 * $LastChangedDate: 2009-06-29 10:48:10 +0100 (Mon, 29 Jun 2009) $
 *
 * $Id: AppBuild_JN5148.ld 22071 2009-11-19 14:22:37Z mwild $
 *
 ****************************************************************************/
   
SECTIONS
{  
        .DISPLAY _overlay_start :
        AT ( _overlay_lma )
        {
        *(.ovly.DISPLAY)
        *(.ovly.DISPLAY.*)
        . = ALIGN((.), 16);
        } >ram

        _overlay_len = MAX((_overlay_len), SIZEOF(.DISPLAY));
        _overlay_lma = ALIGN(_overlay_lma + SIZEOF(.DISPLAY) - (_enc_offset), 16) + _enc_offset;
        
        _overlays += 1;
        
        .overlay_location :
        {
        LONG(0)
        SHORT(SIZEOF(.DISPLAY))
        SHORT(0)
        LONG(0)
        LONG(0)
        } > flash   
}
