
#-----------------------------------------------------------------------------
#
# FILE:  startup.s
#
# DESCRIPTION: 
#
#  This file is where the external interrupt vector definitions are for the 
#  external interrupt handler. It is also where the assembly part of the 
#  external interrupt handler is. This module also initializes vector 0x500
#  for this handler. The stack frame is established here as well as zeroing
#  out the .bss or uninitialized data section. The start of code execution 
#  starts here. Keep in mind that all assembly directives are Diabs 
#  assembler.
#
# REFERENCES: 
#
#      1) MPC8260 Users Manual
#      2) PowerPC Microprocessor Family: The Programming Environments for 
#         32-Bit Microprocessors
#
# HISTORY:
#
# 8/5/98        sgj      Initial Diab Version
#
#-----------------------------------------------------------------------------

.file "startup.s"

#****************************************************************
#
# 
# 
#****************************************************************
.extern main,__SP_INIT 

 .text
 .align 2

	.globl _start

_start:   

	ori		r12,r0,0x0C00		
	sync
	mtspr	HID0, r12  		  ; Flash invalidate Instruction and
							  ; data caches
	isync

#****************************************************************
#
# STACK SET-UP:
#
# If your system does not have a loader that sets up the 
#  applications stack before passing control to the application, 
#  or if the application is responsible for setting up its own 
#  stack, use or modify the code provided below.
#
# On most systems that allow dynamic expansion of the stack, 
#  stack set-up is done by the systems loader.  If you have a 
#  system loader that sets up the stack for your application, 
#  comment out the code between [begin] and [end] in the 
#  following section.
#
# NOTE:  If your system has an operating system and you
#        want to return control to the operating system
#        at application termination, then it is better 
#        to have the loader set up the applications
#        stack.  Otherwise, you will need to use the 
#        code below to save the system stack--a more 
#        complicated process.
#
#****************************************************************

#-------------------- set up frame stack -----------------

# allocate space for stack. Stack characteristics defined in
# linker file.

   #------------------------------------------------------------------------
   # SP_INIT this value is defined in atm_aalx.lnx which is a linker 
   # file.
   #------------------------------------------------------------------------

   addis    r1,r0,__SP_INIT@h  
   ori      r1,r1,__SP_INIT@l

   #----------------------------------------------------------------------
   # load the stack pointer 72 bytes down from top of stack to ensure one
   # stack frame of safety margin. 
   #----------------------------------------------------------------------

   stwu  r0,-72(r1)      
                            


#****************************************************************
# In a real program, where the rom monitor is not being used in 
# this example, PowerPC initialization code would go here.
#****************************************************************

# -->insert initialization code here


# Turn on FPU and turn off exceptions

	mfmsr	r3
	ori		r3,r3,0x2000    # Turn on the FPU 
	oris	r4,r4,0xFFFF
	ori		r4,r4,0x7FFF    # Disable Exceptions 
	and		r3,r3,r4
	mtmsr	r3


#****************************************************************
#
# jump to main()
#
#****************************************************************

   bl      main

#****************************************************************
#
#  If for what ever reason we get here, spin.
#
#****************************************************************

SPIN_HERE:

   nop
   b   SPIN_HERE


#*****************************************************************************
#
#       ABI Stack Layout
#
# Reference: PowerPC Processor ABI Supplement 9/95
#
#             Low Address
# ----------------------------------------------
# | C Frame (Quad-Word Aligned)                | Word 0    <- Updated SP
# |   Contents:  LR, R1 (Back Chain),          | Word 1
# |              PADDING                       | Word 2
# |   TOTAL: 4 Words                           | Word 3
# ----------------------------------------------
# | Interrupt STACK Frame (Quad-Word Aligned)  | Word 0
# | Contents In Exact Order:                   |
# |  R0-R12,SRR0,SRR1,LR,CTR,XER,CR, (19 W)    |
# |  PADDING (1 W)                             |
# |                                            |
# |  NOTE:  R1,R2 Not Saved On Stack           |
# |                                            |
# |  TOTAL:  20 Words                          | Word 19
# ----------------------------------------------
# | R1 (Back Chain)                            | Word 0    <- Original SP
# ----------------------------------------------
#             High Address
#
#*****************************************************************************

.extern ExtIntHandler

#-----------------------------
# Globally accessible symbols
#-----------------------------

.globl ExtIntTable

.globl DecrementerInt

#-------------------------------------------------
# PowerPC Defined Vector for External Interrupt
#-------------------------------------------------

 EXTERNAL_INTERRUPT_VECTOR:   .equ	0x500

#-------------------------------------------------
# ABI Compliant Interrupt StackFrame Space
#-------------------------------------------------
              
 R0_OFFSET:	   .equ	 (0*4)	 # R0 Stack Offset
 R1_OFFSET:	   .equ	 (1*4)	 # R1 Stack Offset
 R2_OFFSET:	   .equ	 (2*4)	 # R2 Stack Offset
 R3_OFFSET:	   .equ	 (3*4)	 # R3 Stack Offset
 R4_OFFSET:	   .equ	 (4*4)	 # R4 Stack Offset
 R5_OFFSET:	   .equ	 (5*4)	 # R5 Stack Offset
 R6_OFFSET:	   .equ	 (6*4)	 # R6 Stack Offset
 R7_OFFSET:	   .equ	 (7*4)	 # R7 Stack Offset
 R8_OFFSET:	   .equ	 (8*4)	 # R8 Stack Offset
 R9_OFFSET:	   .equ	 (9*4)	 # R9 Stack Offset
 R10_OFFSET:	.equ	 (10*4)	 # R10 Stack Offset
 R11_OFFSET:	.equ	 (11*4)	 # R11 Stack Offset
 R12_OFFSET:	.equ	 (12*4)	 # R12 Stack Offset
 SRR0_OFFSET:	.equ	 (13*4)	 # SRR0 Stack Offset
 SRR1_OFFSET:	.equ	 (14*4)	 # SRR1 Stack Offset
 LR_OFFSET:	   .equ	 (15*4)	 # LR Stack Offset
 CTR_OFFSET:	.equ	 (16*4)	 # CTR Stack Offset
 XER_OFFSET:	.equ	 (17*4)	 # XER Stack Offset
 CR_OFFSET:	   .equ	 (18*4)	 # CR Stack Offset
 STACK_SZ:	   .equ	 (20*4)   # Quad-Word Aligned Interrupt Stack Frame
 C_FRAME_SZ:	.equ	 (4*4)    # Quad-Word Aligned C Frame Size


#-------------------------------------------------
# Special Purpose Register Indices for SRR0, SRR1
#-------------------------------------------------

 SRR0:    .equ      26    # Save/Restore Register 0
 SRR1:    .equ      27    # Save/Restore Register 1

#*****************************************************************************
# This is the external interrupts vector table entry for the MPC8260.
# This code is setup for handling non-reentrant external interrupts.
#
# The following are the steps, in order, taken by the External Interrupt
# Table Code:
# 1) Save following Registers:  gpr0, gpr3-gpr12, CR, XER, LR, CTR
#    on stack as necessary to preserve user state across the interrupt
#    handler.  Save SRR0, SRR1 to provide breakpoint/debug support for
#    Interrupt Code.
# 2) The exception vector (0x500) is saved in register r3.
# 3) Absolute Branch and Link to C routine to complete interrupt processing.
# 4) Restore Registers in (1) from stack.
# 5) Execute rfi instruction to return from supervisor-state interrupt handler.
#*****************************************************************************

 .text
DecrementerInt:

    rfi

ExtIntTable:

#-----------------------------------------------------
# Save USER State
#-----------------------------------------------------

#-----------------------------------------------------
# Save r0 -- Volatile Register
# Update SP (r1) (Allocate Interrupt STACK frame)
#-----------------------------------------------------

    stwu	r0, -STACK_SZ+R0_OFFSET(r1)

#---------------------------------------------------------------
# Save SRR0, SRR1
# NOTE:  DO NOT Trace or Set Breakpoint Before SRR0, SRR1 Saved
#---------------------------------------------------------------

    mfspr	r0, SRR0
    stw	r0, SRR0_OFFSET(r1)
    mfspr	r0, SRR1
    stw	r0, SRR1_OFFSET(r1)

#--------------------------------------------
# Save r3-r12 -- Volatile Registers
#--------------------------------------------

    stw	r3,  R3_OFFSET(r1)    # Store r3
    stw	r4,  R4_OFFSET(r1)    # Store r4
    stw	r5,  R5_OFFSET(r1)    # Store r5
    stw	r6,  R6_OFFSET(r1)    # Store r6
    stw	r7,  R7_OFFSET(r1)    # Store r7
    stw	r8,  R8_OFFSET(r1)    # Store r8
    stw	r9,  R9_OFFSET(r1)    # Store r9
    stw	r10, R10_OFFSET(r1)   # Store r10
    stw	r11, R11_OFFSET(r1)   # Store r11
    stw	r12, R12_OFFSET(r1)   # Store r12

#----------------
# Store LR
#----------------

    mflr	r0
    stw	r0, LR_OFFSET(r1)

#----------------
# Save CTR
#----------------

    mfctr   r0
    stw	r0, CTR_OFFSET(r1)

#----------------
# Save XER
#----------------

    mfxer   r0
    stw	r0, XER_OFFSET(r1)

#----------------
# Save CR
#----------------

    mfcr	r0
    stw	r0, CR_OFFSET(r1)

#----------------------------------
# Allocate C FRAME (1-Quad Word)
#----------------------------------

    subi	r1,r1,C_FRAME_SZ

#----------------------------------------------------
# Place External Interrupt Vector in r3
#----------------------------------------------------

    addi	r3,r0,EXTERNAL_INTERRUPT_VECTOR

#----------------------------------------------------
# Execute external interrupt handler
#----------------------------------------------------

    bla ExtIntHandler

#----------------------------------------------------
# Restore USER State
#----------------------------------------------------

#----------------------------------------------------
# Deallocate C FRAME (1-Quad Word)
#----------------------------------------------------

    addi	r1,r1,C_FRAME_SZ

#--------------
# Restore CR
#--------------

    lwz	r0, CR_OFFSET(r1)
    mtcrf	0xff,r0

#--------------
# Restore XER
#--------------

    lwz	r0, XER_OFFSET(r1)
    mtxer   r0

#--------------
# Restore CTR
#--------------

    lwz	r0, CTR_OFFSET(r1)
    mtctr   r0

#-------------
# Restore LR
#-------------

    lwz	r0, LR_OFFSET(r1)
    mtlr	r0

#--------------------------------------
# Restore r12-r3 -- Volatile Registers
#--------------------------------------

    lwz	r12, R12_OFFSET(r1)   # Store r12
    lwz	r11, R11_OFFSET(r1)   # Store r11
    lwz	r10, R10_OFFSET(r1)   # Store r10
    lwz	r9,  R9_OFFSET(r1)    # Store r9
    lwz	r8,  R8_OFFSET(r1)    # Store r8
    lwz	r7,  R7_OFFSET(r1)    # Store r7
    lwz	r6,  R6_OFFSET(r1)    # Store r6
    lwz	r5,  R5_OFFSET(r1)    # Store r5
    lwz	r4,  R4_OFFSET(r1)    # Store r4
    lwz	r3,  R3_OFFSET(r1)    # Store r3

#-----------------------------------------------------------------
# Save SRR1, SRR0
# NOTE:  DO NOT Trace or Set Breakpoint After SRR1, SRR0 Restored
#-----------------------------------------------------------------

    lwz	r0, SRR1_OFFSET(r1)
    mtspr	SRR1, r0

    lwz	r0, SRR0_OFFSET(r1)
    mtspr	SRR0, r0

#---------------------------------------------------
# Restore r0 -- Volatile Register
# Update SP (r1) (Deallocate Interrupt STACK frame)
#---------------------------------------------------

    lwz	r0, R0_OFFSET(r1)
    addi	r1, r1, STACK_SZ        

# ----------------------------------------------------
# Return from interrupt handler in supervisor state to user code
# ----------------------------------------------------

    rfi

 .word 64   # pad space



