/*-----------------------------------------
*
* FILE:  download.c
*
* DESCRIPTION: 
*
*  Simple example 'C' code for downloading RAM microcodes to different 
*  silicon revisions and derivatives of the PQ2 family 

*  Rev History:
*  August 2004     PDW		Initial example Code
*  
*--------------------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h> 
#include "netcomm.h"       /* global defines */
#include "mpc82xx.h"       /* 82xx Internal Memory Map structures */ 


/***********************/
/* Global Declarations */
/***********************/

t_PQ2IMM *IMM_ptr;

UBYTE	uCode_type;

#define HIP3_C2		1
#define HIP4_B1		2
#define HIP7_00		3

#define DPR_BASE  0x04700000

void main(void);
void Rev_Num();	
void LoadUCODE(UWORD dpr_base);
void SetRegs();	

void GP1led(UHWORD);
void FlashGP1led(void);

UWORD revnum;
BOOL hip4; 
BOOL hip7;
	
/*--------------------------------------------------------------------------
*
* FUNCTION NAME:  main 
*
* DESCRIPTION:
*
* This is the main function for the Download example code.  It is responsible
* for the following tasks: 
*
* 1. Clearing microcode registers 
* 2. Determining PQ2 Silicon Revision
* 3. Downloading RAM based microcode (In this example ucode fix for CPM115)
* 4. Enabling microcode in RCCR and setting trap register values.
*
* EXTERNAL EFFECT: 
*                 
* PARAMETERS:  None
*
* RETURNS: None
*
*-------------------------------------------------------------------------*/

void main()
{
   	
   	/*---------------------------------------*/
   	/* Establish Internal Memory Map Pointer */
   	/*---------------------------------------*/
   
   	IMM_ptr = (t_PQ2IMM *)DPR_BASE;
   
   	memset((UBYTE *)(DPR_BASE),0,0x4000); /* Clear contents of DPRAM */

	/*--------------------------------------------------*/
	/* Clear RCCR, microcode traps and break point regs */
	/*--------------------------------------------------*/
	
	IMM_ptr->cpm_rccr &= ~0x0000f000;
	
	/* Microcode breakpoint Register */
	IMM_ptr->cpm_rmdr = 0;
	
	/* Microcode Traps 1-8 Registers */
	IMM_ptr->cpm_rctr1 = 0;
	IMM_ptr->cpm_rctr2 = 0;
	IMM_ptr->cpm_rctr3 = 0;
	IMM_ptr->cpm_rctr4 = 0;
	IMM_ptr->cpm_rctr5 = 0;
	IMM_ptr->cpm_rctr6 = 0;
	IMM_ptr->cpm_rctr7 = 0;
	IMM_ptr->cpm_rctr8 = 0;

	
	Rev_Num(); /* Determine Silicon Revision */
	
	LoadUCODE(DPR_BASE); /* Load RAM microcode */
	
	SetRegs(); /* Enabled RCCR and set trap values */
	
	
 while (1) 

    {
        
        FlashGP1led();
 
    };


}  /* End Main */


extern unsigned long ucode_Hip3_RevC2[];
extern unsigned long ucode_Hip4_RevB1[];
extern unsigned long ucode_Hip7_Rev00[];


void LoadUCODE(UWORD dpr_base)
{
	int i=0;
  	unsigned long addr;
  
  	switch(uCode_type)
  	{		
 			
 		case HIP3_C2:
			
			while(!(ucode_Hip3_RevC2[i]==0 && ucode_Hip3_RevC2[i+1]==0)){
  			addr = ucode_Hip3_RevC2[i];
  			addr = (addr & 0x0001ffff) | (dpr_base & 0xfffe0000);
  			*((UWORD *) addr) = ucode_Hip3_RevC2[i+1];
 			i+=2; }
 			
 			break;	
 			
 			
 		case HIP4_B1:
			
			while(!(ucode_Hip4_RevB1[i]==0 && ucode_Hip4_RevB1[i+1]==0)){
  			addr = ucode_Hip4_RevB1[i];
  			addr = (addr & 0x0001ffff) | (dpr_base & 0xfffe0000);
  			*((UWORD *) addr) = ucode_Hip4_RevB1[i+1];
 			i+=2; }	
		
			break;
			
			
		case HIP7_00:
			
			while(!(ucode_Hip7_Rev00[i]==0 && ucode_Hip7_Rev00[i+1]==0)){
  			addr = ucode_Hip7_Rev00[i];
  			addr = (addr & 0x000fffff) | (dpr_base & 0xfff00000);
  			*((UWORD *) addr) = ucode_Hip7_Rev00[i+1];
 			i+=2; }	
		
			break;
			
  	}
  	
}
  	

void Rev_Num()
{
	
    /*-----------------------------------------------*/
	/* Assume Hip3 is the default silicon revision   */
	/*-----------------------------------------------*/
    
    hip4 = 0;
    hip7 = 0;
    
	/*---------------------------------------------------------------------*/
	/* Determine Silicon Revision from IMMR[MASK_NUM] and CPM Revision Num */
	/*---------------------------------------------------------------------*/
	
    revnum = (IMM_ptr->memc_immr & 0xffff) << 16;
    revnum |= *((UHWORD*) ((UWORD)IMM_ptr + 0x8AF0));

    /*----------------------------------------------*/
    /* Determine microcode version to be downloaded */
    /*----------------------------------------------*/
        
    switch(revnum)
    	{
    		
            case 0x0024007b: /* Hip3 Rev C2 */
    			uCode_type = HIP3_C2;
    			break;    
            
            case 0x0062002D: /* Hip4 Rev B1 */
                uCode_type = HIP4_B1;
                hip4 = 1;
                break;
                
            case 0x0a000070: /* Hip7 Rev 00 */
                uCode_type = HIP7_00;
                hip7 = 1;
                break;                 
                
        } /* switch */

}


void SetRegs()
{
	/*-------------------------------------------------------------------*/
    /* Set RCCR and Traps values depending on Silicon Revision microcode */
    /*-------------------------------------------------------------------*/
	
	switch(uCode_type)
		{
		
		case HIP3_C2: 
			IMM_ptr->cpm_rccr = 0x00002000;
			IMM_ptr->cpm_rctr1 = 0xaa47;
			IMM_ptr->cpm_rctr2 = 0x0000;
			IMM_ptr->cpm_rctr3 = 0x0000;
			IMM_ptr->cpm_rctr4 = 0x0000;	  
            break;
		
		
		case HIP4_B1: 
			IMM_ptr->cpm_rccr = 0x00003000;
			IMM_ptr->cpm_rctr1 = 0xb067;
			IMM_ptr->cpm_rctr2 = 0x0000;
			IMM_ptr->cpm_rctr3 = 0x0000;
			IMM_ptr->cpm_rctr4 = 0x0000;			
			break;
			
		case HIP7_00:
			IMM_ptr->cpm_rccr = 0x00004000;
			IMM_ptr->cpm_rctr1 = 0xadf7;
			IMM_ptr->cpm_rctr2 = 0x0000;
			IMM_ptr->cpm_rctr3 = 0x0000;
			IMM_ptr->cpm_rctr4 = 0x0000;
			IMM_ptr->cpm_rctr5 = 0x0000;
			IMM_ptr->cpm_rctr6 = 0x0000;
			IMM_ptr->cpm_rctr7 = 0x0000;
			IMM_ptr->cpm_rctr8 = 0x0000;			
			break; 
						                	     
     } /* switch */

}


void GP1led(UHWORD setting)

{

BCSR *csr;

   csr = (BCSR *)(IMM_ptr->memc_regs[1].br & 0xFFFF8000);

   if (setting)

      csr->bcsr0 &= ~GP1_LED;   /* turn on LED, active low */

   else

      csr->bcsr0 |= GP1_LED;    /* turn off LED, active high */


} /* end GP1led */


void FlashGP1led()

{

UBYTE  ii;
UWORD jj;

   for (ii = 0; ii<20; ii++)
     
   {

      GP1led(ii%2);  /* Turn on every other time through the loop */

      for (jj=0; jj < 100000; jj++);    /* Wait */

   }

  
   GP1led(0);  /* LED off */


} /* end FlashGP1led */






