/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2023-2023 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_mmc.h"


/* Request codes */
#define RPMB_REQ_KEY		1
#define RPMB_REQ_WCOUNTER	2
#define RPMB_REQ_WRITE_DATA	3
#define RPMB_REQ_READ_DATA	4
#define RPMB_REQ_STATUS		5

/* Response code */
#define RPMB_RESP_KEY			0x0100
#define RPMB_RESP_WCOUNTER		0x0200
#define RPMB_RESP_WRITE_DATA	        0x0300
#define RPMB_RESP_READ_DATA		0x0400

/* Error codes */
#define RPMB_OK				0
#define RPMB_ERR_GENERAL		1
#define RPMB_ERR_AUTH	    	        2
#define RPMB_ERR_COUNTER		3
#define RPMB_ERR_ADDRESS		4
#define RPMB_ERR_WRITE			5
#define RPMB_ERR_READ			6
#define RPMB_ERR_KEY			7
#define RPMB_ERR_CNT_EXPIRED	        0x80
#define RPMB_ERR_MSK			0x7

/* Sizes of RPMB data frame */
#define RPMB_SZ_STUFF		196
#define RPMB_SZ_MAC		32
#define RPMB_SZ_DATA		256
#define RPMB_SZ_NONCE		16

#define SHA256_BLOCK_SIZE	64

/* Structure of RPMB data frame. */
typedef struct __rpmb_frame {
	unsigned char stuff[RPMB_SZ_STUFF];
	unsigned char mac[RPMB_SZ_MAC];
	unsigned char data[RPMB_SZ_DATA];
	unsigned char nonce[RPMB_SZ_NONCE];
	unsigned int write_counter;
	unsigned short address;
	unsigned short block_count;
	unsigned short result;
	unsigned short request;
}rpmb_frame_t;

/* Error messages */
static const char * const rpmb_err_msg[] = {
	"",
	"General failure",
	"Authentication failure",
	"Counter failure",
	"Address failure",
	"Write failure",
	"Read failure",
	"Authentication key not yet programmed",
};

typedef struct mbedtls_md_info_t mbedtls_md_info_t;

#if defined(__cplusplus)
extern "C" {
#endif

// big endian to CPU byte order (little endian)
static inline uint16_t be16_to_cpu(uint16_t x);
static inline uint32_t be32_to_cpu(uint32_t x);
// CPU to big endian byte order (little endian)
static inline uint16_t cpu_to_be16(uint16_t x);
static inline uint32_t cpu_to_be32(uint32_t x);

extern const mbedtls_md_info_t *mbedtls_md_info_from_string(const char *md_name);

extern int mbedtls_md_hmac( const mbedtls_md_info_t *md_info, const unsigned char *key, size_t keylen,
                const unsigned char *input, size_t ilen,
                unsigned char *output );

status_t mmc_rpmb_request(mmc_card_t *card, rpmb_frame_t *s, unsigned int count, bool is_rel_write);

status_t mmc_rpmb_response(mmc_card_t *card, rpmb_frame_t *s, unsigned int count, unsigned short expected);

status_t mmc_rpmb_status(mmc_card_t *card, unsigned short expected);

status_t mmc_rpmb_get_counter(mmc_card_t *card, unsigned long *pcounter);

status_t mmc_rpmb_set_key(mmc_card_t *card, const uint8_t *key);

uint8_t mmc_rpmb_read(mmc_card_t *card, uint8_t *addr, unsigned short blk, unsigned short cnt, const uint8_t *key);

uint8_t mmc_rpmb_write(mmc_card_t *card, uint8_t *addr, unsigned short blk, unsigned short cnt, const uint8_t *key);


#if defined(__cplusplus)
}
#endif
