/*
 * @brief Secondary loader app entry point
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "chip.h"

#include "sl_common.h"
#include "app_usbd_cfg.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/* App boot function (loads SP and jumper to reset vector for app) */
extern void secondaryLoaderAppEntry(void);

/*****************************************************************************
 * Private functions
 ****************************************************************************/
#if defined ( __CC_ARM )
/* Dedicate for MDK */
/* Change StackPointer to RAM place */
__asm prepare_entry(void)
{
	CPSID	I				; Disable ints at core
	LDR R0, =0x0
	LDR R0, [R0, #0]		; Reset stack pointer
	MOV SP, R0

	LDR R0, =0x10000000		; Must match SL_ADDRESS_APPCALLEDFL value only for LPC11U6X

	LDR R1, =0x1
	STRB R1, [R0]			; FLASH boot sets pushAppFlag to 0
}
#endif

#if   defined ( __GNUC__ )
extern void SystemInit(void);
extern int main(void);

void secondaryLoaderAppEntry(void)
{
	__ASM volatile ("cpsid i" : : : "memory");		/* __disable_irq */
	__ASM volatile ("LDR r0, =0x0");
	__ASM volatile ("LDR r0, [r0, #0]");			/* Reset stack pointer */
	__ASM volatile ("MOV sp, r0");

	__ASM volatile ("LDR r0, =0x10000000");			/* Must match SL_ADDRESS_APPCALLEDFL value only for LPC11U6X */

	__ASM volatile ("LDR r1, =0x1");
	__ASM volatile ("STRB r1, [r0]");				/* FLASH boot sets pushAppFlag to 1 */

	SystemInit();									/* Basic System Initial */
	main();											/* Jump to main app */
}
#endif

/*****************************************************************************
 * Public functions
 ****************************************************************************/

/* Secondary boot loader entry point from app */
bool secondaryLoaderEntry(void)
{
	/* Set main clock to IRC*/
	Chip_Clock_SetMainClockSource(SYSCTL_MAINCLKSRC_IRC);
	/* Start loader, will not return */
	/* Entery Secondary bootloader */
	secondaryLoaderAppEntry();

	return true;
}

// end file
