#!/bin/bash
BASEDIR="$( dirname "$0" )"
SCRIPT=$(basename $0)

#change to script directory
cd "$BASEDIR"
printf "\n"

#count number of .dfu in script directory. if 1, download .dfu, else quit
FILENUM=$(find . -name "*.dfu" | wc -l | tr -d ' ')
printf "Counting number of .dfu present in script directory...\n"

if [ $FILENUM -eq 1 ]
then
	DFUNAME=$(find . -name "*.dfu")
	DFUNAME=${DFUNAME:2}
  	printf "Found one .dfu: %s.\n" $DFUNAME
  	printf "Make sure the device is connected and ready to receive the update!\n"
  	read -n1 -rs -p "Press any key to continue..."
  	printf "\n"
  	./dfu-util_mac -e
  	sleep 2
  	./dfu-util_mac -t 64 -D $DFUNAME
  	sleep 2
  	exit 0
else
	printf "Found %s .dfu files.\n" $FILENUM
	printf "Please make sure that there is exactly ONE .dfu in the script directory!!\n"
	sleep 5
	exit 0
fi

