/*
 * @brief Power Management Controller example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2013
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */
 
#include <stdlib.h>
#include <string.h>
#include "board.h"
#include "chip.h"

/*****************************************************************************
 * Public functions
 ****************************************************************************/

/**
 * @brief	Event router interrupt handler
 * @return	Nothing
 */
void EVRT_IRQHandler(void)
{
	/* Toggle LED6 to know the MCU has woken up */
	LPC_GPIO_PORT->B[4][13] = 1;
	if (Chip_EVRT_IsSourceInterrupting(EVRT_SRC_WAKEUP0)) {
		Chip_EVRT_ClrPendIntSrc(EVRT_SRC_WAKEUP0);
		Chip_EVRT_SetUpIntSrc(EVRT_SRC_WAKEUP0, DISABLE);
	}

	if (Chip_EVRT_IsSourceInterrupting(EVRT_SRC_RTC)) {
		if (Chip_RTC_GetIntPending(LPC_RTC, RTC_INT_ALARM)) {
			Chip_RTC_ClearIntPending(LPC_RTC, RTC_INT_ALARM);
			Chip_EVRT_ClrPendIntSrc(EVRT_SRC_RTC);
			Chip_RTC_Enable(LPC_RTC, DISABLE);
			Chip_EVRT_SetUpIntSrc(EVRT_SRC_RTC, DISABLE);
		}
	}
}
