/*
 * @brief LPC8xx clock driver
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2012
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licenser disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#ifndef __FW_IAP_8XX_H_
#define __FW_IAP_8XX_H_

#ifdef __cplusplus
extern "C" {
#endif

/** @defgroup CLOCK_8XX CHIP: LPC8xx F/W IAP example
	* @ingroup CHIP_8XX_EXAMPLE
 * @{
 */

#ifdef __ICCARM__
#define ASTR(str)  #str
#define ALIGN(x) _Pragma(ASTR(data_alignment=##x)) 
#else
#define ALIGN(x) __attribute__((aligned(x)))
#endif
	
#define		DATA_SIZE					(64) 
#define		LAST_DATA_PACK		(0xff) 
	
typedef struct {
	uint8_t  	type;							/*!< message type: UPDATE_REQ: request to update; DATA_PACK: FW data package*/
	uint8_t	 	ctrl_flag;				/*!< control flag: LAST_DATA_PACK: the last data package; others reserved*/
	uint32_t	fragment_num;			/*!< number of fragment data package  */
	uint8_t		retry_num;				/*!< retry number  */	
	uint8_t 	data[DATA_SIZE];	/*!< data to be transmitted */
}FW_MESSAGE_T;

/* message transfer state */
typedef enum {
	MS_RX_START,
	MS_RX_WAIT,
	MS_FW_REQ_RX_OK,
	MS_FW_DATA_RX_OK,
	MS_RX_ERR,
	MS_RX_ACK,
}MS_STATUS_T;


void setupUART(void);
void Init_UART_PinMux(void);
void UART_get_message(uint8_t *ms_status);

uint32_t setup_IAP(void);
uint8_t firmware_IAP(uint32_t *data, uint32_t data_size);
uint8_t update_boot_info(void);
uint8_t update_chk_info(void);
void gen_firmware_signature(void);
/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif /* __FW_IAP_8XX_H_ */
