/*
 * @brief SPI example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2012
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"
#include "Ap_29demo.h"	

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/
#define BS                  15
#define BUSY                27
#define RES                 13
#define DC                  17
#define CS                  18
#define VPP                 19
#define RW_TEST             0
#define LOOPBACK_TEST       0
#define BUFFER_SIZE         10
#define SPI_MODE_TEST       (SPI_MODE_MASTER)
// #define SPI_MODE_TEST		(SPI_MODE_SLAVE)
#define POLLING_MODE        1
#if POLLING_MODE
#define INTERRUPT_MODE      0
#else
#define INTERRUPT_MODE      1
#endif

#define LPC_SPI           LPC_SPI1
#define SPI_IRQ           SPI1_IRQn
#define SPIIRQHANDLER     SPI1_IRQHandler

/* Tx buffer */
static uint16_t TxBuf[BUFFER_SIZE];

/* Rx buffer */
static uint16_t RxBuf[BUFFER_SIZE];

// static SPI_CONFIG_T ConfigStruct;
static SPI_DELAY_CONFIG_T DelayConfigStruct;

static SPI_DATA_SETUP_T XfSetup;
static volatile uint8_t  isXferCompleted = 0;

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/* Initializes pin muxing for SPI1 interface - note that SystemInit() may
   already setup your pin muxing at system startup */
static void Init_SPI_PinMux(void)
{
#if (defined(BOARD_NXP_LPCXPRESSO_812) || defined(BOARD_LPC812MAX))
	/* Enable the clock to the Switch Matrix */
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);
	/*
	 * Initialize SSP0 pins connect
	 * SCK1: PINASSIGN4[31:24]: Select P0.12
	 * MOSI1: PINASSIGN5[7:0]: Select P0.14
	 * MISO1: PINASSIGN5[15:8] : Select P0.6
	 * SSEL1: PINASSIGN5[23:16]: Select P0.13
	 */
	Chip_SWM_DisableFixedPin(SWM_FIXED_VDDCMP);
	Chip_SWM_MovablePinAssign(SWM_SPI1_SCK_IO, 12);
	Chip_SWM_MovablePinAssign(SWM_SPI1_MOSI_IO, 14);
#if defined(BOARD_LPC812MAX)
	Chip_SWM_MovablePinAssign(SWM_SPI1_MISO_IO, 15);
#else
	Chip_SWM_MovablePinAssign(SWM_SPI1_MISO_IO, 6);
#endif
	Chip_SWM_MovablePinAssign(SWM_SPI1_SSEL_IO, 13);

	/* Disable the clock to the Switch Matrix to save power */
	Chip_Clock_DisablePeriphClock(SYSCTL_CLOCK_SWM);
#elif defined(BOARD_NXP_LPCXPRESSO_824)
	//Chip_SWM_MovablePinAssign(SWM_SPI1_SSEL0_IO, 15);
	Chip_SWM_MovablePinAssign(SWM_SPI1_SCK_IO, 24);
	Chip_SWM_MovablePinAssign(SWM_SPI1_MISO_IO, 25);
	Chip_SWM_MovablePinAssign(SWM_SPI1_MOSI_IO, 26);
#else
	/* Configure your own SPI pin muxing here if needed */
#warning "No SPI pin muxing defined"
#endif
}

/* Initialize buffer */
static void bufferInit(void)
{
	uint16_t i;
	uint16_t ch = 0;

	for (i = 0; i < BUFFER_SIZE; i++) {
		TxBuf[i] = ch++;
		RxBuf[i] = 0xAA;
	}
}

#if (RW_TEST || LOOPBACK_TEST)
/* Verify buffer after transfer */
static uint8_t bufferVerify(void)
{
	uint16_t i;
	uint16_t *src_addr = (uint16_t *) &TxBuf[0];
	uint16_t *dest_addr = (uint16_t *) &RxBuf[0];

	for ( i = 0; i < BUFFER_SIZE; i++ ) {

		if (*src_addr != *dest_addr) {
			return 1;
		}
		src_addr++;
		dest_addr++;
	}
	return 0;
}

#endif

/*****************************************************************************
 * Public functions
 ****************************************************************************/

#if INTERRUPT_MODE
/**
 * @brief	SPI interrupt handler sub-routine
 * @return	Nothing
 */
void SPIIRQHANDLER(void)
{
	Chip_SPI_Int_Cmd(LPC_SPI, SPI_INTENCLR_TXDYEN | SPI_INTENCLR_RXDYEN
					 | SPI_INTENCLR_RXOVEN | SPI_INTENCLR_TXUREN, DISABLE);						/* Disable all interrupt */
	if (((XfSetup.pRx) && (XfSetup.RxCnt < XfSetup.Length))
		|| ((XfSetup.pTx) && (XfSetup.TxCnt < XfSetup.Length))) {
		Chip_SPI_Int_RWFrames(LPC_SPI, &XfSetup);
		Chip_SPI_Int_Cmd(LPC_SPI, SPI_INTENSET_TXDYEN | SPI_INTENSET_RXDYEN
						 | SPI_INTENSET_RXOVEN | SPI_INTENSET_TXUREN, ENABLE);
	}
	else {
		isXferCompleted = 1;
	}
}

#endif /*INTERRUPT_MODE*/

/**
 * @brief	Main routine for SPI example
 * @return	Nothing
 */
void BoardPeripheralInit(void)
{
  SystemCoreClockUpdate();
	//Board_Init();

	/* SPI initialization */
	Init_SPI_PinMux();

	/*
	   ConfigStruct.Mode = SPI_MODE_TEST;
	   ConfigStruct.ClkDiv = Chip_SPI_CalClkRateDivider(LPC_SPI, 100000);
	   ConfigStruct.ClockMode = SPI_CLOCK_CPHA0_CPOL0;
	   ConfigStruct.DataOrder = SPI_DATA_MSB_FIRST;
	   ConfigStruct.SSELPol = SPI_SSEL_ACTIVE_LO;
	 */
	
	Chip_SPI_Init(LPC_SPI);
	Chip_SPI_ConfigureSPI(LPC_SPI, SPI_MODE_TEST |	/* Enable master/Slave mode */
						  SPI_CLOCK_MODE3 |	/* Set Clock polarity to 0 */
						  SPI_CFG_MSB_FIRST_EN |/* Enable MSB first option */
						  SPI_CFG_SPOL_HI);	/* Chipselect is active low */

	Chip_SPIM_SetClockRate(LPC_SPI, 1000000);
	DelayConfigStruct.FrameDelay = 2;
	DelayConfigStruct.PostDelay = 2;
	DelayConfigStruct.PreDelay = 2;
	DelayConfigStruct.TransferDelay = 2;
	Chip_SPI_DelayConfig(LPC_SPI, &DelayConfigStruct);

    Chip_SPI_Enable(LPC_SPI);    
				
				bufferInit();
	XfSetup.Length = BUFFER_SIZE;
	XfSetup.pTx = TxBuf;
	XfSetup.RxCnt = XfSetup.TxCnt = 0;
	XfSetup.DataSize = 8;
	//Chip_SPI_SetXferSize(LPC_SPI, 8);
	//Chip_SPI_WriteFrames_Blocking(LPC_SPI, &XfSetup);
	
        Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT,0, BS);
        Chip_GPIO_SetPinDIRInput(LPC_GPIO_PORT,0, BUSY);
        Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT,0, RES);
        Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT,0,DC);
        Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT,0,CS);       
}


void driver_delay_xms(unsigned long xms)	
{	
    unsigned int i = 0 , j=0;

    for(j=0;j<xms;j++)
	{
        for(i=0; i<256; i++);
    }
}

void lcd_chkstatus(void)
{
   driver_delay_xms(2000);
                       
}

void EPD_W21_Init(void)
{
	Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, BS);//EPD_W21_BS_0;		// 4 wire spi mode selected
	driver_delay_xms(20);
	Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, BS);//EPD_W21_BS_0;		// 4 wire spi mode selected
  driver_delay_xms(20);
	Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, RES);//EPD_W21_RST_0;		// Module reset
	driver_delay_xms(20);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, RES);//EPD_W21_RST_1;
	driver_delay_xms(20);
	


}

void EPD_W21_WriteCMD(unsigned char command)
{
   driver_delay_xms(2);
     Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, CS);//EPD_W21_CS_0;                   
	 Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, DC);   //EPD_W21_DC_0;		// command write
	 driver_delay_xms(1);
	Chip_SPI_SendLastFrame_RxIgnore(LPC_SPI, command, 8);//Chip_SPI_WriteTXData(LPC_SPI, command);
	driver_delay_xms(1);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, CS);
	driver_delay_xms(2);
}

void EPD_W21_WriteDATA(unsigned char command)
{
    //while ( (SPI_INTSTAT_TXRDY & STAT_TXRDY) == 0 );
	driver_delay_xms(2);
    Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, CS);//EPD_W21_CS_0;                   
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, DC);//EPD_W21_DC_1;		// data write
	driver_delay_xms(1);
	Chip_SPI_SendLastFrame_RxIgnore(LPC_SPI, command, 8);//Chip_SPI_SendLastFrame_RxIgnore(LPC_SPI, command,8);
	driver_delay_xms(1);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, CS);
	driver_delay_xms(2);
}



 void Ultrachip(void)
{
	unsigned int i;	
                     for(i=0;i<9472;i++)	    
		       {
						 #ifdef pic
						 EPD_W21_WriteDATA(gImage_picture[i]); 
#endif
					 #ifdef nxp	
					EPD_W21_WriteDATA(gImage_nxp[i]); 	 
						 #endif
			   }  
			   	driver_delay_xms(2);	  
     EPD_W21_WriteCMD(0x12);        //display  
		while( Chip_GPIO_GetPinState(LPC_GPIO_PORT,0, BUSY)==0);				 
}

 void Ultrachippic1(void)
{
	unsigned int i;	
                     for(i=0;i<9472;i++)	    
		       {
						 
						 EPD_W21_WriteDATA(gImage_picture[i]); 

						
			   }  
			   	driver_delay_xms(2);	        
     EPD_W21_WriteCMD(0x12);        //display  
		while( Chip_GPIO_GetPinState(LPC_GPIO_PORT,0, BUSY)==0);				 
}

void Ultrachippic2(void)
{
	unsigned int i;	
                     for(i=0;i<9472;i++)	    
		       {
						 
						 EPD_W21_WriteDATA(gImage_jiage[i]); 

						
			   }  
			   	driver_delay_xms(2);	        
     EPD_W21_WriteCMD(0x12);        //display  
		while( Chip_GPIO_GetPinState(LPC_GPIO_PORT,0, BUSY)==0);				 
}

void lut_bw(void)
{	 unsigned int count;
             EPD_W21_WriteCMD(0x20);
              for(count=0;count<15;count++)	     
               { EPD_W21_WriteDATA(lut_vcom0[count]);  }
                
             EPD_W21_WriteCMD(0x21);
              for(count=0;count<15;count++)	     
                {EPD_W21_WriteDATA(lut_w[count]);}   
             
             EPD_W21_WriteCMD(0x22);
              for(count=0;count<15;count++)	     
                {EPD_W21_WriteDATA(lut_b[count]);}    

 EPD_W21_WriteCMD(0x23);
              for(count=0;count<15;count++)	     
                {EPD_W21_WriteDATA(lut_g1[count]);}         
 EPD_W21_WriteCMD(0x24);
              for(count=0;count<15;count++)	     
                {EPD_W21_WriteDATA(lut_g2[count]);}              
                
}

void lut_bwc(void)
{	 unsigned int count;
      /*       EPD_W21_WriteCMD(0x20);
              for(count=0;count<15;count++)	     
               { EPD_W21_WriteDATA(lut_vcom1[count]);  }
                
     /*       EPD_W21_WriteCMD(0x21);
              for(count=0;count<15;count++)	     
                {EPD_W21_WriteDATA(lut_w1[count]);}   */
								   
								EPD_W21_WriteCMD(0x22);
              for(count=0;count<15;count++)	     
                {EPD_W21_WriteDATA(lut_b1[count]);}    
         /*  EPD_W21_WriteCMD(0x23);
              for(count=0;count<15;count++)	     
                {EPD_W21_WriteDATA(lut_g11[count]);}         
 EPD_W21_WriteCMD(0x24);
              for(count=0;count<15;count++)	     
                {EPD_W21_WriteDATA(lut_g21[count]);}   */   
                
}

void Clearchip(void)
{
	unsigned int i;	
	 lut_bwc();	
                   
 EPD_W21_WriteCMD(0x10);
  for(i=0;i<9472;i++)	     
		       { EPD_W21_WriteDATA(0xff);  
			   }  
			   	driver_delay_xms(2);	
				 EPD_W21_WriteCMD(0x12); 
				 driver_delay_xms(1);
		while( Chip_GPIO_GetPinState(LPC_GPIO_PORT,0, BUSY)==0);
				 	// driver_delay_xms(6553);
				 
				 lut_bw();	
				 
   EPD_W21_WriteCMD(0x10);				 
}

int main(void)
{
	
        BoardPeripheralInit();
        EPD_W21_Init();
        EPD_W21_WriteCMD(0x01);        	//Set VGH VGL   VSH VSL
        EPD_W21_WriteDATA (0x03);	    
        EPD_W21_WriteDATA (0x00);
        EPD_W21_WriteCMD(0x06);         //boost setting
        EPD_W21_WriteDATA (0x07);
        EPD_W21_WriteDATA (0x06);
        EPD_W21_WriteDATA (0x05);
        EPD_W21_WriteCMD(0x04);         //power up 
        lcd_chkstatus();                //check ic state
        EPD_W21_WriteCMD(0x60); 		 //TCON Setting
        EPD_W21_WriteDATA (0x00); 
        EPD_W21_WriteCMD(0X50);
        EPD_W21_WriteDATA(0x0f);
        EPD_W21_WriteCMD(0x30);			//PLL setting
        EPD_W21_WriteDATA (0x39);                
        EPD_W21_WriteCMD(0x61);			// resolution setting
        EPD_W21_WriteDATA (0x80);		 //128*296
        EPD_W21_WriteDATA (0x01);
        EPD_W21_WriteDATA (0x28); 
        EPD_W21_WriteCMD(0x82);			//vcom setting
        EPD_W21_WriteDATA (0x00);        
        lut_bw();         
        EPD_W21_WriteCMD(0x10);	       //update grey image
	
				while (1) {
						Clearchip();
						Ultrachip();     
 	 
 
						Clearchip();
						Ultrachippic1();
		
						Clearchip();
						Ultrachippic2();
	
	 
	}
}
