/*
===============================================================================
 Name        :  touch_task.h
 Author      :  nlv11817
 Version     :
 Copyright   :  $(copyright)
 Description :  handles all Touch Solution library API related functions
                + storage of Touch parameters in flash
===============================================================================
*/
#include "LPC82x.h"
#include "LPC8xx_Touch_Solution.h"
#include "Gesture_Recognition.h"

// assign sensor layout to physical port pins
#define PIN_YL                 6                   // P0_6
#define PIN_YH                 23                  // P0_23
#define PIN_YM                 14                  // P0_14 (analog comparator input 3)

#define PIN_X0                 26                  // P0_26
#define PIN_X1                 22                  // P0_22
#define PIN_X2                 21                  // P0_21
#define PIN_X3                 15                  // P0_15
#define PIN_X4                 19                  // P0_19
#define PIN_X5                 20                  // P0_20
#define PIN_X6                 13                  // P0_13
#define PIN_X7                 17                  // P0_17
#define PIN_X8                 28                  // P0_28

#define ACMP_I1                0                    // select if input ACMP_I1 (P0_0)  is used
#define ACMP_I2                1                    // select if input ACMP_I2 (P0_1)  is used
#define ACMP_I3                2                    // select if input ACMP_I3 (P0_14) is used
#define ACMP_I4                3                    // select if input ACMP_I4 (P0_23) is used

extern uint8_t StoreTrainingSet(uint8_t *tsblock, uint8_t nr);      // stores 40 blocks (pages) of trs data
extern uint8_t StoreTouchParameters(void);
extern void    Init_Touch(void);
