/*
 * @brief Blinky example using SysTick and interrupt
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2013
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"
#include <stdio.h>

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/
#define CLKOUT_PIO1 1  

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/
void PININT7_IRQHandler(void)
{
	Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, 7);  //LED ON on LPCXpresso board
	Chip_PININT_ClearIntStatus(LPC_PININT, PININTCH7);
	
	/*clear the sleepdeep bit*/
	SCB->SCR &= ~(1<<2);
}

/**
 * @brief	main routine for blinky example
 * @return	Function should not exit.
 */
int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();

	Board_LED_Set(0, false);
	
/* Setup FLASH access to 1 CPU clock  */
	Chip_FMC_SetFLASHAccess(FLASHTIM_20MHZ_CPU);
	
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_GPIO);	
	
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);
	
/* Enable clock to SWM*/
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);

/* Peripheral reset control to GPIO and GPIO INT, a "1" bring it out of reset. */
	Chip_SYSCTL_PeriphReset(RESET_GPIO);

	/* Configure interrupt channel 7 for the GPIO pin p0.4 in SysCon block */
	Chip_SYSCTL_SetPinInterrupt(7, 4);

	/* Configure channel 7 as wake up interrupt in SysCon block */
	Chip_SYSCTL_EnablePINTWakeup(7);

	/* Configure channel 7 interrupt as edge sensitive and falling edge interrupt */
	Chip_PININT_SetPinModeEdge(LPC_PININT, PININTCH7);
	Chip_PININT_EnableIntLow(LPC_PININT, PININTCH7);
	
	/* Enable interrupt in the NVIC */
	NVIC_EnableIRQ(PININT7_IRQn);
	
#if 0	
/* Connect the SWM_CLKOUT_O signal to port pin P0.1 */
	Chip_SWM_MovablePinAssign(SWM_CLKOUT_O, CLKOUT_PIO1);

	/* Setup CLKOUT pin for specific clock with a divider of 1 */
	Chip_Clock_SetCLKOUTSource(SYSCTL_CLKOUTSRC_IRC, 1);
#endif
	
	/* Initialize the GPIO functionality on all port pins*/
	LPC_SWM->PINASSIGN[0] = 0xFFFFFFFF;
  LPC_SWM->PINASSIGN[1] = 0xFFFFFFFF;
  LPC_SWM->PINASSIGN[2] = 0xFFFFFFFF;
  LPC_SWM->PINASSIGN[3] = 0xFFFFFFFF;
  LPC_SWM->PINASSIGN[4] = 0xFFFFFFFF;
  LPC_SWM->PINASSIGN[5] = 0xFFFFFFFF;
  LPC_SWM->PINASSIGN[6] = 0xFFFFFFFF;
  LPC_SWM->PINASSIGN[7] = 0xFFFFFFFF;
  LPC_SWM->PINASSIGN[8] = 0xFFFFFFFF;
	
	Chip_SWM_DisableFixedPin(SWM_FIXED_ACMP_I1);
  Chip_SWM_DisableFixedPin(SWM_FIXED_ACMP_I2);
	Chip_SWM_DisableFixedPin(SWM_FIXED_SWCLK);
	Chip_SWM_DisableFixedPin(SWM_FIXED_SWDIO);
	Chip_SWM_DisableFixedPin(SWM_FIXED_XTALIN);
	Chip_SWM_DisableFixedPin(SWM_FIXED_XTALOUT);
	Chip_SWM_DisableFixedPin(SWM_FIXED_RST);
	Chip_SWM_DisableFixedPin(SWM_FIXED_CLKIN);
	Chip_SWM_DisableFixedPin(SWM_FIXED_VDDCMP);
	
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO0, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO1, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO2, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO3, PIN_MODE_INACTIVE);
	
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO5, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO6, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO7, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO8, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO9, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO10, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO11, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO12, PIN_MODE_INACTIVE);
	
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO16, PIN_MODE_INACTIVE);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO17, PIN_MODE_INACTIVE);
	
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO4,  PIN_MODE_PULLUP);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO13, PIN_MODE_PULLUP);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO14, PIN_MODE_PULLUP);
	Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO15, PIN_MODE_PULLUP);
	
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 0);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 1);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 2);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 3);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 5);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 6);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 7);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 8);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 9);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 10);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 11);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 12);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 16);
	Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 17);

	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 0);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 1);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 2);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 3);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 5);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 6);	
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 7);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 8);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 9);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 10);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 11);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 12);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 16);
	Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 17);
	
	/*Configure power configuration after wake-up from low power modes*/
  LPC_SYSCTL->PDAWAKECFG = LPC_SYSCTL->PDRUNCFG;
	
	/*LED ON on LPCXpresso board*/
	Chip_GPIO_SetPinOutLow(LPC_GPIO_PORT, 0, 7); 
	
	while (1)                                
	{
		/*sleep mode*/
		if (!Chip_GPIO_ReadPortBit(LPC_GPIO_PORT, 0, 15)) 
		{

		/*LED OFF on LPCXpresso board*/
		Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 7);

		//SCB->SCR &= ~(1<<2);

		/*Select sleep mode*/
		//LPC_PMU->PCON = 0x0;

		/*Call ARM WFI function*/
		//__WFI();
			
			Chip_PMU_SleepState(LPC_PMU);
			
		} 	
		
		if (!Chip_GPIO_ReadPortBit(LPC_GPIO_PORT, 0, 13)) 
		{

		/*LED OFF on LPCXpresso board*/
		Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 7);

		//SCB->SCR |= (1<<2);

		/*Select deep-sleep mode*/
		//LPC_PMU->PCON = 0x1;

		/*Call ARM WFI function*/
		//__WFI();
			
		/* Enter MCU Deep Sleep mode */
		Chip_PMU_DeepSleepState(LPC_PMU);
			
		} 	
		
		
		if (!Chip_GPIO_ReadPortBit(LPC_GPIO_PORT, 0, 14)) 
		{

		/*LED OFF on LPCXpresso board*/
		Chip_GPIO_SetPinOutHigh(LPC_GPIO_PORT, 0, 7);

		//SCB->SCR |= (1<<2);

		/*Select power-down mode*/
		//	LPC_PMU->PCON = 0x2;

		/*Call ARM WFI function*/
		//__WFI();
			
		/* Enter MCU Power down mode */
		Chip_PMU_PowerDownState(LPC_PMU);	
			
		} 	
	}
	//return 0;
}
