/***************************************************************************
* @brief LPC15xx SCT0 bldc demo program for LPCXpresso and EA motor control board
*	
*	Description : This file contains the BLDC motor control example for LPC15xx devices.
*
* @note
* Copyright(C) NXP Semiconductors, 2014
* All rights reserved.
*
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* LPC products.  This software is supplied "AS IS" without any warranties of
* any kind, and NXP Semiconductors and its licensor disclaim any and
* all warranties, express or implied, including all implied warranties of
* merchantability, fitness for a particular purpose and non-infringement of
* intellectual property rights.  NXP Semiconductors assumes no responsibility
* or liability for the use of the software, conveys no license or rights under any
* patent, copyright, mask work right, or any other intellectual property rights in
* or to any products. NXP Semiconductors reserves the right to make changes
* in the software without notification. NXP Semiconductors also makes no
* representation or warranty that such application will be suitable for the
* specified use without further testing or modification.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
**********************************************************************************/


#include "global.h"

volatile uint8_t speed   = 0;
uint8_t f_100ms = 0;
volatile uint8_t oled_X = 0;
volatile uint8_t oled_Y = 0;
volatile uint8_t oled_Y_PixBUF[96];
volatile uint8_t SysTick_cntr = 0;
int32_t pid(uint32_t old_speed, uint32_t target);
volatile uint16_t motorTargetSpeed= 45;
volatile int32_t correction;
volatile uint16_t   new_speed = pwm_end;
volatile uint16_t 	matchValue = pwm_end;

extern volatile int ted;
extern volatile int teu;
volatile int32_t flag=0;
volatile uint8_t index;
volatile uint8_t state = ST_HALTED;


#define MIN_MATCH 5	/* minimum allowed match value */
#define MAX_MATCH 45   /* maximum allowed match value */

void SysTick_Handler(void)
{                                                          // SysTick Interrupt Handler (10 msec)


    if (++SysTick_cntr > 10)                                        // 10 * 10 msec = 100 msec
    {
        SysTick_cntr = 0;
        f_100ms = 1;
    }
}

int main(void) 
{ 
GPIOInit();
    LPC_SYSCON->SYSAHBCLKCTRL1  |= EN1_SCT_IPU;            // enable SWM clock
    LPC_SYSCON->SYSAHBCLKCTRL0  |= EN0_SWM    |            // enable SWM clock
                                   EN0_GPIO0  |            // enable GPIO port 0 clock
                                   EN0_GPIO1  |            // enable GPIO port 1 clock
                                   EN0_P_MUX  |            // enable PMUX clock
                                   EN0_IOCON;              // enable IOCON clock

    LPC_SWM->PINASSIGN7         |= 0xFFFFFF00;             // ASSIGN7(31:8) = FFFFFF
    LPC_SWM->PINASSIGN7         &= 0x1A1D06FF;             // SCT0_OUT0 = P0.6  = SW2
                                                           // SCT0_OUT1 = P0.29 = SW1
                                                           // SCT0_OUT2 = P0.26 = SW4
    LPC_SWM->PINENABLE1         &= ~(1 << 5);              // SCT0_OUT3 = P0.0  = SW3 
    LPC_SWM->PINENABLE1         &= ~(1 << 6);              // SCT0_OUT4 = P0.1  = SW6
    LPC_SWM->PINENABLE1         &= ~(1 << 8);              // SCT0_OUT6 = P0.24 = SW5

    LPC_PMUX->SCT0_P_MUX0        = 0;                      // SCT0_IN0 = P0.2  = HALL A = H1
    LPC_PMUX->SCT0_P_MUX1        = 3;                      // SCT0_IN1 = P0.30  = HALL B = H2
    LPC_PMUX->SCT0_P_MUX2        = 2;                      // SCT0_IN2 = P0.17 = HALL C = H3

    LPC_SWM->PINASSIGN10        |= 0x0000FF00;             // ASSIGN7(15:8) = FF
    LPC_SWM->PINASSIGN10        &= 0xFFFF24FF;             // P1.4 (JOY_LEFT key) = SCT_ABORT0
    LPC_SCT_IPU->ABORT[0].ENABLE = 1;                      // enable SCT_ABORT0
    LPC_PMUX->SCT0_P_MUX3        = 17;                     // SCT0_IN3 = SCTIPU_ABORT = P1.4 (JOY_LEFT key)

    LPC_GPIO->DIR[0]            |= (1 << 27);              // configure P0.27 (current trip) as output
    LPC_GPIO->CLR[0]            |= (1 << 27);              // clear P0.27 (current trip)
    SysTick_Config(SystemCoreClock/100);                   // Init SysTick every 10 ms
	
		
		oled_init();
		oled_clearScreen(OLED_COLOR_BLACK);            // Clear the OLED screen
		vGUI_PrintInstruction();                        // display the startup message
	
		joystick_init();
    SCT0_Init();                                           // Initialize SCT0 forward
	flag=0;
    while (1)                                              // loop forever
    { 
			if(flag==0)
				{ flag=2;
					oled_clearScreen(OLED_COLOR_BLACK);
					oled_putString(0, 0, "Motor status", OLED_COLOR_WHITE, OLED_COLOR_BLACK);  
					oled_putString(0, 10, "Stop", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
				}
			
				if(flag==1)
				{
					flag=2;
					oled_clearScreen(OLED_COLOR_BLACK);
					oled_putString(0, 0, "Motor status", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
					oled_putString(0, 10, "Running", OLED_COLOR_WHITE, OLED_COLOR_BLACK);
				}
		
        if(state == ST_HALTED)                                  // is motor (and SCT) halted?
				{
							speed = 21;                                  // boost up from speed zero
              index = 0;
              if (HALL_A)  index |= 4;                     // read Hall sensor code (H1-H2-H3)
              if (HALL_B)  index |= 2;
              if (HALL_C)  index |= 1;
				}
	
        if (speed < 15)
        {		ted=0;
						teu=0;
						flag=0;
            LPC_SCT0->CTRL_U |= (1 << 2);                  // halt the SCT by setting bit 2 of the CTRL register
            state = ST_HALTED;
            LPC_SCT0->OUTPUT  = 0;                         // all outputs low
        }
				
					
				matchValue = speed;
				if(speed>15)
					{
					if(++SysTick_cntr ==1)                  // 10 ms 
						{
				/* get the new match value from the pid algorithm */
		correction = pid(speed,motorTargetSpeed); }}
		new_speed =  (matchValue + correction); 	
				if(new_speed < MIN_MATCH) new_speed = MIN_MATCH;
				if(new_speed > MAX_MATCH) new_speed = MAX_MATCH;
					
        LPC_SCT0->MATCHREL[1].U = pwm_end - new_speed;
    
		}
}


/* values depend on motor and load */
float KP = 0.1;
float KI = 0.001;
int32_t err[2]= {0,0};

/* simple PID algorithm */
int32_t pid(uint32_t old_speed, uint32_t target) {
	
	int32_t corr;
	/* error[0] is the actual proportional error */
	err[0] =  target - old_speed  ;

	/* error[1] is the cumulative error, integrate for next step */
	err[1] = err[1] + err[0];	
if( err[1] >  100000)
	err[1] = 100000;
if(err[1] < -100000)
	err[1] = -100000;
	/* calculate the correction in terms of RPM */

corr = ((KP*err[0]) + (KI*err[1]))/2000;
	return(corr);
}
