/* 
* TITLE: NM1MEM.H
* Written and Developed by: 
* Orchid Technologies Engineering and Consulting, Inc. 
* 147 Main Street 
* Maynard, Ma.  01754 
* TEL: 978-461-2000  
* 
* This Source Code is the property of Orchid Technologies 
* Engineering and Consulting, Inc.  Copyright 2003, 2004, 2005, 
* 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 
* and NXP Semiconductors 2013.

* THIS SOFTWARE IS PROVIDED BY ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
* PARTICULAR PURPOSE, AND NON-INFRINGEMENT OF INTELLECTUAL PROPERTY RIGHTS ARE 
* DISCLAIMED. IN NO EVENT SHALL ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING, 
* INC. OR NXP SEMICONDUCTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
* IN CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE. ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS RESERVE THE RIGHT TO MAKE CHANGES IN THE SOFTWARE 
* WITHOUT NOTIFICATION. 
*
* @par
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
*/

//State Variables

//RTC Interrupt Memory Declarations
//These are used to run the internal RTC Services and should
//not be modified by application firmware.  The flags are
//used in the rtc_event routine to queue various events on 
//their respective intervals in the foreground.
extern volatile unsigned short rtc_delay;               //Used for short blocking delays in various routines
extern volatile unsigned short rtc_running;             //Base Fractional second timer to esablish seconds count

//SCI0 Storage
extern unsigned char sci_txbuffer0[SCI_BUF_SIZE1+2];
extern unsigned char sci_rxbuffer0[SCI_BUF_SIZE1+2];
extern unsigned char irq_sci_status0;
extern unsigned char *txring_inptr0;
extern unsigned char *txring_outptr0;
extern unsigned char *rxring_inptr0;
extern unsigned char *rxring_outptr0;
extern unsigned short txring_count0;
extern unsigned short rxring_count0;
extern unsigned char comm_lineflag0;
extern unsigned short comm_linecount0;
extern unsigned char comm_linebuf0[SCI_BUF_SIZE1+2];

//LPC15xx Power, PLL API Definitions
extern rom_set_pll   set_pll;
extern rom_set_power set_power;

//Math Helpers
extern float    sincostab[];    //Sin Cos Lookup Table in 0-1024 counts = 0 to 360 Degrees
extern float    tantab[];       //Atan table

//FOC Routines
extern PMSMotor mtr1;
extern ESTMotor est1;
#if GUI_Interface
extern FOC_TUNE foc_com;
#endif
//Application Globals
extern unsigned char  comm_procline0_state;
extern          float user_torque;
extern          float user_flux_est0;
extern          int   user_angle_est0;
extern          float user_flux_est1;
extern          int   user_angle_est1;
extern          float user_motor_r;
extern          float user_motor_l;
extern unsigned char  service_adc_offset_state;
extern unsigned char  service_adc_offset_flag;
extern unsigned char  service_adc_offset_count;
extern          int   service_adc_offset_a;
extern          int   service_adc_offset_b;
extern          int   service_adc_offset_c;
extern          int   service_adc_offset_all;
extern          int   service_adc_offset_suma;
extern          int   service_adc_offset_sumb;
extern          int   service_adc_offset_sumc;
extern          int   service_adc_offset_sumall;
extern          int   adc_diag_count;
extern unsigned char  service_show_state;
extern unsigned char  service_show_timer;
extern          int   estimator_flag;      //estimator type
extern          int   estimator_state;     //Manage Estimator Action
extern unsigned char  service_joy_state;
extern unsigned char  service_joy_timer;
extern unsigned char  service_foc_cal_state;
extern unsigned int   service_foc_cal_timer;
extern unsigned char  service_rpm_pi_state;

