/* 
* TITLE: NM1LIB.H
* Written and Developed by: 
* Orchid Technologies Engineering and Consulting, Inc. 
* 147 Main Street 
* Maynard, Ma.  01754 
* TEL: 978-461-2000  
* 
* This Source Code is the property of Orchid Technologies 
* Engineering and Consulting, Inc.  Copyright 2003, 2004, 2005, 
* 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 
* and NXP Semiconductors 2013.

* THIS SOFTWARE IS PROVIDED BY ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
* PARTICULAR PURPOSE, AND NON-INFRINGEMENT OF INTELLECTUAL PROPERTY RIGHTS ARE 
* DISCLAIMED. IN NO EVENT SHALL ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING, 
* INC. OR NXP SEMICONDUCTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
* IN CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE. ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS RESERVE THE RIGHT TO MAKE CHANGES IN THE SOFTWARE 
* WITHOUT NOTIFICATION. 
*
* @par
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
*/

void InitClock(void);
void initialize_cpu(void);
void initialize_memory(void);
void led_run(unsigned char);
void initialize_uarts_isr(void);
void initialize_systick(void);
void initialize_sct(void);
void initialize_adc0(void);
void initialize_adc1(void);
void initialize_qei(void);
void byte2ascii(unsigned char, unsigned char *);
void word2bin(unsigned int, unsigned char *);

void initialize_sincos(void);
void initialize_tan(void);
float get_sin(int);
float get_cos(int);
int get_atan(float);

void service_adc_offset(void);
void get_analog(PMSMotor *);
void get_rpm(PMSMotor *);
void run_pi(PMSMotor *);

//CORTEX-M3 NVIC Setup Routines
void NVIC_IntEnable(unsigned long);
void NVIC_IntDisable(unsigned long);
void NVIC_ClrPend(unsigned long);
void NVIC_IntPri(unsigned long IntNumber, unsigned char);


//CORTEX-M3 Exceptions and Interupts
void SysTick_Handler(void);
void ADC0_SEQA_IRQHandler(void);

