/* 
* TITL: NM1CORE.C
* Written and Developed by: 
* Orchid Technologies Engineering and Consulting, Inc. 
* 147 Main Street 
* Maynard, Ma.  01754 
* TEL: 978-461-2000  
* 
* This Source Code is the property of Orchid Technologies 
* Engineering and Consulting, Inc.  Copyright 2003, 2004, 2005, 
* 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 
* and NXP Semiconductors 2013.

* THIS SOFTWARE IS PROVIDED BY ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
* PARTICULAR PURPOSE, AND NON-INFRINGEMENT OF INTELLECTUAL PROPERTY RIGHTS ARE 
* DISCLAIMED. IN NO EVENT SHALL ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING, 
* INC. OR NXP SEMICONDUCTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
* IN CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE. ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS RESERVE THE RIGHT TO MAKE CHANGES IN THE SOFTWARE 
* WITHOUT NOTIFICATION. 
*
* @par
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
*/

//Include Files
#include "arm_comm.h"
#include "iolpc15xx.h"
#include "nm1def.h"            /* Control Defines    */
#include "nm1lib.h"            /* Library Prototypes */
#include "nm1com.h"            /* Communications     */
#include "nm1app.h"            /* Application        */
#include "nm1mem.h"            /* Global Memory      */
#include <stdio.h>
#include <math.h>

void main(void);

////State Variables
//RTC Interrupt Memory Declarations
//These are used to run the internal RTC Services and should
//not be modified by application firmware.  The flags are
//used in the rtc_event routine to queue various events on 
//their respective intervals in the foreground.
volatile unsigned short rtc_delay;               //Used for short blocking delays in various routines
volatile unsigned short rtc_running;             //Base Fractional second timer to esablish seconds count

//SCI0 Storage
unsigned char sci_txbuffer0[SCI_BUF_SIZE1+2];
unsigned char sci_rxbuffer0[SCI_BUF_SIZE1+2];
unsigned char irq_sci_status0;
unsigned char *txring_inptr0;
unsigned char *txring_outptr0;
unsigned char *rxring_inptr0;
unsigned char *rxring_outptr0;
unsigned short txring_count0;
unsigned short rxring_count0;
unsigned char comm_lineflag0;
unsigned short comm_linecount0;
unsigned char comm_linebuf0[SCI_BUF_SIZE1+2];

//Now Instanciate the Constant Data Tables
#include "nm1cst.h"

//LPC15xx Power, PLL API Definitions
rom_set_pll   set_pll;
rom_set_power set_power;

//Math Helpers
//Sin Cos Lookup Table in counts = 0 to 360 Degrees
float    sincostab[MOTOR_COUNTSPP + MOTOR_COUNTSPP/4 + 15];

//tan lookup table in counts = 0 to 180 degrees
float    tantab[MOTOR_COUNTSPP/2 + 15];   

//FOC Routines
PMSMotor mtr1;
ESTMotor est1;
#if GUI_Interface  
FOC_TUNE foc_com;
#endif
//Application Globals
unsigned char  comm_procline0_state;
         float user_torque;
         float user_flux_est0;
         int   user_angle_est0;
         float user_flux_est1;
         int   user_angle_est1;
         float user_motor_r;
         float user_motor_l;
unsigned char  service_adc_offset_state;
unsigned char  service_adc_offset_flag;
unsigned char  service_adc_offset_count;
         int   service_adc_offset_a;
         int   service_adc_offset_b;
         int   service_adc_offset_c;
         int   service_adc_offset_all;
         int   service_adc_offset_suma;
         int   service_adc_offset_sumb;
         int   service_adc_offset_sumc;
         int   service_adc_offset_sumall;
         int   adc_diag_count;
unsigned char  service_show_state;
unsigned char  service_show_timer;
         int   estimator_flag;      //estimator type
         int   estimator_state;     //Manage Estimator Action
unsigned char  service_joy_state;
unsigned char  service_joy_timer;
unsigned char  service_foc_cal_state;
unsigned int   service_foc_cal_timer;
unsigned char  service_rpm_pi_state;

void main(void) 
{
   //First Initialize the World.
   //Setup the CPU, Setup Memory Structures, Start Interrupts
   __disable_interrupt();
   InitClock();
   initialize_cpu();
   initialize_sct();
   initialize_adc0();
   initialize_adc1();
   initialize_qei();
   initialize_memory();
   initialize_sincos();
   initialize_tan();

   //This starts SysTick Exceptions
   initialize_uarts_isr();
   initialize_systick();

// Enable Interrupts
   __enable_interrupt();

   //Wait...0.1 Seconds
   rtc_delay = 10;
   while(rtc_delay);

   //Wait...0.1 Seconds - for Updates
   rtc_delay = 10;
   while(rtc_delay);

#if (!GUI_Interface)  
// Sign On
   comm_sprint0(" NXP Semiconductors Sensored FOC Motor control Version 1.");
   comm_putc0(VERSION >> 8);
   comm_putc0((unsigned char) VERSION);
   comm_putc0(0x0D);
   comm_putc0(0x0A);
   
#endif
   
   while(1)
   {
   //Place Application Threads Here
  
   service_adc_offset();
#if GUI_Interface
   Service_Comm(&mtr1,&est1,&foc_com);
#else   
   service_show(&mtr1);
#endif                     
   service_joy();
   service_foc_cal();
   service_rpm_pi(&mtr1);

   //End Application Threads Here

   comm_getline0();
   comm_procline0();
#if TRIG_TEST   
    GPIO_B34 =1;
#endif 
  

   //Debug
   __disable_interrupt();
   __asm("nop");              //This is a safe place to insert a breakpoint
   __asm("nop");              //This is a safe place to insert a breakpoint
   __enable_interrupt();
   }
}


