
/* 
* TITL: NM1APP.C
* Written and Developed by: 
* Orchid Technologies Engineering and Consulting, Inc. 
* 147 Main Street 
* Maynard, Ma.  01754 
* TEL: 978-461-2000  
* 
* This Source Code is the property of Orchid Technologies 
* Engineering and Consulting, Inc.  Copyright 2003, 2004, 2005, 
* 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 
* and NXP Semiconductors 2013.

* THIS SOFTWARE IS PROVIDED BY ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
* PARTICULAR PURPOSE, AND NON-INFRINGEMENT OF INTELLECTUAL PROPERTY RIGHTS ARE 
* DISCLAIMED. IN NO EVENT SHALL ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING, 
* INC. OR NXP SEMICONDUCTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
* IN CONTRACT, STRICT LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE. ORCHID TECHNOLOGIES ENGINEERING AND CONSULTING INC. 
* AND NXP SEMICONDUCTORS RESERVE THE RIGHT TO MAKE CHANGES IN THE SOFTWARE 
* WITHOUT NOTIFICATION. 
*
* @par
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
*/

//Include Files
#include "arm_comm.h"
#include "iolpc15xx.h"
#include "nm1def.h"            /* Control Defines    */
#include "nm1lib.h"            /* Library Prototypes */
#include "nm1com.h"            /* Communications     */
#include "nm1app.h"            /* Application        */
#include "nm1mem.h"            /* Global Memory      */
#include <stdio.h>

#if GUI_Interface
//m3_procline0
//Command Processor for NM1
float ChartoFloat(unsigned char *);
void m3_procline0(void)
{
  
   unsigned char *ptr_line_buff;
 
   ptr_line_buff=comm_linebuf0;
   switch(comm_linebuf0[0])
   {
     case 0:
           switch (comm_linebuf0[1])
          {
           case 0:     //Driver Off
                           GPIO_B27  = 1;    //Drivers Off
                           mtr1.pi_flag = 0;
                           mtr1.rpm_sum = 0.0;
                           break;

          case 1:  //Driver On, Run Start
                           GPIO_B27  = 0;    //Drivers On
                           mtr1.pi_flag = 1;
                           mtr1.rpm_sum = 0.0;
                           est1.start_count = est1.start_time + 1; //No Startup Routine
                           break;

          case 2:  //Driver On Only
                           GPIO_B27  = 0;    //Drivers On
                           mtr1.pi_flag = 1;
                           mtr1.rpm_sum = 0.0;
                           est1.start_count = 0;         //Use Startup Routing
                           est1.start_incr = 0.0;
                           mtr1.rpm_setpt = est1.start_rpm;
                           est1.sp_flag = 1;
         }                break;
        break;
    case 1:   //RPM Setpoint
     mtr1.rpm_setpt=ChartoFloat(ptr_line_buff);
     est1.sp_flag = 1;
     break;             
 
    case 6:  //PIQ PGAIN
             __disable_interrupt();
              mtr1.piq_pgain = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 7:  //PIQ IGAIN
             __disable_interrupt();
              mtr1.piq_igain = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 8:  //PIQ TGAIN
             __disable_interrupt();
              mtr1.piq_tgain = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 9:  //PID PGAIN
             __disable_interrupt();
              mtr1.pid_pgain = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 10:  //PID IGAIN
             __disable_interrupt();
              mtr1.pid_igain = ChartoFloat(ptr_line_buff);
            __enable_interrupt();
             break;

    case 11:  //PID TGAIN
             __disable_interrupt();
               mtr1.pid_tgain = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 12:  //RPM PGAIN
             __disable_interrupt();
              mtr1.rpm_pgain = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 13:   //RPM IGAIN
             __disable_interrupt();
              mtr1.rpm_igain = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 14:   //RPM TGAIN
             __disable_interrupt();
              mtr1.rpm_tgain = ChartoFloat(ptr_line_buff);
               __enable_interrupt();
             break;

    case 15:   //Start Accel Setpoint
             __disable_interrupt();
              est1.start_accel = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 16:   //Start Increment Max Setpoint
             __disable_interrupt();
              est1.start_incrmax = ChartoFloat(ptr_line_buff);
             __enable_interrupt();
             break;

    case 17:   //Start Start Time Setpoint
             __disable_interrupt();
              est1.start_time = (comm_linebuf0[4]<<24 | comm_linebuf0[3]<<16 | comm_linebuf0[2] <<8 | comm_linebuf0[1]);
             __enable_interrupt();
             break;

    case 18:   //Start RPM Setpoint
             __disable_interrupt();
              est1.start_rpm = (comm_linebuf0[4]<<24 | comm_linebuf0[3]<<16 | comm_linebuf0[2] <<8 | comm_linebuf0[1]);
             __enable_interrupt();
             break;

   case 19:   //Estimator Type
               est1.sp_flag = 1;  //Force estimator update
               estimator_flag = comm_linebuf0[1];
               break;               
               default:            
               break;
   }
}

float ChartoFloat(unsigned char *linebuffptr){ 
              com_var receive_tempdata;
              linebuffptr++;
              receive_tempdata.com_uchr_var[0]= *linebuffptr++;
              receive_tempdata.com_uchr_var[1]= *linebuffptr++;
              receive_tempdata.com_uchr_var[2]= *linebuffptr++;
              receive_tempdata.com_uchr_var[3]= *linebuffptr;
              return(receive_tempdata.com_float_var);
       
}  


#else
//m3_procline0
//Command Processor for NM1
void m3_procline0(void)
{
   char cdummy;
   int dummy;
   int para;
   int temp;
   float para_data;
   unsigned char cbuf[50];
  
   switch(comm_linebuf0[0])
   {
   case '0':   //Motor Power
               comm_sprint0("Setting Motor Power");
               sscanf((char *) comm_linebuf0, "%d %d", &dummy, &temp);
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               switch (temp)
               {
                  case 0:  //Driver Off
                           GPIO_B27  = 1;    //Drivers Off
                           mtr1.pi_flag = 0;
                           mtr1.rpm_sum = 0.0;
                           break;

                  case 1:  //Driver On, Run Start
                           GPIO_B27  = 0;    //Drivers On
                           mtr1.pi_flag = 1;
                           mtr1.rpm_sum = 0.0;
                           est1.start_count = est1.start_time + 1; //No Startup Routine
                           break;

                  case 2:  //Driver On Only
                           GPIO_B27  = 0;    //Drivers On
                           mtr1.pi_flag = 1;
                           mtr1.rpm_sum = 0.0;
                           est1.start_count = 0;         //Use Startup Routing
                           est1.start_incr = 0.0;
                           mtr1.rpm_setpt = est1.start_rpm;
                           est1.sp_flag = 1;
                           break;
               }
               break;

   case '1':   //Enter RPM Setpoint
               comm_sprint0("Set RPM:");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               sscanf((char *) comm_linebuf0, "%d %f", &dummy, &mtr1.rpm_setpt);
               est1.sp_flag = 1;
               break;               
               
   case '2':   //Enter User Flux
               comm_sprint0("Set User Flux:");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               if(estimator_flag == 0)
               {
               sscanf((char *) comm_linebuf0, "%d %f", &dummy, &user_flux_est0);
               mtr1.piq_setpt = user_flux_est0;
               }
               if(estimator_flag == 1)
               {
               sscanf((char *) comm_linebuf0, "%d %f", &dummy, &user_flux_est1);
               mtr1.piq_setpt = user_flux_est1;
               }

               break;               

   case '3':   //Enter Theta Offset
               comm_sprint0("Enter Theta Offset:");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               __disable_interrupt();
               if(estimator_flag == 0)
               sscanf((char *) comm_linebuf0, "%d %d", &dummy, &user_angle_est0);
               if(estimator_flag == 1)
               sscanf((char *) comm_linebuf0, "%d %d", &dummy, &user_angle_est1);
               __enable_interrupt();
               break;               

   case '4':   //Enter Parameters
               sscanf((char *) comm_linebuf0, "%d %d %f", &dummy, &para, &para_data);
               switch(para)
               {
                  case 1:  //Motor R
                           __disable_interrupt();
                           user_motor_r = para_data;
                           __enable_interrupt();
                           break;

                  case 2:  //Motor L
                           __disable_interrupt();
                           user_motor_l = para_data;
                           __enable_interrupt();
                           break;

                  case 3:  //PIQ PGAIN
                           __disable_interrupt();
                           mtr1.piq_pgain = para_data;
                           __enable_interrupt();
                           break;

                  case 4:  //PIQ IGAIN
                           __disable_interrupt();
                           mtr1.piq_igain = para_data;
                           __enable_interrupt();
                           break;

                  case 5:  //PIQ TGAIN
                           __disable_interrupt();
                           mtr1.piq_tgain = para_data;
                           __enable_interrupt();
                           break;

                  case 6:  //PID PGAIN
                           __disable_interrupt();
                           mtr1.pid_pgain = para_data;
                           __enable_interrupt();
                           break;

                  case 7:  //PID IGAIN
                           __disable_interrupt();
                           mtr1.pid_igain = para_data;
                           __enable_interrupt();
                           break;

                  case 8:  //PID TGAIN
                           __disable_interrupt();
                           mtr1.pid_tgain = para_data;
                           __enable_interrupt();
                           break;

                  case 9:  //RPM PGAIN
                           __disable_interrupt();
                           mtr1.rpm_pgain = para_data;
                           __enable_interrupt();
                           break;

                  case 10:   //RPM IGAIN
                           __disable_interrupt();
                           mtr1.rpm_igain = para_data;
                           __enable_interrupt();
                           break;

                  case 11:   //RPM TGAIN
                           __disable_interrupt();
                           mtr1.rpm_tgain = para_data;
                           __enable_interrupt();
                           break;
                 
                  default: break;
               }
               comm_sprint0("Parameter Update Complete");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               break;               

   case '5':   //Show Parameters
               comm_sprint0("Parameters:");
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  1: Motor R = %4.4f", user_motor_r);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  2: Motor L = %4.4f", user_motor_l);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  3: Q PGAIN = %4.4f", mtr1.piq_pgain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  4: Q IGAIN = %4.4f", mtr1.piq_igain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  5: Q TGAIN = %4.4f", mtr1.piq_tgain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  6: D PGAIN = %4.4f", mtr1.pid_pgain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  7: D IGAIN = %4.4f", mtr1.pid_igain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  8: D TGAIN = %4.4f", mtr1.pid_tgain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  9: RPM PGAIN = %4.4f", mtr1.rpm_pgain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  10: RPM IGAIN = %4.4f", mtr1.rpm_igain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  11: RPM TGAIN = %4.4f", mtr1.rpm_tgain);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  Rotor Angle Offset Est0 = %d", user_angle_est0);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);

               sprintf((char *)cbuf, "  Rotor Angle Offset Est1 = %d", user_angle_est1);
               comm_sprint0(cbuf);
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               
               break;               

   case '6':   //Show RPM
               sscanf((char *) comm_linebuf0, "%d %d", &dummy, &temp);
               comm_sprint0("Setting RPM Display");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               if(temp)
               service_show_state = STATE0;
               else
               service_show_state = STATE_IDLE;

               break;               

   case 'c':
   case 'C':   //Force Motor Calibration
               comm_sprint0("Calibrating Rotor Position");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               service_foc_cal_state = STATE0;
               break;               

   case 'v':
   case 'V':   //Return Values for GUI
               sscanf((char *) comm_linebuf0, "%c %d", &cdummy, &para);
               switch(para)
               {
               case 1:   //theta
                           sprintf((char *)cbuf, "%d", mtr1.theta);
                           comm_sprint0(cbuf);
                           comm_putc0(0x0D);
                           comm_putc0(0x0A);
                           break;

               case 2:   //valpha
                           sprintf((char *)cbuf, "%4.4f", mtr1.valpha);
                           comm_sprint0(cbuf);
                           comm_putc0(0x0D);
                           comm_putc0(0x0A);
                           break;

               case 3:   //vbeta
                           sprintf((char *)cbuf, "%4.4f", mtr1.vbeta);
                           comm_sprint0(cbuf);
                           comm_putc0(0x0D);
                           comm_putc0(0x0A);
                           break;

               case 4:   //ialpha
                           sprintf((char *)cbuf, "%4.4f", mtr1.ialpha);
                           comm_sprint0(cbuf);
                           comm_putc0(0x0D);
                           comm_putc0(0x0A);
                           break;

               case 5:   //ibeta
                           sprintf((char *)cbuf, "%4.4f", mtr1.ibeta);
                           comm_sprint0(cbuf);
                           comm_putc0(0x0D);
                           comm_putc0(0x0A);
                           break;

               case 6:   //iD
                           sprintf((char *)cbuf, "%4.4f", mtr1.idout);
                           comm_sprint0(cbuf);
                           comm_putc0(0x0D);
                           comm_putc0(0x0A);
                           break;

               case 7:   //iQ
                           sprintf((char *)cbuf, "%4.4f", mtr1.iqout);
                           comm_sprint0(cbuf);
                           comm_putc0(0x0D);
                           comm_putc0(0x0A);
                           break;

               case 8:   //rpm
                           sprintf((char *)cbuf, "%d", mtr1.rpm);
                           comm_sprint0(cbuf);
                           comm_putc0(0x0D);
                           comm_putc0(0x0A);
                           break;
               }      
               break;               

   case '?':   //Help
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("NXP Semiconductors FOC Motor Evaluation Version 1.");
               comm_putc0(VERSION >> 8);
               comm_putc0((unsigned char) VERSION);
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("0 - Motor Power <0:Off, 1:On, 2:Startup-On>:");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("1 - Set RPM Setpoint");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("2 - Set User Flux   - IQ Term");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("3 - Enter Theta Offset");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("4 - Enter Paramter Updates");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("    1: Motor R, 2: Motor L");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("    3: Q-PGAIN, 4: Q-IGAIN, 5: Q-TGAIN");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("    6: D-PGAIN, 7: D-IGAIN, 8: D-TGAIN");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("    9: RPM-PGAIN, 10: RPM-IGAIN, 11: RPM-TGAIN");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("5 - Show Parameters");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("6 - Show RPM <0:Off, 1:On>:");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("C - Calibrate Rotor Position:");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_sprint0("? - This Help");
               comm_putc0(0x0D);
               comm_putc0(0x0A);
               comm_lineflag0 = STATE0;
               break;
   }
}
#endif

//FOC Motor Control
//FOC Motor Control
//FOC Motor Control

//service_foc_cal
//Calibrate rotor angle against position.  First simply
//rotate motor to permit QEI system to reset.  Then lock
//rotor at position 0 degrees and calculate theta offset.
void service_foc_cal(void)
{
   int temp;

   if(service_foc_cal_state == STATE_IDLE)
   return;

   switch(service_foc_cal_state)
   {
      case STATE0:   //Drivers On
                     //Force hi torque and zero angle
                     mtr1.vsdref =  250.0;
                     mtr1.su_flag = 1;
                     mtr1.theta   = 0;
                     GPIO_B27  = 0;    //Drivers On
                     mtr1.pi_flag = 1;

                     service_foc_cal_timer = 500;
                     service_foc_cal_state = STATE1;
                     break;

      case STATE1:   //Wait
                     if(service_foc_cal_timer == 0)
                     service_foc_cal_state = STATE2;
                     break;

      case STATE2:   //Read QEI Value and Update
                     temp = QEIPOS;
                     user_angle_est0 = 250 - temp;

                     GPIO_B27  = 1;    //Drivers Off
                     mtr1.pi_flag = 0;

                     //Done, release
                     mtr1.vsdref =  0.0;
                     mtr1.su_flag = 0;
                     mtr1.theta   = 0;

                     service_foc_cal_state = STATE_IDLE;
                     break;
   }
}


//sincos(PMSMotor)
//This routine performs the Sin and Cos Functions for a particular Theta
//This is used by the other transforms to speed them up.
void sincos(PMSMotor *ip)
{
   ip->cos_t = get_cos(ip->theta);
   ip->sin_t = get_sin(ip->theta);
}

//parke(PMSMotor)
//This routine performs the forward park transform
//This routine uses the structure PMSMotor for input/output
void parke(PMSMotor *ip)
{
   float temp1, temp2;

   temp1 = ip->ialpha * ip->cos_t;
   temp2 = ip->ibeta  * ip->sin_t;
   ip->idout = temp1 + temp2;

   temp1 = ip->ialpha * ip->sin_t;
   temp2 = ip->ibeta  * ip->cos_t;
   ip->iqout = - temp1 + temp2;
}



//inverse_park(PMSMotor)
//This routine performs the inverse park transform
//This routine uses the structure PMSMotor for input/output
void inverse_park(PMSMotor *ip)
{
   float temp1, temp2;

   temp1 = ip->vsdref * ip->cos_t;
   temp2 = ip->vsqref * ip->sin_t;
   ip->valpha = temp1 - temp2;

   temp1 = ip->vsdref * ip->sin_t;
   temp2 = ip->vsqref * ip->cos_t;
   ip->vbeta = temp1 + temp2;
}

//clarke(PMSMotor)
//This routine performs the forward Clarke Transform
//This routine uses the structure PMSMotor for input/output
void clarke(PMSMotor *ip)
{
   //Alpha Term
   ip->ialpha = (float) ip->ia;

   //Beta Term
   ip->ibeta = ip->ia + (2.0 * ip->ib);
   ip->ibeta = ip->ibeta / 1.73205;
}

//sv_pwm(PMSMotor)
//This routine performs the space vector modulation using
//This routine uses the structure PMSMotor for input/output
void sv_pwm(PMSMotor *ip)
{
   int   sector;
   float X, Y, Z;
   int   t1, t2;
   int   T1, T2, T3;

   //Modified Inverse Clarke
   X = ip->vbeta;
   Y = 0.5 * (ip->vbeta + (1.73205 * ip->valpha));
   Z = 0.5 * (ip->vbeta - (1.73205 * ip->valpha));

   //Get Sector
   sector = ip->theta/170;        //60 degrees expressed in counts

   //Apply Math per PWM Sector - Sector 0
   switch (sector)
   {
      case 6:  //Wrap
      case 0:  //
               t1 = (int)  X;
               t2 = (int) -Z;
               break;

      case 1:  //
               t1 = (int)  Y;
               t2 = (int)  Z;
               break;

      case 2:  //
               t1 = (int) -Y;
               t2 = (int)  X;
               break;

      case 3:  //
               t1 = (int)  Z;
               t2 = (int) -X;
               break;

      case 4:  //
               t1 = (int) -Z;
               t2 = (int) -Y;
               break;

      case 5:  //
               t1 = (int) -X;
               t2 = (int)  Y;
               break;
   }

   //Now Calculate Periods
   T1 = (1024 - t1 - t2)/2;   //Max is Value is 1024, Max Input is 512
   T2 = T1 + t1;
   T3 = T2 + t2;

   //Now setup outputs
   //Apply Math per PWM Sector - Sector 0
   switch (sector)
   {
      case 6:
      case 0:  //
               ip->pwma = T3;
               ip->pwmb = T2;
               ip->pwmc = T1;
               break;

      case 1:  //
               ip->pwma = T2;
               ip->pwmb = T3;
               ip->pwmc = T1;
               break;

      case 2:  //
               ip->pwma = T1;
               ip->pwmb = T3;
               ip->pwmc = T2;
               break;

      case 3:  //
               ip->pwma = T1;
               ip->pwmb = T2;
               ip->pwmc = T3;
               break;

      case 4:  //
               ip->pwma = T2;
               ip->pwmb = T1;
               ip->pwmc = T3;
               break;

      case 5:  //
               ip->pwma = T3;
               ip->pwmb = T1;
               ip->pwmc = T2;
               break;
   }

   //PWM Output Now
   SCT0_MATCHREL1 = ip->pwma;
   SCT0_MATCHREL2 = ip->pwmb;
   SCT0_MATCHREL3 = ip->pwmc;
}


#if GUI_Interface
//service_show
//This routine periodically displays diagnostic information
void Service_Comm(PMSMotor *ip,ESTMotor *Estptr,FOC_TUNE *com_ptr)
{
   if(service_show_state == STATE_IDLE)
   return;

   switch (service_show_state)
   {
      case STATE0:   //Display Value
                     com_ptr->com_sync = (0x13<<24)|(0x11<<16)|(0xEF<<8)|(0xF1<<0);	// Define synchronisation bytes ;
                     com_ptr->com_size = sizeof(FOC_TUNE);
                     com_ptr->com_mode = (unsigned char )estimator_flag;
                     com_ptr->deviceID[0] = (*(volatile unsigned long *)(0x400743F8));
                     com_ptr->deviceID[1] = (*(volatile unsigned long *)(0x400743FC));
                     com_ptr->com_theta = ip->theta;   
                     com_ptr->com_ialpha =ip->ialpha;
                     com_ptr->com_ibeta =ip->ibeta; 
                     com_ptr->com_valpha =ip->valpha;  
                     com_ptr->com_vbeta =ip->vbeta;  
                     com_ptr->com_idout =ip->idout;   
                     com_ptr->com_iqout =ip->iqout;   
                     com_ptr->com_piq_pgain =ip->piq_pgain;  
                     com_ptr->com_piq_igain =ip->piq_igain;  
                     com_ptr->com_piq_tgain =ip->piq_tgain;  
                     com_ptr->com_pid_pgain =ip->pid_pgain;  
                     com_ptr->com_pid_igain =ip->pid_igain;  
                     com_ptr->com_pid_tgain =ip->pid_tgain; 
                     com_ptr->com_rpm_pgain =ip->rpm_pgain;  
                     com_ptr->com_rpm_igain =ip->rpm_igain;  
                     com_ptr->com_rpm_tgain =ip->rpm_tgain; 
                     com_ptr->com_rpm_setpt =ip->rpm_setpt;
                     com_ptr->com_rpm       =ip->rpm;
                    /* com_ptr->com_start_accel =   Estptr->start_accel;    //Startup Angle Increment
                     com_ptr->com_start_incrmax  =  Estptr->start_incrmax;   //Startup Angle Acceleration - linear
                     com_ptr->com_start_time  =  Estptr->start_time; //Startup max
                     com_ptr->com_start_rpm  =  Estptr->start_rpm;     //Startup RPM */
                     comm_data_serial(&foc_com,sizeof(FOC_TUNE));
                     service_show_timer = 6; //100
                     service_show_state = STATE1;
                     break;

      case STATE1:   //Wait
                     if(service_show_timer == 0)
                     service_show_state = STATE0;
                     break;
   }
}
#else
//service_show
//This routine periodically displays diagnostic information
void service_show(PMSMotor *ip)
{
  unsigned char cbuf[80]; 

   if(service_show_state == STATE_IDLE)
   return;

   switch (service_show_state)
   {
      case STATE0:   //Display Value
                     sprintf((char *)cbuf, "RPM Setpoint: %4.0f RPM: %d", ip->rpm_setpt, ip->rpm);
                     comm_sprint0(cbuf);
                     comm_putc0(0x0D);
                     comm_putc0(0x0A);
      
                     service_show_timer = 100;
                     service_show_state = STATE1;
                     break;

      case STATE1:   //Wait
                     if(service_show_timer == 0)
                     service_show_state = STATE0;
                     break;
   }
}
#endif

//service_joy
//This routine services the joystick
void service_joy(void)
{
   unsigned int key;

   if(service_joy_state == STATE_IDLE)
   return;

   switch(service_joy_state)
   {
      case STATE0:   //Wait
                     if(service_joy_timer == 0)
                     service_joy_state = STATE1;
                     break;

      case STATE1:   //Key Press
                     key = GPIO_PIN1;
                     key = key >> 4;
                     key = key & 0x0000001F;
                     switch (key)
                     {
                        case KEY_UP:   //RPM Increase
                                       mtr1.rpm_setpt = mtr1.rpm_setpt + 100.0;
                                       if(mtr1.rpm_setpt > 3000.0)
                                       mtr1.rpm_setpt = 3000.0;

                                       service_joy_timer = 50;
                                       est1.sp_flag = 1;
                                       break;

                        case KEY_DN:   //RPM Decrease
                                       mtr1.rpm_setpt = mtr1.rpm_setpt - 100.0;
                                       if(mtr1.rpm_setpt < -3000.0)
                                       mtr1.rpm_setpt = -3000.0;
                                       service_joy_timer = 50;
                                       est1.sp_flag = 1;
                                       break;

                        case KEY_CT:   //Center Press - On/Off
                                       service_joy_timer = 50;
                                       if(mtr1.pi_flag == 0)
                                       {
                                          GPIO_B27  = 0;    //Drivers On
                                          mtr1.rpm_sum = 0.0;
                                          mtr1.pi_flag = 1;
                                       }
                                       else
                                       {
                                          GPIO_B27  = 1;    //Drivers Off
                                          mtr1.rpm_sum = 0.0;
                                          mtr1.pi_flag = 0;
                                       }
                                       break;
                     }
                     service_joy_state = STATE0;
                     break;
   }
}


//service_rpm_pi
//This routine performs the RPM Constant Speed Servo
void service_rpm_pi(PMSMotor *ip)
{
   float pterm;

   if(service_rpm_pi_state == STATE_IDLE)
   return;

   if(ip->rpm_flag == 0)
   return;

   ip->rpm_flag = 0;

   switch(service_rpm_pi_state)
   {
      case STATE0:   //Calculate RPM
                     pterm = ip->rpm_setpt - (ip->rpm);
                     ip->rpm_sum  = ip->rpm_sum + (pterm / ip->rpm_tgain);
                     ip->rpm_out  = (ip->rpm_pgain * pterm) + (ip->rpm_igain * ip->rpm_sum);

                     if(ip->rpm_out > MAX_RPM)
                     {
                       ip->rpm_out = MAX_RPM;
                       ip->rpm_sum = ip->rpm_sum - (pterm / ip->rpm_tgain);
                     }

                     if(ip->rpm_out < -MAX_RPM)
                     {
                       ip->rpm_out = -MAX_RPM;
                       ip->rpm_sum = ip->rpm_sum + (pterm / ip->rpm_tgain);
                     }
                     break;
   }

     if(mtr1.su_flag == 0)
     {
         ip->pid_setpt = ip->rpm_out;
     }
     else
     {
         ip->rpm_sum = 0.0;
     }

     if(mtr1.pi_flag == 1)
     {
         ip->pid_setpt = ip->rpm_out;
     }
     else
     {
         ip->rpm_sum = 0.0;
     }
}
                                       
