/****************************************************************************
 *   Project     : Example for the NXP ARM7 IEC60335 Class B library	
 *   Description : RTC driver code
 *	    
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "LPC214x.h"
#include "IEC60335.h"
#include "rtc_i.h"

__irq void RTC_irq(void)
{
    IEC60335_Clocktest_RTCHandler();

    ILR |= ILR_RTCCIF;                         // clear interrupt flag
    VICVectAddr = 0;                           // acknowledge Interrupt
}

void RTC_Init(void)
{
    CCR     = CCR_CTCRST;                      // clock tick counter reset
    ILR     = ILR_RTCCIF | ILR_RTCALF;	       // clears the RTC interrupt flags
//    PREINT  = (Fpclk / 32768) - 1;
//    PREFRAC = Fpclk - ((PREINT + 1) * 32768);
    CIIR    = 1;                               // an increment of the second value generates an interrupt

    VICVectAddr1  = (UINT32) &RTC_irq;         // set interrupt vector 1
    VICVectCntl1  = 0x20 | 13;                 // use it for RTC Interrupt
    VICIntEnable |= 0x00002000;                // enable RTC Interrupt
    CCR           = CCR_CLKEN | CCR_CLKSRC;    // enable RTC and use the external 32.768kHz crystal
}
