/*****************************************************************************
 *   target.h:  Header file for MCB2130 with LPC213x Microcontroller
 *
 *   Copyright(C) 2013, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2013.07.18  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __TARGET_H 
#define __TARGET_H

/* System configuration: Fosc, Fcclk, Fcco, Fpclk must be defined */
/* Crystal frequence,10MHz~25MHz should be the same as actual status. */
#define Fosc       12000000

/* System frequency, in multiples of Fosc, and equal or less than 60MHz. */
#define Fcclk      (Fosc * 1)
//#define Fcclk      (Fosc * 5)

/* VPB clock frequence , must be 1/2/4 multiples of (Fcclk / 4). */
#define Fpclk      (Fcclk / 4) * 4
//#define Fpclk      (Fcclk / 4) * 1

#endif /* end __TARGET_H */
