/****************************************************************************
 *   Project     : Example for the NXP ARM7 IEC60335 Class B library	
 *   Description : Main source file
 *	    
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "LPC214x.h"
#include "IEC60335.h"
#include "MCB2130_led.h"
#include "tc.h"
#include "rtc_i.h"
#include "test_config.h"

extern IEC60335_CPUreg_struct CPUregTestPOST_struct;
extern IEC60335_CPUreg_struct CPUregTestBIST_struct;

type_InterruptTest TC1_IntTest;

/* IEC60335 Flash test signature */
FlashSign_t signature = {0,0,0,0};
#define FLASH_TEST_RANGE_BIST (0x400*16)
#define	FLASH_TEST_RANGE_POST		(0x7FF80)

void Delay(unsigned long count)
{
	#define	DELAY_NUM	1000
	unsigned long i=DELAY_NUM;
	
	while(count--)
	{
		while(i--);
		i=DELAY_NUM;
	}
}

int main(void)
{
	
#if CPU_REG_TEST || INTEGRATED_TEST
	/* Do the IEC60335 CPU register tests */
	_CPUregTestPOST();
	if (CPUregTestPOST_struct.testPassed == IEC60335_testFailed)
	{
		/* POST CPU register test failed */
		while (1);
	}
#endif
	
#if PC_TEST || INTEGRATED_TEST
	/* Do the IEC60335 program counter test */
	if (IEC60335_B_PCTest_POST() == IEC60335_testFailed)
	{
		while (1);				//test failed
	}
#endif	
	
#if RAM_TEST || INTEGRATED_TEST
	/* Do the IEC60335 RAM test */
	if (IEC60335_RAMtest_POST() == IEC60335_testFailed)
	{
		while(1);					//test faild
	}
#endif
	
#if FLASH_TEST || INTEGRATED_TEST	
	/* Do the IEC60335 Flash test */
	/* Generate the reference signature */
  StartSoftSignatureGen(0x00000000, FLASH_TEST_RANGE_POST, &signature);
	if(IEC60335_FLASHtest_POST (0x00000000,FLASH_TEST_RANGE_POST, &signature) == IEC60335_testFailed)
	{
		while(1);
	}
#endif	
	
	LED_Init();        	// Intialize MCB2130 board LEDs
	
#if INT_TEST || CLK_TEST
	TC0_Init();         // Generate Timer 0 IRQ every 10 msec
#endif	
	
#if INT_TEST  
	TC1_Init();         // Generate Timer 1 IRQ every 1 msec	
	
	/*
    IEC60335_InitInterruptTest(type_InterruptTest *pIRQ, lowerBound, upperBound, individualValue)

    Used:
      Timer 0 interrupt   : every 10 msec
      Timer 1 interrupt   : every 1 msec (this is the interrupt we want to test)
      Main loop Timer 1 Interrupt check is called every 100 msec (derived from Timer 0)
	
    Within 100 msec, 100 Timer 1 interrupts should have occurred
    So:
      lowerBound      = 99  (check for more interrupts than lower bound)
      upperBound      = 101 (check for less interrupts than upper bound)
      individualValue = 1   (interrupt up-counting value)
  */
  IEC60335_InitInterruptTest(&TC1_IntTest, 99, 101, 1);
#endif

#if CLK_TEST
	RTC_Init();         // Intialize the Real Time Clock
	
	/*
    IEC60335_initClockTest(timerOccThreshold, rtcOccThreshold, timerLowerBound, timerUpperBound);

    Used:
      Timer 0 interrupt         : every 10 msec
      Real Time Clock interrupt : every 1 sec
      Main loop clock test is called every ~100 msec
	
    So:
      timerOccThreshold = 1  (within 100 msec always more than one TC0 interrupt has occurred
      rtcOccThreshold   = 11 (need 11 x 100 msec to have at least one RTC interrupt
	
    Within 1 RTC interrupt 100 TC0 interrupts should have occurred
    So:
      timerLowerBound = 99  (more timer interrupts than lower bound)
      timerUpperBound = 101 (less timer interrupts than upper bound)
  */
  IEC60335_initClockTest(1, 11, 99, 101);
#endif		

	while (1)
	{
#if CPU_REG_TEST || PC_TEST || RAM_TEST || FLASH_TEST || INTEGRATED_TEST
		Delay(500);
#endif
#if CPU_REG_TEST || INTEGRATED_TEST
		if(IEC60335_CPUregTest_BIST()== IEC60335_testFailed)
		{//test failed
			while(1);				
		}
		else 
		{//test passed
			LED_toggle(0);
		}
#endif
#if PC_TEST || INTEGRATED_TEST
		if(IEC60335_B_PCTest_BIST()== IEC60335_testFailed)
		{//test failed
			while(1);				
		}
		else 
		{//test passed
			LED_toggle(1);
		}
#endif
		
#if RAM_TEST || INTEGRATED_TEST
		if(IEC60335_RAMtest_BIST(0x40007000, 0x0100) == IEC60335_testFailed)
		{//test failed
			while(1);
		}
		else
		{//test passed
			LED_toggle(2);
		}
#endif		
		
#if FLASH_TEST || INTEGRATED_TEST	
		StartSoftSignatureGen(0x00000000, FLASH_TEST_RANGE_BIST, &signature);
		if(IEC60335_FLASHtest_BIST (0x00000000, FLASH_TEST_RANGE_BIST, &signature, FLASH_HARD_SIGN) == IEC60335_testFailed)
		{//failed
			while(1);
		}
		else
		{//passed
			LED_toggle(3);
		}
#endif

#if INT_TEST || CLK_TEST		
		if (clock_100ms)                       // 100 msec passed?
		{
			clock_100ms = 0;                   // yes, clear flag
	#if INT_TEST	
			if(IEC60335_InterruptCheck(&TC1_IntTest) == IEC60335_testFailed)
			{//failed
				while (1);
			}
			else
			{//passed
				LED_toggle(4);
			}
	#endif
	#if CLK_TEST	
			if(IEC60335_Clocktest_MainLoopHandler() == IEC60335_testFailed)
			{//failed
				LED_set(5);
				while (1);
			}
			else
			{//passed
				LED_toggle(5);
			}
	#endif
		}		
#endif	//#if INT_TEST || CLK_TEST || INTEGRATED_TEST
	}
}
