;/**
; * @file		IEC60335_B_CPUregTestPOST_ARM.asm
; * @purpose	IEC60335 Class B CPU register tests library
; * @version	v1.0
; * @date		6-aug-2009
; * @author		nlv15840
;*/
;/*----------------------------------------------------------------------------
; * Software that is described herein is for illustrative purposes only
; * which provides customers with programming information regarding the
; * products. This software is supplied "AS IS" without any warranties.
; * NXP Semiconductors assumes no responsibility or liability for the
; * use of the software, conveys no license or title under any patent,
; * copyright, or mask work right to the product. NXP Semiconductors
; * reserves the right to make changes in the software without
; * notification. NXP Semiconductors also make no representation or
; * warranty that such application will be suitable for the specified
; * use without further testing or modification.
; **********************************************************************/

	AREA    |.text|, CODE, READONLY

	EXPORT	_CPUregTestPOST	
	IMPORT	CPUregTestPOST_struct

;/* Test pattern definition */ 
pattern1 	EQU		0xAAAAAAAA
pattern2 	EQU		0xAAAAAAA8
pattern3 	EQU		0x55555555
pattern4 	EQU		0x55555554
pattern5 	EQU		0xA000009F
pattern6 	EQU		0x5000005F

;/* Test structure offset definitions */
testState  	EQU 	0x0
testPassed 	EQU 	0x4

;/* Start of the CPU test */
_CPUregTestPOST

;   /* Push ALL registers to stack */
    push    {r0-r12,r14}

	mov 	r12, lr
	cmp		r12, lr
	bne		_cpu_low_test_fail

;/*---- LOW REGISTERS r0-r7 --------------------
; * 	First the low registers r0-r7 are tested
; */

;/* r0 register test:
; * Since r0 is the first register to be tested
; * and no other registers may be used, r0 should be tested
; * by only using immediate instructions.
; */
_cpu_low_test
;	/* Since cmp can only compare with an immediate
;	 * 8-bit value, the bits to be tested needs to
;	 * be shifted to the LSB's.
;	 */
;	/* r0 - stuck at 0 test */
	mov		r0, #0xAA
;	/* r0 - test r0[7:0] */
	cmp 	r0, #0xAA
	bne		_cpu_low_test_fail
;	/* r0 - test r0[15:8] */
	mov		r0, #0xAA00
	lsr		r0, r0, #8
	cmp 	r0, #0xAA
	bne		_cpu_low_test_fail
;	/* r0 - test r0[23:16] */
	mov		r0, #0xAA0000
	lsr		r0, r0, #16
	cmp 	r0, #0xAA
	bne		_cpu_low_test_fail
;	/* r0 - test r0[31:24] */
	mov		r0, #0xAA000000
	lsr		r0, r0, #24
	cmp 	r0, #0xAA
	bne		_cpu_low_test_fail

;	/* r0 - inverted pattern and
;	 * neighbour stuck test
;	 */
	mov		r0, #0x0055
;	/* r0 - test r0[7:0] */
	cmp 	r0, #0x55
	bne		_cpu_low_test_fail
;	/* r0 - test r0[15:8] */
	mov		r0, #0x5500
	lsr		r0, r0, #8
	cmp 	r0, #0x55
	bne		_cpu_low_test_fail
;	/* r0 - test r0[23:16] */
	mov		r0, #0x550000
	lsr		r0, r0, #16
	cmp 	r0, #0x55
	bne		_cpu_low_test_fail
;	/* r0 - test r0[31:24] */
	mov	r0, #0x55000000
	lsr		r0, r0, #24
	cmp 	r0, #0x55
	bne		_cpu_low_test_fail

;	/*!! NOW r0 is known good !!*/

_cpu_r0_test_pass
 	b		_cpu_r1_r7_test

_cpu_r0_test_fail
	b		_cpu_low_test_fail


;/* Register r1-r7 test:
; * The registers under test will be written with
; * pattern1 = 0xAAAA.AAAA. Each register will be individually
; * compared to r0 for a pass/fail for the test.
; * The second part of the test will write the inverted pattern
; * in the register under test and pass/fail with a cmp
; */
_cpu_r1_r7_test

;	/* Load pattern1 in r0 */
	ldr		r0,=pattern1

;	/* Put patter1 in r1-r7 */
	mov		r1,r0
	cmp		r1,r0
	bne		_cpu_low_test_fail

	mov		r2,r0
	cmp		r2,r0
	bne		_cpu_low_test_fail

	mov		r3,r0
	cmp		r3,r0
	bne		_cpu_low_test_fail

	mov		r4,r0
	cmp		r4,r0
	bne		_cpu_low_test_fail

	mov		r5,r0
	cmp		r5,r0
	bne		_cpu_low_test_fail

	mov		r6,r0
	cmp		r6,r0
	bne		_cpu_low_test_fail

	mov		r7,r0
	cmp		r7,r0
	bne		_cpu_low_test_fail

;	/* Load pattern3 in r0 */
	ldr		r0,=pattern3

;	/* Put patter3 in r1-r7 */
	mov		r1,r0
	cmp		r1,r0
	bne		_cpu_low_test_fail

	mov		r2,r0
	cmp		r2,r0
	bne		_cpu_low_test_fail

	mov		r3,r0
	cmp		r3,r0
	bne		_cpu_low_test_fail

	mov		r4,r0
	cmp		r4,r0
	bne		_cpu_low_test_fail

	mov		r5,r0
	cmp		r5,r0
	bne		_cpu_low_test_fail

	mov		r6,r0
	cmp		r6,r0
	bne		_cpu_low_test_fail

	mov		r7,r0
	cmp		r7,r0
	bne		_cpu_low_test_fail

_cpu_low_test_pass
;	/* Indicate in the CPUregTestPOST_struct
;	 * that r0-r7 tests passed.
;	 */
	mov		r0, #0xFF
	ldr		r1, =CPUregTestPOST_struct+testState
	str		r0, [r1]
	b		_cpu_high_test

_cpu_low_test_fail
	b		_cpu_high_test_fail

;/*--- HIGH REGISTERS r8-r12 ---*/
_cpu_high_test
;	/* Store the LR to r2 */
	mov	r2, r12

;	/* Clear r0 */
	mov	r0, #0x00

;	/* Load pattern1 in r0 */
	ldr		r0,=pattern1

;	/* Put patter1 in r8-r12 */
	mov		r8,r0
	cmp		r8,r0
	bne		_cpu_high_test_fail

	mov		r9,r0
	cmp		r9,r0
	bne		_cpu_high_test_fail

	mov		r10,r0
	cmp		r10,r0
	bne		_cpu_high_test_fail

	mov		r11,r0
	cmp		r11,r0
	bne		_cpu_high_test_fail

	mov		r12,r0
	cmp		r12,r0
	bne		_cpu_high_test_fail

;	/* Load pattern3 in r0 */
	ldr		r0,=pattern3

;	/* Put patter1 in r8-r12 */
	mov		r8,r0
	cmp		r8,r0
	bne		_cpu_high_test_fail

	mov		r9,r0
	cmp		r9,r0
	bne		_cpu_high_test_fail

	mov		r10,r0
	cmp		r10,r0
	bne		_cpu_high_test_fail

	mov		r11,r0
	cmp		r11,r0
	bne		_cpu_high_test_fail

	mov		r12,r0
	cmp		r12,r0
	bne		_cpu_high_test_fail

_cpu_high_test_pass
;	/* Restore the LR to r2 */
	mov		r12, r2
;	/* Indicate in the CPUregTestPOST_struct
;	 * that r8-r12 tests passed.
;	 */
	mov		r0, #0x1F00
	ldr		r1, =CPUregTestPOST_struct+testState
	ldr     r2, [r1]
	orr     r0, r0, r2
	str		r0, [r1]
	b		cpu_SP_test

_cpu_high_test_fail
;	/* Restore the LR to r2 */
	mov		r12, r2
	b		_cpu_SP_test_fail


;/* sp register tests:
; * For the sp a different pattern is used because sp[1:0] are
; * always zero.
; */
cpu_SP_test
;	/* Store the current SP */
	mov		r4, r13

;	/* Load pattern2 in r0 */
	ldr		r0,=pattern2

;	/* Move pattern2 in the SP */
	mov		r13, r0

;	/* Compare the pattern with the input pattern */
	cmp		r13, r0
	bne		_cpu_SP_test_fail_res

;	/* Load pattern4 in r0 */
	ldr		r0,=pattern4

;	/* Move pattern4 in the MSP */
	mov		r13, r0

;	/* Compare the pattern with the input pattern */
	cmp		r13, r0
	bne		_cpu_SP_test_fail_res

_cpu_SP_test_pass
;	/* Restore the SP */
	mov 	r13, r4

;	/* Indicate in the CPUregTestPOST_struct
;	 * that SP tests passed.
;	 */
    mov	    r0, #0x2000
    ldr     r1, =CPUregTestPOST_struct+testState
    ldr     r2, [r1]
    orr     r0,	r0, r2
    str     r0, [r1]
	b		_cpu_LR_test

_cpu_SP_test_fail_res
;	/* Restore the SP */
	mov 	r13, r4
_cpu_SP_test_fail
	b		_cpu_LR_test_fail

;/* LR register test:
; * The link register will be written with pattern1,
; * then compared for a pass/fail. Secondly the inverse
; * of the pattern will be tested.
; */
_cpu_LR_test
;	/* Store the current link register */
	mov		r3, r14
;	/* Load pattern1 in r0 */
	ldr		r0,=pattern1

;	/* Move pattern1 in the MSP */
	mov		r14, r0

;	/* Compare the pattern with the input pattern */
	cmp		r14, r0
	bne		_cpu_LR_test_fail_res

;	/* Load pattern1 in r0 */
	ldr		r0,=pattern3

;	/* Move pattern1 in the MSP */
	mov		r14, r0

;	/* Compare the pattern with the input pattern */
	cmp		r14, r0
	bne		_cpu_LR_test_fail_res

_cpu_LR_test_pass
;	/* Restore the LR */
	mov 	r14, r3
;   /* Indicate in the CPUregTestPOST_struct
;    * that LR tests passed.
;    */
    mov	    r0, #0x4000
    ldr     r1, =CPUregTestPOST_struct+testState
    ldr     r2, [r1]
    orr     r0, r0, r2
    str     r0, [r1]
	b		_cpu_CPSR_test

_cpu_LR_test_fail_res
;	/* Restore the LR */
	mov 	r14, r3
_cpu_LR_test_fail
	b 		_cpu_CPSR_test_fail

;/* CPSR register tests:
; * The CPSR register will be written with pattern5, because only APSR[31:28...7:6]
; * can be modified,
; * then compared for a pass/fail. Secondly the inverse
; * of the pattern will be tested.
; */
_cpu_CPSR_test
;	/* Store the current CPSR register */
	mrs		r3, CPSR

;	/* Load pattern1 in r0 */
	ldr		r0,=pattern5

;	/* Move pattern1 in the CPSR */
	msr		CPSR_cxsf, r0

;	/* Read pattern1 from the CPSR */
	mrs		r1, CPSR

;	/* Compare the pattern with the input pattern */
	cmp		r1, r0
	bne		_cpu_CPSR_test_fail_res

;	/* Load pattern1 in r0 */
	ldr		r0,=pattern6

;	/* Move pattern1 in the CPSR */
	msr		CPSR_cxsf, r0

;	/* Read pattern1 from the CPSR */
	mrs		r1, CPSR

;	/* Compare the pattern with the input pattern */
	cmp		r1, r0
	bne		_cpu_CPSR_test_fail_res

_cpu_CPSR_test_pass
;	/* Restore the CPSR */
	msr 	CPSR_cxsf, r3

;   /* Indicate in the CPUregTestPOST_struct
;    * that CPSR tests passed.
;    */
    mov	    r0, #0x8000
    ldr     r1, =CPUregTestPOST_struct+testState
    ldr     r2, [r1]
    orr     r0, r0, r2
    str     r0, [r1]
	b		cpu_test_pass

_cpu_CPSR_test_fail_res
;	/* Restore the CPSR */
	msr 	CPSR_cxsf, r3
_cpu_CPSR_test_fail
	b 		cpu_test_fail

cpu_test_pass
	mov		r0, #0x01
	ldr		r1, =CPUregTestPOST_struct+testPassed
	str		r0, [r1]
	b		exit

cpu_test_fail
;	/* Clear r0 as CPU reg test fail */
	movs	r0, #0x00
	ldr     r1, =CPUregTestPOST_struct+testPassed
    str     r0, [r1]

exit
;   /* Pop the stack back */
    pop     {r0-r12,r14}
	
	bx 		lr

	END