#ifndef __SPIFI_SYS_CONFIG_H__
#define __SPIFI_SYS_CONFIG_H__

#define SPIFI_REG_BASE 0x40003000
#define SPIFI_MEM_BASE 0x80000000
/* allocated size of the SPIFI memory area on this device */
#define MEM_AREA_SIZE  0x08000000
//#define SPIFI_ROM_PTR  0x10400118
#define SPIFI_PLATFORM "LPC18xx/43xx @80000000"
#define SPIFI_VIRT_SECT_SIZE (1024*256)
 
/* CPU frequency in Hz */
#define CPU_FREQ 50000000
/* >=1.8 uS delay after Set high performance Mode command (Winbond and others) */
#define DECR_LOOP_CT_1_8_US (CPU_FREQ/300000)
/* timeout waiting for Busy */
#define LOOP_CT_WAIT_BUSY 4000

/**
 * IO definitions
 * this file contains definitions for both V1 and V2 SPIFI hardware
 *
 * define access restrictions to peripheral registers
 */
 
#ifdef __cplusplus
  #undef      __I
  #define     __I     volatile                /*!< defines 'read only' permissions      */
#else
  #undef      __I
  #define     __I     volatile const          /*!< defines 'read only' permissions      */
#endif
#undef      __O
#define     __O     volatile                  /*!< defines 'write only' permissions     */
#undef      __IO
#define     __IO    volatile                  /*!< defines 'read / write' permissions   */
 
#include <stdint.h>  
 
#pragma anon_unions
 
/* SPIFI register struct: define this at a platform-specific address */
typedef struct {
        __IO uint32_t CONTROL;
        __IO uint32_t COMMAND;
        __IO uint32_t ADDRESS;
        union {
                __IO uint32_t IDATA_WORD;
                __IO uint16_t IDATA_HWORD;
                __IO uint8_t  IDATA_BYTE;
        };
        __O  uint32_t ADDR_IDATA;
 
        union {
                __IO uint32_t DATA_WORD;
                __IO uint16_t DATA_HWORD;
                __IO uint8_t  DATA_BYTE;
        };
        __IO uint32_t MCOMMAND;
        __IO  uint32_t STATUS;
} SPIFI_Regs_Typedef;
 
/* having made such a nice struct, eliminate the need to use it */
#define SPIFI_REGS ((SPIFI_Regs_Typedef *) SPIFI_REG_BASE)
 
#define SPIFI_CONTROL     (SPIFI_REGS->CONTROL)
#define SPIFI_COMMAND     (SPIFI_REGS->COMMAND)
#define SPIFI_ADDRESS     (SPIFI_REGS->ADDRESS)
#define SPIFI_IDATA_WORD  (SPIFI_REGS->IDATA_WORD)
#define SPIFI_IDATA_HWORD (SPIFI_REGS->IDATA_HWORD)
#define SPIFI_IDATA_BYTE  (SPIFI_REGS->IDATA_BYTE)
#define SPIFI_ADDR_IDATA  (SPIFI_REGS->ADDR_IDATA)
#define SPIFI_DATA_WORD   (SPIFI_REGS->DATA_WORD)
#define SPIFI_DATA_HWORD  (SPIFI_REGS->DATA_HWORD)
#define SPIFI_DATA_BYTE   (SPIFI_REGS->DATA_BYTE)
#define SPIFI_MCOMMAND    (SPIFI_REGS->MCOMMAND)
#define SPIFI_STATUS      (SPIFI_REGS->STATUS)
 
/* bits and fields in CONTROL */
#define TO_MASK    0xFFFF
#define TO_SHIFT 0
#define CSHI_MASK  0xF0000
#define CSHI_SHIFT 16
#define NO_PREF    0x08000000
#define DUAL_MASK  0x10000000
#define RFCLK_MASK 0x20000000
#define FBCLK_MASK 0x40000000
#define DRQEN_MASK 0x80000000
 
#define CLRID_MASK 0x0200000
#define CLRID_SHIFT 21
#define INTEN_MASK 0x0400000
#define INTEN_SHIFT 22
#define MODE3_MASK 0x0800000
#define MODE3_SHIFT 23
 
/* bits and fields in COMMAND */
#define DATALEN_MASK            0x00003FFF
#define DATALEN_SHIFT           0
#define UNL_DATA                DATALEN_MASK
#define POLLRS                  0x00004000
#define DOUT                    0x00008000
#define INTLEN_MASK             0x00070000
#define INTLEN_SHIFT            16
#define PS_MASK                 0x00180000
#define PS_SHIFT                19
#define FRAMEFORM_MASK          0x00E00000
#define FRAMEFORM_SHIFT         21
#define OPCODE_MASK             0xFF000000
#define OPCODE_SHIFT            24
 
/* bits and fields in ADDR_IDATA */
#define ADDR_MASK               0x00FFFFFF
#define ADDR_SHIFT              0
#define IDATA_MASK              0xFF000000
#define IDATA_SHIFT             24
 
/* MCOMMAND contains most of the same bits and fields as in COMMAND */
 
/* bits in STATUS */
#define MCINIT_MASK             1
#define MCINIT_SHIFT            0
#define CMD_MASK                2
#define CMD_SHIFT               1
#define MCMD_MASK               4
#define MCMD_SHIFT              2
#define CMDI_MASK               8
#define CMDI_SHIFT              3
#define RESET_MASK              0x10
#define INTRQ_MASK              0x20
#define FIFOBYTES_MASK          0x1F00
#define FIFOBYTES_SHIFT         8
#define VERSION_MASK            0xFF000000
#define VERSION_SHIFT           24

#endif
