#include "lpc_usbhost.h"
#include "lpc_pinsel.h"
#include  "bsp.h"

void Host_CtrlInit(void);

/*********************************************************************//**
 * @brief 			Init host controller.
 * @param[in]		None.
 * @return 		None.
 **********************************************************************/
void  Host_Init (void)
{

    LPC_SC->PCONP   |= 0x80000000; 		/* Enable USB Interface	*/

    LPC_USB->OTGClkCtrl   = 0x00000019;  /* Enable USB host clock, OTG clock & AHB master clock  	*/
    while ((LPC_USB->OTGClkSt & 0x00000019) != 0x19);

	LPC_USB->StCtrl = 0x1;

#if (_CURR_USING_BRD == _RDB4078_BOARD)

	PINSEL_ConfigPin(0,29,1);	/* USB_D+1	*/
	PINSEL_ConfigPin(0,30,1);	/* USB_D-1	*/

	PINSEL_ConfigPin(1,22,2);		/* USB_PWRD1 */
	PINSEL_ConfigPin(1,27,2);		/* USB_OVRCR1	*/
	PINSEL_ConfigPin(1,19,2);		/* USB_PPWR1 */

#else
#if _CURR_USING_BRD == _EA_PA_BOARD

	// Port U1
	PINSEL_ConfigPin(0,29,1);	/* USB_D+1	*/
	PINSEL_ConfigPin(0,30,1);	/* USB_D-1	*/

	PINSEL_ConfigPin(2,9,1);		/* USB_CONNECT1 */
	PINSEL_ConfigPin(1,18,1);		/* USB_UP_LED1	*/

#if 0
	PINSEL_ConfigPin(1,19,1);	    /* USB_TX_E1*/
	PINSEL_ConfigPin(1,22,1);	    /* USB_RX_E1*/
    PINSEL_ConfigPin(1,20,1);		/* USB_TX_DP1 */
    PINSEL_ConfigPin(1,21,1);		/* USB_TX_DM1 */
    PINSEL_ConfigPin(1,23,1);		/* USB_RX_DP1 */
    PINSEL_ConfigPin(1,24,1);		/* USB_RX_DM1 */
#else
	PINSEL_ConfigPin(1,19,2);		/* USB_PPWR1	*/
	PINSEL_ConfigPin(1,27,1);		/* USB_OVRCR1	*/
#endif

	// Port U2
	PINSEL_ConfigPin(0,31,1);		/* USB_D+2	*/
	PINSEL_ConfigPin(0,14,3);		/* USB_CONNECT2	*/
	PINSEL_ConfigPin(0,13,1);		/* USB_UP_LED2	*/

#if 1 /* Use USB Power Switch */
	PINSEL_ConfigPin(0,12,1);		/* USB_PPWR2	*/
	PINSEL_ConfigPin(1,31,1);		/* USB_OVRCR2	*/
#else
	PINSEL_ConfigPin(1,30,2);		/* USB_VBUS	*/
#endif

#else	  /* _CURR_USING_BRD == _IAR_OLIMEX_BOARD */
	// Port U2
	PINSEL_ConfigPin(0,31,1);		/* USB_D+2	*/
	PINSEL_ConfigPin(0,14,3);		/* USB_CONNECT2	*/
	PINSEL_ConfigPin(0,13,1);		/* USB_UP_LED2	*/

	PINSEL_ConfigPin(0,12,1);		/* USB_PPWR2	*/
	PINSEL_ConfigPin(1,31,1);		/* USB_OVRCR2	*/

#endif /* _CURR_USING_BRD == _EA_PA_BOARD */

#endif

    Host_CtrlInit();


    /* Enable the USB Interrupt */
	NVIC_EnableIRQ(USB_IRQn);               /* enable USB interrupt */
	NVIC_SetPriority (USB_IRQn, 0);			/* highest priority */


}
