//*****************************************************************************
//   +--+
//   | ++----+
//   +-++    |
//     |     |
//   +-+--+  |
//   | +--+--+
//   +----+    Copyright (c) 2011 Code Red Technologies Ltd.
//
// crt_flash_if.c : Flash driver interface
//
//*****************************************************************************

#include <stddef.h>
#include "crt_flash_if.h"

// Symbols defined in the linker script
extern UINT32	_b_bss;
extern UINT32	_e_bss;
extern UINT32	__load_base;
extern UINT32	__image_size;
extern UINT32	__cache;
extern UINT32	__cache_size;	// redefine in instance structure
extern UINT32	__initial_sp;
extern UINT32	__stack_size;

// Flash Device
extern struct FlashDevice const FlashDevice;

// MemoryDevice Instance (fill it in)
__attribute__ ((section(".cr_data"))) MemoryDevice_t CR_FlashDevice =
{
  0x0010,					// Version of flash interface
							// Magic number to identify flash driver interface
  { 0x01, 0x23, 0x45, 0x00, 0x00, 0x54, 0x32, 0x10 },
  (UINT32)&__load_base,		// Driver load address
  (UINT32)&__image_size,	// Size of .text and .data
  (UINT32)&__cache,			// RAM buffer location
  (UINT32)&__cache_size,	// RAM buffer size (4096 - 8 pages)
  (UINT32)&__initial_sp,	// Stack top
  (UINT32)&__stack_size,	// Stack size
  (UINT32)&__finish_loc,	// Driver finish location
							// Device configuration
  // Flash Driver API
  &FlashDevice,				// Flash Device
  Init,						// Initialize Flash
  UnInit,					// De-initialize Flash
  BlankCheck,				// Blank Check
  EraseChip,				// Erase complete Device
  EraseSector,				// Erase Sector Function
  ProgramPage,				// Program Page Function
  Verify					// Verify Function
};

///////////////////////////////////////////////////////////////////////////////
// void __finish_loc(void)
//
// Exit point
//
///////////////////////////////////////////////////////////////////////////////

__attribute__((naked)) void __finish_loc(void)
{
   while(1);
}
