/*
* (C) Code Red Technologies Ltd, 2011
 * Linker script for LPC1850A/4350A Hitex SST39VF3201B Flash Driver
*/
__stack_size = 128;								/* stack size */
__cache_size = 2048;							/* flash image default buffer size */
	
MEMORY
{
     SRAM (rwx) : ORIGIN = 0x10000000, LENGTH = 0x18000 /* 96k */
}

GROUP(libcr_c.a libcr_eabihelpers.a)

SEARCH_DIR(..)

SECTIONS
{
	ENTRY(Init)						
	
	.cr_data :
	{
		CREATE_OBJECT_SYMBOLS
		_b_cr_data = .;
		__load_base = _b_cr_data;
		KEEP(*crt_flash_if.o (.cr_data))
		_e_cr_data = .;
	} > SRAM
		
	.text :
	{
		CREATE_OBJECT_SYMBOLS
		_b_text = .;
		KEEP(*crt_flash_if.o (.text))
		KEEP(*(.text*))
		_e_text = .;		
	} > SRAM


	.data :
	{
		CREATE_OBJECT_SYMBOLS
		_b_data = .;
		KEEP(*FlashDev.o (.data))
		KEEP(*(.data*))
		_e_data = .;
		_b_rodata = _e_data;			
		*(.rodata*)
		_e_rodata = .;
	} > SRAM
	
  __image_size = _e_rodata - _b_cr_data; 
  
	/*
		bss order: stack -> RAM buffer
	*/
	.bss :
	{
		CREATE_OBJECT_SYMBOLS
		_b_bss = .;
		*(.bss*)
		_e_bss = .;
		__initial_sp = _e_bss + __stack_size;	/* initial stack pointer */
		_b_cache = __initial_sp;
		__cache = _b_cache;
		_e_cache = __cache + __cache_size;	/* flash image buffer location */
	} > SRAM
}

