/***********************************************************************
 * $Id: spifi_rom_api.h 6475 2011-02-16 19:09:07Z nxp27266 $
 *
 * Project: LPC18xx Rev '-' SPIFI Example
 *
 * Description: SPIFI example project.
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/   
#ifndef SPIFI_ROM_API_H
#define SPIFI_ROM_API_H

/* the object that init returns, and other routines use as an operand */
typedef struct {
	char data[144];
} SPIFIobj;

/* values in protMode (changed to bit-mapped  Jul 6 2010) */
enum {PROT_STAT=1, PROT_REG=2, PROT_CMD3=4, PROT_CMDE=8};

/* error result codes (0 means success)	*/
enum    { SPIFI_ERROR_BASE=0x00020000,
	  SPIFI_DEVICE_ERROR = SPIFI_ERROR_BASE+1,
	  SPIFI_INTERNAL_ERROR, /*0x20002 */
	  SPIFI_TIMEOUT,	/*0x20003 */
	  SPIFI_OPERAND_ERROR,	/*0x20004 */
	  SPIFI_STATUS_PROBLEM,	/*0x20005 */
	  SPIFI_UNKNOWN_EXT,	/*0x20006 */
	  SPIFI_UNKNOWN_ID,	/*0x20007 */
	  SPIFI_UNKNOWN_TYPE,	/*0x20008 */
	  SPIFI_UNKNOWN_MFG	/*0x20009 */
};

#define SPIFI_MEM_BASE 0x80000000

int spifi_init(SPIFIobj *obj, unsigned clksel, unsigned clkdiv, int clkFast,
				unsigned csHigh, int mode3, unsigned timeout, unsigned dummies);

extern int (* spifi_program)(SPIFIobj *obj, char *source, char *dest,	unsigned length,
                  char *scratch, int protect, int force_erase);
extern int (* spifi_erase)(SPIFIobj *obj, char *start, unsigned length, char *scratch,
				 int protect);

#endif
