/***********************************************************************
 * $Id:: Retarget.c 6511 2011-02-19 05:43:47Z nxp12832                 $
 *
 * Project: LPC18xx Common
 *
 * Description:
 *     'Retarget' layer for target-dependent low level functions
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

#include <stdio.h>
#include <rt_misc.h>
#include "stdint.h"
#include "uart.h"

extern volatile uint8_t UART1TxEmpty;
extern volatile uint8_t UART1Buffer[BUFSIZE];
extern volatile uint32_t UART1Count;

#pragma import(__use_no_semihosting_swi)


/*----------------------------------------------------------------------------
  Write character to Serial Port
 *----------------------------------------------------------------------------*/
int sendchar (int c) {

	uint8_t data[1];

	data[0] = c;

//	UARTSend(0, data , 1);
	UARTSend(1, data , 1);
//	UARTSend(2, data , 1);
//	UARTSend(3, data , 1);

  return (c);
}

/*----------------------------------------------------------------------------
  Read character from Serial Port   (blocking read)
 *----------------------------------------------------------------------------*/
int _getkey (void) {
int i;
int c;

while(!UART1Count);

	c = UART1Buffer[0];
	for(i=0;i<UART1Count-1;i++)
		UART1Buffer[i] = UART1Buffer[i+1];
	UART1Count--;

return (c);
//return(0);
}


struct __FILE { int handle; /* Add whatever you need here */ };
FILE __stdout;
FILE __stdin;
FILE __stderr;
			  


int fputc(int ch, FILE *f) {
  return (sendchar(ch));
}


int fgetc(FILE *f) {
  return (_getkey());
}


int ferror(FILE *f) {
  /* Your implementation of ferror */
  return EOF;
}


void _ttywrch(int ch) {
  sendchar(ch);
}


void _sys_exit(int return_code) {
label:  goto label;  /* endless loop */
}
