/***********************************************************************
 * $Id::                                                               $
 *
 * Project:	hello_world_semihosting_tiny
 * File:	main.c
 * Description:
 * 			This project is a fully modified "Hello World!\n" example.
 * 			The project makes use of a LGPL printf library which is
 * 			size optimized, has a reduced size exception vector (because
 * 			interrupts are not used), the linker is configured to removed
 * 			unreferenced sections, and code size optimization is enabled
 *
 * 			At nearly 27KB hello_world_semihosting cannot be made to fit
 * 			the LPC1111. This project can easily fit in the LPC1111's 8KB
 * 			of flash memory.
 *
 * 			small printf original work from Georges Menie (www.menie.org),
 * 			stdarg version contributed by Christian Ettinger
 *
 * 			The project has non-standard post build events which generate
 * 			two useful text files for comparing code size:
 * 			"symbol_size.txt" is the output of nm sorted by size
 * 			"disassembly.txt" is the entire project's disassembly with inline C source
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

#ifdef __USE_CMSIS
#include "LPC11xx.h"
#endif

#include "debug.h"

extern unsigned long _etext;

int main(void)
{
	volatile unsigned int i=0;
	const unsigned int programSize =  (unsigned int) &_etext;

	//SystemInit(); //!! Note !! Call to SystemInit() is removed from startup code

	//Because this project uses no interrupts, the definition of the exception vector
	//has been reduced to further save FLASH

	debug_printf("Hello World\nSize: %d 0x%X\n", programSize, programSize);
	while(1)
	{
		i++;
		debug_printf("i: %d 0x%X\n", i, i);
	}
	return 0 ;
}
