/*==================================================================================================
*   (c) Copyright 2015-2016 Freescale Semiconductor, Inc.
*   Copyright 2017-2019 NXP
*   NXP Confidential. This software is owned or controlled by NXP and may only be used strictly
*   in accordance with the applicable license terms. By expressly accepting
*   such terms or by downloading, installing, activating and/or otherwise using
*   the software, you are agreeing that you have read, and that you agree to
*   comply with and are bound by, such license terms. If you do not agree to
*   be bound by the applicable license terms, then you may not retain,
*   install, activate or otherwise use the software.
==================================================================================================*/
#include <MPC577xC.h>
#include "siu_init.h"


/***************************************************************************//*!
*
* @brief   SIUL2 configuration
*
* @return  N/A
*
******************************************************************************/
void SIU_init(void)
{
    /* SIU configuration for eSCI A */
    /* SIU configuration for eSCI A */
    SIU.PCR[89].B.PA  = 1;            // Pin asigned to ESCI A Tx
    SIU.PCR[89].B.OBE = 1;            // Open drain enable
    SIU.PCR[90].B.PA  = 1;            // Pin asigned to ESCI A Rx
    SIU.PCR[90].B.IBE = 1;            // Input buffer enable

    /* SIU configuration for Resolver - SDADC */
    /* SDADC A +: AN[0] - A4
               -: AN[1] - B5 */
    /* SDADC D +: AN[0] - C18
               -: AN[1] - D17 */


    /* Debug pin */
    SIU.PCR[176].B.PA = 0;		// GPIO176 - Debug pin 2
    SIU.PCR[176].B.OBE = 1;            // Output buffer enable
    SIU.PCR[177].B.PA = 0;		// GPIO177 - Debug pin 1
    SIU.PCR[177].B.OBE = 1;            // Output buffer enable
    SIU.PCR[178].B.PA = 0;		// GPIO178 - Debug pin 0
    SIU.PCR[178].B.OBE = 1;            // Output buffer enable

}


