/*==================================================================================================
*   (c) Copyright 2014-2016 Freescale Semiconductor, Inc.
*   Copyright 2017-2019 NXP
*   NXP Confidential. This software is owned or controlled by NXP and may only be used strictly
*   in accordance with the applicable license terms. By expressly accepting
*   such terms or by downloading, installing, activating and/or otherwise using
*   the software, you are agreeing that you have read, and that you agree to
*   comply with and are bound by, such license terms. If you do not agree to
*   be bound by the applicable license terms, then you may not retain,
*   install, activate or otherwise use the software.
==================================================================================================*/

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "sd_adc.h"
#include "MPC577xC.h"

/*==================================================================================================
*                                       GLOBAL FUNCTIONS
==================================================================================================*/
/**
* @brief          This function performs configuration of SDADC.
*
*/
void sdadc_init(uint8_t pdr, uint8_t gain, uint8_t fifo_thld, uint8_t inp_mode)
{

	/* SD ADC 1 CONFIGURATION */

	SDADC_1.SFR.R = 0x1B;	// clear all the status flags
	SDADC_1.FCR.B.FRST = 1;	// generate reset to flush FIFO
	SDADC_1.FCR.B.FTHLD = fifo_thld;	// FIFO threshold - overcome generates FIFO full event flag
	SDADC_1.FCR.B.FSIZE = 2;	// FIFO size: 0 - 1 word, 1 - 4 words, 2 - 8 words, 3 - 16 words
	SDADC_1.FCR.B.FOWEN = 0;	// disable FIFO overwrite
	SDADC_1.FCR.B.FE = 1;	// enable FIFO
	
	SDADC_1.RSER.B.DFFDIRS = 1;	// DMA request on data FIFO full
	SDADC_1.RSER.B.DFFDIRE = 1; // data FIFO full request enable
	
	SDADC_1.MCR.B.MODE = inp_mode;	// input mode: 0 - differential, 1 - single-ended
	SDADC_1.MCR.B.PDR = pdr;	// Oversampling rate 
	SDADC_1.MCR.B.PGAN = gain;	// Gain 
	SDADC_1.MCR.B.HPFEN = 1;	// High-pass filter enabled
	SDADC_1.MCR.B.EN = 1;	// internal SDADC modulator enabled

	SDADC_1.OSDR.B.OSD = 1;	// set the output settling delay
	
	SDADC_1.CSR.B.ANCHSEL = 0;	// analog input channel AN[x] selection
	SDADC_1.MCR.B.TRIGEN = 1;	// enable HW trigger
	
	/* SD ADC 4 CONFIGURATION */
	SDADC_4.SFR.R = 0x1B;	// clear all the status flags	
	SDADC_4.FCR.B.FRST = 1;	// generate reset to flush FIFO
	SDADC_4.FCR.B.FTHLD = fifo_thld;	// FIFO threshold - overcome generates FIFO full event flag
	SDADC_4.FCR.B.FSIZE = 3;	// FIFO size: 0 - 1 word, 1 - 4 words, 2 - 8 words, 3 - 16 words
	SDADC_4.FCR.B.FOWEN = 0;	// disable FIFO overwrite
	SDADC_4.FCR.B.FE = 1;	// enable FIFO
	
	// DMA settings
	SDADC_4.RSER.B.DFFDIRS = 1;	// DMA request on data FIFO full
	SDADC_4.RSER.B.DFFDIRE = 1; // data FIFO full request enable
	
	SDADC_4.MCR.B.MODE = inp_mode;	// input mode: 0 - differential, 1 - single-ended
	SDADC_4.MCR.B.PDR = pdr;	// Oversampling rate
	SDADC_4.MCR.B.PGAN = gain;	// Gain 
	SDADC_4.MCR.B.HPFEN = 1;	// High-pass filter enabled 
	SDADC_4.MCR.B.EN = 1;	// internal SDADC modulator enabled
	
	SDADC_4.OSDR.B.OSD = 1;	// set the output settling delay
	
	SDADC_4.CSR.B.ANCHSEL = 0;	// analogue input channel AN[x] selection

	SDADC_4.MCR.B.TRIGSEL = 0;	// SDADC_1 trigger output selected as an input trigger for SDADC 
	SDADC_4.MCR.B.TRIGEDSEL = 1;	// rising edge of trigger input selected
	SDADC_4.MCR.B.TRIGEN = 1;	// enable HW trigger
	
}

/**
* @brief          This function starts the SDADC operation.
*
*/
void sdadc_start(void)
{
	// start the SDADC_1 by SW trigger 
	SDADC_1.STKR.R = 0xFFFF;
}
