/*==================================================================================================
*   Project              : Safety Runtime Library - RDC Checker
*   Platform             : MPC5775E
*
*   SW Version           : 0.4.1
*
*   Copyright 2019 NXP
*   NXP Confidential. This software is owned or controlled by NXP and may only be used strictly
*   in accordance with the applicable license terms. By expressly accepting
*   such terms or by downloading, installing, activating and/or otherwise using
*   the software, you are agreeing that you have read, and that you agree to
*   comply with and are bound by, such license terms. If you do not agree to
*   be bound by the applicable license terms, then you may not retain,
*   install, activate or otherwise use the software.
==================================================================================================*/
#ifndef RDC_CHECKER_H
#define RDC_CHECKER_H

/*==================================================================================================
*                                      DEFINES AND MACROS
==================================================================================================*/ 
/* Fractional numbers */
#define RDC_FRACT24(x)           ( (fract24)( (x) * (1<<23) ))
#define RDC_FRACT16(x)           ( (fract16)( (x) * (1<<15) ))

/* RDC Checker fault flags, @ref faultStatus */
#define RDC_FAULT_SIN_STUCK      0x0001
#define RDC_FAULT_COS_STUCK      0x0002
#define RDC_FAULT_SIN_AMPL_OOR   0x0004
#define RDC_FAULT_COS_AMPL_OOR   0x0008
#define RDC_FAULT_SIN_DC_SHFT    0x0010
#define RDC_FAULT_COS_DC_SHFT    0x0020
#define RDC_FAULT_SIG_PHS_SHFT   0x0040
#define RDC_FAULT_VEC_OOR        0x0100
#define RDC_FAULT_ATO_ERR        0x0200
#define RDC_FAULT_EXT_ERR        0x0400
#define RDC_FAULT_TIME_STUCK     0x1000
#define RDC_FAULT_TIMIMNG        0x2000

/* RDC Checker fault thresholds */
#define RDC_THR_SIG_MAX_AMPL     RDC_FRACT16(0.8)
#define RDC_THR_SIG_DC_SHFT      RDC_FRACT16(0.05)
#define RDC_THR_SIG_ZC_AMPL      RDC_FRACT16(0.05)
#define RDC_THR_VEC_MIN_SQR      RDC_FRACT16(0.6 * 0.6)
#define RDC_THR_VEC_MAX_SQR      RDC_FRACT16(0.8 * 0.8)
#define RDC_THR_ATO_ERR          RDC_FRACT24(2.0/360)
#define RDC_THR_EXT              RDC_FRACT24(1.0/360)
#define RDC_THR_TIMING           (5000)
#define RDC_PERIOD_TCR1          (19968*20)

/* Absolute value function */
#define RDC_ABS(x)               ((x)<0 ? -(x) : (x))

/*==================================================================================================
*                                STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/ 
typedef signed long fract24;
typedef signed long fract16;
typedef signed long int24;

typedef struct
{
	fract16  sin08;           /**< SIN input signal sample at the position of positive max */
	fract16  sin24;           /**< SIN input signal sample at the position of negative max */
	fract16  cos08;           /**< COS input signal sample at the position of positive max */
	fract16  cos24;           /**< COS input signal sample at the position of negative max */
	fract16  sin16;           /**< SIN input signal sample at the position of zero-crossing */
	fract16  cos16;           /**< COS input signal sample at the position of zero-crossing */
    fract24  angle08;         /**< ATO result afer processing the first half-period */
    int24    timestamp08;     /**< A timestamp of the first half-period */
    fract24  angle24;         /**< ATO result afer processing the second half-period */
    int24    timestamp24;     /**< A timestamp of the second half-period */
    fract24  angle_ext;       /**< Extrapolation result */
} RDC_InputDataStr; 

/*==================================================================================================
*                                    FUNCTION PROTOTYPES
==================================================================================================*/ 
void RDC_Checker( void );
unsigned long RDC_Checker_FaultStatus( void );
void RDC_Checker_LL( void );

/*==================================================================================================
*                                      GLOBAL VARIABLES
==================================================================================================*/ 
extern RDC_InputDataStr rdc_data;

#endif /* RDC_CHECKER_H */
