/*==================================================================================================
*   (c) Copyright 2014-2016 Freescale Semiconductor, Inc.
*   Copyright 2019 NXP
*   NXP Confidential. This software is owned or controlled by NXP and may only be used strictly
*   in accordance with the applicable license terms. By expressly accepting
*   such terms or by downloading, installing, activating and/or otherwise using
*   the software, you are agreeing that you have read, and that you agree to
*   comply with and are bound by, such license terms. If you do not agree to
*   be bound by the applicable license terms, then you may not retain,
*   install, activate or otherwise use the software.
==================================================================================================*/

#ifndef PIT_H_
#define PIT_H_

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "typedefs.h"

/*==================================================================================================
*                                    FUNCTION PROTOTYPES
==================================================================================================*/
void pit0_start_wait_ns(uint32_t time_ns);
void pit0_stop(void);
uint8_t pit0_read_flag(void);
uint32_t pit0_read_values_ns(void);
void pit0_irq_config(uint8_t irq);


/*==================================================================================================
*                                      DEFINES AND MACROS
==================================================================================================*/
#define SCALE_TO_NS ((1000UL)/(100UL))
#define PIT_IRQ_ENABLE    1
#define PIT_IRQ_DISABLE   0

#endif /* PIT_H_ */
