# Contributing to Trusted Firmware M

Contributions to TF-M project need to follow the process below.

`Note` Please contact [Maintainers](./maintainers.md) for any questions.

- Create an issue in [http://issues.trustedfirmware.org](http://issues.trustedfirmware.org)
  to keep others informed about your ongoing work.
- If it is a major change then please discuss the design with maintainers.
- Clone the TF-M code on your own machine from
  [http://git.trustedfirmware.org/trusted-firmware-m.git](http://git.trustedfirmware.org/trusted-firmware-m.git)
- Follow the [Coding Guidelines](docs/coding_guide.md) for the TF-M project.
- Make your changes in logical chunks to help reviewers.
- Update relevant documentation.
- Test your changes and add details to the commit description.
- Add the issue number and details to commit description as well.
- The code is accepted under [DCO](./dco.txt), Developer Certificate
  of Origin, so you must add following fields to your commit description.
```
    Author: Full Name <email address>
    Signed-off-by: Full Name <email address>

    Note: Sign off authority needs to adhere to the [DCO](./dco.txt) rules.
```
- You may add other fields in the commit message.
- Submit your patch for review at
  [http://review.trustedfirmware.org](http://review.trustedfirmware.org)
- Maintainers will be notified and they will start review process.
- You may be asked to provide further details or make additional changes.
- You can discuss further with maintainer(s) offline if necessary.
- Once the change is approved by maintainers, the patch can be submitted
  either by maintainer or patch owner.

--------------

*Copyright (c) 2017-2019, Arm Limited. All rights reserved.*
