#line 2 "elftosb_lexer.cpp"

#line 4 "elftosb_lexer.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 39
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

    /* The c++ scanner is a mess. The FlexLexer.h header file relies on the
     * following macro. This is required in order to pass the c++-multiple-scanners
     * test in the regression suite. We get reports that it breaks inheritance.
     * We will address this in a future release of flex, or omit the C++ scanner
     * altogether.
     */
    #define yyFlexLexer yyFlexLexer

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */
#include <iostream> 
#include <errno.h>
#include <cstdlib>
#include <cstdio>
#include <cstring>
/* end standard C++ headers. */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t yyleng;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{

	std::istream* yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

#define yytext_ptr yytext

#include <FlexLexer.h>

int yyFlexLexer::yywrap() { return 1; }
int yyFlexLexer::yylex()
	{
	LexerError( "yyFlexLexer::yylex invoked but %option yyclass used" );
	return 0;
	}

#define YY_DECL int ElftosbLexer::yylex()

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 84
#define YY_END_OF_BUFFER 85
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[261] =
    {   0,
        0,    0,    0,    0,    0,    0,   85,   83,   80,   81,
       81,   73,   83,   83,   83,   58,   63,   83,   43,   44,
       56,   54,   48,   55,   51,   57,   36,   36,   49,   50,
       66,   47,   52,   74,   35,   45,   46,   60,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   41,   64,
       42,   59,   83,   83,   82,   80,   81,   82,   81,   70,
        0,   75,    0,    0,   79,   38,   71,    0,    0,   65,
       53,   39,    0,    0,   36,   36,    0,    0,   61,   68,
       69,   67,   62,   35,   35,   32,   35,   35,   35,   35,

       35,   35,   35,   35,   35,   35,   35,   35,   15,   35,
       35,   35,   35,   35,   35,   34,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   40,   72,   76,   77,
       78,    0,    0,   37,    0,    0,   36,   36,   14,   35,
       35,   22,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   23,   35,   24,   35,   35,   35,   35,   35,
        8,   35,   35,   35,   35,   35,   35,   35,   33,    0,
        0,   37,    0,    0,    0,   11,   35,   35,   16,   35,
       35,   35,   35,   35,   35,   35,    7,   18,   10,   35,
       35,    9,   12,   35,   35,   35,   35,   35,   35,   35,

        0,    0,    0,    0,   37,    0,   35,   35,   35,   35,
       13,   20,   35,   35,   35,   35,   35,   35,   26,   35,
       35,   35,   35,   35,   37,    0,   37,    0,   35,   35,
       28,   35,    6,   35,   35,   35,   35,   35,   35,   21,
       35,   35,   35,    0,   35,   17,   30,    4,   27,   29,
       31,    1,    5,    3,   35,   19,   35,   25,    2,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
       22,   22,   22,   22,   22,   22,   22,   23,   24,   25,
       26,   27,   28,   29,   30,   30,   31,   30,   32,   30,
       33,   34,   34,   34,   33,   34,   33,   34,   34,   34,
       34,   34,   35,   34,   34,   34,   34,   34,   34,   34,
       36,    1,   37,   38,   39,    1,   40,   41,   42,   43,

       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
       54,   55,   34,   56,   57,   58,   59,   60,   61,   62,
       63,   64,   65,   66,   67,   68,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[69] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    1,    1,    3,    3,    1,    4,
        4,    4,    1,    1,    1,    1,    1,    3,    1,    4,
        4,    4,    5,    5,    5,    3,    3,    3,    5,    4,
        4,    4,    4,    4,    4,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    1,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[274] =
    {   0,
        0,    0,   67,  133,   70,   76,  427,  428,  428,  428,
      423,  399,   69,  421,    0,  428,  413,  390,  428,  428,
      407,  428,  428,  428,  402,   62,   83,   93,  428,  428,
       57,  393,   65,  428,    0,  428,  428,  428,  367,  200,
       46,   52,   66,   83,  377,   80,  357,  371,  360,  359,
      358,  356,   62,   94,  354,  356,  368,  363,  341,  339,
      428,  428,    0,  337,  428,  428,  400,  383,  428,  428,
      112,  428,  114,  398,  428,    0,  428,  118,  136,  428,
      428,  428,  397,  119,  139,  428,  136,    0,  428,  428,
      428,  428,  428,    0,  348,  428,  347,  344,  353,  350,

      337,   90,   37,  335,  341,  340,  336,  348,    0,  343,
      329,  334,  322,  344,  340,    0,  324,  320,  323,  337,
      314,  318,  317,  318,  318,  316,  428,  428,  428,  428,
      428,  152,  155,  156,  158,  209,  228,  149,    0,  321,
      314,    0,  322,  325,  327,  311,  309,  311,  320,  306,
      304,  309,    0,  306,    0,  304,  138,  315,  313,  308,
        0,  311,  296,  309,  296,  307,  306,  296,    0,  164,
      316,  315,  154,  149,  210,    0,  288,  292,    0,  293,
      280,  298,  285,  284,  295,  294,    0,    0,  298,  285,
      279,    0,    0,  280,  275,  284,  277,  288,  287,  280,

      316,  187,  220,  221,  222,  223,  286,  281,  280,  268,
        0,    0,  269,  265,  263,  265,  275,  257,    0,  251,
      255,  249,  205,  210,  428,  231,  228,  160,  206,  214,
        0,  194,    0,  193,  192,  205,  190,  187,  190,    0,
      182,  141,  149,  224,  136,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  141,    0,  105,    0,    0,  428,
      268,  273,  278,  283,  286,  291,  293,  139,  298,  123,
      303,  308,  313
    } ;

static yyconst flex_int16_t yy_def[274] =
    {   0,
      260,    1,  261,  261,  262,  262,  260,  260,  260,  260,
      260,  260,  263,  264,  265,  260,  260,  266,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  267,  260,  260,  260,  267,  267,
      267,  267,  267,  267,   40,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,   40,  267,  260,  260,
      260,  260,  268,  260,  260,  260,  260,  260,  260,  260,
      263,  260,  263,  264,  260,  265,  260,  269,  269,  260,
      260,  260,  264,  260,  260,  260,  260,  270,  260,  260,
      260,  260,  260,  267,  267,  260,  267,  267,  267,  267,

      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  260,  260,  260,  260,
      260,  263,  271,  271,  271,  271,  260,  270,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  263,
      272,  272,  272,  272,  273,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,

      260,  260,  260,  271,  271,  271,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  260,  260,  272,  272,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  271,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,    0,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260
    } ;

static yyconst flex_int16_t yy_nxt[497] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
       18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
       28,   28,   29,   30,   31,   32,   33,    8,   34,   35,
       35,   35,   35,   35,   35,   36,   37,   38,   35,   39,
       40,   41,   42,   43,   44,   35,   45,   46,   47,   48,
       49,   50,   51,   52,   35,   53,   54,   55,   56,   35,
       57,   35,   58,   35,   59,   60,   61,   62,    9,   10,
       11,   66,   10,   67,   72,   82,  147,   66,   10,   67,
       83,   89,   90,   68,   84,   97,   63,   63,   63,   68,
       92,   93,  148,   99,   84,  100,   63,   63,   63,   98,

       73,  118,   85,   85,   85,  119,   63,   63,   63,   63,
       63,   63,   85,   85,   85,   86,  101,   72,  102,   72,
       84,  103,  105,   87,  109,   86,  138,  104,  134,  145,
      106,  146,  110,   64,    9,   10,   11,  120,  107,  111,
       84,  121,  129,   73,   88,   73,  134,  122,  132,  135,
       84,   86,   63,   63,   63,  137,  137,   72,   85,   85,
       85,  259,   63,   63,   63,  172,  172,  135,  172,   72,
      136,   86,   63,   63,   63,   63,   63,   63,  190,  204,
      202,   86,  170,   73,  258,  202,  173,  173,  203,  173,
      244,  202,  174,  257,  256,   73,  255,  225,  191,   64,

       96,   96,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   96,  172,
      205,  226,   96,   96,   96,   96,   96,   96,   96,   84,
      225,  227,  227,  227,  227,   96,   96,   96,  254,  175,
      173,  206,  253,  252,  251,  250,  249,  137,  137,  248,
      171,  247,  173,  173,  173,  173,  246,  228,  245,  202,
       86,  201,  243,  242,   96,   96,   96,   96,    8,    8,
        8,    8,    8,   65,   65,   65,   65,   65,   71,   71,
       71,   71,   71,   74,   74,   74,   74,   74,   76,   76,
       76,   78,  241,   78,   78,   78,   94,   94,  133,  240,

      133,  133,  133,  171,  239,  171,  171,  171,  201,  238,
      201,  201,  201,  204,  237,  204,  204,  204,  236,  235,
      234,  233,  232,  231,  230,  229,  225,  224,  223,  222,
      221,  220,  219,  218,  217,  216,  215,  214,  116,  213,
      212,  211,  210,  209,  208,  207,  202,  202,  200,  199,
      169,  198,  197,  196,  195,  194,  193,  192,  189,  188,
      187,  186,  185,  184,  183,  182,  181,  180,  179,  178,
      177,  176,  169,  168,  167,  166,  165,  164,  163,  162,
      161,  160,  159,  158,  157,  156,  155,  154,  153,  152,
      151,  150,  149,  144,  143,  142,  141,  140,  139,   75,

       75,  131,   69,  130,  128,  127,  126,  125,  124,  123,
      117,  116,  115,  114,  113,  112,  108,   95,   91,   81,
       80,   79,   77,   75,   70,   69,  260,    7,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260

    } ;

static yyconst flex_int16_t yy_chk[497] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    3,    3,
        3,    5,    5,    5,   13,   26,  103,    6,    6,    6,
       26,   31,   31,    5,   27,   41,    3,    3,    3,    6,
       33,   33,  103,   42,   28,   42,    3,    3,    3,   41,

       13,   53,   27,   27,   27,   53,    3,    3,    3,    3,
        3,    3,   28,   28,   28,   27,   43,   71,   43,   73,
       84,   43,   44,   27,   46,   28,  270,   43,   78,  102,
       44,  102,   46,    3,    4,    4,    4,   54,   44,   46,
       85,   54,  268,   71,   27,   73,   79,   54,   73,   78,
      138,   84,    4,    4,    4,   87,   87,  132,   85,   85,
       85,  257,    4,    4,    4,  133,  134,   79,  135,  170,
       79,   85,    4,    4,    4,    4,    4,    4,  157,  174,
      174,  138,  132,  132,  255,  173,  133,  134,  173,  135,
      228,  228,  135,  245,  243,  170,  242,  202,  157,    4,

       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   40,  136,
      175,  202,   40,   40,   40,   40,   40,   40,   40,  137,
      203,  204,  205,  206,  244,   40,   40,   40,  241,  136,
      136,  175,  239,  238,  237,  236,  235,  137,  137,  234,
      203,  232,  204,  205,  206,  244,  230,  206,  229,  227,
      137,  226,  224,  223,   40,   40,   40,   40,  261,  261,
      261,  261,  261,  262,  262,  262,  262,  262,  263,  263,
      263,  263,  263,  264,  264,  264,  264,  264,  265,  265,
      265,  266,  222,  266,  266,  266,  267,  267,  269,  221,

      269,  269,  269,  271,  220,  271,  271,  271,  272,  218,
      272,  272,  272,  273,  217,  273,  273,  273,  216,  215,
      214,  213,  210,  209,  208,  207,  201,  200,  199,  198,
      197,  196,  195,  194,  191,  190,  189,  186,  185,  184,
      183,  182,  181,  180,  178,  177,  172,  171,  168,  167,
      166,  165,  164,  163,  162,  160,  159,  158,  156,  154,
      152,  151,  150,  149,  148,  147,  146,  145,  144,  143,
      141,  140,  126,  125,  124,  123,  122,  121,  120,  119,
      118,  117,  115,  114,  113,  112,  111,  110,  108,  107,
      106,  105,  104,  101,  100,   99,   98,   97,   95,   83,

       74,   68,   67,   64,   60,   59,   58,   57,   56,   55,
       52,   51,   50,   49,   48,   47,   45,   39,   32,   25,
       21,   18,   17,   14,   12,   11,    7,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260,  260,  260,  260,  260,
      260,  260,  260,  260,  260,  260

    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[85] =
    {   0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
    0, 1, 0, 0, 0,     };

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "elftosb_lexer.l"
/*
 * Copyright (c) Freescale Semiconductor, Inc. All rights reserved.
 * See included license file for license details.
 */
/* %option prefix="Elftosb" */
#line 14 "elftosb_lexer.l"
#include "ElftosbLexer.h"
#include <stdlib.h>
#include <limits.h>
#include <string>
#include "HexValues.h"
#include "Value.h"

using namespace elftosb;

//! Always executed before all other actions when a token is matched.
//! This action just assign the first and last lines of the token to
//! the current line. In most cases this is correct.
#define YY_USER_ACTION	do {									\
							m_location.m_firstLine = m_line;		\
							m_location.m_lastLine = m_line;		\
						} while (0);

/* start conditions */

#line 676 "elftosb_lexer.cpp"

#define INITIAL 0
#define blob 1
#define mlcmt 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
#define ECHO LexerOutput( yytext, yyleng )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
\
	if ( (result = LexerInput( (char *) buf, max_size )) < 0 ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) LexerError( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
#define YY_DECL int yyFlexLexer::yylex()
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = & std::cin;

		if ( ! yyout )
			yyout = & std::cout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 42 "elftosb_lexer.l"


#line 813 "elftosb_lexer.cpp"

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 261 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 260 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			yy_size_t yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					   
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 44 "elftosb_lexer.l"
{ return TOK_OPTIONS; }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 45 "elftosb_lexer.l"
{ return TOK_CONSTANTS; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 46 "elftosb_lexer.l"
{ return TOK_SOURCES; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 47 "elftosb_lexer.l"
{ return TOK_FILTERS; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 48 "elftosb_lexer.l"
{ return TOK_SECTION; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 49 "elftosb_lexer.l"
{ return TOK_EXTERN; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 50 "elftosb_lexer.l"
{ return TOK_FROM; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 51 "elftosb_lexer.l"
{ return TOK_RAW; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 52 "elftosb_lexer.l"
{ return TOK_LOAD; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 53 "elftosb_lexer.l"
{ return TOK_JUMP; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 54 "elftosb_lexer.l"
{ return TOK_CALL; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 55 "elftosb_lexer.l"
{ return TOK_MODE; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 56 "elftosb_lexer.l"
{ return TOK_ERASE; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 57 "elftosb_lexer.l"
{ return TOK_ALL; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 58 "elftosb_lexer.l"
{ return TOK_IF; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 59 "elftosb_lexer.l"
{ return TOK_ELSE; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 60 "elftosb_lexer.l"
{ return TOK_DEFINED; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 61 "elftosb_lexer.l"
{ return TOK_INFO; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 62 "elftosb_lexer.l"
{ return TOK_WARNING; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 63 "elftosb_lexer.l"
{ return TOK_ERROR; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 64 "elftosb_lexer.l"
{ return TOK_SIZEOF; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 65 "elftosb_lexer.l"
{ return TOK_DCD; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 66 "elftosb_lexer.l"
{ return TOK_HAB; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 67 "elftosb_lexer.l"
{ return TOK_IVT; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 68 "elftosb_lexer.l"
{ return TOK_UNSECURE; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 69 "elftosb_lexer.l"
{ return TOK_RESET; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 70 "elftosb_lexer.l"
{ return TOK_JUMP_SP; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 71 "elftosb_lexer.l"
{ return TOK_ENABLE; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 72 "elftosb_lexer.l"
{ return TOK_KEYBLOB; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 73 "elftosb_lexer.l"
{ return TOK_ENCRYPT; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 74 "elftosb_lexer.l"
{ return TOK_KEYWRAP; }
	YY_BREAK
case 32:
/* rule 32 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 1);
(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 76 "elftosb_lexer.l"
{	// must be followed by any non-ident char
										int_size_t theSize;
										switch (yytext[0])
										{
											case 'w':
												theSize = kWordSize;
												break;
											case 'h':
												theSize = kHalfWordSize;
												break;
											case 'b':
												theSize = kByteSize;
												break;
										}
										m_symbolValue.m_int = new elftosb::SizedIntegerValue(0, theSize);
										return TOK_INT_SIZE;
									}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 94 "elftosb_lexer.l"
{
										m_symbolValue.m_int = new elftosb::SizedIntegerValue(1, kWordSize);
										return TOK_INT_LITERAL;
									}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 99 "elftosb_lexer.l"
{
										m_symbolValue.m_int = new elftosb::SizedIntegerValue(0, kWordSize);
										return TOK_INT_LITERAL;
									}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 104 "elftosb_lexer.l"
{
										m_symbolValue.m_str = new std::string(yytext);
										if (isSourceName(m_symbolValue.m_str))
										{
											return TOK_SOURCE_NAME;
										}
										else
										{
											return TOK_IDENT;
										}
									}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 116 "elftosb_lexer.l"
{
										int base = 0;
										uint32_t value;
										int mult;
										
										// check for binary number
										if (yytext[0] == '0' && yytext[1] == 'b')
										{
											base = 2;		// this is a binary number
											yytext += 2;	// skip over the "0b"
										}
										
										// convert value
										value = (uint32_t)strtoul(yytext, NULL, base);
										
										// find multiplier
										switch (yytext[strlen(yytext) - 1])
										{
											case 'G':
												mult = 1024 * 1024 * 1024;
												break;
											case 'M':
												mult = 1024 * 1024;
												break;
											case 'K':
												mult = 1024;
												break;
											default:
												mult = 1;
												break;
										}
										
										// set resulting symbol value
										m_symbolValue.m_int = new elftosb::SizedIntegerValue(value * mult, kWordSize);
										return TOK_INT_LITERAL;
									}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 153 "elftosb_lexer.l"
{
										uint32_t value = 0;
										int_size_t theSize;
										int len = strlen(yytext);
										if (len >= 3)
										{
											value = yytext[1];
											theSize = kByteSize;
										}
										if (len >= 4)
										{
											value = (value << 8) | yytext[2];
											theSize = kHalfWordSize;
										}
										if (len >= 6)
										{
											value = (value << 8) | yytext[3];
											value = (value << 8) | yytext[4];
											theSize = kWordSize;
										}
										m_symbolValue.m_int = new elftosb::SizedIntegerValue(value, theSize);
										return TOK_INT_LITERAL;
									}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 177 "elftosb_lexer.l"
{
										// remove $ from string
										m_symbolValue.m_str = new std::string(&yytext[1]);
										return TOK_SECTION_NAME;
									}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 184 "elftosb_lexer.l"
{ BEGIN(mlcmt); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 186 "elftosb_lexer.l"
{
										m_blob = new Blob();
										m_blobFirstLine = yylineno;
										BEGIN(blob);
									}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 192 "elftosb_lexer.l"
{ return '{'; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 194 "elftosb_lexer.l"
{ return '}'; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 196 "elftosb_lexer.l"
{ return '('; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 198 "elftosb_lexer.l"
{ return ')'; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 200 "elftosb_lexer.l"
{ return '['; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 202 "elftosb_lexer.l"
{ return ']'; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 204 "elftosb_lexer.l"
{ return '='; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 206 "elftosb_lexer.l"
{ return ','; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 208 "elftosb_lexer.l"
{ return ':'; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 210 "elftosb_lexer.l"
{ return ';'; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 212 "elftosb_lexer.l"
{ return '.'; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 214 "elftosb_lexer.l"
{ return '>'; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 216 "elftosb_lexer.l"
{ return TOK_DOT_DOT; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 218 "elftosb_lexer.l"
{ return '+'; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 220 "elftosb_lexer.l"
{ return '-'; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 222 "elftosb_lexer.l"
{ return '*'; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 224 "elftosb_lexer.l"
{ return '/'; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 226 "elftosb_lexer.l"
{ return '%'; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 228 "elftosb_lexer.l"
{ return '~'; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 230 "elftosb_lexer.l"
{ return '^'; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 232 "elftosb_lexer.l"
{ return TOK_LSHIFT; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 234 "elftosb_lexer.l"
{ return TOK_RSHIFT; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 236 "elftosb_lexer.l"
{ return '&'; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 238 "elftosb_lexer.l"
{ return '|'; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 240 "elftosb_lexer.l"
{ return TOK_POWER; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 242 "elftosb_lexer.l"
{ return '<'; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 244 "elftosb_lexer.l"
{ return TOK_GEQ; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 246 "elftosb_lexer.l"
{ return TOK_LEQ; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 248 "elftosb_lexer.l"
{ return TOK_EQ; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 250 "elftosb_lexer.l"
{ return TOK_NEQ; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 252 "elftosb_lexer.l"
{ return TOK_AND; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 254 "elftosb_lexer.l"
{ return TOK_OR; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 256 "elftosb_lexer.l"
{ return '!'; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 258 "elftosb_lexer.l"
{ return '@'; }
	YY_BREAK
case 75:
/* rule 75 can match eol */
YY_RULE_SETUP
#line 261 "elftosb_lexer.l"
{
										// get rid of quotes
										yytext++;
										yytext[strlen(yytext) - 1] = 0;
//										processStringEscapes(yytext, yytext);
										m_symbolValue.m_str = new std::string(yytext);
										return TOK_STRING_LITERAL;
									}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 270 "elftosb_lexer.l"
{
										uint8_t x = (hexCharToInt(yytext[0]) << 4) | hexCharToInt(yytext[1]);
										m_blob->append(&x, 1);
									}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 275 "elftosb_lexer.l"
{
										BEGIN(INITIAL);
										m_symbolValue.m_blob = m_blob;
										m_blob = NULL;
										m_location.m_firstLine = m_blobFirstLine;
										return TOK_BLOB;
									}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 283 "elftosb_lexer.l"
{
                                        // end of multi-line comment, return to initial state
                                        BEGIN(INITIAL);
                                    }
	YY_BREAK
case 79:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 289 "elftosb_lexer.l"
/* absorb single-line comment */
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 291 "elftosb_lexer.l"
/* eat up whitespace in all states */
	YY_BREAK
case 81:
/* rule 81 can match eol */
YY_RULE_SETUP
#line 293 "elftosb_lexer.l"
{
										/* eat up whitespace and count lines in all states */
										m_line++;
									}
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 298 "elftosb_lexer.l"
/* ignore all other chars in a multi-line comment */
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 300 "elftosb_lexer.l"
{
										/* all other chars produce errors */
										char msg[50];
										sprintf(msg, "unexpected character '%c' on line %d", yytext[0], m_line);
										LexerError(msg);
									}
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 307 "elftosb_lexer.l"
ECHO;
	YY_BREAK
#line 1430 "elftosb_lexer.cpp"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(blob):
case YY_STATE_EOF(mlcmt):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* The contents of this function are C++ specific, so the () macro is not used.
 */
yyFlexLexer::yyFlexLexer( std::istream* arg_yyin, std::ostream* arg_yyout )
{
	yyin = arg_yyin;
	yyout = arg_yyout;
	yy_c_buf_p = 0;
	yy_init = 0;
	yy_start = 0;
	yy_flex_debug = 0;
	yylineno = 1;	// this will only get updated if %option yylineno

	yy_did_buffer_switch_on_eof = 0;

	yy_looking_for_trail_begin = 0;
	yy_more_flag = 0;
	yy_more_len = 0;
	yy_more_offset = yy_prev_more_offset = 0;

	yy_start_stack_ptr = yy_start_stack_depth = 0;
	yy_start_stack = NULL;

	yy_buffer_stack = 0;
	yy_buffer_stack_top = 0;
	yy_buffer_stack_max = 0;

	yy_state_buf = 0;

}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
yyFlexLexer::~yyFlexLexer()
{
	delete [] yy_state_buf;
	yyfree(yy_start_stack  );
	yy_delete_buffer( YY_CURRENT_BUFFER );
	yyfree(yy_buffer_stack  );
}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
void yyFlexLexer::switch_streams( std::istream* new_in, std::ostream* new_out )
{
	if ( new_in )
		{
		yy_delete_buffer( YY_CURRENT_BUFFER );
		yy_switch_to_buffer( yy_create_buffer( new_in, YY_BUF_SIZE  ) );
		}

	if ( new_out )
		yyout = new_out;
}

#ifdef YY_INTERACTIVE
size_t yyFlexLexer::LexerInput( char* buf, size_t /* max_size */ )
#else
size_t yyFlexLexer::LexerInput( char* buf, size_t max_size )
#endif
{
	if ( yyin->eof() || yyin->fail() )
		return 0;

#ifdef YY_INTERACTIVE
	yyin->get( buf[0] );

	if ( yyin->eof() )
		return 0;

	if ( yyin->bad() )
		return -1;

	return 1;

#else
	(void) yyin->read( buf, max_size );

	if ( yyin->bad() )
		return -1;
	else
		return yyin->gcount();
#endif
}

void yyFlexLexer::LexerOutput( const char* buf, size_t size )
{
	(void) yyout->write( buf, size );
}

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
int yyFlexLexer::yy_get_next_buffer()
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    yy_state_type yyFlexLexer::yy_get_previous_state()
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 261 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    yy_state_type yyFlexLexer::yy_try_NUL_trans( yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 261 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 260);

		return yy_is_jam ? 0 : yy_current_state;
}

    void yyFlexLexer::yyunput( int c, register char* yy_bp)
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register yy_size_t number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

    int yyFlexLexer::yyinput()
{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		   
    yylineno++;
;

	return c;
}

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyFlexLexer::yyrestart( std::istream* input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yyFlexLexer::yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

    void yyFlexLexer::yy_load_buffer_state()
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yyFlexLexer::yy_create_buffer( std::istream* file, int size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yyFlexLexer::yy_delete_buffer( YY_BUFFER_STATE b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    void yyFlexLexer::yy_init_buffer( YY_BUFFER_STATE b, std::istream* file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

	b->yy_is_interactive = 0;
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yyFlexLexer::yy_flush_buffer( YY_BUFFER_STATE b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yyFlexLexer::yypush_buffer_state (YY_BUFFER_STATE new_buffer)
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yyFlexLexer::yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
void yyFlexLexer::yyensure_buffer_stack(void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

    void yyFlexLexer::yy_push_state( int new_state )
{
    	if ( (yy_start_stack_ptr) >= (yy_start_stack_depth) )
		{
		yy_size_t new_size;

		(yy_start_stack_depth) += YY_START_STACK_INCR;
		new_size = (yy_start_stack_depth) * sizeof( int );

		if ( ! (yy_start_stack) )
			(yy_start_stack) = (int *) yyalloc(new_size  );

		else
			(yy_start_stack) = (int *) yyrealloc((void *) (yy_start_stack),new_size  );

		if ( ! (yy_start_stack) )
			YY_FATAL_ERROR( "out of memory expanding start-condition stack" );
		}

	(yy_start_stack)[(yy_start_stack_ptr)++] = YY_START;

	BEGIN(new_state);
}

    void yyFlexLexer::yy_pop_state()
{
    	if ( --(yy_start_stack_ptr) < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN((yy_start_stack)[(yy_start_stack_ptr)]);
}

    int yyFlexLexer::yy_top_state()
{
    	return (yy_start_stack)[(yy_start_stack_ptr) - 1];
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

void yyFlexLexer::LexerError( yyconst char msg[] )
{
    	std::cerr << msg << std::endl;
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 306 "elftosb_lexer.l"



// verbatim code copied to the bottom of the output



