/*
 * Copyright 2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __TEST_ECMUL_H
#define __TEST_ECMUL_H

#include <stdint.h>

static uint32_t test_ecmulscalar[128][12] = {
    {0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x112534D9, 0xC7923BA7, 0xC27F0B57, 0xA58A3EFC, 0xBEE1DA7C, 0xB9D0BC88, 0x4395C030, 0x5900CE08, 0xD43F9C16, 0x0,
     0x0, 0x0},
    {0xB4939773, 0x6629B5D0, 0xD87D6744, 0xE541C5FC, 0x89B39493, 0xB4A920C6, 0x1703E15D, 0x8AAA27CA, 0x18FD9ABC,
     0xCB2D2AEE, 0xFB3919DA, 0x0},
    {0x282F518A, 0x724F4BFD, 0x23FB2C8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x752A1A6A, 0x25BD5D97, 0x6544842, 0x3C4FBE0A, 0x9221646D, 0x88EA9EB4, 0x6A2CA464, 0x1275E00A, 0x8F5BF05A,
     0x4BDA1045, 0x50ED9282, 0x0},
    {0xB2CA4313, 0x3BFE8C57, 0xB87AFA12, 0xC139E86, 0x337FF94C, 0x53703497, 0xFE9B5AB8, 0x69F38231, 0x9F2EF425,
     0x37156D8C, 0x0, 0x0},
    {0xDD8AF859, 0xE5437788, 0xFECD4C4B, 0xEFBBF560, 0x36EBAF55, 0xFA8EDA86, 0xDFFA3DB1, 0x164A20EA, 0xF2FD6486,
     0xFE8ACE3A, 0x94B53B2D, 0x0},
    {0xF267B44F, 0xC5942A49, 0x36CD5D89, 0xF505F19C, 0x640C6006, 0x1567E06E, 0xF365DEC5, 0x5F5E22C9, 0xC5CF1224,
     0xBBAA4C10, 0x7DE1DDC9, 0x23BF03E1},
    {0xB7C6BFBE, 0xDDC9D5A5, 0xB8A0AAD5, 0x71D694D3, 0xC179649D, 0x68C5F964, 0x8C7CD685, 0x658C379F, 0xC78B4C02, 0x0,
     0x0, 0x0},
    {0xA25BE054, 0xD72B63C5, 0x66140BFB, 0x6878BCE7, 0xD76A7821, 0xB6DCD4BB, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xDCD73879, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xF474E80E, 0x2E090CC5, 0x161E805F, 0x6E0909DB, 0x1CB3D765, 0x52A55FF5, 0xAA98D54D, 0x27314B06, 0x31D8B9EA, 0x0,
     0x0, 0x0},
    {0xFC904060, 0x5DC7AF70, 0x3DBB8829, 0x4443FB42, 0x8A10D6C2, 0xAEFCD03C, 0x679F8F22, 0x1417487F, 0xC9E0D54C,
     0xFFD36E95, 0x0, 0x0},
    {0x5A4135B4, 0x679C5552, 0xC44247AF, 0x8C9F6FAD, 0xBF6B5A2C, 0x94AEE296, 0x9EB84118, 0x67D35329, 0x5ACD5355, 0x0,
     0x0, 0x0},
    {0xFBEF4922, 0xCD5499D7, 0x37D49503, 0xAFBFA60B, 0x1EEA93BB, 0x319FAA92, 0x20F3338F, 0x253EBB19, 0x97BC3F7E, 0x0,
     0x0, 0x0},
    {0x909A7D2D, 0x1A3CA74, 0x65BB8A6B, 0x6EA10E1, 0x2A6F6F04, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xEFC1E069, 0x863F9186, 0x952DB97A, 0x105F059A, 0xA8ED1232, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x7C6E3D96, 0x711B30A9, 0x81E8A890, 0x679E2362, 0xB08AB054, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x3C10BAEA, 0x77B8F3D7, 0x5041A8D6, 0xB852DD01, 0x62B2DC70, 0xC9BE579C, 0xC1AEA46B, 0xCD86E6B9, 0x395FE443, 0x0,
     0x0, 0x0},
    {0x3C0EC461, 0x1E6B89E8, 0x9A42134A, 0x21F3AF81, 0x7D4556B6, 0xCD1DB192, 0xB69A0D7F, 0xF14FE3B2, 0x2D42B262,
     0xCA456014, 0xC5F48072, 0x38C5E353},
    {0xBD9D1F5C, 0x508F6E82, 0xED9BFFCD, 0xF254E1CE, 0xFB0D9ADD, 0x249EA7D4, 0x8359CCFF, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x8C2F616E, 0xC8056F68, 0xF03F6100, 0x590FAE89, 0x2DE0993E, 0xB226B28F, 0x6DE9756C, 0x700388C, 0xC9A4FD88,
     0x1A2AEEC0, 0x6B9839EA, 0xE1657D87},
    {0x978F1CE4, 0xF7697BD5, 0x466BD195, 0xAD2BA0D0, 0xDB2C0463, 0xCE339B7E, 0x6FF8F63, 0xF2AFCE14, 0xA0C847F2, 0x0,
     0x0, 0x0},
    {0xC5FBA796, 0x7040572B, 0x1100D65F, 0x5D4DE2BA, 0x8364229D, 0x5E93BEAA, 0xE10E5B53, 0x467D557A, 0xEAFF9D50,
     0x852CBF06, 0xF7B08FD9, 0x0},
    {0x5458A71F, 0x67F1631A, 0xA2D78135, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x18A169A9, 0x711F5A5, 0x12E6E7D0, 0x6E1BC83A, 0x37B799D0, 0x106FA03F, 0x3BE4E109, 0xB541C545, 0x0, 0x0, 0x0, 0x0},
    {0x9BA78E6, 0x24401F3D, 0x577CDAE8, 0x3380703D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x64A4157, 0x8BB48845, 0x37D23A99, 0xF6907B54, 0x9DDC5D3A, 0x97D7B674, 0xCEE55069, 0x324B904D, 0xA0BD5549,
     0x9D369E55, 0x0, 0x0},
    {0x251A1455, 0x885258ED, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xD5ED757A, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x88191C91, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xC03D349, 0xCC29ED3, 0xBBABBFE9, 0x6DF785B6, 0xFECDDFCC, 0x325085AB, 0x9CD0AF77, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x26E199F6, 0xE9C6A51, 0x92CAEAAA, 0x4DA74E0D, 0x841E9C5E, 0xA661F1B3, 0x50F6386D, 0x5EB940DF, 0x18B6A74E, 0x0,
     0x0, 0x0},
    {0xE07BED67, 0xDE3B51E7, 0xEE84383B, 0x6C13D76, 0xF5B6AA2B, 0x768C16FC, 0x9C2973BB, 0x45EF0CEE, 0xE0BAEB08, 0x0,
     0x0, 0x0},
    {0x746C10C2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xCFDCBD99, 0x8074F589, 0xBA1D1B22, 0x103F48EC, 0x22594C05, 0x1D8D1DB7, 0x46E13E6D, 0xEDCCD763, 0xA2AD6E86, 0x0,
     0x0, 0x0},
    {0xF6CFC827, 0x2E5324E7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x87B9C015, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xE928316D, 0x3ABB5CE1, 0xF1358D73, 0x1EF856C0, 0xD8628AF5, 0x908C0856, 0x2DAE192E, 0x88E6CE1A, 0x0, 0x0, 0x0,
     0x0},
    {0xB0E375BA, 0x6F7C0B9B, 0x18953625, 0xB20C806A, 0x5CD65FC, 0xD8BDEA92, 0x91C98709, 0xAF83EA65, 0xCA1FB10E, 0x0,
     0x0, 0x0},
    {0x3B1F19DA, 0x8E5FD3CA, 0x1BE9145C, 0xD2A87F20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xF580ED98, 0x825466C0, 0xCC11542F, 0xF017D777, 0x6B653385, 0x2D472DEF, 0x77D539A5, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x9C7979A7, 0xDBBEA8D7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x828B2B5B, 0x9DD6F1D4, 0xFA4737F5, 0xD8E5E2FB, 0xF176CF95, 0x7202397A, 0x64CAA10E, 0xCF705108, 0x68820729,
     0xA7B516A8, 0x7DD73040, 0xD56869DE},
    {0x462FF851, 0x53682CE3, 0x9A5500F8, 0xB0AC6F05, 0xEF87A1C3, 0xA25C438C, 0x13F63A8D, 0xA24F5559, 0x8260E40F, 0x0,
     0x0, 0x0},
    {0xCE99CE83, 0x7D336F33, 0x5DF6DBCC, 0xE5B27C4C, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xFD2C4CCE, 0x52050512, 0x18C4109A, 0xDB093477, 0xF5CBA4EC, 0x2E21880A, 0x7A67722A, 0x3488E47E, 0xD6D57BD0,
     0x45F5A7F3, 0x0, 0x0},
    {0x9DF6F94B, 0xBA90188B, 0xAE1D6EE0, 0xE35BB623, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x26B24AA7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x5B07C38E, 0x38206508, 0x8DEB2AC8, 0x63C9A920, 0x1FBD908, 0xA237F9D4, 0x8E5C2D88, 0x8B864092, 0x126129B9,
     0xBE2838A8, 0x17F04A0C, 0x0},
    {0x9D77AE14, 0xD9BBD6AA, 0x273CAA35, 0x2D8FB8DF, 0x7CE0229F, 0x667A2C4A, 0xE28A7791, 0xBD9BB9F5, 0x0, 0x0, 0x0,
     0x0},
    {0xDE46CD65, 0x7C4D5A86, 0x6310FB98, 0xC015E5B0, 0xB03D7D83, 0xA880901B, 0xEEDE83E, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x76433ED1, 0x727F39EB, 0x6DB9642E, 0x4EA4893, 0x6A95EB15, 0x501FF83, 0x8ECC23A6, 0x15FB9E81, 0xA13CA380, 0x0, 0x0,
     0x0},
    {0x54053BCD, 0x3DD53B51, 0x1157CBE5, 0x7FCF1520, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x9196759E, 0x74CDDB27, 0x36B9DCC8, 0x96239ADA, 0x41602415, 0x9CF46E90, 0x1B800AF4, 0x3686F2F5, 0xFF786DE6,
     0x3093C714, 0xD2AABBE3, 0x0},
    {0xCACFDD22, 0x3EB6ECC1, 0xDF587908, 0x23B20809, 0xE9B4DF4A, 0x63806A24, 0x6A27D253, 0x9CFCD565, 0xDD42EA20,
     0x4D894548, 0x37CDF9E0, 0x0},
    {0xAF04283C, 0xAC36D15A, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xEBB72D12, 0xA7438EA6, 0xEF1560EC, 0x986081C2, 0x8F02FA03, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x969EE377, 0x276AC5E1, 0x4F503123, 0x11CC5516, 0x77DF6A75, 0x974E62D4, 0x87B97F55, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xD475D066, 0x7585FA68, 0x27E73170, 0x4520FB75, 0xACFE08F5, 0x14D25D28, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x695E8019, 0xB1CB065, 0x5D0511F9, 0xAC0B6582, 0x7F894123, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x1F5BF298, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x192BFACA, 0xDEBFCCCC, 0xDB6C2E0A, 0x800FE286, 0xDD13FDB0, 0xA8809108, 0x3263608D, 0xCDD6BFCA, 0x91894E9A,
     0xDEB65765, 0x6DA09534, 0x0},
    {0xCB3B9F4B, 0x79946196, 0xB31334DE, 0x9A544BEA, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xB8B5C452, 0x2FD96465, 0xD481416A, 0xACCC521C, 0xE668112E, 0x8EFB0238, 0x46EF99F1, 0xBE55ECED, 0xBF7838FD,
     0x58B6B9FF, 0x0, 0x0},
    {0xA566E099, 0xCEEEA265, 0xF400CE14, 0x26925426, 0x4151880F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xBC98FD3C, 0x6B57DBDD, 0x61657079, 0x7B1D3409, 0xEE6AEC09, 0x24A00F41, 0xF5B88A7, 0xE79BF5C8, 0x62277BC7,
     0xA6E85C37, 0xD3F4A0CD, 0x0},
    {0xDE1D1C3A, 0x2E58A61F, 0x824BEB19, 0xD8B3ED65, 0x4333E7EF, 0x51E986F9, 0xE9C9A195, 0xF46ECE60, 0x2F99753B,
     0x6BB095D7, 0x1CB0062D, 0xB02AF42E},
    {0xE23FCDA4, 0xC856672, 0x797A12CB, 0xDB08FA45, 0x13834347, 0xCADD1FC1, 0x48032ADC, 0xD86ACFFD, 0xF4A354EF,
     0x368972F2, 0x1FBDDE1E, 0x1110918F},
    {0x9EA6333B, 0x49F2FE97, 0x4CF1D931, 0x50E118AE, 0x785B4CD6, 0xF709F79, 0xDA712A71, 0x8EFA87B6, 0x39156743,
     0x715352CE, 0x4EA572D6, 0x0},
    {0x2EA59CDA, 0x4E45AB87, 0xEA89FFA4, 0x6057D10D, 0x20806CE6, 0xAABF1870, 0x538E682B, 0x9157DD43, 0x13B62298, 0x0,
     0x0, 0x0},
    {0xF4862EA8, 0x7E237B1D, 0x4205037F, 0x3E07B36A, 0x31F6D83, 0x37DC97D3, 0x6B35C9AB, 0x92647E9D, 0x0, 0x0, 0x0, 0x0},
    {0x32AA8A39, 0xCB8994DA, 0xF5197779, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x9D53087E, 0xA5AC20E7, 0xE834419, 0xFC9E2BF7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x72D21689, 0xF2D040B0, 0xC94CC5CF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xADD3EA9D, 0x25C91BDE, 0xE21E1794, 0xE694CEB1, 0x8197D9FA, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x5BBA654C, 0xF05D9B4E, 0x7A54748A, 0xDC227851, 0xC3A67FEE, 0x94A79EC7, 0xC64A55F8, 0x5D5A90C7, 0x4D701C39,
     0x8A0D317C, 0x208BE256, 0x59ED682B},
    {0xD8E19AEA, 0xA313A517, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xEFAFE534, 0x80B501C1, 0xB9283BA0, 0xCB962A23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x5821F4B3, 0xAB141A40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x120C0335, 0xA0E1FF43, 0xD4E091D9, 0xDAFCBADF, 0x65802DDC, 0x37E9013D, 0x2180D053, 0x1AEC2AFB, 0x95E4BA2A,
     0xB3CA11D7, 0x0, 0x0},
    {0xEC2871C, 0x614F9D93, 0x7DDACEFD, 0x6ACB4164, 0x299CDD64, 0xCFE0AEFF, 0x977B0280, 0xCB5E3EB7, 0x0, 0x0, 0x0, 0x0},
    {0xA7F1ADE2, 0x60773776, 0xB84291A5, 0x374B5ACA, 0xA1B11BE2, 0xC992B009, 0xF24118C6, 0xE0C7F228, 0x0, 0x0, 0x0,
     0x0},
    {0x883C1199, 0xBE454B92, 0x1DA196DB, 0xDD27C6, 0x632E768F, 0xEB744495, 0xDB024F6C, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x6EF6E1B, 0xC0693054, 0x5A44AC3D, 0xD971BD2C, 0x2DEC86CF, 0x96C3F083, 0x70DBF4B0, 0x45094D3, 0x0, 0x0, 0x0, 0x0},
    {0x5E17105A, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xA2EAC041, 0x74180847, 0xC0AC32F9, 0x7E8ADBB8, 0x3DB5548F, 0xA44C4B96, 0xEDE3AF9B, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x17F6C00A, 0x22A64D88, 0xC8C89B25, 0xA9981E88, 0x15F2BE28, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xA682FB9D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x158E0786, 0xFD1D045E, 0x234F01FE, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x260A10C5, 0x2ED2346D, 0x591E61E0, 0xFE1EE973, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xEF8C6335, 0x767DC8C4, 0x4BDCFE55, 0x4E80E1, 0x88636A4F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x47EEDA8B, 0xC91D1590, 0x3AF434BC, 0xA7552A33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x9FB9CCB2, 0x5DF6CC66, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xFEDAFCCC, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x302804CD, 0xAA4C93E2, 0x71A9EDD3, 0xE4FFDEA5, 0x6ADDEA2F, 0x220E81BA, 0x167EDF0C, 0x1007E196, 0x0, 0x0, 0x0,
     0x0},
    {0xB8E26AE9, 0x2F6FFDCE, 0x476F5F7B, 0x7B22091D, 0x542949E, 0x71094FF4, 0xD8199C36, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x9A3C211A, 0x26751598, 0xDFE38920, 0xD414A22C, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xFC6B1633, 0x5AE24EAB, 0xCD01A3D0, 0xD6A5E592, 0x89F5A774, 0x3A5E4A13, 0x57E5B4F0, 0x620D7E4A, 0xC1813CF4,
     0xE198ED00, 0x0, 0x0},
    {0x7A457A66, 0x1B251392, 0x5C84527B, 0x1B585601, 0x289A746F, 0xE840E1A1, 0x491EB22, 0xBC075014, 0xAB0AB8B6,
     0xF3022232, 0xE4921F7, 0x0},
    {0xBC04A0C9, 0xBF543A07, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x20FE84F1, 0xF4026DB1, 0x59A56249, 0x81EF2E24, 0x155CD750, 0x6470284E, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x57AABC0B, 0x3E0511B5, 0xD958C733, 0x3C4305E4, 0x1AAAB9F0, 0x29CE9804, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x95943885, 0x436839C0, 0xA309355D, 0x8EB874DB, 0xA51C3FCE, 0x911C286F, 0x24263036, 0x282B094F, 0x0, 0x0, 0x0,
     0x0},
    {0xBE1D84FD, 0xCA1A04C8, 0xE1241CE, 0xF60A9B17, 0xB2049044, 0xDEBF63F5, 0x24F45E19, 0x4850E967, 0x0, 0x0, 0x0, 0x0},
    {0xFC3FAAED, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x56C2BBAF, 0xD6613644, 0xB55628B7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x2017E654, 0xB7ECB48, 0x1649C322, 0x8A4CD48D, 0xB201995, 0xCA5F46D7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x72EFAC48, 0x501BDB68, 0xED8B2FD6, 0xE473B01B, 0x7769A50B, 0x41ACE377, 0x71C21732, 0x73CF8581, 0x9AF4777C,
     0xD337D2, 0x16CFCF9A, 0x0},
    {0x3B9AFBA3, 0x5A2459EA, 0xF2AD03C0, 0x3CBB2F1B, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xD2523044, 0xCB3C30D2, 0x4F95B4B2, 0x7261A753, 0xE503FFED, 0x499341E, 0x56BA1470, 0xA274C450, 0x2AD4AE4,
     0x827F991F, 0x19798FE3, 0x4FF0DA20},
    {0xE9EA1718, 0x8E3BD1B9, 0x8AAD25EF, 0x68AEC523, 0xE121A564, 0xB3C6F6D8, 0xBD8D8595, 0xE1A099C6, 0xAC806CCE,
     0x8DF51C26, 0x0, 0x0},
    {0x630E9D79, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x67A89D3D, 0x2314FE7F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xAF0F874C, 0x19A9F6F0, 0x56584634, 0x4F0546BE, 0x2B096194, 0x7A342EB7, 0x7C1F2DF6, 0x6E22C564, 0x0, 0x0, 0x0,
     0x0},
    {0x9ADC3AF5, 0xCBE14AB1, 0x24707A6C, 0xF93F3B12, 0xB1D385E, 0xEB39E45E, 0xE37C4722, 0xFAFB646A, 0x31DF352D,
     0x55830E32, 0x23C4D0C3, 0x0},
    {0xFAB8455F, 0xC9D9405E, 0xE3981F50, 0x844A7D8D, 0xAB5F4E65, 0x120AEA2D, 0x31FDF81D, 0xC3B7016E, 0x7A9039B8,
     0xDF0B4AB5, 0x80F9AACD, 0x0},
    {0x3F72592E, 0xDD4D66D4, 0x6F432128, 0xAE099275, 0xFF08E84C, 0x3EE5A783, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xE8D57774, 0xDC612995, 0xEB699B7E, 0xEC0F8E2C, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x9E3275BE, 0xF3486A24, 0x2326C783, 0xBFF24612, 0x6DFDADCE, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xEB029C15, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xB22698BA, 0x25CE2890, 0xB9E7217D, 0xA11C3B03, 0xA4D2FF3C, 0x139363A5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xEF9D4760, 0x3D7A8EEF, 0x6F2C8E6F, 0xB5957170, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xEFCC73E, 0x12783C19, 0x3CC2306E, 0x5712EE80, 0x199379BE, 0xECD7E1F5, 0x6F17D954, 0x212980DA, 0xB85297EE,
     0xDAC91025, 0x19FE9FE, 0x467A2103},
    {0xBF51AE23, 0x94C6C717, 0xDB42D729, 0x4BE725C3, 0x7A100B3F, 0x1FA59C24, 0xAA98FD7C, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xD9EA58A8, 0x6B68B7D3, 0x87DD701A, 0xAEF53917, 0x3350451C, 0x7B5CD7D0, 0x13289F63, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x8DA53169, 0x3268162B, 0x75FD9F10, 0x4E1AEF92, 0x367CBE7F, 0xB0AB7D6B, 0xA09B08AF, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x7A6A8201, 0xFB54C305, 0x2407DB0E, 0xE64AD218, 0x789FB7EB, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
};

static uint32_t test_ecmulans[128][2 * 12] = {
    {0x72760AB7, 0x3A545E38, 0xBF55296C, 0x5502F25D, 0x82542A38, 0x59F741E0, 0x8BA79B98, 0x6E1D3B62,
     0xF320AD74, 0x8EB1C71E, 0xBE8B0537, 0xAA87CA22, 0x90EA0E5F, 0x7A431D7C, 0x1D7E819D, 0xA60B1CE,
     0xB5F0B8C0, 0xE9DA3113, 0x289A147C, 0xF8F41DBD, 0x9292DC29, 0x5D9E98BF, 0x96262C6F, 0x3617DE4A},
    {0xE5F24FC2, 0x3B61FF2B, 0x924C3070, 0x15B9D34A, 0xA49C35D3, 0xB165DFCE, 0x11030417, 0x34963AAB,
     0x5235664C, 0xEF5FF121, 0x7016D7B8, 0xBDCB409A, 0x556E13EA, 0x62EEA441, 0x470CC852, 0x4E6CCE3F,
     0xA4A62E04, 0x73BEE1FA, 0x70C9B358, 0xB918C90B, 0x7FE3FB39, 0xAB740D1B, 0xBAEDEF8D, 0xB85347A5},
    {0x83BB7CA3, 0x18B91B2A, 0x9C9ADA27, 0x138311A9, 0x14393FE9, 0xADA62232, 0xF07DF97,  0x8CCC057E,
     0xE451B2C8, 0x238B1879, 0xAEE8D024, 0xC0E0307D, 0xA40ED7D9, 0x52EE78EE, 0x6F29FB92, 0x1CE48680,
     0x8425CBCF, 0x87F5F826, 0x171F3A9D, 0xF0CB786C, 0xB459C83A, 0x2859824,  0x501BB076, 0x4617E1DC},
    {0x3797E12F, 0xC9D3CBF6, 0x83A8A374, 0x861906F7, 0xE3AC5E35, 0x68E7E773, 0xF926AE33, 0xC24E6BF2,
     0xF35A1AAF, 0xE2502D4E, 0x63210769, 0x20720048, 0xD0736FE1, 0x71E4D0FF, 0xC61E57F6, 0xA687721D,
     0x9C271BDB, 0x89868DE3, 0x6F8F93AF, 0xE076B723, 0xA08C961F, 0x39AD9BAF, 0xB9141DF0, 0xC5DBD591},
    {0xBA3E75DB, 0x6BA61FA6, 0x306DE30A, 0x926DE4F7, 0xBED32A14, 0x2DCD41BE, 0x25A3448B, 0xF3970F64,
     0x7B3C36F7, 0xE8A1D79A, 0xC5445B7A, 0xA0975F27, 0x270C0743, 0xC5C7F75C, 0xA543231E, 0xAB796645,
     0xD02944D4, 0x92F4C889, 0x2C7C6BCB, 0x1D48B2AE, 0xA49D58AE, 0xF35415FF, 0x937C81C7, 0x839D99D4},
    {0x532D34E4, 0x6A346E0A, 0x582C0083, 0x85DAD25B, 0xF86B767B, 0x866E999B, 0x50D611C,  0xCF141C6F,
     0x3B31E142, 0x70A1AFB5, 0xB4530F48, 0x90BCF142, 0x3BEE32BB, 0xC598403B, 0x4206D406, 0x4801E19E,
     0xB15925A8, 0x8DCF1A92, 0x772F9A2D, 0x55CD60CB, 0x9E56F7FF, 0x3298BBA7, 0x4D105C07, 0xBBE055BC},
    {0x8BD2D507, 0x2D15F765, 0xBCFB0213, 0x1213EECD, 0x3214E5C3, 0x1045AC44, 0xD44D4FAE, 0x70BABC52,
     0xDE3F84A,  0x4756640D, 0x30C36C8E, 0xD44BBD06, 0x989F9EC0, 0x7A18D34E, 0x78E49808, 0x6AC241E1,
     0xB97B077B, 0xFFBAA733, 0x3F3788AD, 0xCA00CC1D, 0xAB9B1F60, 0xC4405EDE, 0xF2B2C658, 0x3117979C},
    {0xC860108F, 0x75A7A7B4, 0x3C32EE23, 0xCA119139, 0x951C654A, 0x932D7BFA, 0xA46389A9, 0x8644E874,
     0xC554984C, 0xE5119AB5, 0xE37562C2, 0x8ECFA7B2, 0xED56FA69, 0xD64DCBFB, 0x24DE0BA4, 0x6DA6D2,
     0xFA9812A8, 0xA5A56E25, 0x64BFDC50, 0xE9B85F6A, 0x55CAAF07, 0xD9179050, 0xD652202D, 0x11D0FF89},
    {0xC31431A3, 0x4A368ABF, 0x54459BD8, 0xD50EF420, 0x4D02323E, 0xBBC1855D, 0x3D088C02, 0x4EEAA9C7,
     0x56937462, 0x1B75C6E6, 0x13E20100, 0xC6FB32AC, 0x6B8F8774, 0x498427C,  0x27916861, 0x5CE56A9B,
     0xD25C0B22, 0x63EC2A8C, 0x2A3811C5, 0x1862B733, 0xDC70C6C4, 0x78A4439E, 0x397F7DF3, 0xDC34ECC0},
    {0x636C9AAC, 0x7D68C3C0, 0x81992B83, 0xF59CACB5, 0xE4172215, 0x32605182, 0x6C574357, 0x8548792C,
     0x8E68688F, 0xBF18F6F4, 0xFA85681F, 0xE7EF0403, 0x58182857, 0x38534CEB, 0x274692D9, 0xFFFC8D65,
     0x26DEE66A, 0x5BEF38F6, 0x2489EBBD, 0xDEF03E06, 0x6E0A6290, 0xEE7BFA30, 0x6BC32968, 0x16AB6E31},
    {0x68BCC227, 0x4E0AFB1E, 0x1ACC3582, 0x33E3B35B, 0x147598CF, 0xB6AE8C6D, 0x8F877105, 0xA748CF16,
     0xC84A1A96, 0x4ED5C3C2, 0xBE562C46, 0x49168E50, 0x35884A3C, 0x8AFDC165, 0xA26B34CF, 0x7D25998D,
     0x15931BEC, 0xBE08E325, 0x8BCD4FC6, 0xD07DAA99, 0x4F0045D7, 0x10BF8F3A, 0xFA9253C2, 0x93AFF90B},
    {0xFC103A61, 0xFDC927D6, 0xAEE0C808, 0x26F8598B, 0x85DE847C, 0xB571A385, 0x1331BB57, 0x590CA540,
     0x80D37F83, 0x792DABBD, 0x57F0B461, 0x977E5984, 0x74C4F472, 0x9E921183, 0x3837A1A8, 0xE5AD3321,
     0xF07D29C9, 0x1373B7F,  0xC97FE0F,  0x3B94E3DF, 0x95E98669, 0xA364E055, 0x5CD983D5, 0xCFE91E0A},
    {0x17FA02CE, 0x266E991D, 0x279617CD, 0xA49D26AB, 0x522BC9A9, 0x58990A07, 0x7205FACA, 0x8BA5624C,
     0x90A30E1A, 0x83B27A14, 0x64D4C934, 0x73E005C3, 0x28BBAE46, 0x5DE6C13E, 0xEE587E8A, 0x36B81974,
     0xA74F1F2D, 0x7B93CC60, 0xC88BCA39, 0x88263E96, 0x3906DC9B, 0xD459B447, 0xE2DC56DB, 0x56C0420D},
    {0xF05E72F4, 0xF21A7393, 0x92ACBAE2, 0xE65FAC96, 0x67A7B661, 0xB6B8D3BB, 0xBF1CA539, 0x55A51E7,
     0x26FB8198, 0x897B805B, 0x383A23F,  0xDEE673F2, 0x70730A75, 0xED204DDA, 0xFC1E61C3, 0x51EDFEEA,
     0x910629DB, 0x141DE59A, 0xEF1D7A92, 0x3C8F7DDD, 0xC9A7501E, 0x5EC297CE, 0x4734347,  0xBE93DA65},
    {0x4176318E, 0xF56FB44E, 0x536A79E8, 0x7955D2F4, 0x22807C59, 0x31D910F7, 0x2C94C99B, 0x9523CEEB,
     0x93035DF6, 0xC51BE8E,  0xD6E68D80, 0x3AEC69D8, 0x92A2496B, 0x929C06E,  0x21B78843, 0xCD592320,
     0x12ED74BC, 0x86805E2C, 0x583FE0F8, 0x3CC3B1EF, 0x8FC544CD, 0x610BEAFC, 0x40D4A25C, 0x762BF5D6},
    {0x73A0B464, 0x6A98F35F, 0x4FBFCBA6, 0x8F20B7C8, 0x8C9E6B71, 0x3C1FAAD7, 0xDCE75683, 0xAC63830C,
     0xD743DF69, 0x2967CECA, 0x7E4B875D, 0x1A2F4A30, 0x3DF7EBD0, 0x1D6F599,  0xD1F6166C, 0x572B4F7E,
     0xDC948CBD, 0xF89DD16,  0x4FD6F2D4, 0x2FEF0BF7, 0xFBF02308, 0x6A94ADE,  0xA8E7A56C, 0xE7278119},
    {0x47253D1C, 0xF766B89C, 0xF01A7991, 0x16A4507D, 0xA7537F79, 0x8BC546F5, 0xB35CA88,  0xF77F35B2,
     0xE6D7D68,  0xC0A79A8,  0x31E0AAC2, 0xA83F6048, 0x57B2DCF9, 0x9394011A, 0x6A247E46, 0x9AAAEF81,
     0x6245CCE2, 0x122AD8AF, 0xDE710DAB, 0xDF672550, 0xFEA71DB7, 0x22333512, 0xAE407C31, 0x77DBEE12},
    {0x40C2570F, 0x9F9CD28E, 0x63EFAC46, 0xEA3A5D92, 0xB3D35E10, 0x60B2A545, 0x420F9B82, 0x307477F0,
     0x82B09454, 0xAFF764BF, 0x10599C14, 0xFFCA830D, 0xC5E38841, 0x3F71963,  0x804C6EBB, 0xDB6773BF,
     0xEB587EBC, 0x4FE31534, 0x40D97F86, 0xB2686DA7, 0xA56E6BCB, 0x52B7BA55, 0x37825AE3, 0xB7A919AF},
    {0xFBA997D2, 0xA9162E9E, 0x2308E5AE, 0xC31839B2, 0xFC5040DD, 0x4C614383, 0x6424196A, 0xB9FBC7BA,
     0xBD4FAA08, 0x69223EB6, 0x7C14DF31, 0x1347B179, 0x5EA68971, 0xE5AA3C64, 0x57654EF,  0x3442315F,
     0x183DDF40, 0xEA7B4FEB, 0x31C52887, 0xBB21202B, 0xFA5381B3, 0xCAEB5139, 0xE1462B86, 0xE019D2D8},
    {0xA8237A14, 0xBD610854, 0xDB46D012, 0x55335781, 0xA86B063B, 0x52637BD8, 0x63F1BC48, 0x2783B84E,
     0xB3D3E769, 0xC2FF639E, 0xDFD26216, 0x6801214E, 0x14C78C2C, 0x1B08FEF8, 0x5B271C65, 0xEA467897,
     0x4F58E4F,  0x7B311D65, 0x98065B06, 0x1B140244, 0x520F62AE, 0xC2515795, 0x1481FB0D, 0x41910AE0},
    {0x63FD36DF, 0xE72793F4, 0xA5F2871,  0x13062DE2, 0xB6BA064B, 0xFD79BF9,  0xC3B6AC4F, 0x970EA6F0,
     0xC66B7928, 0xDC0B7D49, 0xA413A89C, 0x99672B3D, 0x6201026C, 0x6499955C, 0x2B9E3ECE, 0x1DB8371C,
     0x375DC16A, 0xE4E7A7C7, 0x7A4E74F8, 0xE3A5B27B, 0xA252C95B, 0x6A2BAD60, 0x143654F5, 0xD11272B0},
    {0xE2A518AD, 0x58D756C5, 0x5032E0F1, 0xD3DD558C, 0xE5D20BB1, 0x85821AD9, 0x5ACD4426, 0x31A07E9C,
     0x419283D4, 0xEE48B72F, 0x974B858D, 0xA0B6B7AB, 0x5456BC97, 0xEE57BBF7, 0x1E7A2113, 0x7B08DD97,
     0xDA948A48, 0x5FD5A10D, 0x3F3CBFC7, 0xDC60C92D, 0xCDE4B393, 0x72112980, 0xA5994D86, 0x2A475D26},
    {0xFEEC3C8A, 0x392C98F,  0x5FD9EC88, 0xFB4DE0E9, 0xCA465E02, 0x4166F4A2, 0x54E00505, 0xFC4F927D,
     0x84FEF37D, 0xFC6BD0DB, 0x32CF55D4, 0x51DB52B2, 0xF9972D31, 0x2B2F5682, 0x2476FD71, 0x972FF1D3,
     0xAC8B212B, 0xADD9F0EE, 0xE837E917, 0xBF75FBF4, 0x7783A9AD, 0x8F38A1DA, 0x5F043368, 0xF50C119E},
    {0x572BB352, 0x8088E9E4, 0xEDFACDFF, 0xB6B54646, 0xBEBC7EF8, 0xD7E9E0C,  0x66F48328, 0x4829F574,
     0x86FBE0C,  0xB6BF94F0, 0xF7A5ED0A, 0xD98F02D2, 0x5F2E32EB, 0x622CE164, 0xF58C9F89, 0x6758D6BF,
     0x3B4F708A, 0x3B59EA2C, 0x6133BC5A, 0xF2ADC677, 0x3DD88529, 0xFF189C3D, 0x5960898E, 0x3D5DE4CB},
    {0x645A2A16, 0x6EF19C4D, 0x78E81844, 0x990775A,  0xDDF6A0C4, 0x24C29BBD, 0xAEA4D21D, 0x596E0A4C,
     0x80A1D87,  0x1EB1ADF9, 0x46DF49AF, 0xAB377487, 0xB29E8170, 0x1F280CA9, 0xF9716969, 0x47E76DA,
     0xB3DCCBB5, 0xD8EEB492, 0x947CDE81, 0xA2E370B2, 0xBD228627, 0xAEF17C76, 0xFB4CBA62, 0x996EF97F},
    {0xEFB7295,  0xA2AE27AB, 0x663552D2, 0xC20C87AF, 0x83294394, 0x6D2578D3, 0x9C1B1F4,  0xD0451FE4,
     0x6CF93282, 0x24A5D1AE, 0x59C76A5D, 0x62535425, 0x292A03DA, 0x26276C65, 0x9FA2146,  0x4C7426CC,
     0x1CA8D63A, 0x7C91D2A,  0xE27DF925, 0xA8001B60, 0x9973234C, 0xE7DAA0AA, 0x6B5E89D6, 0x19E1675F},
    {0xA6F58661, 0xF5967A9C, 0x11E0FD07, 0x9AED1865, 0xBEB867BB, 0xEBD8EAA9, 0x1DEFBBAC, 0xC3522CAD,
     0xA6B46F9D, 0x8119DCE2, 0x7964BB1E, 0xBF7ADB9C, 0x3A32B0B,  0x9E250E1E, 0xD14AAC91, 0x70E9C2EF,
     0xC2F38462, 0x5829AE29, 0xE8E46B5E, 0x6CCA154D, 0x68013C5D, 0x228E9682, 0x92977604, 0x6B51E103},
    {0xF9364365, 0x13DE4BE7, 0xA1168416, 0x1F8AE2BE, 0x1C05183D, 0x4769D517, 0x9B0E060E, 0xE6852DEA,
     0x146C6898, 0x2F2064F6, 0x41F0421A, 0x51BAEC0,  0xA3A9A825, 0x4591A950, 0x76F333B6, 0x6AC26467,
     0xFD11C01E, 0x1D0DB7F5, 0x3C606AD0, 0x86D67EC,  0x5C410BE0, 0xA9C628FC, 0xCB65140A, 0x8B7DA469},
    {0x1592FCF3, 0xC77A55A1, 0x7ED779A7, 0x53E3A6F5, 0xB966BFF4, 0xD6E003FE, 0x75260CE6, 0x4FE7E965,
     0x38FD0E76, 0xE0F4DEBE, 0x404F7056, 0x16605A1,  0x1EB86B9D, 0x88855EE8, 0x7985A4AC, 0x11E4DE93,
     0xFCCA587E, 0xD3B101EA, 0xB1479A4B, 0xE62443D2, 0x1096B0E2, 0x9C958E4C, 0xB05C1C72, 0xEA281D87},
    {0xDE0B9FB0, 0xA691CBD4, 0xD5BD6C60, 0xB9A19618, 0x1200DB2C, 0x7A93BC57, 0xFF48CFDA, 0xA3A538E5,
     0xB4F9347A, 0xCCDEBE00, 0x7AE90208, 0xA33FFF90, 0x63E86DD5, 0x6844A230, 0x5D9774C5, 0x688F42D3,
     0x93ECD758, 0xF0373068, 0x6E03A62B, 0xF427B2FF, 0x5B07285E, 0x8723728F, 0xBC900771, 0xB5F77B69},
    {0xC7879DAE, 0xC877CB98, 0x221A4B17, 0x9B1083D,  0x46502143, 0xFAE01378, 0x760BFD90, 0x31594F4E,
     0x871060D8, 0xB6280988, 0xB0320325, 0xD0650989, 0x69A04589, 0xEECE63B0, 0xFBDB01E9, 0x9D4E3FF1,
     0x22635D51, 0xEDFB17B6, 0x738C8A9C, 0x9A109DBC, 0xCBDF9454, 0xB5B89FEF, 0x7F51E41E, 0x18A76FE3},
    {0x7F171037, 0xA688AC29, 0xB26D771B, 0xE4618DEC, 0xA5F400E1, 0x2F299699, 0xE7A5E2D7, 0x7B1D297E,
     0xD4AAFEB,  0x2E66FADF, 0xFE0F539E, 0xFDF19E21, 0x3FDDAA01, 0x403FB914, 0xB4BC4596, 0x47957711,
     0xBEEEABBF, 0x98EB2959, 0x712738F9, 0x5F52C9CE, 0xF6E40947, 0x9CAA724B, 0x893A9479, 0xC78327F4},
    {0xB53690A,  0x509FFCD9, 0xAB2E212C, 0xB940CC99, 0x8FF644E,  0x39314AD4, 0xBAD1F254, 0x6270601B,
     0x122191BE, 0x5AAA45D0, 0xF9694B6C, 0x36FBC9AC, 0x3EBED5E0, 0x6508189D, 0x9D692CDE, 0xE06E5D8F,
     0xAA360392, 0x9E5F0411, 0x23ACD131, 0x878B7D4E, 0x462B1CB1, 0x1AEF01B3, 0xD944DD0F, 0x92F25BE8},
    {0x95EEC0E2, 0x99771912, 0x75F1E876, 0x13072598, 0x2A6D95D3, 0xE3383C30, 0x35E0984F, 0x67C5896B,
     0x4BD58381, 0x21414CAA, 0xF3AFC348, 0x2C678F5D, 0x6F76A0B3, 0x2A73EDD2, 0x4C972F91, 0x10BEC206,
     0xB816C003, 0xF9142F32, 0x2D23CA3E, 0x47167D7D, 0x6C909C94, 0xA500150F, 0xC1D274C3, 0x564ECDD2},
    {0xF62202FE, 0x11D93905, 0xA0BDCA84, 0xC738EFE4, 0x4267FD,   0xD9AFBCD,  0x11AA703C, 0x99906161,
     0xD71D4B80, 0x667D7CE2, 0x3A1E4BF8, 0xE2B99B52, 0xBAF7223C, 0x651BDD19, 0x69B74DF8, 0x4234FB58,
     0x8F5A176D, 0xD09C5906, 0x168EDADC, 0x26A0BD04, 0xBB6E2B56, 0x59A17C13, 0x52A11F9D, 0xC701F82D},
    {0xD23E3D5B, 0x6C2E8A34, 0x7EDEAF1D, 0xD954B6DB, 0x646D1281, 0x53BC737F, 0x303BEDB9, 0x4584C1FC,
     0x7F10BB6A, 0xBE1C9B94, 0xD97650BD, 0x58A9549F, 0xA059C083, 0xEF1CEE8B, 0x46CF7E52, 0x162F4BAE,
     0xE3987379, 0x5F6DA879, 0x6E6ED473, 0x3C03C40B, 0x257BE075, 0xBF95A096, 0x52032592, 0x7725F5A3},
    {0xD1520660, 0x586FD130, 0x3624DCCD, 0x217623B4, 0x524CC882, 0x31B275EF, 0xD28415B1, 0x3A9652A6,
     0x96F15E50, 0x9C5F9467, 0x354B51A0, 0xF7B939CA, 0xF08C774E, 0x2BF8BA69, 0x5790E100, 0x510213EA,
     0x705FC289, 0xBAA17368, 0x4BA027F3, 0xE800A17E, 0xB22AE7D1, 0x7710C249, 0xCF9E1521, 0x4C516732},
    {0x6AAA3B54, 0x93ECA990, 0xBE56401E, 0xCEB997A6, 0xDF8DFC37, 0xEBD139E0, 0x5173B7E7, 0x55B6FCC4,
     0x3C9DC00F, 0x6E8BE9DD, 0xC919A87E, 0xF4162D2B, 0xFDFBACA0, 0xF6AFFB8A, 0x56B6059F, 0xE7B0A49F,
     0xBAC9DACF, 0x520EB357, 0xB1596644, 0x160C914F, 0x3C5A3D5B, 0x28B51F88, 0xC33420F8, 0x52390908},
    {0x29E10FD5, 0x4733FD49, 0x846D1120, 0x60C597EF, 0x5B61054A, 0x2705EA87, 0x61F7FB69, 0xD1CCFF51,
     0x61A9A0AE, 0x870F53E,  0x5DD08C77, 0xFECA6573, 0xC2F731FF, 0x11E8CEB8, 0x16BE2266, 0xE70DE037,
     0x1268ECDA, 0xE6ECF295, 0x55F440CE, 0x12F2F2FF, 0x91BC1F34, 0x650B65CA, 0x56AB46FE, 0x21F748CA},
    {0x2EFEF593, 0xE7762A38, 0x30A3B7EE, 0x3E0A1516, 0x8E374639, 0x46EDB07A, 0xA42B19C0, 0xE1DC403A,
     0xA168F917, 0x8C570CC2, 0x84C6B416, 0xBD160B62, 0xCAF3E21F, 0xA15FAE1F, 0xB3E5BFB8, 0x30AA7A76,
     0x2637183E, 0x77E5235C, 0xA6CCA0EF, 0xCFD2C4C5, 0x6BA82213, 0xC0E9D608, 0x1D577F2B, 0x23DD6695},
    {0xBF5CCB4A, 0x3A460744, 0x4C14488A, 0x146616B3, 0x395ED5AF, 0x613B35B6, 0x5F8C18E1, 0x49B2436A,
     0x2A32098C, 0xF5403BDD, 0xE77AA2A2, 0x2B64798A, 0x58116A5,  0x7D6AE526, 0x428DF869, 0xD3701D50,
     0xA9C333BF, 0xC8390E8A, 0x2EA5DF67, 0xA61EC9A9, 0x93053265, 0xEE7888A,  0x1FE37827, 0x3ED250E8},
    {0x56E39499, 0x362B05C7, 0x6CB73083, 0x64532CA1, 0x53928705, 0x4408A8DF, 0xFBAD9DDE, 0xBC0B87A9,
     0x49D034D0, 0x8D9D851F, 0x58F2DCF1, 0x5EB3D453, 0x87D3B3AD, 0xCB125269, 0x660EC0D8, 0x3A985E8D,
     0xD70405D4, 0x54B9D029, 0x62F80913, 0x347FFC80, 0x6BC94529, 0x4EED39CA, 0x863E4560, 0xD69AEEF3},
    {0xBE2861C6, 0x2185A74C, 0x5C19066F, 0x3F9F0AFA, 0xBA575916, 0xA92077FC, 0x4137CA17, 0x62972976,
     0xE18042B5, 0x6A66EA28, 0x440998E7, 0x2F8E2D55, 0xC2FC182A, 0x4AB6E856, 0x7532D0AE, 0xF5186AC6,
     0xED407C89, 0x82A5DA8,  0x4583E6A6, 0x75042DDA, 0xC27EB5AF, 0x9BDDA4B0, 0xA2A708F5, 0x6E6EC758},
    {0xE2F8C677, 0xBFD0E2F5, 0x42005A67, 0xADA2AFF3, 0x646F9234, 0x909F6727, 0x653A12F5, 0x1FBD335B,
     0xB89875F7, 0x96494AA2, 0x10422A6D, 0x9030A6B7, 0xEB55E314, 0x6E14F40B, 0x124B7559, 0xB49BD3CD,
     0x9D0678DC, 0x2365989F, 0xBC1A7B02, 0x1B819CCD, 0x3CE5367A, 0x17A5E506, 0xAB839C9,  0xAF666EFD},
    {0x235525AC, 0xC40E9C8B, 0x4D8BE948, 0x8D69E9D3, 0xB5023DF0, 0x1A38E8AB, 0xD0A16B36, 0xD9BD9955,
     0x56A3EB74, 0xDAA059C1, 0x30E38FDD, 0xAF969398, 0x157B9CD0, 0xA3C15B10, 0x9BDBBA47, 0xD5427F06,
     0x23987574, 0xFD4A27CF, 0x2C6F3803, 0x82A3BA2A, 0x43894BAF, 0x66C2500B, 0x5E9CAAB0, 0x9432F68C},
    {0x9F92ABF1, 0x9E2C3550, 0xC090594C, 0xDADD74A4, 0x222E6142, 0xABE1684,  0x15BE6671, 0xD1676167,
     0xA2CD4759, 0x391869F1, 0xEBFFA9A5, 0x3225A9DE, 0xD77347ED, 0x30EAC508, 0xB16B9243, 0x1CF001A3,
     0x44DE7D66, 0x951482A5, 0xF9D23351, 0xB076B8EE, 0x9443061F, 0xF73D0548, 0x380822F8, 0xD2E2F2C},
    {0x4F863063, 0xA59BC17A, 0x25A1A32D, 0xB4506058, 0x5A567A14, 0x555F1620, 0xB65C4266, 0xA0C5F0AF,
     0xA0E12002, 0xC89F63DE, 0x715DEA42, 0x328965FD, 0x3CF2B084, 0x60ADF6B2, 0xE8B7E165, 0x563C8627,
     0xAD6ED39D, 0x1F91E41F, 0xEF21B400, 0x42BA9E1F, 0x29371BFC, 0xF34E5169, 0x613A37A6, 0x87BF9F80},
    {0x3990837A, 0xA01C5C41, 0x1515D9CA, 0x67D492B0, 0xA8163437, 0xA4828254, 0x5F653BEC, 0x30693B12,
     0xC37DB439, 0xAFEA517E, 0x70367C0E, 0xDB51B98,  0x8E665E57, 0xE906C288, 0xD3099089, 0x8B93BC3A,
     0x85C95803, 0xB1D361D3, 0xB7095C58, 0x62BD250,  0x6A333F6B, 0xFEA82832, 0x3309EA98, 0xF0539BE8},
    {0x58B4CB06, 0x94F6FF78, 0x4876C17C, 0xF82A3160, 0xAA541496, 0x9829BAE7, 0xEC7107D3, 0x8A876E37,
     0x7A5A41EB, 0x8CD526DA, 0x3B89FEDF, 0xCDDB86B1, 0xDD70BE80, 0xB1D9FBC7, 0xE1C30F81, 0x7A2961DD,
     0xDF27C38,  0xF6ACDA8C, 0x17D0EFE5, 0xFD2D842,  0xC936DEE7, 0x4BD80B8E, 0x9C9DBEA8, 0x867023D7},
    {0x2076535,  0x74F6734B, 0x27FAAF74, 0x9A129B4A, 0x8CEBA301, 0x57CAEE74, 0x43E2FF40, 0x6A48DD06,
     0x881F8717, 0xB1911CC5, 0x5E49D4A5, 0xDB6A634,  0xA7B6F3C7, 0xBED9016E, 0x5CE0FAAC, 0xF612440C,
     0x25D2B2D1, 0xF3A71623, 0xBA6595CC, 0x2BC87263, 0x16DD4260, 0x95375057, 0x191E6607, 0xFCD04836},
    {0xAF886224, 0xFDD3D339, 0x2C6928B2, 0x364C0CFB, 0x9484EBB9, 0x34BE369A, 0x3070DF00, 0xCF6697F6,
     0x3A7B1B6E, 0x82E1FDA,  0xBB966977, 0xE5A5828A, 0x1BE0B547, 0x5173054,  0xCCB875A9, 0x2E37A6C,
     0x604E3629, 0xCD890323, 0x1FEE4684, 0x20BC5FD,  0xF92FD579, 0x67CF4925, 0x21F49EF3, 0xA8D4E758},
    {0x4A8411E5, 0x9F02028C, 0xC87936CD, 0x7FAA2808, 0xC15C1987, 0xF8611A10, 0x60B39926, 0x7C60A148,
     0x1B37DEFF, 0x6041D33E, 0x8A97E5CF, 0xDEC018DB, 0x7CB5F477, 0xB67862ED, 0x69B849FB, 0x4D041EFD,
     0xEB13AFF8, 0x8B4CA29D, 0xF7C89653, 0x9D822B6E, 0x793088E1, 0xB49366B6, 0x43980458, 0x2E4CF32D},
    {0xAA0234BC, 0xF2EE870B, 0xA7A15B2C, 0x55C59FFE, 0xC2BB7151, 0x7EC8B1D7, 0xCBD358D5, 0x506CF3E,
     0x2E1EB1BD, 0xA70966C2, 0xBC3E373D, 0x17984D83, 0xBB413478, 0x98852746, 0xD544CA1F, 0x6898D4DD,
     0xFECF52A1, 0x9D13EE5,  0x41424354, 0x90ED1179, 0xDBE7331F, 0x50B7DF93, 0x1BE44F78, 0xE5CF1192},
    {0xE8AF7787, 0xC21AEAF5, 0xFDAC643F, 0x62E2C19,  0x16760697, 0x2D1A6E59, 0x462DAABD, 0x5241C1AA,
     0xCD50ED0F, 0x9F479FFF, 0xE2A07ED6, 0x4A08BD00, 0xDD30A32C, 0xF8C9BF47, 0x26629DEC, 0x6C5849FA,
     0x55FC3259, 0xD83230AF, 0x84EDAF9,  0xEDAF4B20, 0x2782F340, 0x62613876, 0xB5E1AC08, 0x1963B13F},
    {0x7FCD56F8, 0x8A664665, 0xBAE00C4B, 0xA8AF1A19, 0xF07B1B79, 0x3D0E7E6,  0x25AA59AB, 0xE85442A7,
     0x5D12E853, 0x2FCE2806, 0xA57D93DD, 0x3D5E198C, 0x21084492, 0xC6C37812, 0x2E2AF7CF, 0xE977C2E5,
     0x8D041830, 0x9E93BB38, 0xA85CDF32, 0x226F5C66, 0xBAE5518D, 0x2C8DE2EE, 0x259F4496, 0xBABC691D},
    {0xECBD454,  0x4C029560, 0x5AFFFB0C, 0x34FAB420, 0xF2210527, 0x3E17D7DD, 0x1027ADB8, 0x1AE0E971,
     0x28563786, 0x2763158B, 0x4BA2101C, 0xB6A17F6C, 0x7114673C, 0x629DA286, 0xCCDCD754, 0x53275E89,
     0xDE03DFB4, 0x36E1C3B0, 0x692C2997, 0x83F2C826, 0xCA0BF7AD, 0x4A576446, 0x5868406,  0x3840EAC1},
    {0x29B916C7, 0x91D598CE, 0xB728812C, 0xF1461BFE, 0xBF1620A5, 0xDBCB15B3, 0x3F14837B, 0x34E9BD72,
     0xAB586B85, 0xCC90EC05, 0xC9993B7A, 0x3D9B9DA9, 0xA87D07EC, 0x395A0386, 0x4065FD0B, 0x53F57D79,
     0x7600874A, 0x6BB0BDD8, 0x747D25F1, 0x3539E3CF, 0x8E029284, 0x19C8F2A3, 0x5FD6B6D2, 0x6334CD75},
    {0x1AAB9CD,  0x54B0B263, 0xAA4D3221, 0xB308D116, 0x9D56359A, 0xCCB93F7D, 0x64CEF7EF, 0x899CB7DC,
     0x40CF820F, 0x73396CA7, 0x96C8F67B, 0xE4CFC61F, 0x158C6461, 0x64AF44B4, 0xD3B9668A, 0xB5E920A7,
     0x98B167B,  0xFCEFF3F3, 0x8B57EAEB, 0xBD6D1DE9, 0x72BEC78E, 0x96392B29, 0x7C0E0010, 0x6D380045},
    {0xA72978D4, 0x6279A9A8, 0x41CA12AE, 0x3A23D23F, 0xA99AD653, 0x4065EBBD, 0x577BA226, 0x7AC38D44,
     0xE3CF87F7, 0x5CF6508B, 0x685CB09,  0xBEC640E7, 0xB4393319, 0x3CF75569, 0xF971750D, 0xEC39CE65,
     0xDFEA04F,  0x8FE5C18F, 0xECCAA46B, 0x249AABBD, 0x3031C0C,  0x81336BDC, 0x25745A21, 0x34714FA8},
    {0x1DB98005, 0xE64B3E19, 0xD03FF779, 0x80FCFD6F, 0xC12CDC0A, 0x2A56C4BE, 0xAB7E27E9, 0x1B88CC92,
     0x90615A8,  0x75A58655, 0x4B8CEEDE, 0x2701A68F, 0xFAE34BF2, 0xB4598130, 0x92170AE8, 0xECC7BCC6,
     0xB08AACB3, 0xD97894F3, 0xC983C466, 0x3D37778F, 0xE5840F09, 0xF78AC600, 0x51D7A96C, 0xBFD93370},
    {0x1EEC6216, 0xAAFC0CA9, 0x653966F0, 0xC1FF121B, 0x8BBCB85F, 0xD01A85BA, 0x94603E6F, 0x99B4B7E7,
     0x3DE9F580, 0x52558222, 0x9320D4F5, 0xDEC1A585, 0x657BB3FB, 0xFF419995, 0x125E5301, 0x8B7F823D,
     0x3DECF570, 0xDEBE5BE8, 0x88D72CB4, 0xEB644D80, 0xEAF3A488, 0xAC555E5B, 0x790A33D5, 0xF4B7414B},
    {0x612F40B2, 0xB0F7F83F, 0xF772B374, 0x29DEC0E3, 0xBA41F0BC, 0x6B86E67E, 0x6B9F62DE, 0xADCD60C9,
     0x8DB82553, 0x8BBD771B, 0x2D9BE0D6, 0x3C8F00BE, 0x5FB3C2C9, 0xB7F0A164, 0xE38C09C0, 0x68DC03E6,
     0x89500D9A, 0x72066E77, 0x7BD6B97B, 0x9FE60D92, 0x52871C25, 0xFF683A66, 0xCDE8719B, 0x15EF976C},
    {0xA698B9A4, 0xC04F614E, 0x79632683, 0x3B7A4062, 0xC72AA060, 0x24B9FEB8, 0x57C4E6BD, 0xCEB915,
     0x373F60C3, 0xC141F75E, 0x1BD15771, 0x80005D16, 0xE3CB6474, 0x4733AB32, 0xB682936B, 0x332633C3,
     0xDAD3710E, 0xC6C4DA92, 0x77403B95, 0xD12D8130, 0x176B5271, 0x8C7C60F2, 0xFF5CDD0F, 0xB9A78BB7},
    {0x19C15E61, 0x475B3EE8, 0x8FAB3E85, 0xAC0D41FF, 0x4A1DA704, 0xDA3598,   0x36D09CFC, 0xF1587676,
     0x9AB3B209, 0xCAFA4343, 0xDB9269D5, 0x5E6E6193, 0x1366FC1D, 0x75B4D81B, 0x88DD2113, 0xC1196976,
     0x3C0F7F69, 0x27E3A306, 0x2955F81C, 0x2335F208, 0xACBFCE4C, 0xB33D27B4, 0x74177B91, 0x53615165},
    {0x90015F52, 0x6200E2E1, 0x1D7D2BE,  0x3B207545, 0x84E1B3A9, 0x3C4F1EA6, 0x7F1BCA08, 0x20F125C7,
     0xE79C657C, 0xBE9F343A, 0x8895C790, 0x39A10A22, 0x3EA5FA12, 0xC9EFBF28, 0xEAA745FA, 0x5AE1604,
     0xD6DBC1EB, 0xECE12045, 0xC537A20D, 0x9EDDC736, 0xA2640255, 0x50CA95AB, 0xC0A8016A, 0x765E6E2D},
    {0x99AD3E0E, 0xB6531D56, 0x60692F41, 0x94A4C6F2, 0xF6ACE692, 0x63322803, 0xB08B9EE7, 0xCF9CC049,
     0x87FF2FFD, 0x6D4CA579, 0x74DC4D8C, 0xDA89702B, 0xD9BCD107, 0xA6920BC2, 0x92490981, 0x49D23A7F,
     0x57C60DA2, 0x212A482D, 0x98BD67E4, 0xDDB7B129, 0xED77E825, 0x3471E1B,  0xB5F40513, 0x27916816},
    {0x67C43FA,  0x6AC73F0,  0x530478EC, 0x681F09CD, 0x8034CDC8, 0xE549C78E, 0x156E271D, 0x47111044,
     0xF8D9BFCD, 0xFC092FBC, 0xD8B14F97, 0x9FC14157, 0x87F5754A, 0x5064D577, 0xDA4DF209, 0x9543B94A,
     0x4B6500CF, 0xBEE5347D, 0xB1160C1A, 0x27187E84, 0x67AF25BC, 0xBA20A357, 0x7DA01EC9, 0xB260E110},
    {0xA432E1B0, 0xF93A4095, 0x6DCF30C9, 0x58C529C0, 0x5DAC2CDC, 0x6CA20A0C, 0x91913389, 0x60C77BA9,
     0x18293CE4, 0x5C65ED8,  0xEE9911BE, 0x2A55F378, 0xF3456DB8, 0xC62FFB30, 0xFCE87B35, 0x6E031E01,
     0x8281EE0D, 0x53346B53, 0xD62D294,  0xD424419F, 0xBD909907, 0x8AF15010, 0x199C8954, 0xE1CE024F},
    {0x51E481FC, 0x36ACE90,  0x27C7DB7,  0xEFF1640F, 0x62BB8D81, 0x80A2BD08, 0xEE008810, 0xC6C87F37,
     0x35C39EC4, 0x5BC43CB3, 0xDAABD006, 0x1F5393F7, 0xDEFDE101, 0xC375995,  0x654CFF64, 0x8FB9DF02,
     0xDA305208, 0x67215C50, 0x15BDDC50, 0x157F79B2, 0x8CCB2951, 0x353193AB, 0x12D5C7DD, 0x36B73EE5},
    {0x51D1E80F, 0x462E3B4D, 0x812E7C24, 0x9D7F0B39, 0x1A55B925, 0x64326323, 0x2EFE4E98, 0xA48A0A46,
     0x19C5EFBC, 0xAA20F7BA, 0x368A289,  0x9ED3F443, 0xAEDE374F, 0x6DA9C74F, 0x8C1740B,  0x6EB712A7,
     0xAA64218,  0xAF513B9D, 0xA018C0DE, 0x632C25CE, 0xFE8F84D0, 0xC047FAF0, 0x8FA37AB2, 0xA33E9AA5},
    {0xC79F4201, 0x48C4ABF7, 0x17E025F1, 0x5D94F4B8, 0x77CAA230, 0x7DF237F7, 0x60319F67, 0x9F481405,
     0x84AB20B1, 0x14BC7091, 0xE200305D, 0x36FD5146, 0xB90167C1, 0x59FE1897, 0x114C170D, 0x1AEFAA4C,
     0xF4E30B6C, 0x838F4C31, 0xE548764A, 0xF3B90E3A, 0x32188FAA, 0x4AC928F6, 0xB333F2F5, 0xEC34516A},
    {0x47D8DFA4, 0xB8642813, 0xC1FAA327, 0xAEF26AEB, 0xDB06AFE7, 0xAAC12F9E, 0x5A64C194, 0xB653AB63,
     0x49DC25AF, 0xA656D66A, 0xA14E4DE6, 0x805D6684, 0x7C191E5E, 0x81D7AE80, 0xA836B706, 0x5610CA6E,
     0x752632D6, 0x1754FC90, 0x18B3FA42, 0xF4084A5B, 0x6D36687D, 0x1FF881D0, 0x276EDCF9, 0x77F1E81C},
    {0x663C01D,  0x57FBB1F2, 0x9D0BBAAE, 0xB37E90AE, 0x3046E6D7, 0x8954D4AC, 0x9905A44B, 0x20F8E4E7,
     0x57901AC5, 0x43ABBF5F, 0xFA5CEB40, 0xBEC54ED7, 0x41664290, 0x32C1F37C, 0x2185C3E1, 0x943893B5,
     0xD7BD13AC, 0xBB5D5858, 0x6F15B8F7, 0xD4C795E9, 0xF10C9623, 0x31C6857E, 0xE649CE08, 0x884A73BD},
    {0xB440F112, 0x2CC07746, 0x28254481, 0xA782705A, 0x7DC9CA2F, 0x6A782066, 0x2F7AE8F5, 0x665D639A,
     0x9A2B3757, 0xAD6044B5, 0x48C82918, 0xD26BF2AA, 0xCA3FD8D5, 0x49BB3811, 0x5E13064B, 0xE3C1354D,
     0x6A528EEB, 0xE7861552, 0xE9295ED7, 0xD629D966, 0x4928C63F, 0xB1484BAF, 0x453563DA, 0xA0CCDDC2},
    {0x8D2D245,  0x23B7EE05, 0xDACA675B, 0xAE3A6599, 0x8AF3257A, 0xCA2036D5, 0x821748AC, 0x7A628E4C,
     0x42104E69, 0x974B033,  0xB3D24272, 0x37E51161, 0x23344870, 0xED2B1528, 0xF877B823, 0xA4267135,
     0xCD1C345,  0x7A877C48, 0x70200D8E, 0x7FBDB5F5, 0x7B0A6D5C, 0xD315797A, 0xD9894684, 0xAFCC1BF7},
    {0xE6D80C04, 0xEA806C90, 0x5F852766, 0x47E22426, 0x7E361672, 0x64813A9A, 0x811A8D66, 0x11081B5D,
     0x1736429F, 0xEF171FEA, 0xA9985FF9, 0xD94F0A69, 0xA0925574, 0x45818A6C, 0xE358389B, 0xFC9043E2,
     0x9FE5C7B8, 0x4729112A, 0x56C742,   0xB214FA50, 0x79470FDC, 0xF86E3A53, 0xB43F668F, 0x59DC44D6},
    {0x172B58D5, 0xCD387D7D, 0xC611EB4A, 0xD97E7BE7, 0x773F1276, 0xEA1A0195, 0xCFF54F28, 0x986A5292,
     0x8A0251C,  0x814E35C5, 0x5A5959BA, 0x5765B499, 0xB517DECC, 0x87393039, 0x62CE983B, 0x44290838,
     0x409A1FA5, 0x46540A8F, 0x7FFA749A, 0x387E64E1, 0x5A715B0C, 0x84E34162, 0x29526CAA, 0x804D47D2},
    {0x18AE6786, 0x8587000A, 0x80849A80, 0xD2FDC9E,  0x39E3AEE,  0xC5ADB901, 0x2482FD38, 0xFD897E13,
     0x6288F93B, 0x30D32256, 0x9B2209CC, 0xB4068252, 0x37312CE0, 0xEE544112, 0x57336F8,  0x949BDCE8,
     0x47C1F952, 0x471DA042, 0x3627597C, 0xA47CE9A3, 0x2100F86,  0xCF74ED26, 0xF6277C42, 0x3737699A},
    {0xB7CCA508, 0x4BE885C2, 0x39413BC9, 0x8F51A7CD, 0xF99CDE60, 0x84812047, 0x63592238, 0x5D5A262D,
     0x63529B97, 0xE1770674, 0xE424B197, 0x579DFDA8, 0xDEDF6939, 0xAC80B4A6, 0xB965B252, 0xCC8C8513,
     0x1BF855D6, 0x2C465A7F, 0xDB72A01D, 0x81FCA13F, 0x34DACCB7, 0xB370C5FF, 0x56F7A347, 0xEA2B71DB},
    {0xEC9AFC29, 0xD23CA3F1, 0x26A228C0, 0xD988D101, 0x71F18FC3, 0x8827CA00, 0xF1F5E8C0, 0x757FDCFB,
     0x18A59BE3, 0xC9FEDB3,  0xFC463A4D, 0x2DEE0A77, 0x8568FDA7, 0x8AACA0BE, 0xB705A026, 0x15C63BD7,
     0xA050203,  0xF5EAAC9C, 0x1A4423B3, 0xB8D52B8F, 0x7DF20C85, 0xC61E66C4, 0x2C3B9192, 0x2A0053AD},
    {0xF747B8D8, 0xA7B42481, 0x8265D0C,  0x897A5041, 0xBC6D2928, 0xE7AAAE51, 0x618C9B06, 0x452BA3DC,
     0x2C7670C2, 0xB0407D40, 0xB17BFCF8, 0x411FE608, 0xB9D9C0A7, 0xD17FB5CB, 0xABB4EF5A, 0x894F4402,
     0xE2BCFA34, 0xBDB2C6A2, 0x9FD5C417, 0x8EE869A0, 0x3B95449D, 0x5E93B368, 0x809421D8, 0x5DB351D9},
    {0xD4F4BF3C, 0xBD382479, 0xE376821B, 0x455D605E, 0xBB9338C7, 0xFC3CAB7B, 0x58532E02, 0x231BA32,
     0x3DC96DDE, 0xBD396700, 0x792490E9, 0xA67AD009, 0x9ED61100, 0x22B9409C, 0x3E9AC987, 0xFB83A72A,
     0x5715D72B, 0x601EC889, 0x59562255, 0xD999217A, 0x3D9A4746, 0xF1530093, 0x6894D7C4, 0xE4BF301D},
    {0x59C9DAD,  0x7860A95A, 0x805BC032, 0x573C2B4D, 0xE575FE86, 0xD725E3BA, 0xD83D77AE, 0xF5DF49F,
     0x64EC6DE3, 0xD15A612F, 0xC053F8BC, 0x787226FF, 0xB389184C, 0x1968F2EC, 0x311BE011, 0x70A546C7,
     0x36247B67, 0x50FCFBA4, 0x52552E26, 0x66CFD78C, 0x6B309DCD, 0xAA52A368, 0xB6BF1DA,  0x244BE0D0},
    {0xA893CDB1, 0xF91A0357, 0x4BE36496, 0x5CDDADE8, 0x24787953, 0x2B0704A0, 0x38DD941D, 0xF7546F47,
     0x86F813DB, 0x33BAB5EB, 0x1F91E5AD, 0x48EA5ED0, 0x3A64247C, 0x149CD121, 0x2C92430F, 0x87B35B0E,
     0x1E51D3C5, 0xE0385815, 0xD9ADFF36, 0x4CE9CE6A, 0x194F3F3D, 0x678C794B, 0x19E7D3B9, 0x5D2D4D5B},
    {0x36C4B75B, 0x88D40B7B, 0x72081CAF, 0x180520A8, 0x885AF497, 0x429A665B, 0x7918E29C, 0xCF3A9FF4,
     0x2E8743DE, 0xE4626CE7, 0x5CFE8CBD, 0xA9E4957C, 0xEF471B68, 0x53E397,   0x42802B92, 0x71AE208C,
     0xE61072DA, 0x9A88FB12, 0x986CE6C3, 0xFCE16AF0, 0xD09AC520, 0xD1803113, 0x259D4B0C, 0xB7A7E481},
    {0xE2C1800B, 0xA65BD8E2, 0xD53CE914, 0x397E16FE, 0x55B6DEAD, 0x133F1572, 0xF72A19D5, 0x831BAF25,
     0xED8B71CD, 0x1ED3FFC4, 0x7317D2BB, 0xDB85907F, 0x3469EC7A, 0x6816604C, 0x7465FF4F, 0xFBD0E984,
     0x41F44E83, 0x7C773B41, 0x8743FABD, 0x61D372E1, 0x6AAEA767, 0xEA3DEE50, 0x61E2992D, 0x3D5675B6},
    {0xC2DA39CD, 0x88D4992,  0x8D394551, 0x90177CEB, 0x1121B91,  0x49C5CC44, 0x972C6395, 0x598F624A,
     0x31547E98, 0x2631D206, 0x5FFBB1C6, 0x1C901242, 0x26404955, 0x3B1FC0B4, 0x18290811, 0x5B26E476,
     0xA308FEC7, 0x44B55812, 0xB85F058C, 0x117F1A70, 0xAF25E453, 0xD43F8342, 0xD4CE5E6,  0x33A1F231},
    {0xA3C080A,  0xBC882FCC, 0x17E2A683, 0x4520E3A1, 0x4B6F7A21, 0x31174DF9, 0x9A2C65DC, 0xEC06BEDE,
     0x74C38F9C, 0x7E52E831, 0x23221F45, 0xE0AC02CD, 0x6E9AFC9D, 0x5123D79E, 0x48605FA6, 0x434C3365,
     0xA1A082AC, 0x8689D8B8, 0x4C316A0,  0x86897354, 0xABB922A1, 0x96934B91, 0xFE12E5CC, 0x2402BA29},
    {0x57294785, 0x93255184, 0x7BD0D4A4, 0x98206F24, 0x4350E622, 0x112131D0, 0xF82ADD42, 0xFFA3011F,
     0xE68D7FBF, 0x51590839, 0x6F8A2440, 0xD903B29D, 0xDBE4CC3,  0xCAE0DF27, 0xEC42DBC8, 0x44193E5A,
     0xB947A8A9, 0x9BCEA557, 0x7152AE77, 0xD84E0CBB, 0x88F3D27E, 0xF4199B18, 0x310E2365, 0x766CF14},
    {0x19E97ECE, 0xA50EC647, 0xC2BC3217, 0xFFDB6201, 0x9AD175C0, 0xD0AD002A, 0x5A70D85B, 0xA21342D7,
     0x1CF2F2FF, 0x3FFF8040, 0xCF5F5B75, 0x8BD57C96, 0x51CCCC4A, 0xA17FC1C8, 0x1164B7A2, 0x3F813843,
     0xDBD762AE, 0xF46BB7C5, 0x68BEDAF8, 0xF7A02289, 0x28DD2076, 0xA92FAFB3, 0x7E1B0C00, 0xB433FB97},
    {0xC481E285, 0xB7385349, 0x6648136A, 0x1291DE47, 0x22FC33F8, 0x375A3396, 0x3D5D3367, 0xE8C402C9,
     0x25604A76, 0x27E1315D, 0x94EAAF95, 0xD0318AEE, 0xC2B0A154, 0xB774F4FA, 0x47282FFB, 0x64F08FF8,
     0x7E62F641, 0xD28BDB74, 0xB475E31D, 0x2BE4ED4C, 0xED01E5A8, 0xE7E76BFA, 0xCFA1B786, 0x2FBEFB8B},
    {0x868B4974, 0xC587EF33, 0x64FB2C63, 0xC53D4046, 0xB3FC22DE, 0x1C53E4C0, 0x1E0BA91C, 0x86B4FE41,
     0x9B89F25B, 0xE7FFDD99, 0x923BCAA2, 0xA0E2646B, 0x5D8BAEFF, 0xAB13BEE2, 0x8EA952A0, 0x9C8E7C04,
     0x890D4EDE, 0x6CD31414, 0x1A1D1E93, 0xBDDEE0D6, 0x8CA80936, 0x37CF2E38, 0xE2F57D6E, 0x45752283},
    {0x7876024B, 0x91681A38, 0xE5F39264, 0xB8E61A64, 0xE42FF113, 0x2A65A551, 0x38972336, 0xEBD93A4D,
     0xA8679FFB, 0xBB056796, 0x1E5F1E79, 0xD2DCA29C, 0xD32642DC, 0xF5D96679, 0x9E5B8333, 0x6C7C8642,
     0x490FCD02, 0x5F28C3FA, 0x7D627103, 0x5F099C47, 0x3CF5BE74, 0xBA10C2A2, 0xD90282FA, 0x80115AD3},
    {0x7C8DA7A0, 0x9F7A21DF, 0x1E9367DD, 0xE0F660FF, 0xBA3C06A8, 0xAE1FA0F5, 0x73780F37, 0x8779A45D,
     0xB178D31A, 0xAC7A3FD3, 0x12A6B68C, 0x67A4AF81, 0x1CDBC697, 0x12F62E17, 0xBCCD1A23, 0xD99098A9,
     0x4EE00880, 0x12D3F320, 0xC97E299A, 0x738C79C3, 0x54C705A1, 0x190AF15C, 0x6366332F, 0xEC96DB51},
    {0x4D8CB412, 0xE109964F, 0x4F739495, 0xD6437D9D, 0xDC3B4224, 0x84FE385A, 0xE843572C, 0x53650AA7,
     0x5561CAAD, 0x95FC5F13, 0x600AEEC3, 0x304BBA8B, 0xEEE318A1, 0xC148762F, 0x10A25221, 0xDB086030,
     0xDD46EE04, 0xECD16E12, 0x68394DFD, 0xD65AC0A0, 0x712FEA0C, 0x5C60F5D3, 0x1B8408A4, 0x31569334},
    {0x2940B4BF, 0x27CBE67E, 0xACCCA2C0, 0x6F3A4C03, 0x48C7A3D5, 0xA0742D0D, 0x6197CA61, 0xC017714,
     0x8E644647, 0x75084475, 0xAD1856A,  0x7F0FF517, 0x7C2CCE84, 0x8D792977, 0x3EE5818E, 0xED02890A,
     0x8DBB072E, 0xDD22BA8A, 0xF77C8F17, 0xA18AFC0A, 0x82C89355, 0x150E1C25, 0xDA459D89, 0xE3F75F8E},
    {0x7B780726, 0x1C0999A2, 0x4B4FE859, 0x862D0209, 0x93AB9830, 0xA9547152, 0x3E9A40BA, 0xCDB8B76B,
     0xA91DB27F, 0x527D4686, 0x4CC6005E, 0xBC2DBF18, 0xE76400A3, 0x3AD188CF, 0xD4A55D11, 0x3887BC94,
     0x8E2F8DDE, 0x522B574,  0x9E3C8FD2, 0x5AC81DE,  0x9F152EB1, 0xDCDABEAB, 0x994ACFC2, 0xB7CD09A9},
    {0xA592C6EA, 0x8ED6A567, 0xEAAF5660, 0x68619806, 0x74F92C08, 0xEB3A8CF8, 0x46AEF506, 0x7536AA70,
     0x862E842B, 0x3AAB5A23, 0x126174FB, 0x7EA92574, 0x5A20E6D2, 0x74D87F8A, 0x9E46AA3D, 0x453243A9,
     0x300AFFD7, 0x1C0BEB26, 0x286B256B, 0x2093078,  0x3847AC1D, 0xEA00EF16, 0xA17DC039, 0x64C98362},
    {0x74D9808F, 0xC8801F47, 0x971B14FB, 0xE3A4BA9,  0xFCDC5D90, 0x581FE006, 0x7C3DADE8, 0xD4504F74,
     0xA91CAD4C, 0x4100F0CF, 0x828E173B, 0x41754293, 0x90D56E9D, 0xA4518611, 0x461E9437, 0xCD1B0DF2,
     0xC29D3D16, 0xC690F8E5, 0xC14BE32B, 0x77036832, 0x9BF9C1C,  0x8DB1EEF5, 0x58C232B3, 0x46186608},
    {0x63313D32, 0x8ADF13BA, 0x24A46004, 0xB2D65E6B, 0xFBCF877F, 0xBE49FFAD, 0xED35D61F, 0x53F35611,
     0xB750D6EE, 0xA8DDE6D2, 0x42E51E39, 0xE5600710, 0x328808FA, 0xCC74B365, 0x1C27BA28, 0x7874B1FE,
     0xC39C4B16, 0xCA0DDC6E, 0x28D46F86, 0x627E1EC8, 0xCF386826, 0x6BCA06DF, 0xA494C4E9, 0x95ECB004},
    {0x71A476D7, 0x3A036291, 0x1E6DCF40, 0x658F58A0, 0xA1AAB6EC, 0xD4BB5589, 0xB6B036A1, 0x8C8F5F44,
     0x963A0041, 0xC56299A4, 0xC50F0989, 0x6E0CE374, 0x355D20DD, 0x11194C41, 0xDE51D3D2, 0x126ED622,
     0x7056472F, 0x7B87F096, 0xBD8418D4, 0x5A8DD48D, 0x146DF962, 0xC682B2A7, 0xD57BA829, 0xFD911FBD},
    {0xE984D13B, 0x45E354C3, 0x845F3D98, 0xFC41B721, 0xE1A60834, 0x74A2DB43, 0xA68DAB4,  0x97E02FBA,
     0x20562168, 0x11058B4C, 0x298E2BEC, 0x7DE1B404, 0x247331C5, 0xB3A38BBA, 0xDCE4F143, 0x75151676,
     0xAF5A1E75, 0x404B0DCD, 0xAB73D343, 0x2406785,  0x9AA88A78, 0x22C70F16, 0xCC7CD80B, 0x8011CF5D},
    {0xEB90EBD6, 0x105ECA34, 0x53D79A77, 0x2D4C912C, 0x933BFB1B, 0xAD9F9870, 0x8651F06C, 0xBFE2BB42,
     0x9F18622F, 0xC21B49FF, 0x322E1502, 0xF7B30664, 0xFBDC70B5, 0x5424AC34, 0xF0278E7A, 0x46AFD636,
     0xD7B6DDCF, 0x777F8287, 0xBA81C28F, 0x707A8072, 0xED2FE55E, 0x570BA0EC, 0x33E972E4, 0x4A11E067},
    {0x3A6C2D57, 0x3B15F188, 0xBB79C06E, 0x3FB439B3, 0xCA7E56F5, 0x69655416, 0x4288D11E, 0x22468E78,
     0xCE2CBFD6, 0x4348BADE, 0xE6FF7FE9, 0xD90CF4C5, 0x754386AF, 0x88FEF374, 0xEE3E548A, 0xF3E241B9,
     0x89A56AE2, 0xE9410868, 0x14DF6432, 0xC2970BDD, 0xE756BB6C, 0x54196D60, 0xD86DB15D, 0xD7AEE13D},
    {0xC2A934A,  0x434B6BE4, 0xDC601C8,  0x9F00B93F, 0xA702D5B7, 0x3B1E43B0, 0xC9CD8A2D, 0x516CB6B0,
     0x93A7CD2E, 0x663D69BB, 0x6E66F22B, 0xD93148CB, 0xECADC9C2, 0x5C87888A, 0x2F84A34,  0xB9CDE51D,
     0xE63F2557, 0x58F3C0FC, 0x38473094, 0xB6ADC81D, 0x50AA9887, 0x75A7C8E,  0x8E6A6CA8, 0x575A9417},
    {0x8262891B, 0xE82597A7, 0x9A80F12F, 0x6F6431FC, 0x6C008293, 0x2EB4AC7,  0x6082B2C0, 0x3A7BEF80,
     0xFD2B4958, 0xF3A900D5, 0x143C6F7C, 0x121C6796, 0x87A85B79, 0xFE3045FB, 0x1FCE47E6, 0xA3BBE07,
     0xE782087C, 0x7E6F360C, 0x2940FCD3, 0x738600DC, 0xD167DEF2, 0x72D7B3A1, 0xA0AF7382, 0x70AE7F4},
    {0xF016B14C, 0xC949024F, 0x199ECEA,  0xCBE5BA3E, 0xBF000BCE, 0x58EDD997, 0x4BCD450B, 0x9374050E,
     0xEACDC514, 0xE4FBCBFA, 0x28C38011, 0x5849D6AC, 0x6714D5FD, 0xF2E9D3C9, 0x4E48CAEE, 0xBA221C88,
     0xDBBCC21D, 0xDA8CB0FF, 0xA8FEB47A, 0x65992105, 0x1CB45EAA, 0x49E16423, 0x7205C311, 0x9996DAE3},
    {0xB133F23B, 0x7981CEA9, 0x18B123FD, 0x8B8A66CB, 0x3FB30F6D, 0xF07B7096, 0x8B51A5FB, 0xD844FF3,
     0x4C1989D,  0x32FE2887, 0xD633FE8C, 0xBF6C19C7, 0x24D21296, 0xF6985CBA, 0x24C59F37, 0x9A5D89F,
     0x6AA2AE05, 0xB312B09E, 0x84471D52, 0x3FDF2FF7, 0x1302092F, 0x641F2517, 0xCCB57F4,  0x478778A2},
    {0x5C368261, 0x5F2C69BD, 0x71B4DB7A, 0x3356572D, 0x7FC3199D, 0x4E476A62, 0x3616FEEF, 0x1ECBEA97,
     0x148E127C, 0x62981140, 0x22CFB28D, 0xA817E61C, 0xA98DAF42, 0x20B71CDD, 0xA9DEAF22, 0x2FE74C2,
     0xD4C422DA, 0xB5861258, 0x6FC9560A, 0xEB7010F8, 0x17FA42D1, 0xFEA0A86D, 0x8A9E2554, 0x19456D8A},
    {0xD2159195, 0x1705280C, 0x2DD572BA, 0xCF5E587B, 0xBC171B7A, 0xE9AAD0E0, 0xBBC3E64E, 0x1A30F07C,
     0x5D8A783F, 0x4E3C883,  0x96459BFB, 0xF26DEBD2, 0x91434C88, 0x74457E76, 0xB406392B, 0xA5B3DE69,
     0x9376782B, 0x62F75EA6, 0xB0545BD2, 0x8EF64F8,  0x6B50009A, 0x346D3DF,  0x5AE750EB, 0xD2C9572B},
    {0x7B059C1,  0x39FF35F8, 0x58EFE08A, 0x59E4CDF6, 0xDEE2DA3A, 0xC5CB7181, 0x5B49DFA9, 0x2DE0C871,
     0x11E58313, 0x85F76A2F, 0xA89D0D,   0xF902D5DE, 0xA4E8BF8,  0x7E74E57B, 0x4A23ED94, 0x4CB5D253,
     0xD4C808E3, 0x2135CF79, 0x27A74FF2, 0xD6069252, 0xD9F47BB3, 0x6ACAEDB1, 0xF594A06D, 0xB2A5B3F0},
    {0x56D6C905, 0x2A4F22E0, 0x5298A9C5, 0xD58C70B6, 0xDFF83EB3, 0x3A93E440, 0xD3717643, 0xDE1616CB,
     0x1CC86D7,  0x784E0AAD, 0xBD74FFAB, 0x4842A9F9, 0x2F752FE2, 0xF58B063,  0x6A4308FF, 0x7E2C66E6,
     0x3A5EB874, 0xB3697DFE, 0x9946BA95, 0x6258DAC5, 0x99B0F4AC, 0xB6051E3B, 0x2C3574CA, 0xE37676AF},
    {0xD5D5C825, 0x132C8589, 0x6020D3E7, 0x58AD935,  0xC528C53A, 0x6D758B1F, 0xBD05520,  0x73B9EB36,
     0x390A631C, 0xE5916133, 0xAD9BC281, 0x57F7212C, 0xADE4AB8E, 0x37CFEFD4, 0x9F396D49, 0x20A4E895,
     0x8C335124, 0x5E45020,  0x43BF8EC3, 0xF3F34E33, 0xA03F446A, 0x5B23E668, 0xFDEF0980, 0x3DE01400},
    {0x1CF4BE33, 0xFBC45CC0, 0x7401049A, 0x1ABD4107, 0x4B4A4F1C, 0x726F87AE, 0x585EDB38, 0x1C7CFAB0,
     0xB04B8ED5, 0xF986101D, 0xD4797E19, 0x71710BB5, 0xF738175F, 0x4E8BC2C0, 0xE524D2B,  0x89FFC1EF,
     0xF923B0FA, 0x819675BA, 0x5523B624, 0x51F630F4, 0x38B83FF8, 0x4F28385F, 0x8E21936A, 0x34FF09A4},
    {0x5E44AA77, 0x870A83AE, 0xF13F113,  0x8E30251B, 0x14C137B0, 0x4E653C40, 0xF963722B, 0xF48855FE,
     0x6CCF41C8, 0xF86CB153, 0xFC117646, 0xC77BE1EA, 0x33FE6119, 0x4E79D944, 0xF26E3D45, 0xD533AA68,
     0xA5C9DB83, 0x2735988D, 0x1EAF8A24, 0x3BB5E133, 0xF997532A, 0xB40CE9F2, 0x7053ECAB, 0x7B6699F5},
    {0x8895B204, 0x6124B2B4, 0x661FB63A, 0xEC920377, 0x67D2AC09, 0x9EB9C710, 0x3FAD8D85, 0xBBB47DB5,
     0x1C734E4,  0x33E22F9D, 0x85C138F1, 0xDF5D1984, 0x10CF142B, 0xE37301BC, 0x161287D4, 0x720FFA6D,
     0xD95ED48E, 0x74FEA0E8, 0x4D3C1DD2, 0x787BDC3F, 0x9D0986B7, 0xA5A36E66, 0xE9B1621D, 0xE9AF2132},
    {0x9AEA4C7,  0xBAF73728, 0x7A69A3A3, 0x1FB14342, 0xA161CC84, 0x8CC9B0D6, 0xF24C898B, 0x82ADB3E1,
     0xB1A0D92E, 0x37C4D8DF, 0x82299DF5, 0xCA7A260,  0x274A2B2C, 0x95A42F0E, 0xEEBC7BD1, 0xE51F1B53,
     0x14023920, 0xD6500C62, 0xBC41478D, 0x20093E41, 0x2B9E9FAD, 0xC2EE800,  0x14D05B49, 0xCCF3D351},
    {0xA3814B69, 0x9CCC75A4, 0xD3425175, 0xEE0EE55A, 0xA96FA65F, 0x9187C5A9, 0x24FCC144, 0x1A40E56C,
     0x446E813D, 0x17935AB1, 0x4ED5AE72, 0x339CE425, 0x83B7E128, 0x1271BC83, 0xAD5C552D, 0xC57C3CD3,
     0xBAA4381,  0x7963E4EE, 0xE37FB419, 0x42C72166, 0x923C8FFA, 0xB610BE4F, 0x4DF30DC,  0xB565EA35},
    {0x97ED7332, 0xBACEAB17, 0xBA741142, 0x9A09C0B,  0xAAA0C478, 0x243C7EBF, 0x774642C6, 0xE378E009,
     0x50D49F14, 0xC0165E80, 0x89BE2898, 0x72771004, 0xA42AB1EF, 0x3B65D0FE, 0x6D178BE0, 0x5F5F20F1,
     0x41205289, 0x9A08DEF4, 0xD074301F, 0x86C41023, 0x6E5921EF, 0xD2C7DC47, 0x46312A5B, 0x6D562875},
    {0xDEC74CF3, 0x4A3364AE, 0x7BEB2EE5, 0x9755ADEF, 0x77644805, 0xE190B9E4, 0xC3C4D985, 0x35A1BDC0,
     0xED584A3E, 0x837485EF, 0xCA41B474, 0x50C4377E, 0x648D549B, 0x5C20270D, 0xF520C1ED, 0x38C51D92,
     0x86CFEEE3, 0xEBCD69A3, 0x86AB3A2E, 0xDEA78739, 0xF52DA195, 0x706B40B6, 0xC39B8F43, 0x661DF2C8},
    {0xDA31389B, 0x3AD5D694, 0x4526C1B4, 0x52D0E579, 0x70A49AAF, 0xA27E3BAB, 0xC62546AE, 0xEEA99E24,
     0x2F289307, 0xDCF35757, 0x9C0A8025, 0xC0954D93, 0xD62F70C5, 0x2AF7299B, 0x63A260F0, 0x297F47B0,
     0x56F70691, 0x28D5D65F, 0x28AB3F21, 0xC49AC2D0, 0x87C61591, 0x8E165FF1, 0x4C94899A, 0x45B8D8E},
    {0xD1399AA6, 0xB2F7978,  0xE4794D1,  0x7DFA3906, 0x1D9E58EA, 0x105F6FBD, 0x44E50BF4, 0x9B66921C,
     0x37D041BD, 0x24C57921, 0xA45C287F, 0xC3A8B6FB, 0x66AA666,  0x679AFC92, 0x54D7B3C2, 0xCFDA1309,
     0xC74084FE, 0x60150C23, 0x685CA684, 0x543D6AA2, 0xE23CD672, 0xA5B33D6A, 0x276D8D65, 0x1FE85FD8},
    {0x10FEA0FC, 0xD8B39DB,  0xDBE17CF4, 0xA431B8E0, 0xD2E718B0, 0x459DCD79, 0x97D5FB0F, 0xC9DE5593,
     0x8D04EBA6, 0xF2843DEB, 0x9C4E1E7E, 0xD8EECEC2, 0x844DE9F7, 0x4B462695, 0x92EAEA2B, 0x7B6D7E05,
     0x287CA2BD, 0xFD03949E, 0x16FEB08,  0x7437AFAB, 0x23A78CBB, 0xDF01584,  0x5132F525, 0x849B048C},
    {0xDFDE2AAA, 0x329E2A66, 0x4A9E5D5D, 0x121D3086, 0x192B4DEC, 0x5332E5BF, 0x594130AA, 0xD6CFF032,
     0x72DC99C8, 0x7A864C80, 0xE14BA6C4, 0x97F3F1F2, 0x891C5A70, 0x5DA46648, 0x7F58605C, 0x48D84466,
     0xDF836955, 0xDC2F844D, 0x9C438891, 0xDCB91C04, 0x75E6D5A7, 0x164B1BDB, 0xE4701F3C, 0x4990A224},
    {0xC96E2167, 0x6775A5D6, 0xBA464295, 0x7827FEAC, 0xE59C6C2B, 0x68801E38, 0x3EDD8BA8, 0x2B92AED6,
     0x7C2C8C95, 0x288EBB36, 0x4B1DABE8, 0x336EA12A, 0x8E83EBF,  0x7A732F78, 0xA555D341, 0x61CCFAAF,
     0x87180592, 0x4DF0C519, 0x2130BD65, 0xDA9FDFE2, 0xFB383DB1, 0xB3A72094, 0xB577BC79, 0x47E7A8A6},
    {0x40A225B7, 0xE3497E3A, 0x21970F97, 0x9CDFA6A3, 0xBC298A57, 0xD182A8AF, 0x57EDD133, 0x93C80B87,
     0x9A761295, 0x124BBEEF, 0x2173077B, 0x23BC5C07, 0xB32005DE, 0x7FE5D31C, 0x32B6DC4E, 0x98103608,
     0xCDAAE9E9, 0x296F7EDF, 0x56C0CA45, 0xD1FA01F6, 0x7CD429DE, 0x87CFA728, 0x764159C8, 0x61046200},
    {0xAF60ACF0, 0x9358B12D, 0xDE5155B3, 0x570C340E, 0x98EEC0D8, 0x957DC845, 0xF9E901FE, 0xE4596076,
     0x89006F20, 0xFFEE9E79, 0xD02BF046, 0x15C47F10, 0x2F31E52A, 0xDCE3D7E3, 0x6EBC5E4B, 0x89A7D8D9,
     0x806A9526, 0xDC52703D, 0x339BA099, 0x25119D5B, 0x6B19212,  0xFF85FC9F, 0x7D88B673, 0x513D8E18},
    {0x648EC00B, 0x4795E43,  0x78257FE,  0xB75F5892, 0xEEF1170B, 0xDAE5D8E6, 0x60FC4D77, 0x3FE715A2,
     0xD083F175, 0x699A30F3, 0x5FBEA29D, 0x1BD87DB6, 0x3094321D, 0xC482EC25, 0x9410B73D, 0xE42AA86D,
     0x242854F8, 0x53574200, 0xCFBC7D78, 0x9BB38B8F, 0xBDC2F709, 0xA638B972, 0xCFCBE50,  0xAADA6C33}};

#endif /* __TEST_ECMUL_H */
