/*
 * Copyright 2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __TEST_ECMUL_H
#define __TEST_ECMUL_H

#include <stdint.h>

static uint32_t test_ecmulscalar[128][8] = {
    {0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x11112AFE, 0xB6E65164, 0x45CB4B04, 0xB8ED6738, 0x0, 0x0, 0x0, 0x0},
    {0xED614F6D, 0xD03338BE, 0xBEF8599F, 0xC9B97F66, 0x0, 0x0, 0x0, 0x0},
    {0x6FAA7A76, 0x8046542B, 0xB736683D, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x3662C6E8, 0xAA410AC, 0x38E231B3, 0x452F954A, 0x8967387C, 0x0, 0x0, 0x0},
    {0x7381F9B6, 0x9442789E, 0x1E3DFD6, 0xBCB0BCE6, 0x0, 0x0, 0x0, 0x0},
    {0xABF4927B, 0x4F8904AF, 0xA125E4F1, 0xC911B043, 0x118B5EED, 0x7615128, 0x56A4343C, 0x0},
    {0x271B9184, 0x18C0496C, 0xBF53FCB0, 0x6B8DD736, 0x2054BC16, 0x1F3A14D, 0x18662856, 0x16F833E},
    {0x91AD5E3, 0x7952DA95, 0xF3A762A2, 0x27314F3B, 0xBD8C3D9D, 0x35266BB2, 0xFFED33E8, 0x0},
    {0x1C5A75B4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xAC55932, 0x42D172A1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x4E3DEE1, 0x879021A1, 0x8469CA27, 0x20676ACA, 0xDE3E81C5, 0xF6143153, 0x71810521, 0xEB6B3234},
    {0x4EBA8BC8, 0x637AFA5F, 0x786C6821, 0x62B295AD, 0x0, 0x0, 0x0, 0x0},
    {0xA9666352, 0xA7DA2167, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x2FF86798, 0xEE13F282, 0x1AF473ED, 0xCDBCC665, 0xDACAFF24, 0x28E3FF50, 0x5797A0E6, 0x3822870C},
    {0xEE4780D6, 0x16F1B94A, 0xD2E75C25, 0x4528DE1B, 0xBA8C707A, 0x0, 0x0, 0x0},
    {0x5E0B3B19, 0xBE51273A, 0x2034C3D, 0x75DF63FF, 0x49E73B71, 0x2FC3BC9C, 0x698E502, 0x0},
    {0x88E12C47, 0xE4519BCE, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x10406556, 0x722B3470, 0x19CF89A2, 0x7C3B789B, 0x28CA76EC, 0xC445179D, 0xDBB70277, 0x0},
    {0xAC35F315, 0x11D19B78, 0x845840DF, 0x9F43C9B0, 0x2467B884, 0x758DAE31, 0x0, 0x0},
    {0x3071D4F1, 0x650E0951, 0x57D93C6C, 0xABAB4626, 0x16E65D27, 0x23F2BD47, 0x0, 0x0},
    {0xC2B0A106, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x6CEA1FA7, 0xFF6AAA69, 0xFB35C561, 0xA7FC37CE, 0x30906839, 0xBA545D1D, 0x0, 0x0},
    {0x4C505E28, 0xB88C8208, 0x3136AA17, 0x6AAED70B, 0x0, 0x0, 0x0, 0x0},
    {0x9B24A9C4, 0xC8043FA6, 0xA1D802A7, 0xBCC2E4FB, 0x85BE3B12, 0x0, 0x0, 0x0},
    {0x51DA49A, 0xB9CA69B1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x6BA377C0, 0xC6A640F, 0x58D6A573, 0xA9957F61, 0xA60A062A, 0x8C384428, 0x7434D971, 0x5F611FFD},
    {0x72A6D797, 0x97D202DA, 0x31BA67AA, 0xD510D07, 0x7D857383, 0xBA3B27EA, 0x539F3522, 0x32416C16},
    {0x764D6365, 0xEC1D5F24, 0x53151B80, 0xE15B7271, 0x3D661EE8, 0x67884473, 0xD0179D86, 0x0},
    {0xF823A229, 0x49943A97, 0xB2E65A59, 0x354EA85E, 0x884A239F, 0xC1D43F9F, 0x0, 0x0},
    {0xCC1A9096, 0x513E37A7, 0x59E0D6DE, 0xEB0B8F4C, 0xFBB86EA0, 0x515A9041, 0x79C60E0F, 0x0},
    {0x2619D12E, 0x523DA3E1, 0x373EB369, 0xF1A973AB, 0x2D05AA77, 0x564F86E8, 0x0, 0x0},
    {0xA8AAEE08, 0x8E0A8CF, 0x29A5F547, 0xD3D65DE3, 0x1EC3396B, 0x0, 0x0, 0x0},
    {0x1F3D73FA, 0xCF2A83F3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xEB907008, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x6A9AB156, 0x3BA79A44, 0xD8CC03B5, 0xF0326D21, 0x1B9F9EF0, 0x0, 0x0, 0x0},
    {0xD244E60A, 0x16B0F091, 0x72291A80, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xF8F47D72, 0x7B3E6505, 0x99A80126, 0xEC38DC1B, 0x0, 0x0, 0x0, 0x0},
    {0xF1012991, 0xF80CB80B, 0xBFABBAFB, 0x2F34D855, 0xB64CEDF8, 0xC21A8F18, 0x84B22B7B, 0x0},
    {0xA0455EC7, 0xE45515D2, 0xCFDFDBDF, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xBFE8A6D5, 0xF4A7B5A7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xF4CE2B6B, 0x8AC7713A, 0x7259F497, 0xA81249FE, 0x9C551B1B, 0x7DF3A8AD, 0x0, 0x0},
    {0x26DEFF38, 0x90560FA5, 0x2434888, 0x229CF2F8, 0x7AAD957C, 0x2CA604EC, 0x0, 0x0},
    {0x2D9CE8A6, 0x49E33388, 0x554C785B, 0x47C50ACF, 0x97E3B501, 0x3BBB7DB5, 0x0, 0x0},
    {0x6D89562D, 0x8AC3E2E, 0x3D1AFA70, 0x4D605AB6, 0x86A39B5, 0x3C3802E3, 0xDD989870, 0x4197DD05},
    {0xE81ABD18, 0x81BACCD4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xF734DF7D, 0x7938D023, 0xF695D4DF, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x3E940CAB, 0xFB9134D7, 0xE6FE2B3F, 0x57FCE919, 0xDE951CBE, 0xE94D1B5D, 0x4DFE37BA, 0xEFD4C6CE},
    {0x27964DB7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x38C99706, 0xE498129B, 0x4887FDBF, 0x1820E942, 0x51EF0481, 0x1D6AD2DB, 0x0, 0x0},
    {0x1265C06F, 0x6412DFD0, 0x88217AA1, 0x4DF6DD85, 0x3A790D2E, 0x44FA06B7, 0xA06C9FC5, 0x0},
    {0xEA2D9D9C, 0x7ABF9257, 0x1C2AC690, 0x576A99DB, 0xCF19212D, 0x0, 0x0, 0x0},
    {0x618D206C, 0x54D2F8F5, 0x20240E1, 0xA2E78AC, 0x7F4B105E, 0x8A9BCF7E, 0x48B67B26, 0xEF0369CA},
    {0x1AE7A65A, 0xE2DCF08C, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xFCCFDF49, 0x2E11CE91, 0x9E3BBC4D, 0x9CC77CB6, 0x22EFCBAE, 0xF8C6316B, 0x68E86A4, 0x35C050D},
    {0xE6058912, 0x8E8A1BDE, 0x7D19178B, 0x85FE1AD9, 0x21515140, 0x6756D67D, 0x0, 0x0},
    {0xF55ECAF, 0xF35D2507, 0x8D92F226, 0x2E03D7A0, 0x65CD7DFD, 0x0, 0x0, 0x0},
    {0xB94500E3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xD969C514, 0xD7874473, 0x8D998328, 0x7513B057, 0x95C4237, 0x1C4E6ACA, 0x0, 0x0},
    {0x76726A3D, 0x4937910F, 0xF215E425, 0xC4F2CD7D, 0x65C6FF8D, 0x9E1A1967, 0x0, 0x0},
    {0x3912C316, 0xC73DA47, 0x3CD4B3FD, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x837B52F2, 0xE30AD966, 0x852DEE0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xE3C8A191, 0xD1342F26, 0xE521ECC0, 0x3DA6D053, 0x0, 0x0, 0x0, 0x0},
    {0x7115EA9C, 0x9EA80596, 0x8AE0E5C7, 0xFC182333, 0x83649C74, 0x0, 0x0, 0x0},
    {0xC7351144, 0x948DF84A, 0x4A21B5A2, 0x5765A23C, 0xC18A89BB, 0x26203AFE, 0x1FFEF61, 0x0},
    {0xD7F796A4, 0x5E50086, 0xCBA19F5F, 0x16E6FF3D, 0x0, 0x0, 0x0, 0x0},
    {0xCAB84817, 0xFF8AEDE5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xD755C303, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xB54B38D7, 0xA6FA77A, 0x5283910C, 0xEB1AC5C2, 0x944F54FC, 0x36234834, 0x95B690A3, 0x0},
    {0xBB984930, 0x3D8E7CA8, 0x50033D76, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xF8C0DAE9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xAC19FAC6, 0xD36EC394, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xAC6BE390, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xAF9C7E6B, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x495C007D, 0xDF534030, 0xBC80D10F, 0xE0761BD, 0x0, 0x0, 0x0, 0x0},
    {0x79E876E4, 0xD0955A8C, 0xD60140CF, 0x37835E04, 0xC35824E9, 0x0, 0x0, 0x0},
    {0x5D720AE5, 0xF1EAD248, 0xF092F007, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x68989F3B, 0xCD40B864, 0x536D66A1, 0x154BC6EA, 0x632BAA8E, 0x8B6ECAEF, 0x5DDDED7E, 0xB31C5B16},
    {0x15A46077, 0xA13630F, 0x90AC53EA, 0x2072B159, 0xEFECBCCC, 0x0, 0x0, 0x0},
    {0xA47AD277, 0xF2577082, 0xBF577753, 0xFD31CAD, 0x0, 0x0, 0x0, 0x0},
    {0x9F9DF59B, 0xCD3994F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xBB131388, 0x1F54A627, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xF59611BC, 0x335AFFCF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x8222EE78, 0x6674159F, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xE8AA17B4, 0xBB05166F, 0x22C96856, 0xE7C9530, 0x0, 0x0, 0x0, 0x0},
    {0x1FFBE34C, 0x77B54B26, 0xA009EC79, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x6C039ACA, 0x8A44B3CF, 0xDA4AA608, 0xACC31EB8, 0x0, 0x0, 0x0, 0x0},
    {0x2E3A4C5F, 0x4793E34, 0x6405E42C, 0x2FBC28B0, 0x0, 0x0, 0x0, 0x0},
    {0xDB480494, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x9BC2AA80, 0xB394C60C, 0xC9E4D3C3, 0xCFE57810, 0xB4A446B5, 0xE0CAF308, 0x7BA4502D, 0x0},
    {0x2BC13E7E, 0x2644CFC6, 0xC0EA955C, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xBC18EACB, 0xCF14EF21, 0x551ED198, 0x1F1812A7, 0x9444C0C2, 0xD4285B8A, 0xA19249A8, 0x0},
    {0x4E487CAE, 0xA1FAAC7D, 0xE65AABEE, 0xE054D694, 0x0, 0x0, 0x0, 0x0},
    {0xEE1E2D7A, 0x4EC10DD2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x65918F45, 0xA429B9B7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xDB348ED7, 0x2AE9F0D6, 0x6A522CA, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xCC359DBC, 0x37B8791E, 0xC95E8074, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x834C93ED, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xE9B0A09B, 0x97EE0D4, 0xD4AE949D, 0x2BD028C1, 0x0, 0x0, 0x0, 0x0},
    {0xFADDD2B0, 0x843F1432, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xB591656E, 0x3DA696B3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xFB239B94, 0x313D2D4D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x72CED670, 0x1F6D8C18, 0xCC379DDD, 0x8CC2A0B6, 0x1C011360, 0x0, 0x0, 0x0},
    {0xE28F525C, 0x4B5323D9, 0x3338EAB4, 0xE68BACE, 0xA453A14, 0xA04EE044, 0x0, 0x0},
    {0x86956537, 0x880AAC4A, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x9B4B0A1F, 0xB042EA06, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x43F2B48A, 0xB4ADA15B, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x37F92FF8, 0xE227BAF9, 0xDBE00A5F, 0x35DDC110, 0x895445C7, 0x9D55BCA9, 0x5EDE7ACB, 0x0},
    {0xF79298DF, 0xE2612315, 0x8677FFEC, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xF2C042F8, 0xC645CA47, 0xE146F43F, 0xB9F3D8B5, 0xC7184DD5, 0x47D339F3, 0xD726F30F, 0x0},
    {0x417E9243, 0xC25D2C44, 0x564972A4, 0x320D0AC8, 0x2E8B226, 0x0, 0x0, 0x0},
    {0x3AB3607E, 0x7D2CF416, 0x3E3DB2CD, 0xBD2FAD0E, 0xAD64683B, 0x0, 0x0, 0x0},
    {0x26EF8F6E, 0xA92CFB9F, 0xBF4DEB4B, 0xC807076C, 0xEFF9D995, 0x665DA4FE, 0x9AFCE9E8, 0x0},
    {0x27A0CF96, 0x25A76FA1, 0x55A31790, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xA069B5CE, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x4A7410B, 0xE7BEC78, 0x7A61EC56, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x44D925CE, 0x9475A324, 0xB8532830, 0xC2A5981D, 0x40CBF4AE, 0x7113C74A, 0x0, 0x0},
    {0x36A06A8C, 0x7F0238E1, 0x814A467A, 0xEE570725, 0xE68F5FAD, 0xF81C6EBF, 0xAA03B4C2, 0x0},
    {0x7DE8EE19, 0x22663BA2, 0x40D718B3, 0x8DA5D31B, 0x213AFF20, 0x0, 0x0, 0x0},
    {0xF60CD1DF, 0x5C083F0A, 0xC2CA7701, 0x60FB4D0, 0xAB746191, 0x0, 0x0, 0x0},
    {0x5F8818E4, 0xE260FF8B, 0x6D07E51C, 0xFC46B9CB, 0xDBC5017C, 0x9557F740, 0x956AD568, 0x0},
    {0xDD5616AB, 0xB4FA5AE5, 0xACFC0068, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0x3C3879E7, 0x9B33D640, 0x39431BF9, 0x4CD624E, 0xAA065908, 0xC3496C01, 0xA545FA8D, 0x0},
    {0x4BD15C9E, 0x9743C85B, 0x2DB58A64, 0xB560AC28, 0x7A3B8D30, 0xEC7CECA9, 0x8A5B958B, 0x0},
    {0xEB141883, 0xC959A7CB, 0x26D80AAC, 0xDDD40A2C, 0x14245DCC, 0x5ABDF575, 0x39BE1CCB, 0x0},
    {0x1C6BC666, 0x450A62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},
    {0xB5A1D2F, 0x9C955F0C, 0x7848A946, 0xC3839B14, 0xFB69C19E, 0x0, 0x0, 0x0},
    {0xDC651365, 0xDF7DC635, 0xBC53B90A, 0x20938130, 0x2044BF62, 0x0, 0x0, 0x0},
};

static uint32_t test_ecmulans[128][2 * 8] = {
    {0xD898C296, 0xF4A13945, 0x2DEB33A0, 0x77037D81, 0x63A440F2, 0xF8BCE6E5, 0xE12C4247, 0x6B17D1F2, 0x37BF51F5,
     0xCBB64068, 0x6B315ECE, 0x2BCE3357, 0x7C0F9E16, 0x8EE7EB4A, 0xFE1A7F9B, 0x4FE342E2},
    {0xE55F2A26, 0x3067562A, 0x99A59122, 0xBE4ECF89, 0x79E3C038, 0xF56C4612, 0x5B004683, 0x94CC88D5, 0x9ED6D644,
     0x28029F12, 0x29B66DBA, 0x984067A, 0xAEB9EDA9, 0xC6DF24F6, 0xFF52EDD4, 0xBF92A178},
    {0x69102B91, 0xAC15AFBC, 0x89B36B44, 0x519801A5, 0xF351334F, 0x41863842, 0x4FF6CFCC, 0x939D303C, 0x841F65D,
     0x3EFAF6E4, 0xF4465229, 0x780FBDB6, 0xAC20F65E, 0xD177D0CD, 0xA55AFD69, 0x7BE29E34},
    {0x12CDC209, 0x3B0BE47D, 0x1CA5BCA2, 0xBAE99A5, 0xD29F80EE, 0x5540CE61, 0x3DD78430, 0x296FB665, 0x6D940D35,
     0xB992BEFF, 0xF0B12422, 0xAFE262A8, 0x5CF01CB0, 0x7E3F554F, 0x2535CEEC, 0x5607142},
    {0x3EE6DDD7, 0x56E85ED4, 0x4B32EBAE, 0x871156B8, 0xB9406AEC, 0x72DBD8DA, 0xD5D0F5A1, 0xDC99EAE4, 0x5DF68206,
     0xB1D1ADBE, 0xE9490E95, 0xCF3D9A84, 0x10F12691, 0x29933485, 0x48EDB04E, 0x4D5AAC7D},
    {0xFA149278, 0xBCDB89B5, 0x50D3A6C7, 0x19DEE1E9, 0x7FACB416, 0x474C46FB, 0xACC30984, 0xC8E126F5, 0x5061EE0F,
     0x480B0813, 0xAFE93364, 0xC23BE350, 0xE8A2C8CC, 0x37E545C7, 0xA17E3548, 0x56CB7D74},
    {0x9AEA617F, 0xF515DAF7, 0xEB3DE1A3, 0xFAB991C2, 0x384C7DF0, 0x53047018, 0x3849AC38, 0xFA075026, 0xCAEBD0DC,
     0x5FAC1AC9, 0x7353AF6C, 0x365D426A, 0xEF38F606, 0x4FA7CFC6, 0x260ADB3F, 0xD77F09FD},
    {0xD261E056, 0x6D56F2E6, 0x71871D3F, 0xC4BDE6EE, 0xAFC1AF5F, 0x1DD34E54, 0x50461EE5, 0x3711F640, 0x2C413783,
     0x4DFB7A59, 0x7A42F6E4, 0x886E90DA, 0x31901B0F, 0x5723ACBE, 0x9914DD89, 0xB2912AAB},
    {0x8D733AEC, 0x8F2D2AA4, 0x74DADC62, 0x6ED18550, 0x2180267, 0xD1FB9C59, 0x58D87488, 0x8E45C1B8, 0x4DA06798,
     0x61702268, 0xDC972DCD, 0x3EA7774C, 0xDB325F4B, 0x9E2C6E0E, 0x5183E4DB, 0x1B88DDE7},
    {0x29852BF6, 0xB6E4ADCD, 0xB2381C57, 0xCD2B3954, 0x9894EAC0, 0x6183966C, 0x22A81566, 0xA2320862, 0x8E85B9E3,
     0x559B8991, 0xE90003EB, 0xCA7C27AA, 0xC6B8A723, 0xC19A9316, 0xC760FCAA, 0xA9182FAF},
    {0x68B8C370, 0x6CDB0163, 0xA0A62588, 0x28BE16D1, 0xBCB81B55, 0x5957DA78, 0x6D092D90, 0xA92BAA76, 0x1D9F5A1F,
     0x1CD81747, 0xCDC17ED5, 0x6AAB320E, 0xA86DB062, 0xB71CD1F1, 0x1E2C41EC, 0xE8CBA9C3},
    {0x36DD6F11, 0xAB22806C, 0xAB1F5729, 0x68CC5B2D, 0x960D5682, 0xF262B2F0, 0xDB3C0F51, 0xE8242082, 0xEFCC6E02,
     0xD6EDCD05, 0x7DDD0466, 0xD80FD2DA, 0x6F50ECDC, 0x7F4D8326, 0xAE91684E, 0x4543C713},
    {0xF1D0DA19, 0xCE7CC8BB, 0x6876C0C, 0xC100F6F1, 0x974FF98F, 0x73CAE5F6, 0x1DA182BB, 0xF9E6A6B5, 0x971269DC,
     0xD3394463, 0xD839A65A, 0xD9F9B52A, 0x7A4AC8E2, 0x4D2F3F59, 0xD2B62C9A, 0xCFF3262B},
    {0x22F8544A, 0x9766F0C2, 0x91E2DB4B, 0xCA33496, 0xD7BFFF6E, 0x50AAB783, 0x43476DDD, 0x595EA96A, 0x4BED115B,
     0x44FF6015, 0x624E36DF, 0x55FE8FF9, 0x1EDE69A7, 0x681FF3BB, 0x48BABF86, 0x1CFE74C2},
    {0x69C99BCD, 0x297AD1A3, 0xD96D7454, 0x967FAD10, 0x8CEF4162, 0x32559210, 0xD9086DD9, 0x4AAF4F8B, 0x6FA2F164,
     0x4FD45505, 0x11C8ACB9, 0x96C98A33, 0x4E68232C, 0xFCB6A0C1, 0xFA9A7458, 0xF52C3810},
    {0x3CD4413, 0xD60D1C28, 0x40EE4351, 0x2E595380, 0x11437318, 0x9F70FA6, 0x72B12ACA, 0x8A470685, 0xF152DA0A,
     0x81358D78, 0xB7475640, 0x8737901E, 0x293FF0F2, 0xABAF58E1, 0xAAE0C9C7, 0x4F8F0362},
    {0xE1DA0413, 0xA3D6063B, 0x10DDF9AF, 0x75ED9B39, 0x441473CB, 0xBB9ED25D, 0x18CCD6FE, 0x12107B1F, 0x3F5B926D,
     0x99594178, 0x3E4D24DA, 0x7D1C134B, 0x4A245F43, 0xEAE62FDE, 0xAF830170, 0x43E19027},
    {0x24765C83, 0xD4526554, 0xCEC59B77, 0x1DF578C8, 0x97ED048D, 0x96DE7F95, 0x4144E11C, 0x64639757, 0x112DE65C,
     0xD76297CD, 0xA6EF93A4, 0xE199521E, 0x40DB3DEA, 0xAD90EAB4, 0xE2B72DEB, 0x9601E34F},
    {0x9864859B, 0x5DC35083, 0xB8E33281, 0xA8C3D5F0, 0xAF6239D4, 0x834B33F6, 0x6D07C5C6, 0xDA431CBF, 0x548155DA,
     0xB229A72A, 0x7D4AD151, 0xC5A42BC5, 0x2959A6F0, 0xA6A177D9, 0xFF94519A, 0xCEF60116},
    {0xE8C57953, 0x51438DC, 0x92E45126, 0x41315B88, 0x6A0264C4, 0x7AC7C51E, 0x55BDDE89, 0x20713283, 0x99EDEA9E,
     0x9BC21859, 0x9FAB8DC6, 0xED8F2A8F, 0x4D418D20, 0xE98B552E, 0x342C5D91, 0xE93AD20B},
    {0x90A78883, 0x46E2A46B, 0xACCDD0FB, 0x59B94B97, 0x86AD126E, 0x83612776, 0x35109763, 0x3A23DEDD, 0xD24DCA6B,
     0x25960710, 0x51775ACD, 0x2CFD8072, 0x5B66B72B, 0x81B0084, 0xCDDFAAE8, 0xC7F5374F},
    {0x9C96C6D5, 0xF5DA2CEC, 0xC718383D, 0xC523346B, 0x126B86B1, 0xFECC60E4, 0x542FF669, 0x63E8CA3C, 0x6E7958E9,
     0x5DF39588, 0xEBAE4B43, 0xB8FEF9BB, 0x77F1474, 0x605EA94A, 0xFC96FBE5, 0x2C81281B},
    {0x9D417C92, 0x97D5585F, 0xF83D593C, 0x5AA6F1E3, 0x5C573821, 0x88A10153, 0x290F4741, 0x72AA3EE, 0x80BAD4B7,
     0xB7BEBC5E, 0xD2CD9C98, 0x35432B9, 0x28483DE, 0x77A67638, 0x68FA0F30, 0x86B66655},
    {0x801E1882, 0x30138C6, 0x75C66839, 0x2E256DDE, 0x555FAE21, 0x33B00272, 0x374EAE36, 0xFE205D54, 0xAB641DED,
     0xF0724C14, 0xF2A65BB6, 0xE52A70C, 0x11884DC, 0x1E54B398, 0xB441E7A0, 0xE41720FF},
    {0x81262685, 0xCB71E733, 0xE0CBB318, 0x2D6CFFA5, 0xE325BD53, 0xE60C5A59, 0x1454B52, 0xBBC2CF09, 0xE2EBAA4E,
     0xBE626D74, 0x339DEE84, 0x1CE00B28, 0x1271C9C1, 0x25E15B5C, 0xD9661BB1, 0x7E5D5D4E},
    {0x3627BF5F, 0x987FE9B5, 0xDFB1449A, 0x52AFB13A, 0x5B93D853, 0xC71F931A, 0x7DA2C2A6, 0x998078F8, 0x69D013FB,
     0xCBA87B55, 0x8D791B28, 0xF8EE42C5, 0xE49D8A11, 0x93567590, 0x8A2004E9, 0x1A30033F},
    {0x5689B762, 0x83886EB5, 0xE0AE465F, 0x8477E00, 0x3429B24E, 0x8FBF4C15, 0xEBAB2CFC, 0x7A35EB24, 0xE933A1C9,
     0x73F50A11, 0x76AB8D4B, 0x66509EB5, 0x4072F559, 0x89A0D443, 0xF010F688, 0xEA369BA6},
    {0xBF0C346D, 0xA0D98E18, 0xB96F4155, 0x24C78C51, 0xC09401A4, 0xB1398C09, 0xB30D9F88, 0x4F653640, 0x58D65CD,
     0x577A37BE, 0x7291438, 0x4D134DF4, 0x8A96839C, 0x11852709, 0x10B766AD, 0x47A6051F},
    {0x7D78BA61, 0xAF0EA037, 0xE12B55E1, 0x6EE4ED6E, 0x2AC9CA35, 0x2F832236, 0x489B1FAF, 0xFDA15C84, 0xC133CE2F,
     0x1599664A, 0x112CAFC, 0xF052CF02, 0x47C9E8DA, 0x1E707EB, 0x8D9FAB66, 0x2F09C8E0},
    {0x1C8EB282, 0xAAD073D0, 0xD7C7611D, 0xED81FB9F, 0x8F1CDB0E, 0x7E0ACDA6, 0x3606174A, 0xCDD93ADB, 0xBE6E04F,
     0x823962F6, 0x66FF9E77, 0x651CDA63, 0x75E272B, 0x4782F51F, 0x99DF1B02, 0xA5B0C514},
    {0xD2DBA95A, 0xB62F9B9C, 0xD64F0530, 0x82924035, 0xBC1B096C, 0xD44A0383, 0xC311EDE6, 0x8795DD77, 0x84B2D03A,
     0x725881CB, 0x70E01BFD, 0xAA07EA45, 0x51FF004B, 0xD3CFC09B, 0x16045E23, 0xE8F0C218},
    {0xC4081E8A, 0x32BA8AC8, 0xD8286A98, 0xE1F06989, 0x590F5C5E, 0x96579DF6, 0x431A5698, 0xC1BAA861, 0x3E05A66E,
     0x5101D00D, 0x7E4ED88E, 0xA6FE76C7, 0x2B10A722, 0xC457FED1, 0x5619FEEF, 0xF72A1FAD},
    {0x7353995B, 0xB96B9C6C, 0x219F3328, 0x1A8A3412, 0xC1D291B, 0xA481A8DC, 0x83E52454, 0x5884AA3D, 0x903D8EE,
     0xFDB3A11E, 0xCBC2DCBC, 0x754D1478, 0x4A87E72F, 0x8FF1C51E, 0x7E41C37E, 0xB09CAA3B},
    {0xF8C5EFCA, 0x7A9F9DD7, 0x3834BB87, 0x839A7EF2, 0xAFEBF7BB, 0x46AD758F, 0x182E473D, 0x3FE7A96, 0xB1FDA199,
     0xB92ADA79, 0x9D318277, 0xA43A429E, 0xC5362DBF, 0x84D95BF8, 0x1169995D, 0x7035528E},
    {0x7983B9E3, 0xF5B1E154, 0xC42A7ABC, 0xBB86BE0A, 0x7D58C75D, 0x89AA17D3, 0x9D949FCF, 0x5940B48A, 0xAEFBA729,
     0xA26E1293, 0xBDDD1D45, 0x461D65D6, 0x526AD51F, 0xC965BB3B, 0x6FD1A5AC, 0xD8C0FA3D},
    {0x947BD73A, 0xFB9FD7FD, 0x27ADF228, 0xC273A489, 0x4171210E, 0x20981720, 0x369A6075, 0xB1E4E4C, 0xE8953FC8,
     0xFA7279D, 0xB0153FCB, 0xD6CC0025, 0xA009F99F, 0xA6F67CA, 0x3F00E389, 0x3C63DFDF},
    {0x9C0E5439, 0x4D71607E, 0x3833C649, 0xD895EC54, 0xD39E66B5, 0x4D931459, 0x3AB25850, 0xEECCFF7, 0x60885E18,
     0xD5079B70, 0x8CBD3C56, 0x22F804EA, 0xE7E94B03, 0xFB3980F7, 0x780E9223, 0xB7F1FD74},
    {0xD3366008, 0xAECE1649, 0xEE5280AA, 0x5BF77E41, 0x405B0982, 0x43AB0531, 0xC585FDE7, 0x911A7DE0, 0x4BC4E7C4,
     0xD54DCCA3, 0x893CA675, 0x19E642AF, 0xE9907D0B, 0xD0F35E9A, 0xD06E6C78, 0xE72836C1},
    {0xF25F92F4, 0x39FBF544, 0xCF7FD239, 0x4D83B768, 0xA4D8E048, 0xD7BA1F1D, 0xEF124EC8, 0x6D0FEB31, 0x3DA9BC7F,
     0xA2B52732, 0x6165365B, 0x448499C8, 0xED7BA4FA, 0x37BCEFE3, 0x29917D42, 0x1098F492},
    {0xDA87E4F, 0x6CCA2997, 0xFE453D60, 0xAA14C786, 0xA5414743, 0xCAA66770, 0xCFED95EB, 0xFD4CA8A2, 0x13432671,
     0xBAF4E93B, 0x5A253806, 0x7801D02, 0x7B1F00E1, 0xC5EBBF07, 0xD4AEEECD, 0x31FB5B7F},
    {0xE7124729, 0x9F7BBE29, 0x71B60FBE, 0x80400B42, 0xD4000BA2, 0x7B8C1E73, 0x5F7B6FC7, 0x223D8152, 0xECAD7EF1,
     0x2525AB4, 0xA86F27F, 0xF20E0D81, 0xA4161FA7, 0xB096B4A6, 0xCBDA424, 0xC126FD43},
    {0x162A9194, 0x8ACB7348, 0x41819B46, 0x5B1EBABD, 0x3A590E63, 0x83B1C358, 0xC30416BA, 0xF634B00B, 0xDBED0241,
     0x6CE8A4B9, 0x6A797044, 0xFF21FB38, 0x4EC4D4E0, 0x186BA794, 0x86553EE5, 0x8EFDCCE8},
    {0x4BC55BFB, 0xFE21F0D7, 0xD8D3EE8B, 0x7021815A, 0xF359E156, 0x5FF5B14D, 0x2D875A81, 0xDDC31BEB, 0x9581870B,
     0x1C6655F7, 0xE598DBE, 0x771C4B13, 0x27C19714, 0xC1E086CA, 0x7C597E7, 0xF17F70AC},
    {0xB386B348, 0x463C17, 0x11DE817, 0x3E0A6C73, 0x96B8959F, 0xB41FBED9, 0xECFCEF49, 0xFECC83C, 0xD0C17600, 0x869776D6,
     0x446B40A, 0xF6B59089, 0x1B5A3C01, 0x1C31A04C, 0xB8434E5C, 0x281E50A7},
    {0xBB331233, 0xA6130C2C, 0x58990EB9, 0xC8FD1591, 0x7E11714D, 0xD363B804, 0xD18CC4E4, 0x54B05F49, 0x83DCE649,
     0x4353212, 0x8152E8EF, 0xE51337F3, 0x11679A80, 0x46C0F0A4, 0xE8A81B97, 0x5D5AAED8},
    {0x23C9E812, 0x754EE34F, 0x76FDD8AB, 0x426448AE, 0xBAA9C007, 0xBBDC3BD2, 0x3AB73032, 0x55F84954, 0x8E2557FB,
     0x897F01DC, 0xE9F320F3, 0x3E40D38F, 0x16159A43, 0x2F5B6F7E, 0xC10C53ED, 0x76548E24},
    {0x73E49F7E, 0xF26F31DA, 0xF8A1082A, 0x9E6CD684, 0xA47C187B, 0x460444C, 0xF1840E4A, 0xEAC49AAB, 0xFE2219B9,
     0x625FB1E3, 0x8A2255B6, 0x811F3E29, 0xBAA19CCD, 0xAE2DC357, 0x9960B4DA, 0xC2568A15},
    {0x14399004, 0xA075DFDB, 0xD81696CE, 0x6E6FC3E9, 0xD3A05D75, 0x22237D, 0x2475DF18, 0x8430773, 0x250F8565,
     0x6A457F3A, 0x466AEDE7, 0x7753C821, 0x2BAD6CA3, 0x57741F7C, 0x83C9262D, 0xC42B162B},
    {0xE77D72DF, 0xAFBEEACA, 0xFF687CB2, 0xEFE4E78C, 0xEE6B87FA, 0xE4BEE6B, 0x87B59F59, 0x742AB801, 0x908D60DE,
     0x3E141102, 0x54FD954, 0x6BAF62F3, 0xEFDC58BE, 0x5B2AAF78, 0x1FA29381, 0xDB203271},
    {0x34D4260D, 0xA266D122, 0xDF1B7518, 0xBA5A2DE, 0x58470AEE, 0x529FCF03, 0x132601FF, 0x59C0317E, 0x9F9CD81,
     0xFF02ED2D, 0x67BEE7C7, 0x19EFBCD, 0x7888D82D, 0xD3C13B22, 0xE283B247, 0xE78C70BF},
    {0x1B2A8321, 0xDE9ED9B7, 0x53A68A53, 0xFA60DD1D, 0xF0FD28B4, 0xBA2EB0C4, 0xFBC59BDC, 0x6A687099, 0xEED52660,
     0x7CFEC166, 0x5C18B4CE, 0x7B5FB661, 0x5681CA3C, 0xEC434D71, 0x653B8B3A, 0x42ACE657},
    {0x3574FEAD, 0x5FDCB855, 0x38264B78, 0xE63F47D2, 0xD068ADE4, 0x6B99FDA2, 0xF5247FCB, 0xCB8FFAE7, 0x4BC3F79B,
     0x7D8E6B2A, 0x83C03478, 0x72C078BC, 0x145D7415, 0xA7B16EBE, 0xD8F3A7CA, 0x9DE32D9},
    {0xAA5FD330, 0x6B5733EA, 0xD3E708D4, 0x4C291778, 0x2E3C81B8, 0x239C6622, 0x2D3D2D7B, 0x7390A2BC, 0xEF3602C6,
     0x407AC80F, 0x76150E9B, 0xBAA4A8F5, 0xC56EE2B8, 0x8E9CC1A2, 0x28B1BA73, 0x68C98B98},
    {0x6CA8187D, 0xE913E461, 0x19374C29, 0x94A8C90, 0x57DAD5BC, 0xA285883C, 0xA977B44D, 0xEDE36F1B, 0xD4BC0966,
     0xDBF87ED3, 0x687456BC, 0xB0D2E9A7, 0xA1B8D62E, 0xA6AC72F7, 0x9C6404E7, 0x8F8ED476},
    {0xB2B6C61B, 0x3A4C6D80, 0x98507047, 0x3E4798D8, 0xE4EB951F, 0x3C621A20, 0x7E352D0E, 0x28D69C88, 0x27190E72,
     0x4F0F1F78, 0xF485925, 0xF91877B, 0x226E9FCD, 0xA8FD60AB, 0xC2324D43, 0xBF84976},
    {0xA52C14FC, 0xD42D6578, 0xE656A898, 0xBFF7BF4A, 0xC6EFC330, 0x238D6299, 0x7E0EA934, 0xFD8F3291, 0x30DFA52F,
     0x161C9675, 0x78251595, 0x9F7BB20A, 0xF280CE86, 0x7503A20A, 0x72E2914D, 0x50541775},
    {0xADEC4B95, 0x96DD2CF8, 0x9D929FCB, 0x5BD4E95, 0x108BAF63, 0xABA2EDA4, 0x5ED661FA, 0x78BBED7D, 0x87651829,
     0x3A15AE2D, 0x27E270AE, 0xB9616367, 0xFE151117, 0xE6426DAC, 0xFEC29A3A, 0xF93202C6},
    {0x66C0A1F6, 0x5AA3C25C, 0xA03EC55, 0x49872D7E, 0xD0C174FC, 0x44D67A10, 0x8B37551F, 0x6F86D55A, 0x3FA5BF92,
     0x351F7CFF, 0xD4543A7F, 0x712BFA75, 0xB93A3E, 0xB2C1D0BB, 0xF131BB92, 0x6268B4D7},
    {0xD824C277, 0x64766551, 0xFC0DF8B, 0x58B37F9B, 0xFAED8011, 0xB503E8D3, 0xD803DD9F, 0x12ED192E, 0xEE4AD066,
     0x65D65170, 0x8B846D57, 0x693547E6, 0xFC3047C9, 0x6AE228AB, 0xDFC6ECBC, 0x6ECC6F81},
    {0x9B18193, 0xDD6F84E7, 0x4EDD214E, 0xB82A710B, 0x7AD35221, 0xDAEF7230, 0x9583376, 0x9038C1A3, 0x1DE4042,
     0x3BBC01D9, 0xD7E2B344, 0x338CD501, 0x15986C1B, 0x4BC332FE, 0xDFBF785A, 0x20C28F7B},
    {0xFDBA27A9, 0x56BF8462, 0xC83C33E9, 0xCA3EF956, 0x890EEB08, 0xEC0858CD, 0x234D41C, 0x1CE4F6BF, 0x79813D94,
     0x5EB56340, 0x96971950, 0x6F386FD6, 0xE1BCC403, 0x62B173CA, 0x1C9530C6, 0x3552BBB6},
    {0x3C07C648, 0xBEA0971D, 0xC5F4A3D8, 0x7C4D91DD, 0xB602C216, 0x82DAADF3, 0x2614DEC3, 0xC5C5343F, 0x3FD72ABE,
     0x54AE2A89, 0xC76DCED6, 0xBAA3310, 0xBF319235, 0x39F62518, 0x2CAA8100, 0xA1B68A5C},
    {0xEB2D26C3, 0x2E9B4BED, 0xF0303EDC, 0xE6E94EEB, 0x2F1E5F6B, 0x95225EAB, 0xE82B8936, 0xD72183F0, 0xD4B6EAE5,
     0x39381326, 0x3ED8FCB4, 0xC01138C2, 0xE000AB3F, 0x1D194A6A, 0x699A3C90, 0x942A9D07},
    {0xD3E3F625, 0x47BBC560, 0x8F1B54CE, 0x198575C6, 0x6157F1EC, 0x9B9DB953, 0xD4867228, 0x8F72E93A, 0xFC2F0372,
     0x8DE25B2, 0x6B6D89D6, 0xF0BBA450, 0x7ACF2340, 0xC37F7B90, 0xB04DBCC5, 0x8C4E2EC1},
    {0x37F5B563, 0xAE391DBB, 0xD35F5833, 0xAC59687C, 0xB1F601D5, 0xAA119CA, 0x8174DC15, 0x39C338B9, 0x4AD544A2,
     0xC34C831, 0x96C1527, 0x317A6829, 0x34B12ABE, 0x9EF1C981, 0x74F5BECD, 0xC8A4ABED},
    {0x9E57E027, 0x89F6FE75, 0x93ADAC90, 0x1C1F36A1, 0x6E7D3F96, 0xE4F2266D, 0xF7CB3114, 0x97FAB93, 0xBE3726E1,
     0x9092C160, 0x81D7F084, 0x6FCAC2D3, 0xB69FEAA9, 0xCCFADF0, 0x16A668AE, 0x49262A5F},
    {0xCF81CB8A, 0xDFB3BD53, 0x38BDE8DB, 0x14ADCC0F, 0x6F543664, 0xFDFF6037, 0x3516F072, 0x8C6B2553, 0x95F156E2,
     0x40390920, 0x94868DA6, 0x5E89861D, 0x559BF821, 0x2F67B59E, 0x3A4EA791, 0xED10D913},
    {0x1DAA9331, 0xCCFEB636, 0x5E53509D, 0xA11E10BF, 0xF61C02D4, 0xDEB81068, 0xB22A121B, 0x74996FAB, 0x915F50D7,
     0x3ACE737, 0x65782EAD, 0x4CD80B1, 0x9F1EB5D, 0x8ED01B00, 0x56256B51, 0xAC1DEF46},
    {0xDDE1FFC5, 0x7402733A, 0xD8581D74, 0x14150CEE, 0xF7C53851, 0x4EC648C8, 0x25E67E59, 0x2EE6CE9A, 0xFD3DE7DE,
     0xB5D35588, 0x52DA0DE7, 0xACAE465A, 0x584CA469, 0x5A23E5E4, 0x6722EBB8, 0x4E27756F},
    {0x3C8E4AB6, 0x87A2BCC8, 0x442D6944, 0x41CAB8A7, 0xF80D52F2, 0x40A48D1B, 0x4E23B83E, 0x7DC15448, 0xDD3098B5,
     0xE2B82CA3, 0x8EF11C08, 0xCFF5D63C, 0x1E575590, 0x4E22AE9D, 0x82480AFF, 0x6E72FEF7},
    {0x7C8D89E7, 0xDB7033BD, 0x1DA9BA2B, 0x8C2D10E6, 0x46AD9CD1, 0xB4161705, 0x73A52E63, 0x871BB92C, 0x1FCBD6F5,
     0x5FDE2FBA, 0x6B4FA86A, 0x1414273E, 0xBA9BBFB2, 0x3763D2C4, 0x451EDE47, 0xF70768C0},
    {0x1D082AE2, 0x27ED1098, 0x628192F, 0xB04153D1, 0x8E320B96, 0xFA59CA62, 0x5AED4799, 0x76E37E39, 0x7B49E672,
     0xE5537A7D, 0xE33C3EF6, 0x9FC46AE7, 0xA20942D7, 0xF9C47E2B, 0xEA3B9D96, 0xA6E71F99},
    {0x545753EA, 0x989AA79A, 0x6AF79A39, 0xC8D1E05C, 0xE0E51FBF, 0x68EA7448, 0xB694BBFC, 0xA92C2C22, 0x321FEE1E,
     0xDCEEDD0F, 0x1B0FE3F9, 0x757C657D, 0xF7102AAE, 0xE72DE977, 0x9DF7CCAC, 0x93F2C1C9},
    {0xDA7ED45B, 0x7F4BA5B4, 0x31C696A7, 0xC0A413F, 0xD09518EB, 0x5466BB66, 0x62D0F0C8, 0xC6F179F5, 0x9005F751,
     0x8A6F0BA, 0x9411F86, 0xD9055F76, 0x763835C5, 0x74EE8BE6, 0xD8F1B7C7, 0xA5CA4692},
    {0x62A71D62, 0x5C4C837C, 0xD51E977, 0xAEA0634D, 0xE8CD8F3E, 0x838AFA8D, 0xE629FB58, 0x595881DC, 0xE6230030,
     0x483343C4, 0x12BBF203, 0x8ABFE043, 0xE2DBA46C, 0xBE80D89E, 0x43CE062F, 0xA99ABBE},
    {0x324517F7, 0xCC81D9ED, 0x3D0617AD, 0x9B41F2C7, 0x282E74B4, 0xE370CD2F, 0x3648C947, 0x5006812B, 0xD0C61A84,
     0x7CFF981D, 0xCBF18E9E, 0x7A9B7A20, 0xC858A4D8, 0xD315474C, 0x379507EC, 0x2AA860CD},
    {0xFF341262, 0x16412B4B, 0x321B16C5, 0x6E7882D, 0x16D30370, 0x323853B8, 0x86B3CEE4, 0xBA77FC47, 0x334F0171,
     0x54895E45, 0xEC195832, 0xBF329D36, 0x5C4E9A4F, 0x21857AEB, 0xA75753B2, 0x2B4A0FB8},
    {0x57A288BC, 0x43F70957, 0xB8CB3629, 0xDF905C53, 0x322BF597, 0xA32AEC40, 0x57DB0DF5, 0x2C4BB45A, 0x9E8CB9DF,
     0xDC9A39FD, 0x8B39F05E, 0xCFB3C82A, 0x411A716A, 0xA81EAFB6, 0x9498F243, 0x6AC330BB},
    {0x337BDF47, 0x7B09B619, 0x6AB99D06, 0x25C6F739, 0xB6EB4FDD, 0x52337FC2, 0x3174AEEA, 0x4D1045E3, 0xD7979971,
     0x1710188F, 0xC8DC8E09, 0xE2E80217, 0x2D2D2BEB, 0xB464B8FB, 0x91FA5652, 0x5D10F2EF},
    {0x74F8121F, 0xB1062538, 0x1DC89F7C, 0xC7D9FE37, 0x3D29DACE, 0xF904ECD0, 0xB54C8DFB, 0xD083090F, 0xDFA7D9B,
     0xF3825E92, 0x2812A22C, 0x623BDDD1, 0x799A497E, 0xE6F0E95B, 0x6A198B75, 0x35A70C93},
    {0x8EC2F005, 0x6F3E9983, 0x98EC99E1, 0xE79633B3, 0x883AD59D, 0x883A211C, 0x508C3AD, 0x7516A7C0, 0x97CD3CA0,
     0x93DC474B, 0x19D2E2E9, 0x7E97C183, 0x51D44274, 0x7F9D4E42, 0x1ED160FD, 0xD3F02B25},
    {0x584515CA, 0x7101A4E2, 0xC51BA5EA, 0x1ABFB816, 0x87ABCF89, 0xBC4F951, 0x88DA4AE0, 0xC0D442F8, 0xDF796FA3,
     0x7A6DBEDF, 0x9C78A9D7, 0xB0C7E381, 0x6FD50414, 0x3AABC7C2, 0xA5741A2C, 0xD7770439},
    {0xB0354B3B, 0xEB638A8B, 0xE1A53A23, 0xC4472E38, 0x24C7B90C, 0x927FBAEE, 0x3084BB6D, 0x2138E0D4, 0x51591501,
     0xA90DF61F, 0x68C1B18E, 0x7F41D047, 0x335471BA, 0xE5B223C8, 0x5E873733, 0xD2DD9601},
    {0x52E17B6C, 0x177ED00B, 0x1CFFAD88, 0xDB182E52, 0xEE67A772, 0xCE0DAC09, 0x46A82A28, 0x4BD8DDE9, 0xF97896DF,
     0xED5B63A7, 0x801B760A, 0x42B32B20, 0xB1D2B5AC, 0xFDFA627E, 0x5445703, 0x1092E2B0},
    {0x100AF03F, 0xD6E1AA86, 0x7C17E2ED, 0x4F462730, 0x50D6DA64, 0x52C22F14, 0x76BD2870, 0xD14E8679, 0x7B80822F,
     0xEED3E7F0, 0x6C96ED8F, 0xA5E12762, 0x9CBDD7ED, 0x56360B5B, 0x8E8D180, 0x6C0467D6},
    {0x8784C546, 0xE0659BE9, 0x602B3464, 0x357262A2, 0x1B97ADEE, 0x623D2F08, 0xCF2791FF, 0x147F84CA, 0x90098E0F,
     0x92940A8D, 0x86079A21, 0x5FB277B5, 0x64A8E58F, 0x75E01E87, 0x7A2C13CC, 0xEA0E5823},
    {0xB5B76CAB, 0xDFD9757A, 0xF39C23AA, 0x178738B0, 0x4B4BC10C, 0x3F8CDAE4, 0x4026E682, 0x7166EAB, 0x8C675E8C,
     0x5A0AED24, 0x46E3FD9F, 0x23101953, 0x43159E3F, 0x47C1C740, 0xA35A4E4, 0x315A9B52},
    {0x7A6A4C2B, 0xBC31F0F3, 0xF69AA83C, 0x3517DB28, 0xCB80B3B5, 0x568CEFED, 0xDA9014CE, 0x8B8B20DC, 0xF79513F6,
     0x5ADB90D9, 0x882A4B39, 0x9C7B3C46, 0xE5111FB1, 0x5B7EF136, 0x5C44E494, 0x57C23180},
    {0x2BBF7C50, 0x30C10D95, 0xF3CFF8AC, 0x82F3FEE8, 0x9F2218CF, 0x3CED49B0, 0x5FE44286, 0x2960D89E, 0x54D91FC8,
     0xAD2B9AF3, 0x4DD8273B, 0xEB03AD1, 0x5489A0CE, 0x7706C260, 0xAF7593D5, 0x2D970CF6},
    {0xA7DD8F03, 0xA997CC6B, 0xD23314D5, 0xF72C66AB, 0x7CF20DBC, 0x806316FF, 0xD7C7FEE5, 0x28AE757, 0x5D3EDCBE,
     0xCE2F56E4, 0xB7E7C62C, 0xFC055D34, 0x570A47CE, 0x992A7727, 0x5D81CC35, 0xD842E11},
    {0xEE1F4021, 0x8C64B722, 0x10D954FF, 0xFAEA3535, 0x7D3E5F4F, 0x1D6BF032, 0x7D205D8A, 0x115ED23B, 0x5CCDCD28,
     0xEFF7A8F3, 0xB846CC41, 0x6308FD8B, 0x2284F008, 0xB8FF0F25, 0x7214A517, 0x3AD25DA5},
    {0x3F10F8E0, 0xC8AEACD9, 0x9573A95C, 0xBB2685, 0x936A5E13, 0xD5A4F8EC, 0xBB41DCA7, 0x1429006F, 0xA67272DA,
     0x6893BFC1, 0x21864A98, 0xD233E19D, 0x8B7F1045, 0xF2467230, 0x80197DF1, 0xA735D4CE},
    {0x2FEBAF26, 0x4B835FC0, 0xDE50C07, 0x18D43876, 0x6A7F8D83, 0x668C35DD, 0xD9448EF7, 0x1D7C1703, 0x5DA78A0D,
     0xED309CF8, 0x2EE2934A, 0x16D85A1F, 0x70D485DC, 0x64EB6560, 0x3CE84179, 0x462D50ED},
    {0xC7EE2F3B, 0x1B69F0C, 0xC0C9B777, 0x143A1463, 0x11FD63EC, 0x632CE1D1, 0xF0662627, 0x67CD8266, 0x31154B6C,
     0xAB87960E, 0xE14EFA5C, 0xC5FCD168, 0x8463D2AD, 0x3C09A666, 0x72613A41, 0xFAF23515},
    {0x6AFE01B4, 0x82720E5F, 0x1D83B2B3, 0x480B7162, 0xF3E69E80, 0x9EB80090, 0x77E1F35E, 0xA76A8B9F, 0xF92EB9BB,
     0x4C8C0381, 0x26F3F0F2, 0x9C23162C, 0xFCBCF956, 0xEDBA26CA, 0x2497F88A, 0x5CF95641},
    {0x55C6D760, 0x48174068, 0x98E16057, 0xAD3E1774, 0xA795C33B, 0xB49B4A6F, 0xC459C303, 0xF3CD26C6, 0x4B14F03,
     0x48C8DF4B, 0x84BAE57D, 0xF57480C1, 0xFF61DABA, 0x5D00DD1F, 0x79A2992F, 0x1E84CE4D},
    {0xAA3B75D3, 0x437DE17E, 0x2C4E3DCD, 0x947600E7, 0xF024DA3A, 0xB5D926C8, 0x94C4F2B7, 0x51A75107, 0x2D20A146,
     0x2F77A81B, 0xCE44AC82, 0x882230E8, 0xD7D7F6C5, 0x745C5DEE, 0xB3063DAA, 0xE7BACDC9},
    {0x436C163E, 0x905CB53, 0x38953D9, 0xDE07FA8E, 0xAF039586, 0xCFC9ED9C, 0xB87BB602, 0xEB8546A9, 0xD91CE6B,
     0x8199EF90, 0x2FD3BB6A, 0xA4C214BD, 0xCE3C365C, 0x8B88B477, 0x96793BC3, 0x25EED7D2},
    {0xDB714C01, 0xE4D6845B, 0x56CA1DB, 0xDA4B9B37, 0x20979666, 0x5226CC49, 0x2DC2C401, 0xC4C88FB3, 0x3BDF17FE,
     0x7B082618, 0xEFF177D3, 0x7DE170A4, 0x6BD66984, 0x93B5ABF1, 0xBF70F5F3, 0x95A30222},
    {0x316DF2FC, 0x241B3E90, 0x45B3FD7A, 0xC0DCC2B5, 0xB1C457D9, 0x9A7D1241, 0x7F514497, 0x8D94E5E8, 0x854BB503,
     0x3D62EC0B, 0x49C69612, 0x621D0500, 0x3A9026F0, 0x26434421, 0x9523F3D6, 0x2FF59BC9},
    {0x4FA946A1, 0x1AEFEE37, 0x12382FCD, 0x964A42F6, 0x55C43973, 0x3078156, 0xF5D68DBF, 0x9B039883, 0xD332B13F,
     0xAB8C3390, 0xB10FD9F, 0xEFC30366, 0xCA856B4D, 0x753E3C80, 0x5F3A8686, 0x6352CDCA},
    {0xCD63DD9A, 0xCA13A6ED, 0xFB70D408, 0x5A5A8235, 0xD9A495A4, 0x41A1E2A3, 0x638E0499, 0xA048FE55, 0x754A8E0D,
     0x5FCE0153, 0xD8BDF0B, 0xDAE7BDAE, 0x2A0980A2, 0x196A13C1, 0xF43B82FF, 0xFBBC8E25},
    {0xB4DD4DF9, 0x6F9B97F, 0x56885D5C, 0x9AC7384, 0xFAD2315, 0x59A1039B, 0xC9F3B12B, 0x70EFC0BF, 0x7CB35F97,
     0xFCD6F05B, 0x3D2874EF, 0xADDEFF6B, 0xE61F9CB7, 0x96049D58, 0xC36B0D35, 0xC5F406DD},
    {0xBD1CA19B, 0xE66B61D6, 0xE429CFBD, 0xFD340661, 0x56EF8F99, 0x7DD67497, 0x48A6E7DB, 0xDAADF4EE, 0xF1223A39,
     0x35EB60EF, 0x322579E7, 0x9DA7C01F, 0xEA9E2EAC, 0xCA418744, 0x135BF8C9, 0xFCD70481},
    {0x5950F0A, 0xF8BEB1D3, 0x88F48A6B, 0xFC900B76, 0xB685879A, 0x93050B5B, 0x56C92C29, 0x359476F2, 0x4B82DE40,
     0x7F6E1E0A, 0x14C7857F, 0x2352EEA8, 0xF6A91E89, 0x2C4B333D, 0x9DED6192, 0xB329C6F8},
    {0xA6EEBFA7, 0xD5549DFE, 0x42E2F20B, 0xAF140ECE, 0x63895271, 0x5D482530, 0xDFD5FB04, 0x7CB76EE5, 0x2B2E61C0,
     0x27FD8E03, 0x9B9F19FF, 0xFAC12C17, 0xFBCA75, 0xA83D56ED, 0x2E7D8D09, 0x2CE4971C},
    {0xB6DFB33, 0xA3D899E5, 0x11E5B73A, 0xD6A55A50, 0x5944477B, 0xBBF6DA73, 0xF01FBB70, 0x59856417, 0x3F91517,
     0xAE7F8428, 0x9A0F87B9, 0x2F317E92, 0x698414CC, 0xAD4AE279, 0x85FA3B74, 0x6BEC4D7C},
    {0x6777D5FE, 0xDD63173B, 0x74D2DAD3, 0xB78164D4, 0x8D744CC8, 0xDEDF250D, 0x1B0C2427, 0x527F96EB, 0xCF8FE3FB,
     0xBD5BFC46, 0xF0583ED6, 0x71B56199, 0x82183F5A, 0x282CC8F2, 0xDAD84B33, 0x4AC2EECE},
    {0x1A423DAC, 0xF50923F, 0x71CFF6C, 0xA4D235AA, 0x366A0DA4, 0x1D0A9B8B, 0x5EF07167, 0x886A003A, 0x3848A079,
     0x4B03DB6E, 0x2260FDF, 0x39C43977, 0xFB417124, 0x25193DB0, 0xFB0E7844, 0x93FB7443},
    {0xF642ACDE, 0xD7666D47, 0xAFA51EEE, 0xA8DFA969, 0xA62EF339, 0x56E97C91, 0x79C28859, 0x1BA7F10A, 0xA283891E,
     0x1CB42DB4, 0x1D6D0BF6, 0x16CEF922, 0x3529334, 0x6AC0DD92, 0x6E9FC202, 0xEFE28045},
    {0x3E40D033, 0x66D10D87, 0xFC4BBDDF, 0x5E36AFDC, 0x9A2CDCC5, 0x6121058E, 0xF57BAAC8, 0xAC4C363, 0x350B5D66,
     0x9E03D9AC, 0xA421A7D4, 0x16BF1098, 0xA7416040, 0xCF2CE100, 0x16C24C93, 0x803B8832},
    {0xFF3864B6, 0x62A7915E, 0x70FBC179, 0x7DEAE705, 0x6F607599, 0xECB25E63, 0x1A372610, 0x20DFB4A8, 0x1F4B0213,
     0xD6C3C4E5, 0xF82C832, 0x4DB06475, 0x1068F58, 0xC27C9B9F, 0x1A2A90AD, 0x22B54556},
    {0x96A387FE, 0x29FA74AA, 0x1D12999F, 0xE97843F, 0x16ED788, 0x2012ECB8, 0x9CD8E332, 0xFB49F6DF, 0x5527EFCD,
     0xEC117958, 0xEEDC03C5, 0x739EFE55, 0x4E11A566, 0xD99F22FE, 0xDAE4EC31, 0xDF711144},
    {0xD3EC3F22, 0xDD230100, 0x4BD6A8AB, 0xE053984D, 0x628EE6D7, 0x4CAB826D, 0x16C21C6F, 0x9417EC02, 0xC0E2AD6,
     0x981EB251, 0x6BE8FE52, 0x46E2B6BB, 0xBD582166, 0xC2D262DD, 0x5D01D578, 0xB86AFF92},
    {0x3521A4C, 0x20271478, 0x80AB3413, 0x356911A5, 0xB4758006, 0x215E8768, 0xE1B69055, 0xC2957760, 0x42DF2F0A,
     0xB0324BE4, 0x6E90381A, 0xA35B476D, 0x41473303, 0xA8B48592, 0x2B9F5618, 0xC9FF3196},
    {0xCB007B8C, 0x1AC2E592, 0x71349A2A, 0x2AC69BB7, 0x6B233563, 0x46C602D3, 0xB26A29CB, 0x295E2643, 0x9781F436,
     0x691A789, 0x45D19753, 0x72711795, 0x8BADA1D7, 0xF2E98A59, 0xE1346552, 0x113D39CD},
    {0xDBCFEF65, 0xC2B898F9, 0xEEFA63F2, 0x3947002A, 0xF20DB819, 0xD4E6E7C, 0x2CC1865, 0x8467C937, 0xE7060944,
     0x9AF50ED5, 0x79A4B968, 0xF2E4A5A3, 0xDE6557C0, 0x5875E179, 0x7DC0F9AA, 0xD3981A69},
    {0x36107C14, 0x9B0CB8D7, 0x6B2FD679, 0x688BE23D, 0x3CE3E942, 0xAD90AA8E, 0x2D6C29BB, 0x8FFAFA7A, 0x1EF22876,
     0x40BC27CE, 0xAFFC2DB9, 0xC5B578A5, 0x628134C5, 0xFFF3700F, 0x599754DF, 0x6C5AF2AE},
    {0x1FD8D911, 0x98944748, 0x7B850220, 0xD97F04F6, 0x440EAD60, 0x4FCC07CB, 0x9EFF1275, 0x25DD3EC8, 0xF9B83898,
     0xBCD1B10E, 0x6414DB85, 0xEEA44522, 0x71BA0C02, 0x38E4FDF7, 0x24AB18E2, 0x1DC1D567},
    {0x2AAF59E1, 0xFAC2FC9B, 0x270F6F7, 0x56A3D4EC, 0x86FB3ACD, 0x3750E286, 0x853C500F, 0x213E4F8A, 0xA856FC63,
     0xD62D733A, 0x6779D659, 0x2AC6DB97, 0x98BC6DB1, 0xA9223A39, 0x49AC225D, 0x1783A914},
    {0x5E8DE393, 0x6A10489F, 0xAD0C4E36, 0xF13D19DB, 0xBA9712A4, 0x302998F7, 0x3A072B0B, 0x118602E2, 0x9D00EDDA,
     0x8A7C7615, 0x8204E27, 0xC6C1A789, 0xCF511599, 0x67572ADC, 0x1205C635, 0xC2527835},
    {0x1C6DA562, 0xEFA00AF, 0x6ED8FF71, 0x285DE07E, 0xE93A4AC3, 0xBD1C70A3, 0x9459BF10, 0x18C636B5, 0xAC030AA2,
     0xB550B2DF, 0xC95EA669, 0x65EE0A04, 0x7F094728, 0x9179D907, 0x4E5900D8, 0x9411F7E0},
    {0x4E81EE69, 0x6BBC39CB, 0xCE1C4E5A, 0x6C54AB24, 0x3835FEF2, 0x6066B7D6, 0x520929C0, 0x73AC1F28, 0xDDB812C2,
     0x3E2A6D4, 0xECFD9594, 0xC521D858, 0x2DF8EA89, 0xD5A1924A, 0x312AE8A7, 0x5B10105C},
    {0x98C188FA, 0x297C4D19, 0xFF48A951, 0x78DC97FE, 0xF4F041B1, 0x8F778138, 0x3BB6101B, 0xC1E2A2F2, 0x3987B0CC,
     0x6DCE9819, 0x5D49F17, 0x256FA649, 0x6C2AAB5E, 0x13DBD898, 0xD9C929B3, 0x37BA86B1},
    {0x7EA779D0, 0xEFE3C67C, 0x12E5F42E, 0xCD467A33, 0xFE24C8F8, 0x1946513E, 0x6A00BC8C, 0xE52FAB00, 0x461C8A69,
     0xB956498D, 0x570A6586, 0x4403843A, 0xB407A784, 0x18E0DD1B, 0x59DCA960, 0xFC2344D9},
    {0x7E40D255, 0xC158CF89, 0x3606C6A4, 0x1A95BF13, 0x15266699, 0x3E032511, 0xC6FD8302, 0x634FCCA, 0x62FDB782,
     0x1F78B7D, 0x14EB7AD9, 0xF738D0C1, 0x4D19145D, 0xBCCF9E43, 0xF335659F, 0xEA869EFC},
    {0x8CD1A58B, 0x45E8CA2D, 0x7507641D, 0xC8851E02, 0x722F58AB, 0x46A44193, 0xB9A1F876, 0xD1A1A804, 0xCE414C87,
     0x4D458122, 0x835F9386, 0x17A6E85D, 0xF98E71C0, 0xC63846D7, 0x2C8E7B42, 0x205AF73D},
    {0x4D9F779D, 0x9C3D8E1C, 0xB93DF879, 0xBF0AC2D1, 0x671B2298, 0xD8938FCD, 0xF55FD832, 0x1DCF0D67, 0x5D8C7318,
     0x413786D5, 0xB2A5D21, 0x9A43750B, 0x15BD6E98, 0x4A28A871, 0xC4BC1915, 0xC6759DBA}};

#endif /* __TEST_ECMUL_H */
