/*
 * Copyright 2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __TEST_ECDOUBLEMUL_H
#define __TEST_ECDOUBLEMUL_H

#include <stdint.h>

static uint32_t test_ecddoublemul_base[2][2 * 12] = {
    {0x72760AB7, 0x3A545E38, 0xBF55296C, 0x5502F25D, 0x82542A38, 0x59F741E0, 0x8BA79B98, 0x6E1D3B62,
     0xF320AD74, 0x8EB1C71E, 0xBE8B0537, 0xAA87CA22, 0x90EA0E5F, 0x7A431D7C, 0x1D7E819D, 0xA60B1CE,
     0xB5F0B8C0, 0xE9DA3113, 0x289A147C, 0xF8F41DBD, 0x9292DC29, 0x5D9E98BF, 0x96262C6F, 0x3617DE4A},
    {0xDDC8496D, 0x25267C55, 0xABDD40DA, 0xB23F0689, 0x89C61586, 0xD6FFF585, 0x9FD23CA6, 0xEFDEED6C,
     0x5A555DAE, 0xAA35FE2C, 0x3EA2B8AB, 0x90F84D1D, 0x2E9CE4C6, 0xCDCDFC0,  0xA773130D, 0xDDEEEF6B,
     0xD277469D, 0x51A4E87,  0x9CFEA63A, 0x94F86D36, 0x4E8FC352, 0x663C7080, 0x477637D1, 0x5AADA49E}};

static uint32_t test_ecddoublemul_scalars[128][2 * 12] = {
    {0xED612087, 0x6581C62,  0x6C3D7A80, 0x298AEE7D, 0xA69A4F54, 0x8406E08A, 0x2C4C27D4, 0x6DD4EFAC,
     0x3BFF8F75, 0x3D0F4B0B, 0xCAFF3122, 0xC82E261,  0x3A70A955, 0x1F3241DF, 0x27F65DE1, 0xDD119AAE,
     0x88701D34, 0xA10880E5, 0x827B074D, 0xB0C285F,  0xDD7A7C08, 0xD2E23BF7, 0x4CA47EF2, 0x1713C7EF},
    {0x51B52355, 0x5BEEA9C,  0x1CAEF77E, 0xAF09BFE,  0x216436CD, 0xE97BF213, 0x41A4C5F1, 0xC8F9E11E,
     0xC7070D47, 0x751C9E00, 0xAF7DC5E6, 0xBB708B3,  0x14B37F5F, 0x36BC962A, 0x65829DC0, 0x995D6A39,
     0xA5BFF573, 0xA33CF200, 0x13103144, 0x7D4F5BC8, 0xA15355BE, 0x3E1C0DE4, 0x7F400B61, 0x3B010796},
    {0x3D4128CB, 0x892965DC, 0x5D0348A8, 0x31FE5BFE, 0xCEBD2B8F, 0x6812DF9,  0xE9CCA27D, 0xC68D82E5,
     0x7AC0AF7E, 0x18808582, 0xB7F79129, 0xDC52A935, 0xB1DF421F, 0xFBD38368, 0x50DA7DF7, 0x79F28DDD,
     0x2A0D1D70, 0x2C56ADBA, 0x770C25E4, 0x900B1BEE, 0xD7D7BD0D, 0x83DB585E, 0x8AB56963, 0xE64E187A},
    {0xF1DDC710, 0xABBFEF9F, 0x6F064AE8, 0x912F64D,  0xFE646014, 0x4E389408, 0x8D528B13, 0x1253C14B,
     0x9368F7BE, 0x43319BCA, 0x7F08CDB4, 0xBB06DCA8, 0xFD3E5673, 0x1F181865, 0x47EF0F0B, 0x6C377998,
     0xF55FDE7B, 0xA14E9DD5, 0xD5C25C7E, 0xCCF57458, 0x188E62FF, 0x6AA92900, 0x4AE8CB5B, 0x90E64D7D},
    {0x66B532D,  0x37695F74, 0x72840BB4, 0x7D0F9023, 0x1C7274A9, 0x5109585C, 0xD2AA41AA, 0x99F1EAB4,
     0x28950830, 0x9FD202C5, 0xFD3A386B, 0x1B482B46, 0xE2DECA97, 0xEBA8FF9,  0x40DE63B,  0x7E1F7838,
     0xF2D24572, 0xDDD70347, 0x98A94686, 0x66A9042,  0x24C55A1D, 0xFE4B578,  0x7F1A6FDA, 0xD154D9A5},
    {0x11C95E0E, 0x4FA42EA5, 0x6E82D3ED, 0xBD882FD3, 0x71A6463A, 0xFC21F80C, 0x8BB554E8, 0x47419829,
     0x9B789CCA, 0x8A4EC75F, 0xDE0D010A, 0x5B966024, 0x53B945E6, 0x2735D80D, 0x983EF143, 0x2CF2FF8,
     0x8624CD66, 0x83E5172A, 0x603D6909, 0x38C64B91, 0x673C0BEB, 0x6FB8BEE6, 0xAEEC611A, 0x71AF8054},
    {0x1B2585A8, 0xC64252B8, 0x452A27FB, 0xF69EA044, 0xA91452B4, 0xA2D193A9, 0xB5805E8A, 0x157DF2EC,
     0x72778CB7, 0x15D55DB9, 0x387311C6, 0x584955B5, 0xCD3F50A3, 0xF111438F, 0xC8861F86, 0xF1E42EE3,
     0xDBD1FEE5, 0x6138B22,  0xA4310B56, 0x3AE59D83, 0x81F6B51A, 0xC7F4E5F8, 0x5B6DEFD9, 0x806A738},
    {0x173C99D8, 0xACFEFF99, 0x8BFD0E53, 0x2F0FBD2A, 0x85514C92, 0xBF5B5574, 0xB76F58B3, 0xC24605E6,
     0xAA8C1E6,  0xF64FB593, 0x667E470A, 0xECBF445E, 0x6D674B73, 0x464804FC, 0x7802FC5F, 0x1196BA24,
     0xC87D0E49, 0xAAD13241, 0xF981D38A, 0xE59AFA74, 0xC791078F, 0x7808E7CD, 0x54E69E16, 0x2AA3778C},
    {0xD99516C5, 0xE3C87923, 0x9A364564, 0x2DD0BCB5, 0x3DC94346, 0xE35BEB82, 0x6635817A, 0xF6B924DC,
     0x9CDAADE6, 0x16EA7B56, 0xB29C5478, 0x2024AB39, 0x5CDA3921, 0x1B5137D5, 0xC5B491CF, 0xA7692F55,
     0xBFA58835, 0xB6F60A36, 0x9E5470B4, 0x658DE49E, 0x91159A31, 0xCFDA2CC1, 0x551BA096, 0xBAE8F857},
    {0xD2615F71, 0xE82B640B, 0xDD2B34FF, 0xD7431B9,  0x494C275D, 0x20486949, 0xC7AF5197, 0xFAFD95CD,
     0xCDB8AB4A, 0x3A307BC9, 0x446A89F7, 0x361553AD, 0x275D36B1, 0xA5F65519, 0xD0A930B3, 0x22CF422B,
     0xE3EA851C, 0x947E7B52, 0xF371A0F0, 0xDDEB9730, 0xACB4CD72, 0x4D958B6B, 0xDF0F2DBE, 0xF85D2059},
    {0xA534A9C5, 0x7F1C7AC,  0x8916AB76, 0xB0DBB66,  0xDEB0AED9, 0x37C0C81B, 0x7D498A89, 0xD1C4954A,
     0x9E39C2A,  0x89C4975B, 0x2208A2A6, 0x3A2AA28E, 0xFCADC3EE, 0x32CC10E2, 0x61123DA7, 0x66B3919D,
     0xAF6226FB, 0xA45738A,  0xD4C09BE5, 0xAA3341A6, 0x4685510E, 0x8B663346, 0xE7350F31, 0x90A6D66D},
    {0xC087B26E, 0x1EF5C95D, 0x7F212662, 0xD72F70F5, 0x239E4159, 0xC64DD6EE, 0x394B3C5,  0x81283349,
     0xEE17AE1A, 0x8D2509CE, 0xBEA6697,  0x65836A54, 0x1F1B0821, 0x29BB5FC6, 0x7A6FF373, 0x20549AB5,
     0x4F07EAE9, 0x9807F35,  0x64B7B47C, 0xAC0C267D, 0xE8EA383A, 0x9EBD9A27, 0x74EB75A2, 0xF43C4793},
    {0x2C848F76, 0x96E4329E, 0x123CCD3A, 0x349E9C69, 0xE9D27D81, 0x8A103B6E, 0xE06A74DE, 0x2D88843F,
     0x4A5DF09E, 0xFA9AF003, 0x75F91D2B, 0xA05CAEB4, 0x31BFCFE1, 0x333C7561, 0xB3CACE45, 0xDFD43C49,
     0xCA55084,  0x6131BE5B, 0xAD7A0128, 0x83075CF9, 0x35FEBD6F, 0x7D229857, 0xA8235FF2, 0x817CA9C8},
    {0xBC893EF6, 0xAF44718A, 0x15F09FAA, 0x88344EAF, 0xDEB25632, 0x8B040DE2, 0xD376F845, 0x5288B8F6,
     0x9418D5C6, 0xFDAC9802, 0xCAFFBE7F, 0xE67D4D5D, 0x5F832150, 0x7B02D530, 0x7783B317, 0xB7A888BF,
     0x8A021A67, 0x3DC220E4, 0x755DB269, 0x51A4A12B, 0x268F2ED,  0xE47B72AB, 0x6DC82AE1, 0xDD9B8A4F},
    {0x13D2B2B1, 0x4E9507B2, 0x41CBCFB3, 0x5E86A2D,  0xFF380035, 0x2AC0B3ED, 0x8C1E7ED5, 0xC58D135E,
     0xAD756747, 0x207ADDC0, 0x77F5BE43, 0x3CB18C3A, 0x1DDF8840, 0x3E26D027, 0x5384FAEE, 0x7687CD9D,
     0x69267D38, 0x3F7B870C, 0x5D0E1A9D, 0xF6C9A88D, 0x8DF5352F, 0x89EE7067, 0x3F7EE499, 0x36273075},
    {0x111CC1B3, 0x166FF91F, 0x1CDEA6AB, 0x680055D4, 0x5468C4EC, 0x16BBFF17, 0xDDEBEEEB, 0x79144F14,
     0x717959DA, 0x4EF68D42, 0xAF222A7,  0x6C26BDDB, 0x4058C585, 0xBB11FBF6, 0x6AD08426, 0x6F3C43B5,
     0xBF742A93, 0x85482A06, 0x48E4F213, 0x83EF0BE0, 0xC14D58B3, 0xF0D60DB0, 0x902AF989, 0xE75EF265},
    {0x31C4DF77, 0x7D7F71DE, 0x2D8E57C0, 0x7126452,  0xD59E183B, 0xAA8CED8F, 0x65D7FD84, 0x92103093,
     0x5EDC8B2,  0xDCBD3A6D, 0x53FFBAE9, 0x1B63F7CC, 0x172C25A7, 0x8E87D223, 0x648CE37C, 0x7BE1B04C,
     0x43D4DD90, 0x27A7170,  0xF86CB9C3, 0x63FC5087, 0x3E1ECAFC, 0xAD0F64C1, 0x129CFA95, 0xBE884191},
    {0x6A7585BC, 0xF93C5A7E, 0xE31B3144, 0xDC6A325D, 0x4D42528F, 0x61CB0E24, 0x65FF47D9, 0xE499FC26,
     0x2687E408, 0xAEF88E40, 0xC532131B, 0x42913544, 0x615D17DE, 0x2C9D52AD, 0x562891D6, 0xBFE28E7E,
     0x6618E9E3, 0xB5AA457F, 0x1FDAC754, 0x5AF41E10, 0x40BF8C40, 0xFB4F8AF4, 0x12A1F186, 0x7E43833F},
    {0xE108B06D, 0x9D864E28, 0x5431B917, 0xE9AF13A7, 0xEC56BB5E, 0x48972459, 0xD0C74183, 0x146BAB40,
     0x9AE6D1D3, 0x71B85552, 0x170A9B16, 0xFB5930E0, 0xD6206B4C, 0x8C9B078A, 0x84DCF1AB, 0xE4CC787,
     0xB77966BD, 0x3D8C08D,  0xE513B1A4, 0xA5DE072D, 0x18093EF6, 0x9BE54DEC, 0x7EAC14F2, 0x1CB86320},
    {0x89F0C60,  0x5DC89BA2, 0x43CA8CE5, 0x31A1AC5D, 0xF3E25BA,  0x950327AD, 0x9BB2FC0B, 0xF923942E,
     0xA82E464C, 0xECAB4520, 0xFE75431E, 0x463E7DA5, 0x6C7ECDD7, 0xD5471141, 0x7C88080A, 0xEAEF27B9,
     0xAC1BE567, 0xE4C3FD77, 0x8450C35A, 0xED69180E, 0x7558E96B, 0x8A75BCE6, 0xF358485F, 0xA497CAF4},
    {0x87C11CE2, 0xB0943F3B, 0x3F5DEAF1, 0x2CD31627, 0x2C25FC9B, 0x49F7E04E, 0x30501A3A, 0xBCC1E30D,
     0xB32789A0, 0x4DE2B7D8, 0xD46FBE91, 0x32C8CEE7, 0x3D4EF720, 0x5460A76A, 0xB12BB331, 0x88CFFCF4,
     0x93B868A5, 0x23033C22, 0xBF0D582,  0xE4647D2B, 0x65CC758E, 0x25DA0721, 0x39661659, 0xF532BB73},
    {0x4C65C150, 0xDFF6EA76, 0x9A953AE5, 0xCBA9D978, 0xF01E0DF,  0xF46B4E56, 0xAFD1DA71, 0x34580180,
     0xBE77ACED, 0xAACDC20B, 0xCBFE2AF2, 0xF81A0EEF, 0x937EA4AC, 0x936D013A, 0x62BE5A5B, 0xAABFAA98,
     0x3A78D504, 0xB7A67542, 0xC3B05136, 0xACC984A3, 0xB3B9C06,  0xEF5174CA, 0x8DDFDC61, 0xFF82AA33},
    {0x17ECC71E, 0xF3B3ACE7, 0xE4793641, 0xAEE215B0, 0xCBDA08B4, 0xD02C691D, 0xC98AE0F1, 0x7A7698A5,
     0x97ED4628, 0x4C36A82D, 0x8BBCBB90, 0xE219DA7F, 0xC66B72E5, 0xB7FC51F0, 0xE489F3BC, 0xF343952C,
     0x58DEA2ED, 0xE9387C24, 0xA76C0358, 0xB49A0210, 0x30E87008, 0x1CF55FA5, 0xB045FEAF, 0xC262319C},
    {0xF3A4CE94, 0x9D4F2C2E, 0xA0E5586C, 0x4BC7D211, 0x22FE3AC8, 0x208DADB6, 0xB6086033, 0x1133542A,
     0xD10CEE59, 0xB2D65B84, 0x318308FF, 0xE638D07A, 0x6F439685, 0x515EFE1C, 0x56F53FB2, 0x52C49A08,
     0x3B15A9C0, 0x8F8A0F8B, 0xA33C3ED9, 0xE2D7A4BD, 0x8E22FA3C, 0xFBCD6A90, 0x9BE3F92,  0x4B94C36F},
    {0x5486D955, 0x7339A2C2, 0xFC9A4905, 0xA9A4E5F8, 0x9F93DE2,  0x56C0D627, 0x569D00EA, 0xD5A78FE0,
     0x649C6447, 0x33EB62DE, 0x73C78341, 0x8EE671F5, 0xF3C7365B, 0x99D066A,  0x3D8A301A, 0x1EBF7467,
     0xE97C4CB1, 0xF28A52C3, 0x3DB45D85, 0x8BC17CFE, 0x96E023C8, 0x8B9F142A, 0xA97241FF, 0x4542472E},
    {0xCA7B5C5C, 0x2FE97459, 0xDC6BC685, 0xB93D9DB1, 0x16044C4,  0x1E3189E7, 0x5465E150, 0x1718F4CB,
     0xDF7D8D23, 0x664D1C16, 0x8C2131E5, 0x43A5713E, 0xB3819C24, 0x7AFAEDFE, 0xBEF6E05A, 0x5FC631D1,
     0xC9974DF8, 0xD4C90674, 0xF7FCDADE, 0xECA9978A, 0x14DB1A1,  0x23DD9BF4, 0xDA81EC31, 0x842BD067},
    {0x1653E367, 0x3ED2128C, 0xC5BAA531, 0x28B9445A, 0x33B4F8DF, 0xD96D84DB, 0x54E4DC55, 0x28E97A8F,
     0x7C9E7927, 0xA1318704, 0x754CE55,  0xCC55F6CA, 0x5A055C1E, 0xAAD5E4C4, 0x86468460, 0xB19F351E,
     0x89C1BFD8, 0x6ED30A86, 0x76502DC7, 0xCC8E6DA7, 0xD1F895B3, 0x1D087DE3, 0x5B8FBD90, 0x5C5A4779},
    {0x582E6D7F, 0xDC32A042, 0x60BAC3EA, 0x3342AEDB, 0x923D1254, 0xF89C1266, 0x14B8E553, 0x8110E3C,
     0x497F3A1A, 0xD20CCD2F, 0xCC9CB761, 0x7F289696, 0xB9877891, 0xA1B87713, 0x7619FA23, 0xE0A13D19,
     0x9E465D15, 0xACC9E612, 0x7C16E75E, 0xDC1E7881, 0xE167A096, 0xE9D873D6, 0x26818D03, 0x62E71C89},
    {0x14D2DBC9, 0x3448BDDA, 0xC9AF554D, 0xB7F3CA0,  0x265B44C6, 0x38F54162, 0x8A9CD569, 0x14446D69,
     0xC31C32F8, 0x50EB01C3, 0xB1F560BD, 0xA75DD06A, 0xBA533205, 0xEE35F86D, 0x27B4823D, 0x6AAB0374,
     0x714D1EB5, 0xCC2F58DF, 0xD590D764, 0xBAD626B0, 0xB9FDE90B, 0xB11F15DA, 0x483582B6, 0x5AE3FBCA},
    {0x1DD51474, 0x73C1526F, 0x85E738A7, 0xD82C9713, 0xF3962BEC, 0xE9A42488, 0x936E4F48, 0x892FE50,
     0x8DA865,   0x766FC296, 0xC0F7E631, 0xC7B0D151, 0x9A91E478, 0xEAA67C6C, 0x4709CC36, 0x19FB5D49,
     0x3328F18C, 0xA83DDF3A, 0x4E0FDFC6, 0x2DA71F17, 0x6C4AC5F2, 0x63E65AA5, 0xE8874104, 0xF50FF2E7},
    {0x8DE9B24F, 0x8C6DB731, 0x5ACCBD1,  0x56054AB0, 0x9F7A4C4B, 0x4E84DC32, 0xD2C96FEA, 0xF510FFEF,
     0x27C99C2F, 0x5BBEAD32, 0xD75E9795, 0x8FA79AA9, 0xF9A25BC0, 0x63F74581, 0xDFC96F87, 0x5C0A1218,
     0x8ECE9788, 0xC2F5E5B4, 0x10C6E60A, 0xA9599A23, 0x61EA5CD3, 0xB7261200, 0x1F16E8AE, 0x3A99CA1A},
    {0xF758750B, 0xE919E0CE, 0xD5602912, 0x264FFD30, 0x9DEE2819, 0x17B86B4C, 0x4F11B87B, 0x9DA37318,
     0x75D0BC7,  0x2D88FDF3, 0x777A53D2, 0x74CC5107, 0xC57BD9FA, 0x6DE23D35, 0x83A2415B, 0x9C1C5897,
     0x37C791F7, 0x294A7972, 0xC85E0109, 0xAAF60F2,  0x3FE28727, 0xE1A61403, 0x39AAF0E5, 0xA04EF27},
    {0xA43F099C, 0xF96C1B6B, 0x9CB981B7, 0xE139E94C, 0xBE1F5BC8, 0x26258BE3, 0xEAA4DC41, 0xC1260435,
     0x5EA19E15, 0x63205F6,  0x54F9A31,  0x5240064F, 0x4DDA815A, 0x4B65DA79, 0x14FAB681, 0x5360333F,
     0x9CEBE0C2, 0x10F1315E, 0xDFEFDC70, 0x3E783D7D, 0xFDB0FC35, 0x635A03CC, 0x9D0E19C6, 0xBC038BCF},
    {0xB0CFA117, 0xB3FD37C9, 0xE25486D2, 0xC6C0223C, 0xDE0816A5, 0x6ABDD9F1, 0x4ADD9BE4, 0x77DC6308,
     0xF1C1E577, 0xF48DAD44, 0x4586EB54, 0x4AEDE281, 0x908D70C2, 0x7FC49146, 0x186B409A, 0xD06B165F,
     0x52E89F95, 0x3C5EEF86, 0x28BBD8C6, 0x5594F98E, 0xEA4F7156, 0x4E8258B2, 0x70F53875, 0xFF99992A},
    {0x185DE92,  0xDA4128BF, 0x44472FFA, 0x86343445, 0x1CC3F321, 0xE0F2EBF8, 0x2F29B9D0, 0xA866F552,
     0x30AE65E8, 0xD9F47474, 0x6FD8FFA0, 0x60F742DB, 0xC6881B39, 0x62532047, 0xCDDD845A, 0xE5317FA9,
     0x13D80949, 0x4CBE2AB6, 0xD23D5B8,  0x358C38CE, 0xF541E9A0, 0xB3A49CB4, 0x255AED80, 0xF5DA61F3},
    {0x287D5124, 0xE2562F4F, 0x6BE57E58, 0x9E5FAE2B, 0x4ED01244, 0x1D146D5,  0x8B37438D, 0xBE20BD27,
     0xCEC2F12C, 0x59D730A6, 0x90BA4F28, 0xE967E316, 0x86FB8D94, 0x25E4749D, 0xAD7E29F7, 0x20BA403A,
     0x97833D56, 0x672BB424, 0x1AB31152, 0xA7C1284C, 0xC5B3FF9D, 0x58906875, 0x2AFE5AC8, 0xD1815903},
    {0xE9A0E82D, 0x836F77CD, 0xAEFEF360, 0x9CD85A45, 0xAC8F4799, 0x75B76E55, 0xB07E9B1A, 0x7F9EF069,
     0x2B490754, 0x1E80AC46, 0xC4925126, 0x8C989CA8, 0xCD09DBB,  0x829AFF4C, 0x85A8C614, 0x5D9E61BD,
     0xD13FB79F, 0x17FB9092, 0xC219DDF0, 0x962A0DBC, 0xEC71D7B6, 0xBFFC3FA,  0x78E85D7B, 0x6ED63337},
    {0x900754D0, 0xEDF1398A, 0x1D460EE,  0x5FEB9E52, 0xB1DFCD1D, 0xC76029BA, 0x3669573A, 0xEAE59F3,
     0xA34A8E0B, 0x9B52ADE8, 0x73048619, 0x7BB17417, 0x639817AC, 0xBD6B8C3A, 0x2768C427, 0x23410B0D,
     0xC6D8097,  0xA99270D1, 0xAFBA542D, 0x1DA58DCC, 0x67BE4301, 0xFE988ABF, 0xA1ECFBF,  0xD805585D},
    {0x5D5F7005, 0x265C67F5, 0xDD7FBC93, 0x4E453E4C, 0x68CF3B6,  0xD28242A8, 0xF65B94C9, 0x8DC6E661,
     0xDA8CCC97, 0x52F45895, 0xFC8C4AB8, 0xA2C3E95F, 0xCCD6C3D4, 0x42CB305C, 0x17E2E290, 0x9F240D2F,
     0xB87BB87A, 0x914A9928, 0xB2AD9087, 0x4F073EAF, 0x8DC70C4F, 0xACE798FF, 0xE23E182F, 0x4C4FA5},
    {0x2A91EB25, 0x668BB2B3, 0x70039F91, 0xC76EF66A, 0x71FF2D60, 0xA0440E6B, 0x1396339,  0x8BF998F2,
     0xD3177AC9, 0xA5CBB947, 0xD0223F4,  0x667B5CED, 0x396E4372, 0x3E462A9E, 0xE874B3F0, 0x1C78BC72,
     0x55FA4753, 0xFA4B5455, 0x5E3E31FE, 0x8FC98FB2, 0x1CDDA07B, 0xBE12A05B, 0x2D8206EE, 0xDE0CC646},
    {0xF46D02B8, 0x27CDA3EF, 0x24DBB2C1, 0x60FFB29F, 0xC02B6B51, 0x7314E42C, 0x15B3D380, 0x118687ED,
     0x447980E8, 0x4DCDDC00, 0x1B12F81A, 0x41D4E88F, 0xD6199BF9, 0xE37CFAB1, 0xB6F27D26, 0xC9486D63,
     0xBBCF6D62, 0x3D8BE48F, 0xB50ABA4,  0xD5F507D8, 0x3CA7772,  0xD2C90FB9, 0xAC8F9BF,  0xEFA501E5},
    {0xF2AB8149, 0x382CEF98, 0x1215B7A3, 0x877C1944, 0xC1D06E16, 0x37F29164, 0x7108EB59, 0xC4ECA436,
     0xA16712C0, 0x9B4EC4E1, 0x4AD1C88D, 0x58AC46E,  0xC6FF283F, 0x3EDCDCFA, 0x6272E620, 0x33E1A768,
     0x9BE7A01D, 0x1146B092, 0xEBDA876,  0x7AC1B8F4, 0xD36AB27D, 0x6AF7F18A, 0x66E6F9AE, 0xFF2A3B32},
    {0x42202500, 0x50E8FA52, 0x9DA90BD6, 0xD7C78AAD, 0x6E35976,  0x369B9364, 0xD52362C,  0xDDE05CCC,
     0x3368C646, 0xEFD5370F, 0xFA3FCC37, 0xB8F06EB8, 0xBFB7EF06, 0x95AD29B4, 0xDA698056, 0x7DB87B0A,
     0xF49C4BC4, 0x9CB577F4, 0xA95A57A4, 0x57F4213A, 0x16E8A215, 0xA5302F91, 0xE5211106, 0xAD1221AA},
    {0xDAD07B1C, 0xF155F9FB, 0x41EC9B4D, 0x28049E0F, 0xFA474A46, 0x899F9056, 0x9155D8A0, 0x831E5AB7,
     0x125B102A, 0x36BBC9EF, 0xA61BD4E7, 0x14C9F36F, 0x77C33EF0, 0x7B1F9C77, 0x78D86124, 0x2F625C85,
     0xC16B6989, 0xF5BE592B, 0x48E78387, 0x9BF30F34, 0xC560D1CD, 0xF013869D, 0x88ADF8F2, 0x60049301},
    {0xBC44DDB0, 0x1E0CCBA9, 0x9298776B, 0xB30A7BD5, 0xA686A782, 0x3E086016, 0xA2C7A93D, 0x3534B790,
     0x13024AA7, 0x735EA277, 0x907BAAD0, 0xF636133A, 0x93CB652E, 0xD72F228D, 0x6A2362EF, 0xA44E0186,
     0xBC3CE482, 0x5EEA3B9C, 0x8C99313B, 0x6BAE29AD, 0xBE28EC88, 0x8E1798B9, 0x9A41C3FE, 0xD7909928},
    {0xF887D85F, 0x2AB1B74C, 0xA5A0D9C4, 0xC6463262, 0xF959A603, 0x5B8E235A, 0x621F8B71, 0xEB6AA76A,
     0xF522F023, 0x35DBBB36, 0xB38BA,    0x5E5B548E, 0x16CEAC79, 0xD298EDB8, 0xAA54A593, 0x3C28B0E8,
     0xB48F32FA, 0xA3490A61, 0xCFFA008A, 0xEB536BAD, 0xD0376142, 0x15928A95, 0xC9D8AD2A, 0x953C1A37},
    {0x5129613A, 0xB2DC921E, 0x81F5E08F, 0xD6787C5B, 0x77225465, 0xE9367A8B, 0x9ABAA624, 0x3CA14BF9,
     0x24DB701B, 0xA7C7477A, 0x2E4C822A, 0x43A80B4B, 0x93A1EB97, 0x8C3C1B52, 0x4BDFF849, 0xFF3BEC33,
     0x6B3AC769, 0xFA6450EC, 0xE6FBA8D,  0x29C24F42, 0x36F4E775, 0xB641759A, 0x8BBD370C, 0x14A31D5B},
    {0x307432A1, 0xB4C1E39A, 0x26AF6996, 0xE73183B4, 0xAEC7E64E, 0x35FFA0E6, 0x86091FEE, 0x4CE1D48E,
     0x74C6CF3E, 0xA1762EAA, 0x2780664B, 0x22F0D3AF, 0x4FC1358A, 0x209A25F1, 0xA9ED3DCE, 0xA8BABBED,
     0xBA27A4D2, 0xF1F5A36C, 0x135D9464, 0xA9E339E2, 0x217F40EF, 0x9489B89,  0xE700BA29, 0xF1C4889D},
    {0x1B70F239, 0x47EC6A31, 0x6CE5E6,   0x3685E11,  0x4BAA3241, 0x525DE420, 0x61841CC3, 0x838D9A9E,
     0x1F41A7B0, 0xD1841C06, 0x5716D215, 0x20D13E4,  0xF6F282AB, 0x3A915DD7, 0x1D2641F4, 0x5682596C,
     0x1E89B6D2, 0xC4064CFF, 0x645E9390, 0xF364DDEA, 0xECC85861, 0xEB02C540, 0xCDB2830A, 0xBC65EA2E},
    {0xE26BC69A, 0xCC122A95, 0xC19D8034, 0x16F3BE35, 0x574A8A05, 0xA9693D69, 0xA158122F, 0xE836F4A2,
     0xE7F82C08, 0x62EDF35B, 0x60A85E06, 0x14DB9BF7, 0xCC90DDD4, 0x6E1BCB5B, 0x8DCC9185, 0x2D7733B3,
     0xB48DCA98, 0x792E676C, 0x46087E69, 0x10488AE3, 0x35054521, 0x9E12FF21, 0xFE9809DD, 0x236A0233},
    {0xFFF9D6D2, 0x2E467E71, 0xDCFACF24, 0xFC88865A, 0x87614386, 0xF88D6176, 0xD6FED698, 0x7DAACA51,
     0x35C4D7E3, 0xAACF6AA9, 0x2812E6D2, 0xA4C3A4D1, 0x697F3C09, 0x82C99F05, 0xC118AA97, 0xA1AB075,
     0xF213985F, 0xCF34D3F9, 0x22331DF7, 0x69D44DD3, 0x9E6BEF77, 0xFAE890D7, 0x1BBBE897, 0xA1D25EA3},
    {0x287D87D9, 0xFBD166F3, 0xF1B6B068, 0x215390A,  0xC2E8DDD5, 0x5E67896E, 0xCB02DC04, 0xAA530E97,
     0x4B86731C, 0xF66EB88C, 0x644F278B, 0x7E061798, 0x1514BD5B, 0x6BA57B09, 0x1F52F82C, 0x438472F1,
     0x18FE8471, 0xE63EC958, 0xAA443D18, 0x7F8FE967, 0xBA938680, 0x7268B37C, 0x84196813, 0xBE4CEEE3},
    {0xC7ABB808, 0xB710FD24, 0x2760A3DB, 0xB84A4B85, 0x2CC63361, 0xB2D06828, 0xC308300D, 0x165CDF2C,
     0x54F1F781, 0x6CD85227, 0x67903521, 0x6E16B150, 0x1AB38BA7, 0x72153906, 0xDF0BED1F, 0x8BE9AF5B,
     0xF6B784A8, 0xDE3A24C1, 0x21CC5A22, 0x9360F724, 0xA904351A, 0x4E28D8C4, 0xD55ED96B, 0xC509EA65},
    {0x33AB2C08, 0x7A0BB26,  0x7DF074A2, 0xC3B4878B, 0x9F8CD42F, 0x88F9165A, 0xE924ED8B, 0x773C2D3B,
     0xAE065596, 0x5193E534, 0xFB9F2D96, 0x1B077A81, 0x388F66A5, 0x69015031, 0x733CAF16, 0xF04260F2,
     0x49DAF141, 0x28959BD,  0x8F235058, 0x3F3E8359, 0x596DE82,  0xDDFF8CE3, 0xDB13A851, 0xB300235},
    {0x209D8C32, 0x7B87BBB9, 0x642C8889, 0x56362D41, 0x8A89EA3E, 0xBDD5607F, 0x3D48DEF2, 0xF7E4F0A4,
     0x6803B786, 0xB73ED7B7, 0x6B11183E, 0x68B365B1, 0xAB439AB8, 0xCFCAF646, 0x4BFE47F5, 0xBE583ADC,
     0xD3139F91, 0xCFE009DB, 0x2825D28B, 0x6C74CEBE, 0x86E2D5E7, 0x49578748, 0x29D6B8E2, 0x5DDCF917},
    {0x4451D3C4, 0xEBF26A6B, 0xAA6D716,  0x1347475B, 0x39A86F6C, 0x6283AF6B, 0xB45F4875, 0x14FA8A00,
     0xA91F0667, 0x2CC9D971, 0xE98D6E24, 0x9512381E, 0x6F8A9668, 0x7AB953B0, 0xA060977F, 0x182119BE,
     0xD7645C9D, 0xF483199,  0x651A81F3, 0x909037DD, 0xC0490236, 0xB2120E2D, 0x45FD88D3, 0xAA526BB9},
    {0xE9D2BCB2, 0xA79283EE, 0xB238A323, 0x4DEA4AB8, 0xEF6CD3D,  0x54B1EBFD, 0xD09D0A4,  0x5C95B6C,
     0x9F647586, 0xD4F6A3EC, 0xAD8CBBDF, 0x1A36826F, 0x361E71CD, 0x75BF7BCD, 0xDC88F643, 0x3A940E43,
     0xFF7DC396, 0x78E8E32D, 0x700F6698, 0x3666366F, 0x2FD1CF40, 0x57522829, 0x42919964, 0xD4E1417},
    {0x32C4230C, 0x8451B49,  0xA766C5E6, 0xE20E151,  0xE456AAE2, 0xBB65B3C,  0xEEEF4DDC, 0xE62510D0,
     0x502D961C, 0xBBF25E3,  0xA2FE32C5, 0x3B55F5F7, 0x5903E14F, 0x2479F76B, 0xB9A82630, 0xED307F58,
     0xE40775A0, 0xE4D16701, 0x11C2A6DC, 0x952D89F0, 0x820213C2, 0xE010E80F, 0x8BFD63B2, 0xA877DC79},
    {0x3D0CCB7E, 0xF70245D7, 0xF5AC01A8, 0x7F460758, 0x15F6A041, 0x34B234E1, 0x75216D88, 0xF02C29DF,
     0x8FAFAD73, 0x4EFF7EBC, 0xEBCFF890, 0xDF705441, 0x1798F86A, 0x64649FA0, 0xD1C0A432, 0x85B66B5D,
     0x1CEBA965, 0x2DDCA3B9, 0xD45E95A1, 0xD2A1AC84, 0x777C7175, 0x532A8C70, 0xF5FF577E, 0x2561CEF1},
    {0x7F9A48A6, 0x42ED26DE, 0x95457C98, 0x552B60ED, 0xBCACACB4, 0x87AA0AE8, 0x2D18278E, 0x85289A2C,
     0x2CA4DF44, 0xC1E43712, 0xEC82BD53, 0x894B8169, 0x5AC9D98E, 0xF5AF8123, 0x67E80F7,  0x43621970,
     0x2AA57645, 0x2D09EFC5, 0x8B7CC263, 0x6933F0BF, 0x1CD117DE, 0x7A8637FA, 0x1C610433, 0xA014E7B3},
    {0x92ADDE78, 0xF7BBB534, 0xF61ED029, 0xB1A42E52, 0x7FECA376, 0x894C5EE6, 0xCF61EE78, 0x4B37ED19,
     0x425CCB1B, 0xE502CF7B, 0xCCD0122E, 0x1874664,  0xFC9BB4F4, 0xCFDCBEC,  0xEFDC26FB, 0x7DC09E49,
     0x20B669D2, 0x310DC818, 0xA49C467F, 0xAFAD8CE1, 0x670F634,  0xF5B1204A, 0x3C6DE925, 0xC032CC51},
    {0xBB1250A,  0x56F01CDC, 0x6851646A, 0xDBD873C,  0xB1F008F4, 0x99500C3B, 0x390494DD, 0xB1BAC30D,
     0x2C339B61, 0x6FDA0387, 0x71A95DB1, 0x5CF12F5F, 0x8AFEE468, 0xE8629A57, 0xFA8573E2, 0xB2831A7D,
     0x4F1251D3, 0xB480C128, 0xF5E649FB, 0xF64A4DB3, 0xD76369BC, 0x8EAF33C6, 0xFD49B191, 0x1802D3AC},
    {0x7C362A8,  0xA3B83003, 0xF0078BED, 0x57481303, 0x42DE3607, 0x3AD56E13, 0xC85E302E, 0x7C574E15,
     0x403D778A, 0xFFC197CB, 0x5717FD24, 0x53868497, 0x515CE1DE, 0x4B899CA5, 0xF4D46F61, 0xBDC0FFDA,
     0x6A961AA5, 0x658EEAF3, 0x3D39FB3D, 0xAAE6F466, 0x89AE3A4A, 0xC06C93A2, 0xAAE56EA9, 0xC236AD8A},
    {0x2C3E56A3, 0x8AC89234, 0xBC08354,  0xB73B60D0, 0x6989B960, 0x7AE43731, 0x739DD841, 0x5C38E216,
     0x544F1264, 0x34BB2F0E, 0xDC812F99, 0x8B57873B, 0x2D4D540C, 0x35A41511, 0x99A37B16, 0xC3E19BA7,
     0x9ABD0969, 0x364B20FC, 0x1C53DB84, 0x29464C72, 0xCB1D1ECD, 0x874FABA8, 0xFAF4165,  0x792B9A75},
    {0x6AE9FFB9, 0x62A0DC56, 0x4107F25C, 0x33743D17, 0xEC2C1DB9, 0xBF790CC0, 0xAA671FA0, 0x4B64D856,
     0x584CA89E, 0xFD868CCB, 0x6107F630, 0xFA16E989, 0x406796F4, 0x951615AA, 0x6BA8566E, 0x618606F3,
     0x36DA4866, 0xF5DD00F5, 0x2981AF90, 0x2E62A436, 0x44B912B7, 0x452B7F2F, 0x24A7005E, 0x438CEEED},
    {0x83CC187F, 0x9ADB3A9,  0xC3F2D67,  0x9990CFF4, 0x2C92138A, 0xE65F7E24, 0x10E70254, 0xDA59180B,
     0xDDBAA23A, 0x222B8CC9, 0xF916AD40, 0xF1B1DFE,  0xF2A93A62, 0x4CF4F167, 0xF69B756F, 0xB210356F,
     0x3C7D5ECA, 0x1E040B3,  0x4AC9CD5,  0x1A8DF09A, 0x2253841A, 0xEB3E84CE, 0x2FC0751C, 0x91265768},
    {0x6841459A, 0xE0EABB6B, 0x616F6153, 0xA13ABB01, 0xF8AA6ECA, 0xFE1E2A11, 0x7D7A04AC, 0x2F3217A9,
     0x242271A,  0xBA8E917C, 0x2DA5CECC, 0x148C98B7, 0x399AAE67, 0x348716E2, 0x36A04B20, 0xDD4C3FF3,
     0xFBDC32D,  0xC19D7E20, 0x336DB10F, 0xB41A7F10, 0x351450E4, 0x42E9028E, 0x9A45F825, 0x1777A001},
    {0x4B9615E9, 0x9509F39B, 0x55A02A53, 0x6C84603A, 0xBD5AC1A3, 0xF200577C, 0x8B7EAE8F, 0x7DFA5314,
     0x329E8B69, 0x8B066F53, 0xDF066EA2, 0x427616C7, 0x2765E382, 0x897ADF2F, 0x748F400C, 0xD8BF2A9A,
     0x7390FF7,  0xFAB30AA3, 0x8184E811, 0xF9605178, 0xDA04B86B, 0xBEC73865, 0x23FF6347, 0x35723C84},
    {0x9565944F, 0x56C47859, 0x2C2C2A8E, 0x5587DB31, 0x5C1F16C4, 0x33C84D3A, 0x76FC5CA0, 0x1A6605C3,
     0xB5F226C2, 0x3F3125C0, 0x68B5B16,  0xADECC48D, 0x7CD512A,  0xD0530771, 0x955C6AAC, 0x411AC991,
     0x913443EF, 0x11AD28B2, 0x9383B255, 0xD55F826,  0x12E328E1, 0x6B6C4440, 0x6DED2076, 0xBD8D5D7B},
    {0x980D2BE0, 0x7529E277, 0xC54FAC25, 0x8EBC2ED7, 0xD10C4A05, 0x8DB0E6C2, 0x365F8237, 0xCB696C2C,
     0xFD906346, 0x5D0BF5F9, 0xA8EAE789, 0x37BBF71E, 0xE5CC622C, 0x9C55FDD2, 0x9A83D52D, 0x57FEBF36,
     0xA660CEDE, 0xEECADF75, 0xC8143678, 0x4EBD1298, 0x52A25AAD, 0xA4F829FB, 0x1CD715C0, 0x927D5A25},
    {0x6486DAB7, 0x7326067A, 0xE911DE9C, 0xDD3BA50F, 0xAD6FEA58, 0x2B951BD1, 0xE8BBFBB5, 0xDE915FBF,
     0xAA168CDF, 0xD99CEBD4, 0x7D13BF2A, 0x53929744, 0x4BC704E5, 0x66AC58B9, 0x98CA2172, 0xD034623E,
     0x9AB8FAD2, 0x7C767473, 0x93875FCD, 0x8BA585D7, 0x2A810F07, 0x20D42504, 0x5D0AF95F, 0x7F38503F},
    {0xCE962DF8, 0x5B622D3D, 0x9B1A28E5, 0xBA2C4177, 0xB78DCF0,  0x3528B4FC, 0x26802103, 0xFEA9AAEE,
     0xDF386AC8, 0x79B18188, 0x27645D5F, 0xB125491B, 0xD1D20786, 0x341C86C7, 0xE0D9F99,  0x95962A53,
     0x6F921D75, 0x65B63293, 0xF9A0452A, 0x8ECDE675, 0x2B8DF1D7, 0xA3CEDB8C, 0x1BE53DB,  0xBD69F72E},
    {0xFADA2172, 0x346FF030, 0xCBB1174A, 0x241244F3, 0x28233194, 0x3F4D3EC4, 0x26ACF250, 0x23CE4AB1,
     0x43FCD0E8, 0x49414142, 0xBF96B0BF, 0x6745E7F7, 0xB3CD5CC5, 0x2C533499, 0xA35E8A1,  0xFF4410AB,
     0x3DD61AF2, 0x133DF4D5, 0xCDA850,   0x4335A06C, 0x28C72C36, 0x885B5689, 0x1F3D25BA, 0xA69417A9},
    {0x66EEF6D,  0x2B3693E6, 0xCD65569F, 0xE6D5805E, 0xB5E86EDF, 0x33E57FBA, 0x92637C0D, 0x356700FF,
     0x11496581, 0x2957B07F, 0x9CCAFBE5, 0x6F1D638D, 0xE1FE672F, 0x2C7071D9, 0x232FADA9, 0x1137DDE8,
     0x9BE2AD3E, 0x26D488AA, 0xDB421CE2, 0x7E0A1420, 0xEF3C4267, 0x4E472E23, 0xF1E63886, 0xA2E8558C},
    {0x755D6408, 0xDE204B69, 0x3C4E60D,  0xC7DF380,  0x3E29BA54, 0xFA7EF6FF, 0x6B85FD66, 0xA49DC4FE,
     0xD1F032B0, 0x82D3F564, 0xBEDEE958, 0x27048712, 0x45EF3766, 0x6F088D4C, 0x4EBE0A2B, 0xA674DA07,
     0xA4C293E9, 0x7D21E7CD, 0x3C43796E, 0x5924E1D3, 0xED86AA76, 0xC0417A8D, 0xB4BFB1FE, 0xA19CADC2},
    {0x93FBA4ED, 0xE673A19A, 0x6B83E4EB, 0x8506A919, 0x66776747, 0xDC876DCE, 0xBB7867C9, 0x26253463,
     0x99E2F202, 0x8E1E6793, 0x5D6F7E75, 0xDB946053, 0x8F873A71, 0xFBCF24B7, 0x8FDDCE97, 0xE36EFD40,
     0xD79B4AB9, 0xBEE266EB, 0x2EBA62BA, 0xDEC6534C, 0x241543B9, 0xCEAFD942, 0x38C857D2, 0x56DCC50F},
    {0xD563C35B, 0x649161C3, 0xFF40686A, 0x9E936EC6, 0x99A4EA02, 0x6C943484, 0x8E3B58CE, 0x554AB67F,
     0xB73DEC75, 0x403F9680, 0x279918FC, 0x3A2102D7, 0x31ACBA6D, 0xBCF6900E, 0xFCDF4CDB, 0xCC9633E3,
     0x65FA2E96, 0x70A527D3, 0xCC0AB14,  0xC222ED1,  0xF3B3A281, 0x7BF73FD1, 0x99ADA8CE, 0x238F6075},
    {0xAFF696C0, 0xDE213736, 0x32AA37FC, 0xC35EC4E3, 0x8C02BEA6, 0x740DF7E2, 0x4B490C7D, 0xDC80C9F8,
     0x5ED6A515, 0xCEBCBC02, 0xE2FCE7E6, 0xD12E368C, 0xF4A86112, 0x914F28C7, 0x9A2526F9, 0x957FF7CB,
     0x1F0681D3, 0x4CCDBC5C, 0xC6AA3EB0, 0xC41F8CDC, 0x56E9F8D4, 0xFBA1EDE9, 0xEE9895D5, 0x5BE92FA7},
    {0xA3541247, 0x81D41615, 0xE0D59DE4, 0xA93180B8, 0xF3EBF39D, 0x38B4341,  0x8DBBA17D, 0x8A6E705D,
     0xF827D60A, 0x48EC51A5, 0x54A1BFA6, 0xA672ED38, 0x105DB1F7, 0x36638465, 0x525C7617, 0xECC748FE,
     0x2CB4F9E4, 0x6A9805A1, 0xD9751B34, 0x244439A0, 0x567313D1, 0x85FBCF84, 0x172F1CD0, 0xCE29AEC4},
    {0x2854D225, 0x48DDE87F, 0x52839B4,  0xB6B42E7B, 0xD1610089, 0x16B4E484, 0x67070BD6, 0xE3B4EE2B,
     0x95C1CF07, 0xE5D6D25F, 0xB7CBA739, 0x238C3EE3, 0x78FA6DDF, 0xCC095819, 0xC4BF8914, 0x440CF2CE,
     0x795DD485, 0xAC9E204D, 0xD6B30A16, 0x36C36A83, 0x200BDCEC, 0x6B013F02, 0x1593A4FC, 0x7A00BD38},
    {0x223C0727, 0x24C8DD77, 0xC0A12FF7, 0xDD04A474, 0x389D4CE2, 0x140C598C, 0xE5DC87D0, 0x3F7270F4,
     0x8CE69F7B, 0xD647E9B8, 0x6717A5FB, 0x575B4C14, 0xB9A1C434, 0x14661634, 0xCC792159, 0x1CEDC549,
     0x178B3DDA, 0x8BD815FB, 0x64368A1A, 0x8A912985, 0x9ABA71E6, 0xED06F253, 0x24F7A10E, 0xFCEBE23A},
    {0xF4832315, 0xEB91F4B5, 0x6EADE436, 0x69E7C95F, 0xD123D962, 0x67A7EA73, 0x7E4FAFBA, 0x3790B754,
     0xCBC0A47E, 0xA0727A8B, 0xE4A6F054, 0x42F3B7EC, 0xDE711179, 0xAD1C5D17, 0x993E9B15, 0x873F1133,
     0xFF95EA4,  0xE004A826, 0x86C416DF, 0x2C115970, 0xC049193B, 0x5EE0D413, 0xE9511A96, 0xC7575946},
    {0xBDCA8176, 0xE86CB5D,  0x25672B37, 0xF319C4E9, 0x5B002D00, 0xA81A47AC, 0x77E8EC4F, 0xADF36797,
     0x1D868910, 0xEF351112, 0x3BA9F87A, 0x3835A626, 0xA7FBAD25, 0xEF623B5B, 0x8F05E6A5, 0x5AAF4707,
     0xA7555798, 0x119A5C8,  0x4F177703, 0x4B037C89, 0x4D87AB27, 0xF9CF0BE3, 0x6A28F075, 0xE99A8C16},
    {0x61D6CD93, 0x7F2063E0, 0x8E161423, 0xFCE669F2, 0x74FA71AD, 0x82927763, 0x331FFF2B, 0x6541C77,
     0xD73B99DE, 0xE44CF6A9, 0x51CD7716, 0x27C77E07, 0x54143BEE, 0x43D23F8C, 0x7C5D5D86, 0x7A07473F,
     0xFA9D57D8, 0x9B22E713, 0xFB297D59, 0x68855A23, 0xEB8E36,   0x3667058C, 0x3EA7DD51, 0x94095DA9},
    {0x8B9ADFDA, 0xBC339565, 0x4A60D321, 0xD25EB5A1, 0xF268D61E, 0x66E43998, 0x573A7BEF, 0x98B83EBE,
     0x19F8631D, 0x87ABFC88, 0x8F5D6E48, 0xA8FF33B8, 0xB438113B, 0xA9D0B82C, 0x972E5790, 0xBB9461E,
     0x37A8A963, 0x67634597, 0x1D0109F3, 0x70F54ADB, 0x72123683, 0x105F0801, 0xE852F4BF, 0x1BDA1336},
    {0x726B63C6, 0x7AA4B782, 0x70BB80B2, 0xA734A678, 0x87FAC5C4, 0x47944789, 0x4C19DD22, 0x262B7518,
     0x4FEA86A1, 0xDFF39DE9, 0xB3FD0A9A, 0x4F0C0F64, 0x43F18E1A, 0x9C1B72EB, 0x7652CB36, 0xB4F4599B,
     0xBC414121, 0xA5602986, 0xDCA62BD7, 0x2B534DE4, 0x507F7CD0, 0x16854EF6, 0x53B2305A, 0xC6C5A8D9},
    {0x9D9486BB, 0x94A947BA, 0xA8E53612, 0x1C50AF7F, 0xF117F63C, 0xBF8DB57D, 0xF9F7CE31, 0x9DE7C2A0,
     0x764F52FC, 0xAFAC88D9, 0x94E11E4A, 0xAF1A19F1, 0x4AB1728F, 0x74E4AB5D, 0x279A6665, 0x8B3123F8,
     0xAE718B9F, 0x9CBB839D, 0xFC1A3461, 0x845472C3, 0x23B47F4D, 0xBEA6DCC2, 0xE1BFAB5E, 0xD73E8E6},
    {0x7D177A29, 0x5B00A198, 0x85380C0D, 0x26955CEE, 0xBAC52DC,  0xFA07CA63, 0x4854B9FA, 0x838D4481,
     0xE1027241, 0x8A0240E1, 0x42563F8B, 0xE202B970, 0xD2316E27, 0xCE48E14A, 0x54F18393, 0xA627AF65,
     0xCC5FC55,  0xE07CCFA3, 0x96053F9,  0x9A17ECCA, 0x3719D4A9, 0x92DAF88,  0x91D1DA04, 0x7F5D0C15},
    {0x399FAB16, 0xF4B94E04, 0xDD17ECF8, 0xE0BEED02, 0xD26C2124, 0xC8ED8D14, 0x9A810B1A, 0xE1141E5,
     0x5C1379EE, 0x4923B063, 0x61C6C0D5, 0xED3DE342, 0x75E71A4F, 0x8C089F75, 0x538D3EBC, 0x41127EB4,
     0x23B427F6, 0x2F24D0F4, 0x7EAFEA1A, 0x613A740,  0xA7E8D37D, 0x197376E9, 0x7F504C05, 0x6BCE6488},
    {0x84A1758,  0x53DA165C, 0x72294D8C, 0x339F3412, 0x9947E0C4, 0x6EF338A4, 0x742015EF, 0xD140EDE8,
     0x452AD825, 0x9131A818, 0xC8215957, 0x3F9985B,  0x5F3142A9, 0xD8FC85C7, 0x5F1E507C, 0x5E9C354F,
     0x6F929E6B, 0x5EF0EC02, 0xF843D6AA, 0x4BC64DAC, 0x4D5E8314, 0x57E95B1,  0x1ADA7347, 0xBD328F9B},
    {0xAB93F4CC, 0x13F2C305, 0x58578218, 0x5A03F282, 0x9F3194ED, 0xF2F7B65,  0x6D4913FE, 0xF2C9D1E8,
     0xC76D0800, 0x7FFE1DA1, 0xE9857B3C, 0x1DF5AE3B, 0x11B899C7, 0x9B3E3B5B, 0x72E32EB5, 0xCCE7C58F,
     0x6F807726, 0xB7A7DA84, 0x202B8F4B, 0x82F1ECBF, 0x67790682, 0xCAC852B5, 0xEE3CE112, 0x481E64A6},
    {0xE0B5D207, 0x9633BCCA, 0xE0A2C6BB, 0x6F441483, 0x7E747AEF, 0xFA52C679, 0x5A767E9A, 0x6C6701BC,
     0x28ECBB38, 0x549ABDF0, 0xAEA94EAC, 0xD7D2FAB2, 0x3BBDAD86, 0xE518B1F7, 0x9F777FCA, 0xD5A2847A,
     0xB5C7F1E7, 0xFEDE8B62, 0xD235E18D, 0xFB58F1BC, 0x8DE888C0, 0xF3086F8B, 0x5003F064, 0x3DEA7EBD},
    {0xAFE21139, 0x3D4C688E, 0xE42D4232, 0xC85EB95F, 0x6EB23CC3, 0xE41BA5CC, 0x52811445, 0xA77F4CF4,
     0x26CFD37D, 0x3A8AC8F1, 0x5BFB8E77, 0x7D49199C, 0x8168E811, 0x59C41D59, 0x36F5D643, 0xEB57C236,
     0x7206114E, 0x6F942554, 0xCA3A48A5, 0x95EA50EE, 0x2270E409, 0xEB748E75, 0xECE7C613, 0x863BEDE3},
    {0x54540C17, 0xBEBB4E22, 0x3E035C38, 0xB2B1442A, 0x58DF34F4, 0xB18C0E8,  0x649515A9, 0xA557C1E4,
     0x676FA0AC, 0x56722BDE, 0x3214F64B, 0x1FA28F17, 0xC4EADD61, 0x90A2F950, 0xC2F6BCE4, 0x1371FB64,
     0xE13A8624, 0x1D5E1F0C, 0xE6961B1D, 0x50D90886, 0x98AF2D34, 0xA006758F, 0x1E0563E5, 0x2FC4D020},
    {0xF1D79B15, 0xFF85D528, 0x7B015FA6, 0xFE2FC47D, 0xCE2F1584, 0x3730EF96, 0x6D084D90, 0x2BA8EBA7,
     0x5A15DEE,  0xEE238047, 0x24CFB5A,  0xBD083695, 0xA3E26B2E, 0x1943E9,   0xA8254700, 0xA0BCB8F4,
     0xE73F0A7,  0xBB1EDECB, 0xD24F60E6, 0x26F5E7C4, 0x96D04EDC, 0x872C4785, 0xC494C604, 0xBF874D1A},
    {0xC1A427A7, 0x4DBA8F84, 0x942DA2F7, 0x2B9A7C9D, 0xF02AD281, 0x2E27766B, 0x2C440F25, 0xD517DD5,
     0x26015091, 0x369CDC8A, 0xAF9B6299, 0x610BFC04, 0xBE002E22, 0xDD079506, 0x7DBC66A6, 0xE320EA4E,
     0x13BB0A59, 0x678E1A07, 0x98199C7C, 0xD563FAF6, 0x6E1B6DEA, 0xB53F8D60, 0xE49A8C41, 0xD5270857},
    {0x7B94D8EE, 0x7C9C6361, 0x8DFE512E, 0xA85FABE2, 0x19D2F462, 0x48FC0E35, 0xE4B323E0, 0x181051E,
     0x25B8C5AB, 0x13B4B0E,  0x5FE13C06, 0x573A5119, 0x1FEC28A6, 0xE7148183, 0x14D48BDE, 0x8DBFCB7B,
     0x27AE0569, 0x5CB68319, 0x7572544F, 0x8A97BCA2, 0x9B550652, 0xA2ABEF0A, 0x1E72A495, 0x269583C6},
    {0xC329A6E6, 0x3D2EF0C9, 0xF0E34AF5, 0x2BD5595,  0x473C24DB, 0x606C0150, 0xE477FAF5, 0x46460FBE,
     0x47EF2934, 0x66074D79, 0xB61F5078, 0xF119C457, 0xC96E1476, 0xF465920,  0x39DB7890, 0x6ABD8B1F,
     0x956BE9B1, 0x419FDC97, 0x6A7E95FC, 0x85ED4A63, 0x42DDE41E, 0xF2C4AD86, 0xDEED9C8D, 0x2F2CC0F},
    {0x8A221BAE, 0x97DCC5FC, 0xC6160A35, 0xB088B287, 0xC516D5C1, 0xFB707FFC, 0x617FFD74, 0x27F5D074,
     0x4CCE49F5, 0xD9D90719, 0x8655E60C, 0x72ACCFB5, 0x95FB5A56, 0xFC1B0CE5, 0xEE915D28, 0xA335847B,
     0x776B2EF6, 0xE0F5AB3F, 0xBBFA8499, 0xD9AE2728, 0xE6CB9BAA, 0x6715519B, 0x49D0F88B, 0x570A7D31},
    {0x52047456, 0xC4AB50F9, 0xE31D4DB4, 0x36C0A57A, 0xDC4FF542, 0x59B341CC, 0xE1F146D5, 0x6070F1A7,
     0x5A1E1955, 0x718A8C4F, 0x6FC491,   0xA3CB615C, 0x556C9EDF, 0xB5AF1662, 0xBB3BD564, 0xF5AD39C8,
     0xED45B05A, 0x51BD705A, 0xE8404314, 0x7FD5F9BD, 0x99209B2A, 0x2B0F708A, 0x943B4281, 0x65177A19},
    {0x41C02ECC, 0x1D96FACE, 0xA0B9A8CE, 0xF18ECCD8, 0xB566C6CD, 0x6D420416, 0x2AA81931, 0x1C9C4C89,
     0xB9367AE2, 0x97674682, 0x2F6AD30C, 0x5DDDBB3B, 0x8165D691, 0xE77BBDC6, 0x8A79D769, 0x8F2EBE01,
     0xA619A165, 0xD0CD6EAF, 0x305B3404, 0x1D51A96D, 0xAEFCAE5F, 0xA4691162, 0x88627C18, 0xC10112AC},
    {0x61AFD94E, 0xC7192241, 0xC2C4B960, 0x4AD94DAD, 0x5B2FCBB2, 0xAC78B7DD, 0x45285A27, 0x426BEAD1,
     0x241C564D, 0x8347FF80, 0xD9A1F49A, 0x56094684, 0x1AD13E8A, 0xC49A0294, 0x8AB1AE04, 0x8AD716C4,
     0x20A906E0, 0xEAD1C052, 0x1C286D1,  0x9F2F0A8D, 0xB56AC1FD, 0xD16F46CC, 0x2C8C7B24, 0x38AF73A7},
    {0x928B6AF6, 0xCA0C8A2D, 0x1FA864D5, 0x64A28009, 0x27748BB,  0x173A3628, 0x38FC463F, 0xF6B472CD,
     0x4202165F, 0xDA3E32D8, 0x3DDDEAEF, 0x280BE268, 0xD4D00257, 0x4494DF68, 0xAEC5A444, 0x2C2EF8E4,
     0x85A93239, 0x396C2B3C, 0xC2EA3181, 0x574A196F, 0x7C156601, 0x3E9AF4A,  0x45F50265, 0xB54863B6},
    {0x4865D278, 0x5753F305, 0x427DD4C1, 0x21CEFFBA, 0x15A14C03, 0x106BBFFD, 0x65DD1316, 0x4810ABB9,
     0x8BAFA550, 0x68CF4B8D, 0x5DD2C4E4, 0x36BC474B, 0x53CD552C, 0x42ADDB01, 0xEABA5AD0, 0xD80BB63E,
     0xF5D16C7C, 0x9A2E6B14, 0x487E3BB7, 0x717FEF7B, 0xA69E13EB, 0xC5FD357B, 0x17DC0BDF, 0x7587E5FB},
    {0x9EE9DBA5, 0xCA77103E, 0xEB125B5D, 0x274E0129, 0x6FF6715B, 0x7FA427DD, 0xBB4503E2, 0xD42D120E,
     0x8F94B2C6, 0x3F18423A, 0xDAD9EE32, 0xA70D9680, 0x44068DA0, 0x4DA6A4AC, 0xD828D0A6, 0x861CA0CE,
     0xC50B66C3, 0x4693481A, 0x4FDD5783, 0x429550F6, 0x58915C23, 0x17BB7819, 0x1F388139, 0xF9E824C0},
    {0xCCC5EA24, 0xB3B8D897, 0x12E6A71F, 0x3BFD7DB4, 0x76600BFB, 0xA0C2AF00, 0x9ED83CC5, 0xF32A26E3,
     0xB9F2250D, 0x23AE9BF4, 0x6AF27522, 0x9D8AD044, 0x598BA1BE, 0xBABE34D3, 0xA63E126F, 0x27D64969,
     0x817AB509, 0x2A8A1E2D, 0x74B9D8E9, 0x3F71FDA8, 0xF30F093F, 0xB6A0A2DD, 0xBCDE5FEC, 0x3644A296},
    {0x15344456, 0x31875702, 0xEDC54AB6, 0x49A3D74A, 0x42A87EB1, 0x409BC46C, 0x491C5D6B, 0xE91AE9BB,
     0x7951DDBB, 0x16C49AF2, 0x8F5D14B5, 0x78D69243, 0xDB682BF2, 0xF2B32938, 0x4AB7E041, 0xFFD5287C,
     0xF4432531, 0x3DD93905, 0x4AE18840, 0x8FB71480, 0x64E52368, 0x949E91A2, 0x1903C204, 0xEC196111},
    {0xDB836321, 0xE907B2E0, 0x7650D18C, 0x482BD16D, 0xC78F4FCB, 0xE79A2A64, 0x751A7DEF, 0x52B3EF9C,
     0xF503D128, 0x195E08D1, 0x373A42E5, 0x90914591, 0x81D9DAF6, 0x9E3C8989, 0xFADA40D0, 0xAE2A1A12,
     0x634DBF2C, 0x43D12DB2, 0x3520178E, 0x22396112, 0x46435D70, 0xF2284A8C, 0x881A7D48, 0xF7F11165},
    {0x4AE4BB15, 0xC0A7B51D, 0xE76953D0, 0xA6F94444, 0x18741C23, 0x9578DBC6, 0xB36C0FFA, 0x69279A81,
     0xEE8A7AD2, 0x92561159, 0x48964F28, 0xD030852C, 0x3A550F70, 0x46E3D8C7, 0x7F5A7F40, 0x90C522DD,
     0xBA21C3C1, 0xB9C28561, 0x6FFE5A25, 0x96D89453, 0x7E4BAF27, 0x33D235DF, 0xDBA81C7C, 0x6757E9AB},
    {0x3A2C9106, 0x4848C558, 0x68A088C0, 0x40BE789C, 0x8E3281F2, 0x54C6DCC8, 0x9C07ADAA, 0x9DC5A281,
     0x38B0029B, 0xE9A14E08, 0xBA75D839, 0x33DF6917, 0x22AA4311, 0x6BE20ACE, 0xAF98DB51, 0x8B11B651,
     0x82A47471, 0x6AFE5C53, 0x309D7FAA, 0x2CE84323, 0xD966101C, 0x1DC6CD45, 0xC534EA1B, 0x65C4D437},
    {0x7FC7C4EA, 0xB904623F, 0xEE6B535E, 0x54517F55, 0x6007B36F, 0x797F982D, 0x621B0271, 0x6AE80083,
     0x347C5219, 0xD7611DFB, 0x179E6D40, 0x4BE49CDD, 0x46FDA0A8, 0x821D82CD, 0xB580AE8B, 0x6D2852A0,
     0x727E5159, 0xEA1B07B3, 0xE311DD08, 0xA443F5B7, 0xE32296B5, 0x4F1A6219, 0x5D884DE8, 0x5B5B2C16},
    {0xE1FE3E8C, 0xC65448A8, 0xB6E8A9AD, 0xCA750DBA, 0x1DDD2CD1, 0xA36485CA, 0xCA69E462, 0xA47AC1DF,
     0xA47CC15,  0x5E0FBA60, 0x9748FD30, 0xAA74DC34, 0x2D71CC97, 0x4C2FF869, 0x5914815D, 0xBD2D0CF6,
     0xB6C27A69, 0x6B3CAE0F, 0x77B4D94F, 0x6D2127C,  0x55456374, 0xA8D2AD65, 0xD3224691, 0x621A38D9},
    {0x28D3C772, 0x635E252F, 0x38D7541E, 0x2D7E6414, 0x9AEE6F89, 0x2DE5E8BF, 0xA7C1C75B, 0x3A58C6BB,
     0x79100408, 0x7A3D4EB,  0x9F2862ED, 0xA27AFAA2, 0xA0D1A2BB, 0x5F3EF5FC, 0x9324199C, 0xE31C578A,
     0xC99CA848, 0x64887336, 0xC8D2D355, 0xD8396B5C, 0xD5A8D82F, 0x76BF308D, 0xA5B5FE9F, 0x3055D494},
    {0xC3EB3164, 0x10F9B971, 0x62D5AEB8, 0xAB618E81, 0x9FEA62B6, 0x19E27597, 0xE51D2011, 0x532877D9,
     0x28C82405, 0x4ACE1CEF, 0xE57C3C15, 0x73B3B699, 0xBD49EAB,  0xA17F42D6, 0x8A4ACA6B, 0x7E954FF3,
     0xEDD293CD, 0x3FEDE601, 0xA8182AF7, 0x36D5355C, 0x550D1DCB, 0xDDF681A1, 0x40C36B18, 0x747FAA40},
    {0xF9EB1B9B, 0x2FF2E91F, 0x3F5EDDCF, 0x345B4C57, 0xAD6B5F00, 0xD7ADC763, 0xF1616588, 0xA8844584,
     0x224591E4, 0xFE8167BF, 0x375886C8, 0x6D68E256, 0x52BD2962, 0x1360AB8B, 0xCA25DC6D, 0x42DC6672,
     0x623F60F3, 0x1E1C3AE8, 0x841850E7, 0x87E87B2B, 0x7436976B, 0xF6BBC123, 0x5E6F8509, 0xAC762B8B},
    {0x4024EA9A, 0x95839472, 0x13C9BC7B, 0xD9FEE040, 0xB5778D60, 0xB40132AE, 0x3568012C, 0x768AA1DD,
     0x51EF404B, 0x48D2BF4D, 0xE7F09B48, 0x85F2813F, 0xA3DC329D, 0x3FF2E8C2, 0x85BCD865, 0x6DABB11A,
     0x6EB84250, 0x7915FEE3, 0x626D6D54, 0x310E2114, 0xB5026BF4, 0xB34568F3, 0x210B59F6, 0x71827121},
    {0xE0122A18, 0xFCF7CBC6, 0x441FB384, 0x55EA2A50, 0x2D418BA0, 0x745F09FC, 0x82AAB3F7, 0xA9BCA14C,
     0x4A2E76FF, 0x33C277E8, 0x8AFEB95F, 0xFAEFD3C6, 0x7C2A704E, 0xA3D3F6C6, 0x83E94409, 0xAC64A865,
     0x7FE20A5E, 0xEB64E272, 0xF737CE9F, 0x45455F36, 0x7D3BEA03, 0xC3A52E37, 0x1CCAFC9B, 0x3CA53B8A},
    {0xB3A3EC4B, 0xD2ED919A, 0x8557ED11, 0x2FD94C32, 0xD2C65DF1, 0xA8648D57, 0x1FCCFB41, 0xD08939C3,
     0x6CEFD88E, 0x1801644D, 0x8A0613E8, 0x7D9059A2, 0xBD38BA51, 0xFBEBF901, 0x72574D11, 0x6D2CC3AA,
     0x30F32232, 0x4FAA597E, 0xADC4B397, 0x22D47C01, 0xE7A787DB, 0x9967012E, 0x4C493F84, 0xAF54EF8D},
    {0x72A23F7D, 0x7541A31F, 0xAAE38CA4, 0x1CCE8D67, 0xC1FFFF4F, 0xECB8432D, 0xFCEC1BF6, 0x4F01023E,
     0x2F6044D3, 0x5E6834C5, 0x6FD66CAA, 0x2138C10C, 0x796FB840, 0x965499E,  0x8B8029F2, 0x1B3C3CEE,
     0x7717BC37, 0x1123CFBE, 0xE91772A5, 0x5203881F, 0x2AB81886, 0x1613C860, 0xCD0FA169, 0x5AE6FE9},
    {0x96DCC830, 0x6E012F62, 0x8BDF3E3A, 0x39D96693, 0x49CA5F88, 0x9EED72D8, 0xA0F33962, 0x56949A38,
     0xF4D10504, 0xFE2268B1, 0xDE72C98,  0x97F7359D, 0xDE62BDB4, 0x5D7CEF95, 0x98C8CA59, 0x5052EF62,
     0xD4AE0924, 0x3DDC5334, 0x1B1EDC0F, 0xAC071A41, 0xD445DCB9, 0xEA3D8859, 0xC0910CA9, 0xA5901A34},
    {0xB44BD21B, 0x71610378, 0xCBDD4181, 0xC6A91F8B, 0xBCF4EC8F, 0x6868C891, 0x22925AD5, 0x77003804,
     0x85F543F7, 0x229FDA5C, 0x84C6CED1, 0x805540FE, 0xD5F27B45, 0x91510551, 0xA4D42279, 0xB4A480E2,
     0xCF65D063, 0x7E0EA3E0, 0xD80D84B6, 0xC26E53D,  0x99AC0D96, 0x48DAE5F4, 0x75583B8A, 0xDE38784A},
    {0x6696D10F, 0x10004204, 0x84262978, 0xF750B6B2, 0xDA0A91E2, 0x8FB8C5CA, 0xEB4196C5, 0x6D18C604,
     0x16FA7A04, 0xE207166F, 0xB5EEC85,  0xFEDD758,  0xF61495DB, 0x985CE909, 0xBC392CFF, 0xA33ECC65,
     0x8C97D225, 0x90B7A244, 0xBF13E0C9, 0xDA990E16, 0xC4235E8A, 0x68DF0EE,  0x688CFBCF, 0x174A8FD2},
    {0x44EC61C,  0x86ACC85C, 0x62B5BE85, 0xD9E097D3, 0xE8963001, 0xF9A1F0A5, 0x390269F9, 0xC684F26D,
     0xA259C965, 0xC001B842, 0x62A7C8BC, 0x445603D9, 0xB7FD882F, 0x711357B5, 0x5DB2CD3F, 0x734283CA,
     0xD4F4D18C, 0x6576C547, 0xFF913059, 0x69BCB575, 0x63ED7949, 0xD46BD2A6, 0x1C0DE4AB, 0x92EED625},
    {0x83A6804,  0x7A6019D,  0x367495C0, 0xC571BD38, 0x4219AFCC, 0x8285CD50, 0x6C89DD02, 0xFB0EA819,
     0x2845998,  0xAE42E878, 0xE93ADC37, 0x8C93C4D7, 0x22DCC0CD, 0x3D218E3D, 0x59789337, 0xBCD229FC,
     0x390A9073, 0xE8C4B2C8, 0xAE74323A, 0x4FEAECCD, 0x5AAC0BFC, 0xF57333FA, 0x9DB765B5, 0x251C938C},
    {0x6B806194, 0x890C4128, 0x832CDAC6, 0x20307E1,  0xB6B5D4A5, 0x7ED3BB81, 0x64EEAE1D, 0xF65A39B2,
     0xF54C9F41, 0xDFAA350E, 0xA935CABC, 0x27B40C78, 0xDFD1A0D,  0x85B0A577, 0x2BBFF755, 0x5B982410,
     0x9B9CA213, 0xE9E443CA, 0x985F6215, 0x94EECA78, 0xC25AD32F, 0xD59C6D25, 0x863A5C52, 0xC96BD442},
    {0xE45DE1B1, 0x177B3994, 0xA9F83B2C, 0xC033055,  0x41F68A30, 0x7CF17898, 0x2ECAC0B,  0xCA9CB41D,
     0xCFF36464, 0x9DF0D9E3, 0x6466086,  0xEC906898, 0xE08C3707, 0x964D3EAA, 0xC767E8F6, 0x39318C0E,
     0x39CE92CC, 0x60121288, 0xAE5B616C, 0xDA1787DE, 0xA1CA9E37, 0x4EABD2B6, 0xB160A83C, 0xDC954F8F},
    {0x1B6BB2AF, 0xAE155550, 0x49D63705, 0xC23B6FAF, 0x2460C9A5, 0xD1A8FD1A, 0xD127465F, 0x1475DEF4,
     0x2FB84328, 0x5713456E, 0x7C18BECE, 0xCF71ABA0, 0x5C12D87,  0x906F5240, 0x31AD625D, 0xB2D6FD27,
     0xA1FDCC88, 0x5FF590,   0x3303D3F4, 0x8B8281E7, 0x4ED04593, 0x23092474, 0x16F4B975, 0xD9E0F4AD},
    {0xBFBB1F85, 0xCD9C5659, 0x4A356AAF, 0x90DC85DC, 0xC629659A, 0xD75F4818, 0xB5209FC3, 0x6550D19C,
     0x2955E758, 0x6C7C7EDF, 0x8BA98F4B, 0x4D358AD,  0xF848AD36, 0xFA30E8FF, 0xC0A87837, 0x3298CF10,
     0x2C4D6C77, 0xF6A683BF, 0xC0528343, 0x10480BF,  0x587980A6, 0x46D8BEEA, 0xAED215CA, 0x54D6E611}};

static uint32_t test_ecddoublemul_result[128][2 * 12] = {
    {0xFE774771, 0x9C4A5428, 0xF4090893, 0x88786CCF, 0xCB223F9B, 0xF7D1B7FC, 0x7FAAD874, 0x5FD64EB0,
     0x21FB56A0, 0x63656FFB, 0x77F6D8F4, 0x6D777251, 0xD2E771F3, 0x888182F0, 0x343EF8C3, 0x31287D35,
     0x4895DB09, 0x92EA79FE, 0x9DB6389D, 0xBC114C5C, 0x1448F760, 0x8D64071D, 0x40BC588B, 0xFC2D1576},
    {0x7C4A3D4C, 0xDD2F45B9, 0xE8BCED13, 0x440274AD, 0x1E2C94BF, 0xB3EE5867, 0xAE58A561, 0x3CBB9F3F,
     0x6E937B68, 0xDFDECAF9, 0x2A3D94EB, 0xD3947E97, 0x8A8C733C, 0x8238E19D, 0xBB82EBFC, 0xAD495E2C,
     0x475BF11E, 0x2EEA85AC, 0x74E3DBF0, 0xEDFD39EE, 0xF6FCB607, 0xE93CEE35, 0x3589BD14, 0xACA657C1},
    {0xE0FF0333, 0xA73933EF, 0xF9F3DDA6, 0x6969F5DC, 0x93DE37B7, 0xAB512D5A, 0x503C9EEC, 0xDD8D8F24,
     0x3D5EE9E3, 0x614EEB34, 0x5C8AAF9D, 0xA18B8E03, 0x14DA2F94, 0x4FE9F8FA, 0x80D820BD, 0x6BF4C394,
     0x91CE44E8, 0xE94F078B, 0x6B2B545F, 0xE19FD2B4, 0x34935F9B, 0x3634EEA4, 0x9BF6EBFE, 0x32394F7F},
    {0xE6930549, 0xDAF98BA1, 0xBEE55B2C, 0xD26B39CE, 0xA54D1917, 0x9E56BD1,  0xD945184C, 0x70151B2E,
     0xF552661B, 0x70F46DB5, 0xBCCA3400, 0x3CD12BB3, 0x7C7499A9, 0x6D0F0F7F, 0xBE0312E,  0x34108BB2,
     0x710A7DEA, 0xBAB4B270, 0x274FFFE0, 0xAD7E2098, 0x82528075, 0xB668169,  0x3C63281C, 0x32B7C57D},
    {0x8D548D3A, 0x3197C69A, 0x677AEBF3, 0x66CBEA4B, 0xDB939605, 0xF028A01D, 0x77ACA0BE, 0xF9B39AD8,
     0xC947E4EB, 0x3B7C2D35, 0x47C3FC34, 0xF18E0B67, 0x17AC7B5F, 0xCC3EED54, 0x90EE7C32, 0xA38162C5,
     0xDF070788, 0x12A3350C, 0x549468D9, 0xBCEF199,  0xB7AC0181, 0xFE60D1EA, 0x355D6020, 0x749818F},
    {0xFF2597D1, 0x82B301F4, 0x3325369,  0x4BDABC02, 0xE67F271E, 0x24D9A625, 0xA0A5FC99, 0xA353D3E6,
     0xB6048122, 0x976BAF7D, 0x98A87C04, 0x3EC17D29, 0x3FC7421F, 0x18E8E226, 0x77426B6,  0xA25E4922,
     0x8EFE71FD, 0xF662E4EA, 0x7E856E75, 0xB9C19DB6, 0x974F1E76, 0xF44D0FBD, 0xBD12EDC4, 0x8AE4EFD0},
    {0xF33FD68D, 0x75C53A50, 0xAD9B4953, 0xB99F26EB, 0x6CF0AC1C, 0x840BD283, 0x4B66BAB4, 0x52282C32,
     0x6176E227, 0xA8403524, 0x44B39A11, 0xA00B1BC3, 0x24DCE338, 0xC3D3C589, 0x9DC9785C, 0xBD4A4322,
     0xE78F88C6, 0x67508E82, 0x6A4A3248, 0x1FC27093, 0x858680DE, 0x98B4AE32, 0x92FDC835, 0x596B3402},
    {0xE068DC9C, 0x4639B9D3, 0xE3A24FBC, 0xBE66F7DF, 0xE4A4EA67, 0x75830DF9, 0x3AAD3427, 0xE4E4F837,
     0x9DC5E7FB, 0xCB4ECB8F, 0xB3CCDC94, 0x2D9FDC96, 0xF9C1E88F, 0x5048AB0A, 0x4765B976, 0xBA08155A,
     0x578F84D,  0x45458A4,  0xD6C7E465, 0x593CB5F0, 0x79213B49, 0x413232ED, 0x80EBB2D2, 0xEC8EF2D1},
    {0xE0E7530C, 0xA3399AD,  0x6FFB5720, 0x840F1105, 0x7A0EFA41, 0x36C69672, 0xC91BA132, 0x2F253F58,
     0x54CD1203, 0x8D3C1ABC, 0xA3050B1C, 0x6A77ACBB, 0x27023942, 0xC9654E23, 0x661B92E3, 0x138C9FCA,
     0x38028294, 0xB66CEF95, 0x2A62DD65, 0xC31EC46F, 0xC41C069A, 0xC0E97EFE, 0xCD58718F, 0x7044D3B9},
    {0x78E86C59, 0xC39DE679, 0x9FC43170, 0xA8D185DF, 0x4C410E2C, 0x9B3C8293, 0x1632E7EC, 0xDD88CE64,
     0x9442DF3C, 0xF07638C4, 0x31237C54, 0xE775F1F9, 0x1B9122EA, 0x4E23E8FB, 0x62DAE8A0, 0x6848306B,
     0xAFF82E6F, 0x3A0DBE05, 0xA99003FC, 0x418E2D6D, 0xA2ADBD15, 0xFC1D40E7, 0xA888D860, 0x437ED421},
    {0xE52F3F97, 0xD06D35B4, 0xBB93514F, 0x20995E8F, 0x31D069D8, 0x6D6B3D7D, 0xA86826EE, 0x4467996D,
     0x836E3216, 0x672A8FFA, 0xBC078247, 0x1EBF2B1,  0x33F2BB68, 0x65F69DC,  0xD7DDF843, 0xB6B3D0FD,
     0x90F7E37A, 0x3BA36E3E, 0x840DF9E4, 0xDC8764E7, 0xBE25B83E, 0xBD91D715, 0x95A6D56,  0xEBF6C623},
    {0xFFD96046, 0xB678B7B9, 0x687E8AF0, 0xB5148DC5, 0x7334013E, 0xC677992F, 0x4A00643A, 0x946CCC19,
     0x8CB73EF6, 0x57E52B4A, 0xA22F1DC0, 0x53CA88C3, 0xC0F6A435, 0x411A8E8D, 0xED84565D, 0x790C7F9B,
     0xF65B1386, 0xB5A9FB23, 0x64C1A489, 0x6262C00D, 0x7B4F398F, 0xFDC2BB55, 0x63B565D4, 0x4FE1EBA2},
    {0xE8784967, 0x1C53F382, 0x77179985, 0x9AA9780D, 0x979F74FE, 0xFDF15974, 0xC41AACA6, 0x2900BF6D,
     0x38CB2AC1, 0x441B560C, 0x10C4DD81, 0x656CC9F7, 0xD2FB953F, 0xFD8C8139, 0x59589FAE, 0x1A3FACC4,
     0x6D9AC2F9, 0x72ED99EA, 0x20976CDD, 0xC8B8FE7,  0xB0980622, 0xC49E02CA, 0xD97BB652, 0xDA3A15D8},
    {0x1C310BB3, 0x2DB858BA, 0xB6213593, 0x801E68D4, 0x8AF67F8E, 0x375BDDF4, 0x47AE9210, 0xCA9EB75E,
     0xDB85BCAF, 0x33DA014A, 0x5A7F9804, 0x73BB27ED, 0xA19A3FBE, 0xB39AFCDA, 0xA6A1BB52, 0xFAA83886,
     0xC82BDBB,  0xF4C09BB5, 0x40E07A4E, 0x96FA6608, 0xB57750F,  0x5531034C, 0xF25E91F0, 0x4C444134},
    {0xA731D551, 0xC94FC555, 0x5FD4AD42, 0xC924162B, 0x1D5DDF03, 0x8CBC30D9, 0xBEBD95D9, 0x6E47D05B,
     0x55C56C2B, 0x1222EBD8, 0x4C15AD38, 0xBB962676, 0x90CC11CE, 0x9207792A, 0x62DF85C4, 0x28618288,
     0xC9EB6ED4, 0x14D14E9B, 0xDCBD215D, 0x318DFFCD, 0x3803A2E8, 0xA0070E97, 0x72281C07, 0xA7371CA4},
    {0x21ED868,  0x76817E1C, 0x315B1392, 0x49B243F2, 0x7D692ADC, 0x3AB08C68, 0x4A9B8FE9, 0xCDC65F68,
     0x596A0DBD, 0x79291837, 0x7D5FB722, 0x7D075D2,  0x21FEF57E, 0x9C2FB506, 0xF641D653, 0xBD87A820,
     0xF71F6B02, 0x48704CB2, 0x7D79AAE,  0x8C5A94BF, 0xD921B9F1, 0x442C0C22, 0x59B832E6, 0xC615BFA2},
    {0x73C67390, 0x4177B0E,  0xFC00538C, 0xDE1BADD0, 0xD0380567, 0x3564EEDD, 0x41FDE5C4, 0xAB91BEE0,
     0x929F748A, 0x20A9E345, 0x8812EBA,  0x4E69E1DB, 0x217162C2, 0x642A9F23, 0xDBF08CA9, 0x5963E212,
     0xDC1E3F61, 0xAEE9C49D, 0xE9702FFC, 0x224239AA, 0x1BE05D34, 0xF9FA07D0, 0x402AF20E, 0x7351AEAD},
    {0x2593969E, 0x5E7C0B0D, 0x2D94E17A, 0x25D748FD, 0x12A3949F, 0x29E48295, 0xB86A4099, 0x69B9CE95,
     0x504FBE9,  0xE254EF90, 0x2CE6F428, 0x21618B0E, 0xBEF79C1F, 0x98EA2A41, 0xBEA632E7, 0xECC56342,
     0x29BC6C53, 0x1D4DA563, 0x9A862D2B, 0x8A883283, 0xA4317A9F, 0x96C080E9, 0xA0A7F0FA, 0xE71F8CB},
    {0xCF37056A, 0xF0316E14, 0xB552339E, 0x6E961174, 0x194F8FB7, 0xE3C09F3C, 0x1C4C30CE, 0x4EE81AF3,
     0x15CA55F5, 0xA4227D6A, 0x47A164C,  0x51B0F96D, 0xF5AD213B, 0x6EEFE38D, 0xCF033BAF, 0x9C5A7FCE,
     0xAD68A8AA, 0x68B01DF5, 0x652073D7, 0xF35E719A, 0xF0ED0A9F, 0xC385627D, 0x62FC9CE0, 0x4BBC743C},
    {0xDF128F2E, 0x50672C79, 0x7F1135F7, 0xAF556932, 0x98B70304, 0xA3E9CFA,  0x77C731AC, 0x2D318B59,
     0xA5F74F95, 0x779A8970, 0x26CDBD43, 0xA0F208A3, 0x5785ACF5, 0xED991A87, 0x134E16DC, 0x8B385C31,
     0xF5D20F31, 0x8DC3F32F, 0x1419BB8E, 0x104D7AFA, 0x6B9056D3, 0x834A7F75, 0xDF877C6E, 0x7E043429},
    {0x2DF2838F, 0xB754FD04, 0x1298A54C, 0xC934FA76, 0x434796F6, 0x55DC46B7, 0x53D0D8E,  0x2DDE3E03,
     0xA90B8348, 0x6056D01D, 0x2BB98425, 0x162139DA, 0xFBA3AF60, 0xEECE1F06, 0x203FA490, 0x16B02D56,
     0x3EEC7D7,  0xA4EC078E, 0xC8E0DB6B, 0xD4CF6A9B, 0x2371759,  0x82F12BC5, 0x9B27A5D8, 0x70A1E6F1},
    {0x5B63CD8B, 0x8795FA00, 0x33DA5ED1, 0xBD3D5D1E, 0x1C4A7A3D, 0xEFE4965F, 0x5B325ED,  0x5D6BB9B1,
     0x79D313A4, 0xD28FC41F, 0xD54CC102, 0x4668BEA2, 0x885430B9, 0x7D94D0EE, 0x3A4028A6, 0xF497265D,
     0xB12F10B4, 0x875E866C, 0xA4D12C02, 0x5FA3E029, 0x3F6D7EA3, 0xC075AA54, 0xB5304B8A, 0x98CFC3BC},
    {0xD80A752D, 0x6BA8726E, 0xF7BF89DE, 0x2516888D, 0xB6543742, 0x564E9A2C, 0xB6825540, 0x96FE94B7,
     0x557692A0, 0x9EF09DB,  0x1717007F, 0x2442E58D, 0xDA6EFCA3, 0x9CE3643C, 0x5D7EBE41, 0x47BBF60E,
     0x3C2B72EA, 0x90D78BB,  0x43D49F0C, 0xA32821BA, 0xB14F1EA,  0x2D3661AF, 0xC31A6ED,  0xF53EA133},
    {0x8657972F, 0xF9698802, 0xC7E28AB1, 0x6953AC7B, 0xA657BBF9, 0x1A6A54,   0x896BAE69, 0x42E773B4,
     0x54792D7B, 0x9A90604A, 0x2040BE54, 0x3AF06DF,  0x65F370D,  0xFE2F340D, 0xE293596A, 0xE904E452,
     0xC67890E,  0xEB005D87, 0x21396BE1, 0x578FD0F7, 0x6A715E47, 0x3B8912E8, 0x3C6E225C, 0x6E6FBC87},
    {0xFAD88D07, 0xE484AA73, 0xE4B1A952, 0x899A3C90, 0x7EB6F96D, 0x7E0888EF, 0xDAA81C43, 0x4E5C99B9,
     0x5410568B, 0xD9D3C14D, 0x8B381EF0, 0xAA6CEDDF, 0xB5472483, 0x5A654426, 0xA14B5264, 0xE0D9CC2D,
     0x313A10AA, 0x3D6F4BD3, 0x285ADE0F, 0x83CC5A2A, 0xC9D54476, 0x120C383C, 0xFBDD55CC, 0x9487A7BC},
    {0xEE76A893, 0xD20E3D79, 0xBFAC363B, 0xC46A8BBD, 0x1207263B, 0xEA684ED4, 0xAD45719E, 0xA969B110,
     0x710A38EF, 0xB598F02D, 0xDC3A886D, 0xC2A6CFD,  0x1B726B9,  0x3FB51AA3, 0x42DE9FD7, 0xAAAA8622,
     0xF02039E4, 0xADB57985, 0x46AD0F0F, 0xABA26461, 0x4E3A5A90, 0x822EF88B, 0x8B6E94CF, 0xF4E7730D},
    {0x4AC9CA9A, 0x13425289, 0xE46FD222, 0x9DA9575A, 0x123592A2, 0x34EFB631, 0xAE4C3B6F, 0x338D490A,
     0xEBBCB999, 0x18FE171D, 0xE0F92109, 0xD35BC195, 0x6ACE1A3E, 0x9C14738F, 0x71D046B,  0xFC0B282A,
     0xDEE86555, 0x8D526FF6, 0x551517D0, 0x90295D42, 0xC68F3626, 0xCDC14F13, 0xAB07FB1,  0x6B9601C6},
    {0xEA4DC1E4, 0xFFB131A2, 0x676F4C3,  0xD9A9DA64, 0xBA059DF6, 0xB5F5B718, 0x87F136B5, 0x94DFBA1E,
     0xCD214CAB, 0x14FD4F98, 0xA31BA368, 0xED87AFA4, 0xFAE72F33, 0xCD051607, 0x9F40C473, 0x3853D148,
     0x82AD14D9, 0xC269EF6,  0xB2A67ECE, 0xE20397B4, 0x4CCE1A95, 0x28863355, 0xF1EA078C, 0x1EEAE797},
    {0x63E1E51E, 0x39EBB75F, 0x8C2421B9, 0x7E8AC132, 0x8CF9CFD8, 0x43D7B755, 0x3AF80A6A, 0x38609C0D,
     0xF165BE7,  0xCE2BABC5, 0x5CE4D58A, 0x15DB6388, 0xEC85AA4,  0x844B3BC7, 0x56AE8BF1, 0x36923B06,
     0x32922345, 0x18A40407, 0x6D54FD5C, 0xDCC26AAB, 0xAB4B92F6, 0x9FC6A239, 0x3CF3E6D8, 0xA1D267D9},
    {0xC337C707, 0x739F227B, 0xE4F5D2C0, 0xB4A9795F, 0x1CFDEEF7, 0xC8358621, 0xE49298EF, 0x6B468173,
     0x91186F96, 0xCF974020, 0xFB312855, 0x789582E5, 0xC238EAB6, 0xAA8FB35,  0xFA0C2730, 0x8D07DDB3,
     0xD9A5A4D,  0x40E7B5B9, 0xDD51FF1,  0xF941C18A, 0xC22AD3FF, 0xEC76832F, 0xBA40C118, 0x5B51D115},
    {0xE1F10766, 0xC0690C4D, 0x4B43E0,   0x315A344D, 0x3335F7CE, 0x539BADAB, 0x62071B06, 0x5F387D0C,
     0x8EC79606, 0x8DF32A30, 0x77D80208, 0x93BA5593, 0x3EE76603, 0xEB01D43E, 0x13D3E23D, 0x2BCAB8A8,
     0xC5251673, 0x12F31367, 0xA3CAE026, 0x385CBEB4, 0x5128F4C7, 0xDF3968E5, 0x1FEA281F, 0xAD75DA89},
    {0xF15FF47B, 0x4A547743, 0x2EFA0442, 0x52797310, 0xC98B7551, 0x6F3A3953, 0x7ACD3BB7, 0xF600B81E,
     0x6B2F2D66, 0x5B8DD648, 0xA299BCBC, 0xB4C5654C, 0x3294766A, 0x306837A5, 0x986C19E7, 0xB72BCB5,
     0xAA183F8C, 0x64973DC4, 0x5F6FA509, 0xE65F8D34, 0x9D584D0B, 0x5C266E79, 0xBB7CF655, 0x21083453},
    {0x7FA3D622, 0x1667F393, 0x12F314C1, 0x532E0191, 0xF1E9C649, 0xD33D6F66, 0xB3ACCD85, 0x3137182C,
     0x8131B4A5, 0xF4829955, 0xA1CFEE5,  0x49F3FD69, 0xD6713FCF, 0xD28CA9BE, 0xA53A9875, 0xDAB9A4B0,
     0x4EC3049,  0x797CAF57, 0x1C8DD57D, 0x22400697, 0xDD02045B, 0xFA2DD292, 0x33CCCD4,  0xA376369A},
    {0x2EA8836A, 0x666EC330, 0xA19C850B, 0x5F3E6075, 0x7BF6727D, 0x421A0B84, 0x1B002C4E, 0xBCE80532,
     0x704DD2E1, 0x24578AB1, 0x82F2146C, 0x766630F0, 0x6F27859D, 0x46DD64C2, 0x266C0BF8, 0x12E9364A,
     0x79E665C3, 0x8911EAC8, 0x72BF6BE,  0xE30850D5, 0xEAEC9AEA, 0x332FE212, 0x50F695B8, 0xEEFF202D},
    {0xA551D2F4, 0x1859AFD2, 0xFA7EF580, 0x19D62784, 0x74E9C797, 0x7C51D892, 0x6C41CA69, 0xF8BF4EDA,
     0x6A0C84EF, 0xA4F869AB, 0xC3E1CCF8, 0x5C9951CF, 0xC4B2673,  0x8536B866, 0xCE8CF2F9, 0xF566824,
     0xCF96AB53, 0xB41B4C65, 0xF27A2041, 0x74979B82, 0x166F1F77, 0x67EDAEC1, 0x11FC3B01, 0xBC15FF96},
    {0x29EB2C8D, 0x58B53426, 0x28FDC488, 0x8FAE8118, 0xFC1A1313, 0xDEBB9A6C, 0xA0DC6CE6, 0x98C0062C,
     0x101F3AA,  0x52596294, 0x26C929CC, 0x5CB4747B, 0x7164FE0D, 0x35A26D69, 0x479CEFC7, 0xE0EB6AB7,
     0xEC6F3A43, 0xCD68F54C, 0x26DBEF22, 0xD911652E, 0x2D351324, 0x95E3ED3F, 0x340F06C4, 0x3E563B1},
    {0x1DBC2BF5, 0xE7DC18F9, 0x94FFBF6C, 0xA250FF70, 0x4D150BC2, 0x71193B4A, 0x555BF6E6, 0x6EBD110D,
     0xAB526ED3, 0xB4296F0F, 0xAF55EE40, 0x9EA01B61, 0x11BF0F65, 0x6F104D7F, 0xFD1A03A6, 0xAD14DD28,
     0x547D514,  0x63C53B56, 0x16C917DB, 0x746323C9, 0x2412EFF8, 0x19A5083F, 0xED5EBF33, 0xCF146630},
    {0xFBC6C313, 0x89427C0C, 0x7D299F7A, 0x67CAF9AF, 0xA90775F0, 0x4DB9288F, 0xF3AE47A,  0xEB91C3AD,
     0xA9C6FBF8, 0x40F87EA7, 0xDF2CED03, 0x3BB474A1, 0x83F81064, 0xE6110C84, 0x14F5FE74, 0x237BF7D6,
     0x65552C3,  0x2BE7A153, 0xB5DA013,  0xD9EF3466, 0xF2059942, 0xF315F21F, 0xA2C3EA96, 0x611B5C8E},
    {0x31F62125, 0x6F3C09DA, 0x2A1603AE, 0xD0B2710,  0x2CAA666F, 0xDB7C5C94, 0xE372814,  0x7F229FB7,
     0x9EC9F906, 0x272814DD, 0x7470B464, 0xDF653EF4, 0x6EE07BB5, 0x6F9C574D, 0xB7BF814F, 0x2DE06238,
     0xC8FC4C05, 0x79B615F6, 0xB923384C, 0xCDA5B83C, 0x447B9228, 0x4BAF4865, 0x82A41BD,  0x21559667},
    {0xBE708707, 0x7B0FEDC6, 0xE69C66EF, 0xCFF51A42, 0x232899A3, 0x5CCE5054, 0xC5C4A411, 0xE1AE28B5,
     0xD058FA13, 0xB3175C45, 0x7FDC567D, 0x256FEE9,  0x24AFAF40, 0xEC54E1A8, 0x38397FC2, 0x155BC0B2,
     0x7DB8DA4A, 0xE85E4C79, 0xF33E2A61, 0x7117576E, 0x15ADE0DF, 0x94C2AC5,  0xBDFF3E9C, 0x3AA5997F},
    {0x53FE59B8, 0x751D7CBC, 0x498B2E34, 0xB033BE98, 0x55471290, 0xB0A11EB9, 0x800C4068, 0x5F966B7E,
     0xB0A05EA1, 0xC9BB01BF, 0x780C9BA6, 0x52449227, 0x944150E4, 0xFF69C9EC, 0x35694E8D, 0x5E119D01,
     0xEA5FACBA, 0xDF2C7DB4, 0x48160A0B, 0x4F13B6CC, 0x8828DCB1, 0x284C9C59, 0x80DC375A, 0xA6DE683},
    {0x434BADAF, 0xA8933379, 0xBADF322E, 0xA4A79653, 0xB1ED82F0, 0x23B231EE, 0x3EA469D7, 0x11BEDBAA,
     0x967E55A5, 0x1354EFEB, 0x59AC7757, 0x4184AA51, 0x1385D08C, 0xCF5EB3AA, 0xE8EE09FA, 0x67206963,
     0x353C9EBB, 0x75003C5F, 0x65D7D4AB, 0x5F0F8E14, 0xBDA21B49, 0x7B5D5413, 0xAE808294, 0xD93B160F},
    {0x2681BFE4, 0xD4D760DA, 0x8E43DD3B, 0x9E338145, 0xE545AD2D, 0x6F7A3478, 0xABE4C17F, 0xB7BC9CB1,
     0x7AC110FB, 0x901A8710, 0xBE6CFDCB, 0x170969DD, 0x94FA4061, 0xC66FA7A3, 0x8B0B94FF, 0xC3710777,
     0x5473615A, 0xC2363148, 0xDFEB28FE, 0x251FCB74, 0x3BEFFC1F, 0x680831D2, 0x91919E5A, 0xBAFC6414},
    {0x2A996E76, 0xDD3EBD05, 0x66DBB188, 0x68B81BC1, 0x54E4A58,  0x55ACE003, 0x910BBDFD, 0xC14E5556,
     0xDB669706, 0x2C3B7399, 0xFDC0401A, 0x19253117, 0xADBB27C7, 0x9B06CAB5, 0x8EC40696, 0x2018BE1E,
     0x8C819F17, 0x48AB16EA, 0x2F286DE1, 0x775F235E, 0x663205C7, 0x80A6B287, 0xB798AF63, 0xBF36E36},
    {0xB9B162E8, 0x5FD6EE3F, 0x73D4FD52, 0x43C07B28, 0xCED3FD6D, 0x30096F43, 0x9C698C9,  0xE6C6F25E,
     0x37D7F49A, 0xCDB4856E, 0xA7021DA,  0x41258018, 0xF1060601, 0x6338EBE1, 0x6BBB865C, 0xE6365B53,
     0x9E41ED45, 0x8B853DB,  0x45DB6704, 0xBF969796, 0x6A9012BA, 0x3BD807D1, 0xFE9AB3F4, 0x765B6552},
    {0xC7C9D062, 0x76BB33D0, 0x840CCB82, 0xD7DE8439, 0xB240A154, 0xEEEAD8B5, 0xE2CA9819, 0x45D28FAF,
     0xD7CB9D42, 0xCFACEDCA, 0x9DE2D79A, 0x5B2AA580, 0xF59534F0, 0xBACCD4F7, 0x9E2AE681, 0x8FBAE484,
     0x271DC174, 0x39E9F557, 0x3A782DC4, 0x2CB63FDE, 0x731C630,  0x2BCFED21, 0xB47200F0, 0xB3078701},
    {0x8C4CDDD3, 0x87FD0B46, 0x4DE2E29,  0x2412E4EB, 0x62534A6F, 0x4B282570, 0x79E79EB,  0x2DE16571,
     0xBDA05969, 0x861422E9, 0x864AF422, 0x640D0C7B, 0xDBD2F55B, 0x64E5D923, 0xB3092D99, 0x9FEA1596,
     0x8C9B3924, 0xBE10E3FD, 0x437996C1, 0x927BC752, 0x1CDF883F, 0x8AF6A1FC, 0x478504B,  0x3E300B02},
    {0x64384631, 0x96F87D2D, 0x3A768F47, 0x455BAE83, 0x3FD6549F, 0x5F9EDF6C, 0xEE7F2DF4, 0xC495230C,
     0x86D802FD, 0x54ABA95F, 0x21765727, 0xE086F4EB, 0xCD7A72F7, 0xD2E33F0B, 0x70CDCF89, 0x4B8AE9F1,
     0x252FE139, 0xC8AB6B43, 0x4ADC091F, 0xC133D3C7, 0xE3AB50C6, 0x5924DC7E, 0xEBEB0496, 0x896C482F},
    {0xAF1DC643, 0xFE83CB74, 0x140143F1, 0x74C946AC, 0x4F49447C, 0x201DE031, 0x2051DC75, 0x144EBAAF,
     0x8480D6F9, 0x9E6A17B3, 0x9A4D3C9F, 0x5D5B02A7, 0x429E4C5D, 0xD95E7296, 0xAA182F8,  0x6F49B968,
     0x57DCCD12, 0x76B57542, 0x9CBDC6AF, 0x2BB6FCAB, 0x9585C4AD, 0x55016D1,  0xCA609BBC, 0xFA53EF6F},
    {0x2FB82928, 0xC830C8A6, 0x53B355ED, 0xC5ADAACF, 0x50EAF3C0, 0x308318AB, 0x5E24244E, 0x693B88BB,
     0x61B1BAF0, 0x197B6962, 0x6770C9B8, 0x5F54E972, 0xB50580BB, 0x92646660, 0x4195C697, 0xF7A0E5AA,
     0x973A4BF4, 0xABE1961,  0xAC5FC182, 0x3FE64CFA, 0x764BE071, 0x541A83BC, 0xD3B4401D, 0x11D20B21},
    {0xFBCFBD0E, 0x8DE840DB, 0xE6DDE64F, 0xCF029942, 0x2352A286, 0x83042F1C, 0xF92B07A,  0x50DDFE64,
     0x6EB66CF,  0x5598F208, 0x4FB37300, 0xCE6984DF, 0x24550E8D, 0xF1102C91, 0xE9D036C8, 0xBE686A1D,
     0xC880C56,  0x5139D4C8, 0x519683A3, 0xD3136E5B, 0xF713EF01, 0x44449A3E, 0xEAD77B04, 0xA20C60C7},
    {0x26F67509, 0xDE8B3665, 0x547C5D26, 0xDD2FC44E, 0x7682FBE9, 0x6BCF575D, 0x373B942A, 0xDA652CDE,
     0x5FB8F21,  0x948119F8, 0x559AE44C, 0xB79BC655, 0x6E9947C2, 0x65F788BB, 0x7ECA7AC3, 0x2A9723AE,
     0x7DDA69BC, 0xF00EFCF6, 0x791CA698, 0x146E82C5, 0x43A0F4E2, 0x9E9D3B00, 0xF379BBC,  0x30DB38A6},
    {0xFF507C89, 0x5B231681, 0xB8D61FD5, 0xA4E7E1B0, 0xCC7AD510, 0x4B474612, 0x1BDF71FF, 0x63843C1,
     0x272F7A92, 0x1BC635CB, 0x1D806F65, 0xEBBE7AC8, 0x2C5F3EA5, 0x356123C2, 0x425EE0F5, 0xF112CB69,
     0xE1CD3A2A, 0xD7C014F0, 0xEA9E33EE, 0x8542E951, 0x90CC6A12, 0x197A72BA, 0x65996BC7, 0xE7CA0C80},
    {0xEACE401B, 0xDF1BE5EF, 0x4E25B28D, 0xC3E22C5C, 0x19740FF8, 0x3C3F3C1D, 0xE8B48541, 0x9949E412,
     0x780DEF21, 0xED012F00, 0x5ECF5680, 0x186CB393, 0xA2648EE,  0xD9965EE,  0xB2EAA573, 0x243B8F1E,
     0xB7777357, 0xDA142285, 0x6081D79D, 0xEC3A95ED, 0xC1E1C403, 0x7CD0E707, 0x4C3BB420, 0x3BF76124},
    {0x249709CF, 0xF267B77,  0x71EF96B6, 0xF74D0780, 0x9692E7D3, 0xABB9F67C, 0x11E74301, 0xB0CC4DA7,
     0x51888E25, 0x5A90F28D, 0xC89BB8A,  0x7396C7CB, 0x9A8FCACD, 0x787ED3CE, 0x9C2F6E5C, 0x6413980B,
     0x29757200, 0x10CCDFF3, 0xD8EB8919, 0xC3463901, 0x81FDD075, 0xBF4539A,  0x1323E91,  0x3F2EB0E4},
    {0xF92FDAE0, 0x85DFB98F, 0x88A01ED3, 0xCAE86118, 0x416F8493, 0x161EAF70, 0x121A39A3, 0x3C74D27E,
     0xE0D141F7, 0xB1E84E5C, 0xECDD0C9B, 0x299E51D7, 0x69F131B3, 0x965371E2, 0xDDBAFD7,  0x3881032E,
     0x53CA8138, 0x89C7C48A, 0xF81FBD1,  0x214F77F1, 0xA0DF07F4, 0x313027C9, 0x2B93EF41, 0xF02127E6},
    {0x45C1B4F3, 0xC7BC44CC, 0xF4C22781, 0x6B73E595, 0xDB84E78A, 0xCEB55625, 0x5FE1C979, 0x6285AF19,
     0x5BF7EBF6, 0x70C074EE, 0x36EAF918, 0xD291B562, 0x1C9C57CF, 0x733B7913, 0x7F55A8BC, 0xF61E9F67,
     0x113CEA6,  0x14AAE057, 0xA7923020, 0xB3340423, 0x4141B673, 0x6D74F74E, 0x5F25D400, 0xE8F6D3B0},
    {0xCFED616F, 0x93E3F122, 0x38EC4EAB, 0x817DD42F, 0xF4E15B17, 0x7F09BCCF, 0x42381793, 0x91FB9A8A,
     0x323B6166, 0x8A8D4D42, 0x4AA0A176, 0xF52E42C1, 0x832B1A14, 0xC9FBE77F, 0xDBC22DA8, 0x18EA1B11,
     0xE8469D10, 0xE8EE50D8, 0x100434FA, 0xD6AD05B4, 0xDEFCA68C, 0x2168C90,  0xD4081068, 0xA5BE7619},
    {0xF8AFE26C, 0x6D1586F7, 0x6B5CE219, 0x3F5C79C2, 0x40E5B767, 0x11491943, 0xE4A3CEB6, 0xCA6B63A2,
     0x433C4331, 0x63D46DE8, 0xC5B3E78D, 0x2676C0AA, 0x94E6EB57, 0x28F4B6,   0xF5574B1F, 0xCD119034,
     0x94263306, 0x5CFD09EB, 0xD5953421, 0xC189FE4B, 0x4256F739, 0x5D2B2786, 0x5C8104D6, 0xC7C7E7D2},
    {0xB2DF27B0, 0x8172706F, 0x905CDD04, 0x6905EBE0, 0xD05F1B95, 0x79AF197D, 0x5FCCAD98, 0xFCACE6E3,
     0xE4CEDDBB, 0x601D2073, 0x138C0E8F, 0x485F6550, 0xC4158661, 0x647A1265, 0x404420D8, 0x167455F4,
     0x3292CBD4, 0xABABA0BF, 0x99AB0F4F, 0x5B1956FC, 0x90900C80, 0xDD1EC622, 0xEE86C409, 0xBD5F014D},
    {0x720F9C79, 0xFA279F4,  0x14BAC8F7, 0x35C50B90, 0x934EE9FC, 0xC6854EB0, 0xC2F7A08E, 0x340574E6,
     0xE7AAD03D, 0x98E9AD8B, 0xB9F0F29C, 0x7C7CA6CC, 0x81A5D23C, 0xD5EE31F4, 0x2CA4EEBD, 0x97E9ADD0,
     0x3A5C0326, 0x3588EB04, 0x9833563A, 0xE703248A, 0xB4E8DE65, 0x6415AF5,  0xE1D66CAF, 0x3F5DF41F},
    {0x60C8E4C2, 0x5C1B8B4C, 0xC66F682D, 0x6A04ACE9, 0x1F5FCDD2, 0x38B81A32, 0x3D1038FF, 0x16072A8F,
     0x3FE2659A, 0xACB74CFA, 0x9615798A, 0x1B51A848, 0x39C19A1C, 0x94601972, 0xD827E518, 0xB420F5FA,
     0x4FB236A,  0x96FCA6D5, 0x77BEE1C1, 0x492AFC11, 0x20D42634, 0xC0133FC5, 0x30973782, 0xD19AE5A8},
    {0xED0D7948, 0xEA34EE07, 0xDD5B89B2, 0xEC203B49, 0x2ECEFEFC, 0x3DE38CB2, 0x25E830F0, 0x9C1CAAA7,
     0x8349F232, 0xE229EAE2, 0xA6C1435C, 0x6FD24BB1, 0xC363FB22, 0x8434BE89, 0x9E59297C, 0xED384470,
     0x9B03F31A, 0x21CDF36F, 0xB9640699, 0x238C813,  0x21181122, 0xF8DF3E8C, 0xA826070E, 0x53F2EBF6},
    {0x299572ED, 0x5DF0B370, 0x5501CCD,  0xDC3AF1AC, 0xCEA491EF, 0x971B6FAA, 0x3DB55E26, 0xF6835B8,
     0xAF8BDA0E, 0x6984B01F, 0x2256AF01, 0x5F8359E7, 0xA9CB32B6, 0xA08F3DA7, 0xC240A42B, 0xBEBD9905,
     0x9EBC5503, 0xD2AABE59, 0x9821A4AB, 0x710B4A0B, 0xF866CF2B, 0xCF98FA7C, 0x9C1A85C6, 0xD39A8077},
    {0x9C79A584, 0xB305C5D0, 0x47F7903F, 0xB1493FCC, 0xCA29DC2B, 0x659F36DB, 0x65ACC90,  0x25E3A731,
     0xB72A6465, 0xC714F995, 0x155C989E, 0x87834B04, 0xFD2F4F96, 0xBB1872BD, 0xF8482F38, 0x538FBE41,
     0xF3596171, 0xE1218AC9, 0xD60156A4, 0x97B4D8BA, 0xA3621D34, 0xADA678AF, 0x39D76485, 0xFAABA10B},
    {0xFDA1BD77, 0xA8211EB6, 0x7F03FC1C, 0xACF80F40, 0x7F313A0D, 0x7235A618, 0x28D59DF8, 0x76BF6B0B,
     0xA7609AE8, 0xCEB33716, 0x3AA99575, 0x8298F47E, 0x1DC1370D, 0x4014CA2E, 0xB8599C99, 0x78675D86,
     0x9034F2C5, 0x91E526A9, 0x7B3485FC, 0x3F596A9,  0xF0100C86, 0x2E56A7E3, 0xF1F7EC8E, 0x704A9DD6},
    {0x8748574D, 0x4009C59C, 0x783F43AD, 0xE1C0C79C, 0xAECBC22B, 0xAABDF22,  0xB7430D30, 0xA646443E,
     0xEF042AD6, 0x7BDCD2F,  0x7BD04738, 0x3B109BD,  0x62211083, 0x36E7E9D3, 0x12D9997B, 0x63B126AA,
     0xD2F7B389, 0x263E9D88, 0xB2C90B01, 0xACC18008, 0x52FCB27E, 0x33D7821D, 0x49F30AA8, 0x986B738E},
    {0xF3A4DEE0, 0xDC9DCA0D, 0xCF89A69A, 0x374F126F, 0x3C75D47D, 0x3756D37A, 0xCC3CDF41, 0x81BE70E8,
     0x5FE26F87, 0xF552F575, 0x2F0C715E, 0xC3773868, 0x599CFD93, 0x1E0F528E, 0x2C74ED16, 0xE71C7DC0,
     0xB8B2FE2D, 0x2CC31996, 0x1D39FDD6, 0xC5E06BCF, 0xB413BC7,  0xA1ED2F86, 0x3C3BADC2, 0x17CD8180},
    {0xC15807FD, 0xA82F94A5, 0x517484BA, 0x916C728D, 0xAE7F2CD6, 0x788C3F90, 0xB919EC03, 0xA96E00AA,
     0xFE8FB68C, 0x6CCB047D, 0xBC58F086, 0x8D838A39, 0xC7065F33, 0xC5E40FB,  0x71BB1CCA, 0x4E009735,
     0x4644C293, 0x243644A1, 0xA712E24A, 0x244DDD12, 0xA72615BC, 0xE23F59D2, 0xA0786B36, 0x966CA411},
    {0xED026A35, 0x33C4441C, 0xD47EA878, 0xE4FD4EB5, 0xF0FB7457, 0x90672CC9, 0x9D6046C9, 0x9B88CEE9,
     0x81AD7AA3, 0x13FA81D6, 0x84E47DEC, 0x4300784C, 0x78E102AB, 0xDA59858B, 0x5134EEC2, 0xB6CB92E0,
     0x46FF8903, 0xEC709650, 0xFE40A102, 0x58F8A072, 0x934150C8, 0x86721C06, 0x2388B459, 0xCBB8AF45},
    {0x37019FB4, 0x992CB348, 0x4AD6B5F2, 0x5ADE5088, 0x2AB99B81, 0xA276AC29, 0xE3E5D55D, 0xFD1C395B,
     0x499AAD30, 0x6989E9B7, 0x541769D6, 0x57A87573, 0x76C82162, 0xAE7C626C, 0x9EB30906, 0x9035724,
     0x42A0A6F2, 0x2A190943, 0xD90F20E5, 0xEC7B754A, 0xA6232860, 0xCD4D7078, 0x5A0D77F5, 0x43F7AC7C},
    {0x5CCBFABC, 0xE96E307F, 0x54C0E3AC, 0x41F8B73B, 0xF78FAB8C, 0x6F7D6217, 0x38AF934E, 0x258C7564,
     0xE3D15D29, 0x5E931A31, 0xEB456D3A, 0x9CDA4408, 0x7AFBD600, 0x74863439, 0x1091781C, 0x54C7BE0D,
     0xCD77EEA2, 0x69A83951, 0x5A8EF6AA, 0x4B87B04C, 0x6A98AA8C, 0xABA4C615, 0x45F01FF2, 0x922E6E5D},
    {0xBCCEA880, 0x515D1DDC, 0xBB4E5261, 0xA1727803, 0x769AD78F, 0xC48538B7, 0x3166813B, 0xB72C53B8,
     0x93BEF73F, 0xD525E24,  0x678610FE, 0xE8FCB06E, 0x27AB979C, 0xAB96963C, 0x34D189D1, 0xC47F3ED,
     0xE66F4ACB, 0x208968DB, 0x6F1F870D, 0x971DFF3E, 0x8A337B18, 0x81E73387, 0xD0F97569, 0xA9A249A1},
    {0xF71FA74C, 0xE5C604CB, 0xF513F47C, 0x699BCA23, 0xC38FC3E5, 0x112DFA5F, 0x8F159C6C, 0x43ACB05A,
     0xB1ACDE9B, 0x803FE0E9, 0xCBFAB342, 0x43F9B9FC, 0x1E291196, 0x83C22252, 0xA6AE148E, 0xDB5D74D0,
     0x3C46D723, 0x7B16B426, 0xA977018C, 0xF287E075, 0xDAAFAED8, 0x7544B5F0, 0xDB7BB206, 0x9009DEF0},
    {0x9E7F7861, 0xE0E0E2D3, 0xACB578F,  0x13684DD,  0xD4DCB98C, 0x2360654E, 0xA4C21617, 0x9649D09D,
     0xE749D536, 0xA1939904, 0xCE3823C2, 0x76879A6B, 0x8E6F7280, 0x96B69B29, 0xDC420F63, 0x852A4C1A,
     0x838EA317, 0x2518DF7B, 0x2BF15801, 0x2E7E65EA, 0x88890CD,  0xEDC053E,  0xA87101F4, 0x2377E9A},
    {0x12777CA,  0x7F05BD26, 0xFF9123D2, 0x75A1C1A7, 0xF954965D, 0x8E6C2E01, 0x64AF40DC, 0xB03A22FB,
     0xF18D73B2, 0x5F101829, 0x9290C0A,  0xB799646B, 0x6A596680, 0xC88F816C, 0x6528A4B9, 0x2A69F684,
     0x70A4BC92, 0xF93D9555, 0x7C2C861D, 0x6BA3CD0B, 0x94C3C735, 0xADC4E0F6, 0xC94A9238, 0x528153B1},
    {0x6D839ED2, 0x33CCC214, 0x4DF5ECB5, 0xD2BB6462, 0x1D3F17FB, 0xEA8ACCB9, 0xC01921A, 0x92A0AE83,
     0xD1E4F4F6, 0xDAA91C71, 0xC4677910, 0xB5E30DDC, 0xF95AE781, 0xDF689E97, 0xF34570,  0xEC73D7E1,
     0x5C4CE1C6, 0x793FE89,  0x9BFD8140, 0x4B0C2C1F, 0x6DDEE25,  0x91257D71, 0xD084EE8, 0x741589E7},
    {0xDDECEABA, 0xC7101775, 0xFDF93451, 0xE88F9EA4, 0xBF653E9E, 0xBD1CD6F1, 0x2E0105C4, 0x50833766,
     0xACB4F808, 0xD0FBB0B6, 0x436FEBB5, 0x7523896A, 0xAB3DBB6D, 0x62C6258A, 0xCF1B1493, 0xF8A00E6D,
     0x3C7D04F1, 0xE228F945, 0x5524BC1C, 0xF23FB3FC, 0x30B4D505, 0xDFBE5F56, 0xA3D23DFC, 0xF837776C},
    {0xF4D950A8, 0xFB65CA33, 0x886AEF5D, 0x6973BB1B, 0x2F279F2F, 0x248B142B, 0x85DA66E9, 0x9C4C9F6A,
     0x2347FA42, 0x26E7BA32, 0xB873482A, 0x41D3B71B, 0x1591DB2E, 0xD3978B94, 0xBF590D25, 0xB5F1C868,
     0x70E40AA3, 0x906380EB, 0x560EA724, 0x77259C98, 0x1F80F536, 0x76D56792, 0xDD7C018F, 0x8C89D006},
    {0xBF638A86, 0x4605A5AB, 0x46ACC6D1, 0xB8059A0A, 0x7FD993CC, 0xDF0C3A84, 0xDA52E8B9, 0xA3AAB325,
     0x4D3129E3, 0xAAD6BA54, 0x2FC6FB36, 0x6EF5D62D, 0x23EBC5D4, 0x8A2DAFF,  0x2B6FC914, 0xE6F14504,
     0x6E06D42D, 0x8B79CE31, 0x69B28AE6, 0xD366F382, 0x6BFBF911, 0x85876C8B, 0x94A1185E, 0x62CF667E},
    {0xAE7741DB, 0x62505BBD, 0x4218E4E0, 0x5F018CB2, 0x65885842, 0x770F1A3B, 0x499D5EF0, 0xD6055881,
     0x9C6B17A4, 0x2EC01C66, 0x31C617FA, 0xFA933C86, 0x300ED58E, 0xA9E6E29,  0x4ADF9870, 0x4EF59B9F,
     0x3A4D52CF, 0x8EA7CE69, 0xC99279B6, 0xD8E40076, 0xFFCDC5CF, 0x7EE1C9ED, 0x14DE1228, 0xA96D91B1},
    {0x23F976DD, 0x2F0C7CF5, 0xC674CB9F, 0x9125DD3B, 0xB3118519, 0x8962830D, 0x97CB11B4, 0x9F9FF940,
     0xF8E1A962, 0xB7D564D0, 0xFF281CF7, 0x63092881, 0xC3CC696,  0x5D06F994, 0x26CDDE7C, 0xDE612F15,
     0x7C704C8E, 0x2C2E9299, 0x7E1D4822, 0xF1755DAC, 0x6F57A1F6, 0xBA040536, 0x262B4B13, 0xD9A34AF4},
    {0x95676E56, 0x5F66E059, 0x5BA87E74, 0x1AE4F2C9, 0x3BFEBC63, 0x3FB2CB48, 0x4270B346, 0x6A773B96,
     0xE2A8F231, 0xF6541134, 0x91E10D2E, 0x5CE1AC98, 0x8C000319, 0xD86FCC1F, 0x525DE0D0, 0x1FE9CDCE,
     0x5C0B61EC, 0xA3559B1A, 0xAD4BED5,  0xDE700F5,  0x5BD797AF, 0x6A8685EA, 0xCD1741D7, 0xA9C95DF4},
    {0x6BAC7D17, 0x6B336CB,  0xAACD5F71, 0x453F155,  0x69F70B9C, 0xA887A414, 0x62D9A496, 0x7F79CE88,
     0x6B660584, 0xA2FFBAB3, 0xB49F6E96, 0xF9FBE3EF, 0xD4835BB1, 0xB5F0AB07, 0x4DB32FB9, 0x8670B22C,
     0x4F141A13, 0xABED1A,   0x62855163, 0x697730ED, 0x4249E20C, 0x47471C77, 0xEC738625, 0xD3284046},
    {0xAF18D2C4, 0x852861B2, 0x4FDB0491, 0x6B2F8F0,  0xDDE7827D, 0x99D50275, 0xC532C3C2, 0x4F1632B0,
     0xC4D802BB, 0xB8880569, 0xD6F11286, 0xF57D4619, 0x6C8DB1D7, 0xBF1963EC, 0x355136EB, 0x47195BF3,
     0xC41B5758, 0xDADF480D, 0xF8855633, 0xEA0EFA2C, 0xF0C555D4, 0x6C1B20BD, 0xC23EEEB0, 0x2D2B0992},
    {0xF9C36608, 0x9C7F1467, 0x1F8BB4C9, 0xF57FA40,  0xD96559F4, 0xB8741871, 0x67437678, 0x89C8268C,
     0xF2E646D1, 0xA00D0A75, 0x398BB23F, 0x897041BA, 0xE5C9EF50, 0x14376083, 0x1F2AD9FC, 0x6C66788,
     0x46C30C40, 0x84DEF833, 0x805454B8, 0x3577DE73, 0x86546F5,  0x5FB37557, 0xCDC3AD8F, 0xDF69DED3},
    {0x6F0C60A6, 0xB3C7AB08, 0x3E781B4A, 0xB2868503, 0x49237467, 0x18B3CC01, 0xF83BF15E, 0x1962C4B9,
     0x9C4D820C, 0xBD967041, 0x6A5B781A, 0x6531EE31, 0xFC6D3604, 0xCBD62882, 0xC0447420, 0x52938AF,
     0x5E3EF9C6, 0xC6ED2176, 0x8D7032CF, 0x686D122B, 0x4D18E1C2, 0x90AB8E78, 0x68513175, 0xF8B2C03D},
    {0xF62526F9, 0xE7AD2486, 0x42A7B5CC, 0x57701B11, 0x6302EED4, 0x4E3FDA25, 0xC3389BB4, 0xBA0B9F10,
     0xACA1C49A, 0xACAEF40D, 0x13329DC6, 0x3ECD8150, 0x596E08FC, 0x71F8E70D, 0x767E77B4, 0x4D9137F2,
     0xF5FBCACD, 0x6CFA08FB, 0xB8679669, 0xAEA19416, 0xCBA459D6, 0x21786BA4, 0x1B8BFA7E, 0x5B9A381E},
    {0xD4EFD2E,  0x6C72B131, 0xA8D86052, 0x4AFAE078, 0xE1E99FD6, 0x8058F6CC, 0xFE5430A6, 0x1D5CBAD3,
     0xC83DE317, 0x69F9250B, 0x96B15407, 0xAD1169EA, 0x7ED6E813, 0x8560E077, 0xDA72CDB8, 0x7D1CFC80,
     0xCA84052C, 0x3656322C, 0x7E6B807F, 0xD25A7AD9, 0xA6F376E5, 0xD93A5B7,  0xFC9DF691, 0x305E6551},
    {0xF21B6741, 0x8E31010D, 0x9228E71A, 0xCD320466, 0x4BFECAE6, 0xEFDEA8A2, 0x6273CE46, 0x81963E24,
     0xC14F5A27, 0x1222C68F, 0x9616DF4C, 0x1793D6AF, 0xACB941D5, 0x8DE0DD62, 0x41E2E4C7, 0xFA95D8F5,
     0x94DD1D8A, 0x348A2DE9, 0x1C92E045, 0x994592C6, 0x493D791B, 0x13956C70, 0x5227,     0x14383DB7},
    {0xF62BA223, 0x6F3781B0, 0x480DC106, 0x2534AD4E, 0xB0C59551, 0x3B095822, 0x3D46637C, 0x6F4B38AB,
     0x56A9B910, 0x24BB9529, 0x443138E4, 0x7041273A, 0x2C4D730E, 0x81DBF472, 0xD0442AA5, 0x62911D5B,
     0xFAA823CE, 0x8154F79B, 0x2011C69F, 0xC73A8F23, 0x86DA1BAC, 0xBD2C362E, 0xB9E72F8B, 0xED2ADAC3},
    {0x2ACD7805, 0x8E1BE931, 0x6226E04,  0x335DCCFE, 0xFDA5C6F6, 0xEC455F0D, 0x6894F6F0, 0x7AB08AED,
     0x9A27DE28, 0x8A07BE9A, 0x9EFE5654, 0x8B7F25C8, 0x9F83763F, 0xA78686FB, 0xC21084B0, 0xD9343396,
     0xB3A35037, 0xBF5CF752, 0xAC78AD99, 0xF4E50883, 0xE62BC01E, 0x10B81A45, 0x7A94C6E5, 0x6A45C0F4},
    {0x7D0F5870, 0xD18FB551, 0xDFA94F2,  0xDD5F2897, 0xA308FF69, 0x90F42ED0, 0xD1220A2A, 0x5B55FFF2,
     0x9996174B, 0xCFDD7D11, 0x93C9E964, 0xABA1B1AF, 0xDA8D2CEA, 0xE942E285, 0x6559C40E, 0xE1C8D437,
     0x674F3860, 0xAA64D1F6, 0xE73BB923, 0xA0C3F1E0, 0x5951A677, 0xD63A9411, 0x76D81BB2, 0xF754CB97},
    {0x22EDE4FF, 0x9F6470E,  0x62FD6361, 0xD8EEDF71, 0x1A122BCE, 0xFBF063B7, 0x70026AA6, 0x8A87519F,
     0xC1BBC284, 0xBE0747F6, 0x2F32C8FF, 0x607D4A6,  0xDD9BDD32, 0x6D491706, 0x7CB5E592, 0xCF5C0548,
     0xDA85C904, 0x6E0C4565, 0xDD3EB24A, 0x2D396685, 0x5B4E8C43, 0x91D6914F, 0x830F26E6, 0xFEC4C176},
    {0x1CF19539, 0x3EDED50C, 0x66E22B69, 0x8AC4CFEC, 0xBC6C9283, 0x40239265, 0x69AA20B9, 0x3E556478,
     0x936F676,  0x8F82F06A, 0x3D4E1C2B, 0x3ECAA2E5, 0x3AF78B00, 0x2F119F2C, 0xE09C6B45, 0xE4FC6B47,
     0xFFC5FE93, 0x1A4FA73D, 0x441A4FE4, 0x988525BD, 0xBFFFC0FB, 0xD5A1B167, 0x8A950E68, 0x3192DDF8},
    {0xBF9A858E, 0x76C9F35E, 0xDD22ABE3, 0x78DA8DC5, 0xE6C18F2,  0x11C04BA6, 0x3F218142, 0x1BD577B1,
     0x91CC0456, 0x324C143D, 0x57EFFA75, 0x3802E409, 0xE23B9BBB, 0x1D64C70E, 0x2D9CD669, 0xA39DD9AD,
     0x25742816, 0x4D7AD491, 0xA1093175, 0x11090A80, 0xBD69282C, 0x8474361C, 0x36A0A710, 0x81224FD0},
    {0xE6A41F45, 0xA7B8DE68, 0xEB324E40, 0xF245A4D0, 0xC216A0A4, 0x48979FAA, 0x6290DA94, 0xDB7A35B0,
     0xC13C9DB0, 0xEE60BB9D, 0x64719BC2, 0xFA62F067, 0x334767B9, 0xD9351A45, 0xDC3D57DA, 0x762EDDAD,
     0x8A8F9540, 0xAC2F978D, 0x7AD2EC6B, 0x149F1063, 0xAB4320DF, 0xC0453360, 0x4571FC4F, 0x6D435954},
    {0x82D6CA87, 0x9BF8A933, 0x97FBFDC0, 0x67CAD3E7, 0xAB053DCA, 0x204633A3, 0x9ABF2534, 0xBD72E9B3,
     0x2BF7965B, 0x59B8E11C, 0xABFECAF6, 0xD0BA288,  0x69118CE3, 0xE2E7F0DC, 0x3490077B, 0xB123CC92,
     0xB9E313ED, 0xEBF39115, 0xC0B7E5B8, 0x73D66914, 0x39D177C2, 0x7609FF63, 0xC48609F5, 0xE3EFFBDD},
    {0x4BB8810F, 0xB5BD2370, 0x95D093AD, 0x68E1081C, 0xCCCF179F, 0xAC456EF6, 0x2A0458FF, 0xC06F276,
     0x97665844, 0x178E80C7, 0x8A78C593, 0x26183AD7, 0xABC3FC06, 0x4828681B, 0x85A79DB1, 0xE7888028,
     0xC4753519, 0x296DD97E, 0x69F16E36, 0x176C4D6F, 0x15A68BAB, 0xC3DE7E20, 0x60E3B7F,  0x427C4548},
    {0x52F0A774, 0xC340B58E, 0x4DC90681, 0x82733C76, 0x7AC51889, 0x1D0E0379, 0x2FBBF10B, 0xAE7F8133,
     0xDD4201FD, 0xC257A4E5, 0xAA4742DA, 0x8945B1AE, 0xFD0C2C74, 0x101C17C7, 0xA4340024, 0x987667E1,
     0xF98929DC, 0xFC355DE2, 0xEAD95747, 0x42103E62, 0x71E4C4A9, 0xEBC2DEE5, 0x3F89711B, 0x85F0EB4},
    {0xB6CE9723, 0xBA6D7804, 0xF93FBC25, 0x45FC682B, 0x67061DFF, 0x6C772765, 0xBECAA713, 0x2EB8C69C,
     0x4D079F65, 0x7E811DD3, 0x53E8BE76, 0xBF6CBC55, 0xFECC3EE6, 0xBEFC4097, 0x73B4CD6E, 0xF4F5E957,
     0x1DFDEFF8, 0xE1EA96C7, 0x777A804C, 0x6BC8C75E, 0x9AA2F2C,  0xAB10E398, 0x101FF06B, 0xEA07AA57},
    {0x9206D6B1, 0x4542B50B, 0x8FF9CF47, 0x92C80BE6, 0x730F505A, 0xBB265BF5, 0x1A7636E9, 0x51DC407,
     0x8B0858D9, 0x5A4BB9BD, 0x777A3708, 0x394BB723, 0xED22A398, 0xDE01620B, 0x20D60CBC, 0xC7F40726,
     0x354947DE, 0xD970812E, 0xA974FB73, 0x30697575, 0x4B0F936E, 0x18222F95, 0xAD3D0A94, 0x6F0E9B18},
    {0x830DA879, 0x8F07FE7,  0x8BDAD311, 0xB0B86BE6, 0x633CFB3,  0xF3C745A7, 0x56C39AC8, 0xA4CDEF4C,
     0xCCCFAB13, 0xBD5F0B2F, 0x40FD3139, 0xF7D51579, 0xF9BF185C, 0xC5AA0784, 0xC28A1531, 0xF787A080,
     0xAF096487, 0x1996126B, 0x7D9A64AC, 0x5D8C3BAB, 0xB425B73,  0x196C5A8,  0xB2EF636A, 0xAA3DAA1A},
    {0x7727194E, 0x606132DD, 0xA8259C5F, 0x8892249,  0xA2ECAAE,  0x34FB602C, 0x6434AB2F, 0x462CC61B,
     0x7AD69AF9, 0x62A009A9, 0x8A86777E, 0x895DFCC6, 0xB1B3E00E, 0xA55A4F86, 0xB3990B24, 0xFAFBC289,
     0xAD2C03FB, 0xE826059,  0x988137CA, 0xD28C7249, 0xBA76482C, 0x1A1500A1, 0x217576A3, 0x4A805520},
    {0x738DD032, 0xE9885217, 0x61E97605, 0xC2C75090, 0x7B2BD454, 0x86812BDF, 0x8E54CD4F, 0x731C7A9A,
     0x8ACA0F7A, 0xFCB204F3, 0xE0CC1E0A, 0x77AD7231, 0x83B5D75C, 0x2B21100,  0x723FDDD7, 0x8F210C57,
     0x10A0B4BC, 0x39DA95B,  0xAC0DD841, 0x759295BC, 0x2A1B236E, 0xCD009C53, 0x39375EE3, 0x6551CBDC},
    {0xF514A884, 0x65D5E7CB, 0x6F20361E, 0x567EA13,  0x3FA71964, 0x659D332,  0x2760F1C5, 0xE0A20588,
     0x7A699348, 0x9424E05B, 0x80418598, 0xE6C9B69D, 0x5F3E1C06, 0x68147107, 0xE93532DD, 0x8836D978,
     0x6C11D2B8, 0x5E3F7CDE, 0xECF7F5A1, 0x212B3FC1, 0xE44026EF, 0x89C017EC, 0x8B2C5B35, 0xE0CBEA38},
    {0x3DFD6F7F, 0xE99F7FB0, 0xA37937E2, 0xF8B39D19, 0x2F2CE3BC, 0x9C1793AA, 0x1219B340, 0xC533C864,
     0x9DD34513, 0x3F4A242F, 0x566882B9, 0x16CB009F, 0xB674EB83, 0x60AA2A4E, 0x9165CAB6, 0x866BF474,
     0xA0A33A84, 0xEE321F8C, 0xA6927079, 0x7C6C3C7B, 0xB8CC9BCA, 0xB280B926, 0x654BED08, 0xA7DD55B4},
    {0xD8A2B111, 0x278EC52D, 0xAC15E767, 0xABEBEB56, 0x64979021, 0xE0D641D5, 0xBD462A10, 0x5345DE83,
     0x527E7A5B, 0xFA3286F,  0x9CB85047, 0x4F7FA89F, 0x9224BFCB, 0x20732CF2, 0xB5E42CD4, 0x5DA9C415,
     0x59941B36, 0xE69BE344, 0x273F3336, 0xEEBDE1D6, 0x1478A930, 0x6F697511, 0x8D9B2190, 0xEAD3B2BE},
    {0x4252E2E3, 0xB033AF80, 0x92BCC745, 0x5266BCF7, 0xA09F7A91, 0x2D70350E, 0x16933E74, 0x863F35BE,
     0x43E6B735, 0xCAE3DEAA, 0x440E45DD, 0x130B3F5A, 0x6A43026F, 0xF8B52F73, 0xB8B634C,  0x202BDDD,
     0x778EDB68, 0x7D94869D, 0x3D87FBA2, 0x721B0A7B, 0x6C0AFCC2, 0x9EF5CAE1, 0x931C462,  0x7DAC392E},
    {0x9FC8DE0B, 0xCBFAF09F, 0x2C0AEB8A, 0x23379BD8, 0x2735CAC9, 0x738BA7CE, 0x8692C8EA, 0xF3D9621D,
     0xFD81316A, 0xB1B13F0A, 0xB55D754F, 0x6DDAEEA3, 0xA278A166, 0x7BAB923,  0x8542953D, 0x84C23252,
     0xCF8CC3DB, 0x8C625B6F, 0x323A52C,  0x78AA457F, 0xCDEF52AB, 0xF5215C6E, 0xBF7767E6, 0x906BA176},
    {0xAA784AB3, 0x88CE6834, 0x67556335, 0xC81BB7D9, 0x882ECB9E, 0xCBCBACAD, 0xD723B43F, 0x992C6C46,
     0xB3619123, 0x332DFFE1, 0xE6CBB04F, 0x29286EA7, 0xD227A3B5, 0xE4E7708C, 0x1709A4B,  0x527B92F5,
     0xF8A0847E, 0xA22E335E, 0x7EFA9AE3, 0x7BEC9C4A, 0x751F45C4, 0x193BFEEB, 0xE4D2E6B6, 0xA7997340},
    {0x342E6E12, 0xCB7B5B63, 0x8F383D66, 0x76785819, 0x352F7558, 0x2D9CDEA9, 0xDE39C344, 0xF14F646B,
     0x9D11E9E5, 0x92C66403, 0x46F82912, 0x48F9CDDD, 0xD4E86FA7, 0xDE2FBD66, 0x86973893, 0x7BC6D569,
     0xAACA1032, 0x8D4C0A9F, 0xDB4E4E92, 0xB0BC17A3, 0xCF41A614, 0x7F7D46A8, 0xB440C780, 0xC7B0CFFF},
    {0xC117447A, 0x3569DB23, 0x36CF6D5A, 0xB1085340, 0xBF08EE47, 0x1633C358, 0x2CA7E1E7, 0x659854A9,
     0xD2F7ADC6, 0xAE065922, 0x51E9AED5, 0x513A8D0F, 0x6EC50B8D, 0xD496E66B, 0xDA7911C0, 0x8153809C,
     0xC30C7C0A, 0x9178A1DE, 0x58AB88F2, 0x4A20AC07, 0x88564FC0, 0x6FD4BDC0, 0xBE1931D0, 0x58E81E96},
    {0x74970AD4, 0x1C944C28, 0x9479C192, 0x41176E56, 0x47AED322, 0x135B0977, 0x1ECAA2E9, 0x4673E242,
     0x3AF32227, 0x2F56E73,  0x77191476, 0xB30BBB48, 0x575B2220, 0x25D4BF9E, 0xC078205D, 0x33AAB7E8,
     0x278B2484, 0xC70D3C3B, 0x7AD59D6,  0x8F74159A, 0x61D5E808, 0xFC47612C, 0x2B8526A8, 0x98C74DB},
    {0xD1D3A1EA, 0x4CF31DD,  0xB5E8FF8A, 0xD3BF5109, 0xCDB06786, 0x8F3DFFF1, 0x60C03E54, 0x8950FD95,
     0xBC9FD7C3, 0xDB70BCAB, 0x8BFD20F8, 0x3067DC2D, 0x8348885C, 0x51D5B94C, 0x54AE441C, 0xA0008399,
     0xE5A3FF51, 0xBD173181, 0x65E518DB, 0xD4B3EFFE, 0xF0D532BD, 0x34B1249A, 0xA2CC8650, 0x96143482},
    {0x7C912511, 0x13F9D8A7, 0x192AA87A, 0x2EFC7006, 0x4CE93A6C, 0xB115EEC6, 0x568F3E55, 0x81D093E8,
     0xC3F18E8E, 0xED98A567, 0x4D447092, 0x24BB6078, 0x5EE7E63B, 0xF4A87D08, 0x6299F44C, 0xFA0A9BFF,
     0x6C0214CC, 0x1A7473C2, 0x22090263, 0x54E19E4,  0x2F91B80C, 0xE5925BFD, 0xE686289E, 0xE51EB545},
    {0xFF9DAC43, 0x487CD543, 0xBF837D2F, 0xD733EB16, 0xBC6E4101, 0x1285EC5A, 0x66FC64FF, 0x5570A113,
     0x8E4067CC, 0xDA6CFC5F, 0xACBCD057, 0x81A36B7E, 0xA2F923E2, 0xE18B836A, 0x2FD57435, 0xC950F079,
     0x32CC670E, 0x53D57C54, 0xD9ABC46C, 0x2BF88347, 0xEE777D21, 0x74560A1D, 0x937A4945, 0xC340A8A5},
    {0xCDD8CC9F, 0xD38E298E, 0xDF447221, 0x9523488E, 0xBABD6E89, 0xAD41B21,  0x2E386E60, 0x9EDB0437,
     0x3370FDEE, 0xA4E0004,  0xDC3CAA3E, 0xE68A8CDC, 0xAA87AA4,  0xF5DE6261, 0x15B4B656, 0x57E4EB46,
     0xCCBEC5DB, 0xDDDAFBC7, 0xE7004A07, 0x6D781820, 0x3C9C67D7, 0xE0383F82, 0x27278607, 0x2D739041},
    {0x1A18F9B6, 0xBF5FC05E, 0x263EA04A, 0xAD1FFA11, 0x8A146432, 0xEC68B2B1, 0x46B49250, 0x3DA2607,
     0x2CCCB9E0, 0xC5818CE2, 0x33B38A53, 0xCD5673F1, 0xD6553056, 0x1E7DF565, 0x424843BF, 0x6FD22FCD,
     0x4046FAFA, 0x30BF7590, 0x797F9254, 0xF60B5F9C, 0xEB7D1B60, 0xB3E913EA, 0xCE3F3C16, 0x95722500},
    {0x61C1F554, 0xC7ED9C5E, 0x7B6536A6, 0x624E24DE, 0x91B32637, 0xCA0F5456, 0xE37F6C7F, 0xEEEA548D,
     0x2B25DE5D, 0xCDC14FD8, 0xF13651FA, 0xC6112667, 0xD640763E, 0x2753AFB2, 0xCDA48C23, 0xDFF1F648,
     0x7B2B9089, 0x5FEAB28,  0x75529C29, 0xE37639AC, 0x80E341EA, 0xEA85F991, 0xAE1B367D, 0x3A6D1737},
    {0xD202559A, 0x3CF2B82F, 0x1A17CC54, 0x6C82CDA,  0x404F4301, 0x1B3D56D,  0xA18CACE5, 0x69E417E,
     0xA28801E4, 0x7B0D92B8, 0x40641ED6, 0xF657C52C, 0x5C5A878E, 0x9060FCC0, 0xA508B68A, 0xFF14F691,
     0x74E5B081, 0x8CF182FE, 0x8435EC50, 0x5E113500, 0xCD358D95, 0xF854AA5E, 0x9BDB702B, 0x31D24FCC},
    {0xF9D73510, 0xEB9EC5C2, 0x25E4E277, 0x58290EB1, 0x27136D2D, 0x6CBC6BC2, 0x94DCB786, 0x4D1077D1,
     0x780CF95A, 0xC1F4B767, 0x3789BCD8, 0xFAB92611, 0x5393F642, 0xF62FE8ED, 0x1E12637C, 0xE5FB4D30,
     0xDCE28F2E, 0x71CBB0CB, 0xD585452E, 0x4A39E1A4, 0xD65924A2, 0xB495E919, 0xF9F4CD1C, 0x78398E03},
    {0xCB79D3EF, 0xCF8EA2A5, 0xCB8A58FB, 0x636974AE, 0x5F6B199E, 0x6A7BA6D8, 0xE7DE431B, 0x86B7608A,
     0xE8AB9770, 0x5DA4DBC4, 0x9B1505C1, 0x608FCA93, 0xFF03157E, 0x158D3F50, 0x3C37B2A0, 0xBF1930B1,
     0x7F46C8EB, 0xD8198B4E, 0x8C078DCF, 0x1415F759, 0xDE1832E9, 0xFC6C0C3,  0x13113608, 0x4D97C1AB},
    {0x2BCC7E19, 0x35E337E3, 0xE3CB6525, 0xF969986E, 0x707C31CD, 0xB4C812F5, 0xAB15BD12, 0xA6B94E88,
     0xB07846B7, 0x433E8388, 0xCAE0B804, 0xCE985FC2, 0xD9D989E6, 0x2E91DC8C, 0x5254F3DD, 0xD056FF65,
     0x9D048AE1, 0x9A81A829, 0x7EB86E01, 0xCF6DA698, 0x3459A15B, 0x722E509E, 0x7E873FE6, 0x72EA4BA8},
    {0x937C9DF7, 0x9B3EC4C6, 0x1E043F4D, 0x9FA7C4B2, 0x50173612, 0x34DDE736, 0x5FD4A38D, 0x19ED90BD,
     0xBEBEB69C, 0x942B957A, 0xAD61132B, 0x72E61A25, 0x64F4A54A, 0x5E09DB63, 0xB5F588C6, 0x511F574C,
     0xBBE96B75, 0x70D6E353, 0xB7D0BABB, 0x6E351E46, 0x36F34B6D, 0x93240AC7, 0x46878BC5, 0xC5DB37BA},
    {0xCF7F4B93, 0x228E37B3, 0xA4D6C125, 0x2ACEC697, 0xF6C6C87,  0x2F422C9D, 0x31436F4D, 0xD044EFDF,
     0xFCB78396, 0x4DB51D3,  0xC7F62029, 0x7410B173, 0xBAE13EC2, 0x473F84BB, 0xD4BB46A,  0x5ABD3405,
     0xB2746A4E, 0xBED7667C, 0x414D1994, 0xC03E7A1A, 0xB464BC7C, 0xB8FB6BA5, 0xFAE9EE82, 0xD6D03E71},
    {0xD476E261, 0xB7B1816E, 0x733565D1, 0xC0F92E2F, 0x372ECA95, 0x7D3E93B8, 0xDB8FC051, 0xC6D5DD26,
     0xC2066169, 0x2E3EC3AA, 0x5048297D, 0xC0443DFC, 0xF37EAA8F, 0x7199B123, 0x60FB1F40, 0x1096E511,
     0xA7246877, 0xE77C6CB2, 0x99610590, 0xB0339FE0, 0x37CEA6E4, 0x3951230C, 0xC73D0670, 0xD9A8003F},
    {0x507F66CB, 0xFD78E7EE, 0x29758E7C, 0xE20078BE, 0xE8181921, 0xDE8C69F4, 0x84D313BC, 0x629181CC,
     0x6A59E9BB, 0xA9ABABBE, 0x7C196DBA, 0xD6E499AE, 0x5232E980, 0xA6700995, 0x2E44AB8F, 0xC31EDA3A,
     0xDC01C056, 0xD8E1CFA0, 0x3C4FF949, 0x5AAC34B0, 0x419AB9B5, 0x13006A28, 0xAFA1908C, 0xC4E1F13C}};

#endif /* __TEST_ECDOUBLEMUL_H */
