/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*${header:start}*/
#include "pin_mux.h"
#include "board.h"
#include <stdbool.h>
/*${header:end}*/

void BOARD_InitClocks(void)
{

    /* 32MHz clock */
    CLOCK_EnableClock(kCLOCK_Fro32M);       // derived from 198MHz FRO

    /* 32KHz clock */
    CLOCK_EnableClock(kCLOCK_Fro32k);      // isnt' strictly required but put for clarity
    //CLOCK_EnableClock(kCLOCK_Xtal32k);

    CLOCK_EnableClock(kCLOCK_Iocon);
    CLOCK_EnableClock(kCLOCK_InputMux);

    /* Enable GPIO for LED controls */
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* INMUX and IOCON are used by many apps, enable both INMUX and IOCON clock bits here. */
    CLOCK_AttachClk(kOSC32M_to_USART_CLK);

    CLOCK_EnableClock(kCLOCK_Aes);
    CLOCK_EnableClock(kCLOCK_I2c0) ;
    CLOCK_AttachClk(kOSC32M_to_I2C_CLK);
    CLOCK_AttachClk(kMAIN_CLK_to_DMI_CLK);

    CLOCK_EnableAPBBridge();
    SYSCON->DMICCLKDIV=0;
    CLOCK_SetClkDiv(kCLOCK_DivClkout, 1, false);

    CLOCK_EnableClock(kCLOCK_Xtal32M);
    /* WWDT clock config (32k oscillator, no division) */
    CLOCK_AttachClk(kOSC32M_to_WDT_CLK);
    CLOCK_SetClkDiv(kCLOCK_DivWdtClk, 1000, true);
}

/*${function:start}*/
void BOARD_InitHardware(void)
{
#if 0
	/* Security code to allow debug access */
	SYSCON->CODESECURITYPROT = 0x87654320;
#if 0
	/* Allow debug access in firewall */
	FIREWALL->UPDATE_VALUE = 0x80000005;
	FIREWALL->UPDATE_SETTING = 0x7 << 8;

	/* Allow DMA access */
	FIREWALL->UPDATE_VALUE = 0xa000f733;  // Modification allowed
										  // Enable
										  // Debug
										  // SCPU xrw
										  // CPU xrw
										  // SecDMA rw
										  // DMA rw
	FIREWALL->UPDATE_SETTING = (0x04 << 8) | 0;
	FIREWALL->UPDATE_VALUE = 0xa000f733;  // Modification allowed
										  // Enable
										  // Debug
										  // SCPU xrw
										  // CPU xrw
										  // SecDMA rw
										  // DMA rw
	FIREWALL->UPDATE_SETTING = (0x04 << 8) | 1;
#endif
	/* attach clock for USART(debug console) */
    CLOCK_AttachClk(BOARD_DEBUG_UART_CLK_ATTACH);

    /* reset FLEXCOMM for USART */
    RESET_PeripheralReset(kFC0_RST_SHIFT_RSTn);

    BOARD_BootClockRUN();
    BOARD_InitDebugConsole();
    BOARD_InitPins();
#endif


    /* Security code to allow debug access */
    SYSCON->CODESECURITYPROT = 0x87654320;

    /* Configure the optimized active voltages, set up the BODs */
    POWER_Init();

    /* reset FLEXCOMM for USART - mandatory from power down 4 at least*/
    RESET_PeripheralReset(kUSART0_RST_SHIFT_RSTn);
    RESET_PeripheralReset(kGPIO0_RST_SHIFT_RSTn);
    RESET_PeripheralReset(kI2C0_RST_SHIFT_RSTn );
    /* For power optimization, we need a limited clock enabling specific to this application
     * This replaces BOARD_BootClockRUN() usually called in other application    */
    BOARD_InitClocks();
    BOARD_InitDebugConsole();
    BOARD_InitPins();

}
/*${function:end}*/
