/****************************************************************************
 *
 * MODULE:
 *
 * DESCRIPTION:
 *
 */
/****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164,
 * JN5161, JN5148, JN5142, JN5139].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2016. All rights reserved
 *
 ***************************************************************************/
#ifndef COMMAND_H_INCLUDED
#define COMMAND_H_INCLUDED

#if defined __cplusplus
extern "C" {
#endif

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
#include <jendefs.h>

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/


#define DEFAULT_CHANNEL				16
#define DEFAULT_TX_POWER_dBm		10

typedef enum
{
	E_CMD_ID_PING = 0x00,				 //0
	E_CMD_ID_ACK, 						 //1
	E_CMD_ID_SET_CHANNEL,				 //2
	E_CMD_ID_OBSOLETE1,					 //3
	E_CMD_ID_OBSOLETE2,         		 //4
	E_CMD_ID_SET_POWER,					 //5
	E_CMD_ID_GET_POWER,					 //6
	E_CMD_ID_GET_POWER_RESPONSE,		 //7
	E_CMD_ID_DUMMY8,					 //8
	E_CMD_ID_STREAM,					 //9
	E_CMD_ID_START_RX_TEST,				 //A
	E_CMD_ID_END_RX_TEST,				 //B
	E_CMD_ID_RX_REPORT,					 //C
	E_CMD_ID_REBOOT,					 //D
	E_CMD_ID_OBSOLETE3,			         //E
	E_CMD_ID_OBSOLETE4,	 		         //F
	E_CMD_ID_GET_REBOOT_BYTE_RESPONSE,	 //10
	E_CMD_ID_GET_HW_VERSION,			 //11
	E_CMD_ID_GET_HW_VERSION_RESPONSE,	 //12
	E_CMD_ID_GET_SW_VERSION,			 //13
	E_CMD_ID_GET_SW_VERSION_RESPONSE,	 //14
}teCommandId;
/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/
PUBLIC void vCommand_Task(bool_t bRxPoll);
PUBLIC void vCommand_SendChannel(uint32 u32ChannelMask);
PUBLIC void vCommand_StartModulatedWaveTx(uint16 u16Periodms);
PUBLIC void vCommand_Transmit(uint8 u8Id, uint8 u8Len, const uint8 *pu8Payload);
PUBLIC void vCommand_ResetCounters(void );

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

#if defined __cplusplus
}
#endif

#endif /* COMMAND_H_INCLUDED */

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
