/****************************************************************************
 *
 * MODULE:
 *
 * DESCRIPTION:
 *
 */
/****************************************************************************
 *
 * This software is owned by NXP B.V. and/or its supplier and is protected
 * under applicable copyright laws. All rights are reserved. We grant You,
 * and any third parties, a license to use this software solely and
 * exclusively on NXP products [NXP Microcontrollers such as JN5168, JN5164,
 * JN5161, JN5148, JN5142, JN5139].
 * You, and any third parties must reproduce the copyright and warranty notice
 * and any other legend of ownership on each copy or partial copy of the
 * software.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Copyright NXP B.V. 2016. All rights reserved
 *
 ****************************************************************************/
/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
#include <jendefs.h>
#include "CRC.h"

/****************************************************************************/
/***        Macro Definitions                                             ***/
/****************************************************************************/

/****************************************************************************/
/***        Type Definitions                                              ***/
/****************************************************************************/
typedef uint16 crc;
typedef uint8 (*bit_order_8)(uint8);
typedef uint16 (*bit_order_16)(uint16);

/****************************************************************************/
/***        Local Function Prototypes                                     ***/
/****************************************************************************/
PRIVATE uint16 straight_16(uint16 value);
PRIVATE uint16 reverse_16(uint16 value);
PRIVATE uint8 straight_8(uint8 value);
PRIVATE uint8 reverse_8(uint8 value);
PRIVATE uint16 crc16(uint8 const *message, int nBytes, bit_order_8 data_order, bit_order_16 remainder_order, uint16 remainder, uint16 polynomial);

/****************************************************************************/
/***        Exported Variables                                            ***/
/****************************************************************************/

/****************************************************************************/
/***        Local Variables                                               ***/
/****************************************************************************/

/****************************************************************************/
/***        Exported Functions                                            ***/
/****************************************************************************/
/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PUBLIC uint16 crc16ccitt(uint8 const *message, int nBytes)
{
    return crc16(message, nBytes, straight_8, straight_16, 0xffff, 0x1021);
}

/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PUBLIC uint16 crc16ccitt_xmodem(uint8 const *message, int nBytes)
{
    return crc16(message, nBytes, straight_8, straight_16, 0x0000, 0x1021);
}

/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PUBLIC uint16 crc16ccitt_kermit(uint8 const *message, int nBytes)
{
    uint16 swap = crc16(message, nBytes, reverse_8, reverse_16, 0x0000, 0x1021);
    return swap << 8 | swap >> 8;
}

/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PUBLIC uint16 crc16ccitt_1d0f(uint8 const *message, int nBytes)
{
    return crc16(message, nBytes, straight_8, straight_16, 0x1d0f, 0x1021);
}

/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PUBLIC uint16 crc16ibm(uint8 const *message, int nBytes)
{
    return crc16(message, nBytes, reverse_8, reverse_16, 0x0000, 0x8005);
}

/****************************************************************************/
/***        Local Functions                                               ***/
/****************************************************************************/
/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PRIVATE uint16 straight_16(uint16 value)
{
    return value;
}

/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PRIVATE uint16 reverse_16(uint16 value)
{
    uint16 reversed = 0;
    int i;
    for (i = 0; i < 16; ++i)
    {
        reversed <<= 1;
        reversed |= value & 0x1;
        value >>= 1;
    }
    return reversed;
}

/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PRIVATE uint8 straight_8(uint8 value)
{
    return value;
}

/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PRIVATE uint8 reverse_8(uint8 value)
{
    uint8 reversed = 0;
    int i;
    for (i = 0; i < 8; ++i)
    {
        reversed <<= 1;
        reversed |= value & 0x1;
        value >>= 1;
    }
    return reversed;
}

/****************************************************************************
 *
 * NAME:
 *
 * DESCRIPTION:
 *
 * PARAMETERS:  Name    RW  Usage
 *
 * RETURNS:
 *
 ****************************************************************************/
PRIVATE uint16 crc16(uint8 const *message, int nBytes, bit_order_8 data_order, bit_order_16 remainder_order, uint16 remainder, uint16 polynomial)
{
	int byte;
    for (byte = 0; byte < nBytes; ++byte)
    {
        remainder ^= (data_order(message[byte]) << 8);
        uint8 bit;
        for (bit = 8; bit > 0; --bit)
        {
            if (remainder & 0x8000)
            {
                remainder = (remainder << 1) ^ polynomial;
            }
            else
            {
                remainder = (remainder << 1);
            }
        }
    }
    return remainder_order(remainder);
}

/****************************************************************************/
/***        END OF FILE                                                   ***/
/****************************************************************************/
