/*******************************************************************************
*
*  FREESCALE SEMICONDUCTOR INC. 2006
*  ALL RIGHTS RESERVED
*  COPYRIGHT (c)
*  
********************************************************************************
*                                                                      
*  DESCRIPTION:
*   CEA709 ETPU Function Set
*
********************************************************************************
*
*  REVISION HISTORY:
*                                                         
*  REVISION    AUTHOR       DATE         DESCRIPTION OF CHANGE                  
*  --------    -----------  ---------    ------------------------------------              
*  1.0         M. Princ     08/Jun/07    Initial version of file.
*******************************************************************************/ 

#include "etpuc_set_CEA709.h"

/**********************/
/* Define memory size */
/**********************/
#pragma memory ROM[MEMORY_SIZE - ((LAST_FUNCTION+1)*0x40) - 4] @ ((LAST_FUNCTION+1)*0x40);
#pragma memory LOCAL[0] @ 0x00;

/*******************************/
/* Define entry table location */
/*******************************/
/* Put entry table at the beginning of memory so that it is not
   dependent on memory size. */
#pragma ENTRYADDR 0x0000;

/*******************************************************************************
  GlobalError routine and global variable Global_Error
*******************************************************************************/
#ifdef GLOBAL_ERROR_FUNC

#include <etpuc.h>          /* Defines eTPU hardware */
#include <eTPUc_common.h>   /* Standard way to use eTPU */

int24 Global_Error = 0xFF;

void Global_Error_Func()
{
	ertb = chan;
	if (LinkServiceRequest == 1) ertb+=0x0100;
	if (MatchALatch == 1)  ertb+=0x0200;
	if (MatchBLatch == 1)  ertb+=0x0400;
	if (TransitionALatch == 1)  ertb+=0x0800;
	if (TransitionBLatch == 1)  ertb+=0x1000;

	Global_Error = ertb;
  ClearAllLatches();
}
#endif

/* CEA709  */
#include "etpuc_CEA709.c"

/************************************************************************
*  Output eTPU code image and information for CPU.
************************************************************************/
#pragma write h, (::ETPUfilename (etpu_set_CEA709.h));
#pragma write h, (/****************************************************************);
#pragma write h, ( * WARNING this file is automatically generated DO NOT EDIT IT! *);
#pragma write h, ( *                                                              *);
#pragma write h, ( * FILE NAME: etpu_set_CEA709.h    COPYRIGHT (c) Freescale 2006 *);
#pragma write h, ( *                                      All Rights Reserved     *);
#pragma write h, ( *                                                              *);
#pragma write h, ( * DESCRIPTION: eTPU CEA709 Functions - image file.             *);
#pragma write h, ( *                                                              *);
#pragma write h, ( * GENERATED BY: etpuc_CEA709.c                                 *);
#pragma write h, ( *                                                              *);
#pragma write h, ( ***************************************************************/);
#pragma write h, (#ifndef _ETPU_SET_CEA709_H_ );
#pragma write h, (#define _ETPU_SET_CEA709_H_ );
#pragma write h, ( );
#pragma write h, (#define FS_ETPU_ENTRY_TABLE ::ETPUentrybase);
#pragma write h, (#define FS_ETPU_MISC         ::ETPUmisc);
#pragma write h, ( );
#pragma write h, (const uint32_t etpu_globals[] = { ::ETPUglobalimage32 }; );
#pragma write h, ();
#pragma write h, (const uint32_t etpu_code[] = { ::ETPUcode32 }; );
#pragma write h, ();
#pragma write h, (/* List of functions: );
#pragma write h, (::ETPUnames);
#pragma write h, (*/);
#pragma write h, (#endif /* _ETPU_SET_CEA709_H_ */ );
#pragma write h, ( );

/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 ********************************************************************/
