/****************************************************************************************************/
/**
\file       PDB.h
\brief      
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010    
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef PDB_H_
#define PDB_H_

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "derivative.h"
#include "FslTypes.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
typedef struct tPDB
{
	UINT16 gu16Modulus;
	UINT16 gu16DelayA;
	UINT16* gu16PDBDelays;
	UINT16 gu16DACDelay;
	UINT16 gu16IntDelay;
	UINT8  gu8Status;
	UINT8  gu8TotalChannels;
};

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
extern struct tPDB sPDB;
/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
#define PDB_ONESHOT_MODE 	0
#define PDB_CONTINUOUS_MODE	1

#define PDB_TRG_COCOA		0
#define PDB_TRG_ACMP		PDBC1_TRIGSEL0_MASK
#define PDB_TRG_SOFTWARE	PDBC1_TRIGSEL_MASK

#define PDB_PSL_1	0
#define PDB_PSL_2	PDBC1_PRESCALER0_MASK
#define PDB_PSL_4	PDBC1_PRESCALER1_MASK
#define PDB_PSL_8	PDBC1_PRESCALER1_MASK | PDBC1_PRESCALER0_MASK
#define PDB_PSL_16	PDBC1_PRESCALER2_MASK
#define PDB_PSL_32	PDBC1_PRESCALER2_MASK | PDBC1_PRESCALER0_MASK
#define PDB_PSL_64	PDBC1_PRESCALER2_MASK | PDBC1_PRESCALER1_MASK
#define PDB_PSL_128	PDBC1_PRESCALER2_MASK | PDBC1_PRESCALER1_MASK | PDBC1_PRESCALER0_MASK

#define PDB_INTERRUPT_EVENT 	EVENT(sPDB.gu8Status,0)
#define PDB_INTERRUPT_CLEAR 	CLEAR(sPDB.gu8Status,0)
#define PDB_INTERRUPT			COMPARE(sPDB.gu8Status,0)

#define PDB_TRIGGER		PDBC2_SWTRIG = 1

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
void vfnPDBInit (void);
void vfnPDBConfig (UINT8 u8Mode);
void vfnPDBFillBuffer (UINT16 *u16NewData);
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* PDB_H_ */

