/****************************************************************************************************/
/**
\file       OPAMP.h
\brief      
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010    
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef OPAMP_H_
#define OPAMP_H_

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "derivative.h"
#include "FslTypes.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
typedef struct tOPAMP
{
	UINT8 gu8Mode;
	UINT8 gu8Gain;
	UINT8 gu8PositiveInput;
	UINT8 gu8NegativeInput;
};
/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/


#define OPAMP_BUFFER_MODE	0
#define OPAMP_GP_MODE		GPAMP1C0_MODE1_MASK
#define OPAMP_INV_MODE		GPAMP1C0_MODE0_MASK
#define OPAMP_NINV_MODE		GPAMP1C0_MODE1_MASK | GPAMP1C0_MODE0_MASK

#define OPAMP_INV_3		GPAMP1C1_AMPRF0_MASK
#define OPAMP_INV_5		GPAMP1C1_AMPRF1_MASK
#define OPAMP_INV_8		GPAMP1C1_AMPRF0_MASK | GPAMP1C1_AMPRF0_MASK
#define OPAMP_INV_12	GPAMP1C1_AMPRF2_MASK
#define OPAMP_INV_16	GPAMP1C1_AMPRF2_MASK | GPAMP1C1_AMPRF0_MASK
#define OPAMP_INV_1		GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF0_MASK
#define OPAMP_INV_2		GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF1_MASK
#define OPAMP_INV_7D2	GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF1_MASK | GPAMP1C1_AMPRF0_MASK
#define OPAMP_INV_11D2	GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF2_MASK
#define OPAMP_INV_15D2	GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF2_MASK | GPAMP1C1_AMPRF0_MASK

#define OPAMP_NINV_4	GPAMP1C1_AMPRF0_MASK
#define OPAMP_NINV_6	GPAMP1C1_AMPRF1_MASK
#define OPAMP_NINV_9	GPAMP1C1_AMPRF1_MASK | GPAMP1C1_AMPRF0_MASK
#define OPAMP_NINV_13	GPAMP1C1_AMPRF2_MASK
#define OPAMP_NINV_17	GPAMP1C1_AMPRF2_MASK | GPAMP1C1_AMPRF0_MASK
#define OPAMP_NINV_2	GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF0_MASK
#define OPAMP_NINV_3	GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF1_MASK
#define OPAMP_NINV_9D2	GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF1_MASK | GPAMP1C1_AMPRF0_MASK
#define OPAMP_NINV_13D2	GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF2_MASK
#define OPAMP_NINV_17D2	GPAMP1C1_AMPRI0_MASK | GPAMP1C1_AMPRF2_MASK | GPAMP1C1_AMPRF0_MASK

#define OPAMP_PI_PAD	0
#define OPAMP_PI_OUT0	GPAMP1C2_AMPPSEL0_MASK
#define OPAMP_PI_OUT1	GPAMP1C2_AMPPSEL1_MASK
#define OPAMP_PI_DAC5	GPAMP1C2_AMPPSEL2_MASK
#define OPAMP_PI_DAC12	GPAMP1C2_AMPPSEL2_MASK | GPAMP1C2_AMPPSEL0_MASK
#define OPAMP_PI_VDD	GPAMP1C2_AMPPSEL2_MASK | GPAMP1C2_AMPPSEL1_MASK
#define OPAMP_PI_VSS	GPAMP1C2_AMPPSEL2_MASK | GPAMP1C2_AMPPSEL1_MASK | GPAMP1C2_AMPPSEL0_MASK

#define OPAMP_NI_PAD	0
#define OPAMP_NI_OUT0	GPAMP1C2_AMPNSEL0_MASK
#define OPAMP_NI_OUT1	GPAMP1C2_AMPNSEL1_MASK
#define OPAMP_NI_DAC5	GPAMP1C2_AMPNSEL2_MASK
#define OPAMP_NI_DAC12	GPAMP1C2_AMPNSEL2_MASK | GPAMP1C2_AMPNSEL0_MASK
#define OPAMP_NI_VDD	GPAMP1C2_AMPNSEL2_MASK | GPAMP1C2_AMPNSEL1_MASK
#define OPAMP_NI_VSS	GPAMP1C2_AMPNSEL2_MASK | GPAMP1C2_AMPNSEL1_MASK | GPAMP1C2_AMPNSEL0_MASK

#define OPAMP0	0
#define OPAMP1	1


/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
void vfnOPAMPInit (void);
void vfnOPAMPConfig (UINT8 u8OPAMPNumber);
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* OPAMP_H_ */

