/****************************************************************************************************/
/**
\file       DAC.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date			  June 2010      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "DAC.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
UINT8 gu8DACStatus;
/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
const UINT8 gu8DACConfig1 = DAC_TOP_INTERRUPT;
const UINT8 gu8DACConfig2 = DAC_NORMAL_MODE | DAC_WATERMARK_1;
/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/
/****************************************************************************************************/
/**
* \brief  Fills the Data buffer (DACDATx) for the output   
* \author Freescale Semiconductor
* \author Technical Information Center (TIC)
* \param  void
* \return void
* \warning The u8DataSize should be amount of words (16 bit data)
* \todo     
*/
/****************************************************************************************************/
void vfnDACFillBuffer (void)
{
	DACDAT0  = 812;
	DACDAT1  = 796;
	DACDAT2  = 772;
	DACDAT3  = 744;
	DACDAT4  = 716;
	DACDAT5  = 692;
	DACDAT6  = 676;
	DACDAT7  = 670;
	DACDAT8  = 676;
	DACDAT9  = 692;
	DACDAT10 = 716;
	DACDAT11 = 744;
	DACDAT12 = 772;
	DACDAT13 = 796;
	DACDAT14 = 812;
	DACDAT15 = 818;	

}
/****************************************************************************************************/
/**
* \brief  Initialize the DAC module    
* \author Freescale Semiconductor
* \author Technical Information Center (TIC)
* \param  UINT8 u8DACC0Parameters - Interrupt flag source
* \param  UINT8 u8DACC1Parameters - Buffered mode and Watermark
* \return void
* \todo     
*/
/****************************************************************************************************/
void vfnDACInit(UINT8 u8DACC0Parameters, UINT8 u8DACC1Parameters)
{
   
    DACS = 0x00;    /** Clear the status register since one of the flags is set on POR */
    
   // DACC0 |= (DACC0_DACRFS_MASK | DACC0_DACTSEL_MASK | u8DACC0Parameters);
    DACC0 |= (DACC0_DACTSEL_MASK | u8DACC0Parameters);
            /** Default configuration */
            /** DACRFS = External Reference */
            /** DACTSEL = SW Trigger */
            /** LPEN = Low Power */
            /** The interrupt source is selected with u8DACC0Parameters */             
   
    DACC1 |= u8DACC1Parameters; 
    
    DACC0 |= DACC0_DACEN_MASK; 
}

/****************************************************************************************************/
/**
* \brief  Set the pointers on the buffer for the output  
* \author Freescale Semiconductor
* \author Technical Information Center (TIC)
* \param  UINT8 u8ReadPosition - Position for the read pointer
* \param  UINT8 u8UpperPosition - Position for the top pointer
* \return void
* \todo     
*/
/****************************************************************************************************/
void vfnDACSetPointer(UINT8 u8ReadPosition, UINT8 u8UpperPosition)
{
    DACC2_DACBFRP = u8ReadPosition;    
    
    DACC2_DACBFUP = u8UpperPosition;
}

/****************************************************************************************************/
/**
* \brief  Interrupt service of the DAC module  
* \author Freescale Semiconductor
* \author Technical Information Center (TIC)
* \param  void
* \return void
* \todo     
*/
/****************************************************************************************************/

__interrupt VectorNumber_Vdac void DACISR (void)
{
                    
    gu8DACStatus = DACS;    /* Backup the flags, the main application should look     */ 
                              /* for the one that is interested on                      */
    DACS = 0x00;    /* Clear the flags */
}
/****************************************************************************************************/


__interrupt VectorNumber_Vtpm1ovf void TPMISR (void)
{
    (void)TPM1SC;
    TPM1SC_TOF = 0;
      
    DAC_TRIGGER; 
}

