/****************************************************************************************************/
/**
\file       Display.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010	        
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	  */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	  */
/* product.                                                                                      	  */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "Display.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/
void vfn16bitsToASCII (UINT16 lu16HexData, UINT8* pu8Buffer);
void vfn8bitsToASCII (UINT8 lu8HexData, UINT8* pu8Buffer);
/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/

UINT8 au8ByteGraphicFormat[14];
UINT8 au8WordGraphicFormat[21];



/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
UINT8 au8ByteFormatLetters[] = {'W','Z','Y','X'};
/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief Creates the ASCII format array that needs and sends the information through the SCI
* \param  UINT8* --> Pointer to array that contains the values to be plotted     
* \return   
* \todo     
*/
/****************************************************************************************************/
void vfnGraphicBytes (UINT8* lpu8ByteValues)
{
	UINT8* lpu8ByteFormat = &au8ByteGraphicFormat[0];
	UINT8* lpu8ByteLetters = (UINT8 *)(&au8ByteFormatLetters[0]);
	UINT8 lu8Counter = 4;
	
		while (lu8Counter--)
		{
			*lpu8ByteFormat = *lpu8ByteLetters;
			lpu8ByteFormat++;
			lpu8ByteLetters ++;
			vfn8bitsToASCII (*lpu8ByteValues, lpu8ByteFormat);
			lpu8ByteFormat += 2;
			lpu8ByteValues ++;
		}
		*lpu8ByteFormat = 0x0D;
		lpu8ByteFormat++;
		*lpu8ByteFormat = 0x0A;
		
		vfnSCITxMsg(&au8ByteGraphicFormat[0], sizeof(au8ByteGraphicFormat)); 
}

/****************************************************************************************************/
/**
* \brief Creates the ASCII format array that needs and sends the information through the SCI
* \param  UINT8* --> Pointer to array that contains the values to be plotted     
* \return   
* \todo     
*/
/****************************************************************************************************/
void vfnGraphicWords (UINT16* lpu16WordValues)
{
	UINT8* lpu8WordFormat = &au8WordGraphicFormat[0];
	UINT8 lu8Counter = 4;
	
		while (lu8Counter--)
		{
			vfn16bitsToASCII (*lpu16WordValues, lpu8WordFormat);
			lpu8WordFormat += 4;
			lpu16WordValues ++;
			*lpu8WordFormat = ':';
			lpu8WordFormat++;
		}
		lpu8WordFormat--;
		*lpu8WordFormat = 0x0D;
		lpu8WordFormat++;
		*lpu8WordFormat = 0x0A;
		
		vfnSCITxMsg(&au8WordGraphicFormat[0], sizeof(au8WordGraphicFormat)); 
}

/****************************************************************************************************/
/**
* \brief Converts a 8-bit hexadecimal value to an ASCII array 	
* \param  UINT8  lu8HexData --> u8 to be converted
* 		  UINT8* Buffer --> Pointer to the array address that stores the result of the conversion      
* \return   
* \todo     
*/
/****************************************************************************************************/
void vfn8bitsToASCII (UINT8 lu8HexData, UINT8* pu8Buffer)
{
	UINT8 lu8Counter = 2;
	
	*pu8Buffer = ((lu8HexData & 0xF0) >> 4);
	pu8Buffer ++;
	*pu8Buffer = (lu8HexData & 0x0F);
	
	pu8Buffer --;
	do
	{
		if (*pu8Buffer < 10)
		{
			*pu8Buffer += '0';
		}
		else
		{
			*pu8Buffer -= 10;
			*pu8Buffer += 'A';
		}
		pu8Buffer ++;		
	}while (--lu8Counter);	
}

/****************************************************************************************************/
/**
* \brief Converts a 16-bit hexadecimal value to an ASCII array 	
* \param  UINT16 lu16HexData --> u16 to be converted
* 		  UINT8* Buffer --> Pointer to the array address that stores the result of the conversion      
* \return   
* \todo     
*/

/****************************************************************************************************/
void vfn16bitsToASCII (UINT16 lu16HexData, UINT8* pu8Buffer)
{
  UINT8 lu8Counter=4;	
	
	*pu8Buffer = ((lu16HexData & 0xF000) >> FOURTH_NIBBLE);
	pu8Buffer ++;
	*pu8Buffer = ((lu16HexData & 0x0F00) >> THIRD_NIBBLE);
	pu8Buffer ++;
	*pu8Buffer = ((lu16HexData & 0x00F0) >> SECOND_NIBBLE);
	pu8Buffer ++;
	*pu8Buffer = (lu16HexData & 0x000F);
	
	pu8Buffer -= 3;
	do
	{
		if (*pu8Buffer < 10)
		{
			*pu8Buffer += '0';
		}
		else
		{
			*pu8Buffer -= 10;
			*pu8Buffer += 'A';
		}
		pu8Buffer ++;		
	}while (--lu8Counter);
}
