/****************************************************************************************************/
/**
\file       DAC.h
\brief      
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010    
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef DAC_H_
#define DAC_H_

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "derivative.h"
#include "FslTypes.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
typedef enum
{
    DACV1_BOTTOM_FLAG = 0,
    DACV1_TOP_FLAG,
    DACV1_WATERMARK_FLAG 
    
}eDACV1InterruptFlags;
/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
extern UINT8 gu8DACStatus;

extern const UINT8 gu8DACConfig1;
extern const UINT8 gu8DACConfig2;
/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/

/*----------------------- gu8DACConfig1 ------------------------------------------------------------*/
/** Voltage Reference */
#define DAC_REFVOLT_VREF	0
#define DAC_REFVOLT_VEXT	DACC0_DACRFS_MASK
/** DAC input trigger */
#define DAC_TSEL_HW			0
#define DAC_TSEL_SW			DACC0_DACTSEL_MASK
/** Interrupts */
#define DAC_BOTTOM_INTERRUPT  	DACC0_DACBIE_MASK
#define DAC_TOP_INTERRUPT       DACC0_DACTIE_MASK
#define DAC_WATERMARK_INTERRUPT DACC0_DACWIE_MASK
/*--------------------------------------------------------------------------------------------------*/

/*----------------------- gu8DACConfig1 ------------------------------------------------------------*/
/** Buffer Mode */
#define DAC_NOT_BUFFERED      0
#define DAC_NORMAL_MODE       DACC1_DACBFE_MASK
#define DAC_SWING_MODE        DACC1_DACBFE_MASK | DACC1_DACBFMD0_MASK
#define DAC_ONE_SCAN_MODE     DACC1_DACBFE_MASK | DACC1_DACBFMD1_MASK
/** Watermark selection */
#define DAC_WATERMARK_1   	0
#define DAC_WATERMARK_2   	DACC1_DACBFWM0_MASK
#define DAC_WATERMARK_3   	DACC1_DACBFWM1_MASK
#define DAC_WATERMARK_4   	DACC1_DACBFWM0_MASK | DACC1_DACBFWM0_MASK | DACC1_DACBFE_MASK
/*--------------------------------------------------------------------------------------------------*/

#define DAC_TRIGGER (DACC0_DACSTRG = 1)
#define DAC_INTERRUPT_OCCUR     (gu8DACStatus)
/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
void vfnDACFillBuffer (void);
void vfnDACInit(UINT8 u8DACC0Parameters, UINT8 u8DACC1Parameters);
void vfnDACSetPointer (UINT8 u8ReadPosition, UINT8 u8UpperPosition);
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* DAC_H_ */

