/*
 * Timer.h
 *
 *  Created on: Jan 18, 2016
 *      Author: B55840
 */

#ifndef TIMER_H_
#define TIMER_H_

/**********************************************************************************************
* Macros
**********************************************************************************************/
#define TIM0 0
#define TIM1 1

/**********************************************************************************************
* Types
**********************************************************************************************/
typedef enum{
	TIM_IC_INT_EN,
	TIM_IC_INT_DIS,
	TIM_OC_INT_EN,
	TIM_OC_INT_DIS
} TIM_CONFIG;

typedef enum{
	bus_clk_div_1,
	bus_clk_div_2,
	bus_clk_div_4,
	bus_clk_div_8,
	bus_clk_div_16,
	bus_clk_div_32,
	bus_clk_div_64,
	bus_clk_div_256
} TIM_frequency;

typedef enum{
	TIM_IC_CAP_DIS,
	TIM_IC_CAP_RIS,
	TIM_IC_CAP_FALL,
	TIM_IC_CAP_ANY
} TIM_IC_MODE;


/**********************************************************************************************
* Public functions 
**********************************************************************************************/
/* General timer functions */
void TIM_init(unsigned char TIM_select, TIM_frequency bus_divider_selection);
void TIM_channel_config(unsigned char TIM_select, unsigned char channel_select, TIM_CONFIG channel_configuration);
void TIM_run(unsigned char TIM_select);
unsigned int TIM_get_time(unsigned int TIM_select);
unsigned char TIM_OF_status(unsigned char TIM_select);

/* Output compare functions */
void TIM_OC_set_compare(unsigned char TIM_select, unsigned char channel_select, unsigned int compare_time);
unsigned char TIM_OC_flag_status(unsigned char TIM_select, unsigned char channel_select);

/* Input capture functions */
void TIM_IC_capture_config(unsigned char TIM_select, unsigned char channel_select,TIM_IC_MODE input_capture_mode);
unsigned char TIM_IC_flag_status(unsigned char TIM_select, unsigned char channel_select);

/*callback function*/
void TIM0_set_CH0_callback(void (*ptr)(unsigned int));
void TIM0_set_CH1_callback(void (*ptr)(unsigned int));
void TIM1_set_CH0_callback(void (*ptr)(unsigned int));
void TIM1_set_CH1_callback(void (*ptr)(unsigned int));


#endif /* TIMER_H_ */
