*********************************************************************************
*                                               Copyright (c) Freescale 2015    *
* File Name: MC33PT20000_VFM_65V_6C_EOI_DIAG.dfi                                *
* Current Revision: 1.0                                                         *
* Purpose: PT2000 example - 1 Bank diagnostic + End of Injection + Peak and hold*
*                                                                               *
* REV  AUTHOR           DATE             DESCRIPTION OF CHANGE                  *
* ---  ------           --------         ---------------------                  *
* 1.0  Pierre Calmes    2015/03/19       - initial coding                       *
*********************************************************************************

*********************************************************************************
* Freescale reserves  the right to make  changes without  further notice to any *
* product herein to improve  reliability, function,  or design.  Freescale does *
* not  assume  any  liability  arising  out of  the application  or use  of any *
* product, circuit,  or software described herein;  neither does  it convey any *
* license under its patent rights nor the rights of others.  Freescale products *
* are not designed, intended,  or authorized for use as  components  in systems *
* intended for  surgical implant into the body,  or other applications intended *
* to support life,  or for any other  application  in which the failure  of the *
* Freescale product could create a situation where  personal injury or death may*
* occur.  Should Buyer purchase or use Freescale products for any such intended *
* or unauthorized  application,  Buyer shall indemnify and  hold  Freescale and *
* its officers, employees, subsidiaries, affiliates,  and distributors harmless *
* against all claims costs, damages, and expenses, and reasonable attorney  fees*
* arising  out of,  directly or indirectly,  any claim  of personal  injury  or *
* death  associated  with  such unintended  or unauthorized use,  even if  such *
* claim  alleges  that  Freescale   was  negligent   regarding   the  design  or*
* manufacture  of the part.  Freescale and the  Freescale logo  are registered  *
* trademarks of Freescale Ltd.                                                  *
*********************************************************************************

#define HSBatB3   hs5 ;
#define HSBoostB3 hs6 ;
#define LS1B3     ls5 ;
#define LS2B3     ls6 ;

*cur3 for uCore0
*ucore1 not used

#include "dram2.def";

*################## STATUS REGISTER ##############
* This bit must be set to 1 if the Iboost current is never reached during the boost phase
#define BoostErrorBit0 b5;
* This bit must be set to 1 the sequencer is currently executing the Automatic interrupt routine
#define AutoIrqBit0 b6;
* This bit must be set to 1 the sequencer is currently executing the Idle Diag interrupt routine
#define IdleIrqBit0 b7;
* This bit must be set to 1 if start pin stays high longer than 10ms
#define HoldErrorBit0 b8;
* The followings are the status bits of the 2 injectors 
* Bit = 1 => last actuation not completed correctly
* Bit = 0 => no problems during last actuation
#define Inj5FaultBit b0;  *uc0
#define Inj6FaultBit b1;  *uc0



*################## FLAGS ##############
* This flag is sent to the DCDC sequencer. It must be active for the whole period the boost voltage is used
* When the boost voltage is used, the DCDC must be deactivated
* flag = 0 => boost voltage is used, DCDC must be deactivated
* flag = 1 => boost voltage not used, DCDC can be active
#define BstFlag b0;



*################## CONTROL REGISTER ##############
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define AutoDiagResetBit0 b6;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define IdleDiagResetBit0 b7;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define BoostResetBit0 b5;
* During the interrupt routine, the sequencer wait for this bit to be set to '1' before resuming execution of application code
#define HoldResetBit0 b8;



*################## ALU registers  ################
#define IRQ_stat_Reg0 r0;


*********************************************************************************************************            
*                                        AUTOMATIC and SOFTWARE INTERRUPT                               *            
********************************************************************************************************* 
irq_detected:   stos off off off;                       * Disable drivers
                endiaga diagoff;                        * Disable automatic diagnostic
                stirq low;                              * Set low the IRQB pin
                stf high BstFlag;                       * Set flag0 high to release the DC-DC converter idle mode

                
*######################## Check which injector was interrupted          ################################

check_inj0:   joslr MarkInj5 start5;               * the last active injector was number 5
              joslr MarkInj6 start6;               * the last active injector was number 6
              jmpr check_irq;                      * jump to restore


*######################## Report fault to status register for the injector interrupted #########################
MarkInj5:     stsrb high Inj5FaultBit;             * mark the injector 5 as fault
              jmpr check_irq;
MarkInj6:     stsrb high Inj6FaultBit;             * mark the injector 6 as fault
              jmpr check_irq;


*######### Check which interrupt occurred BoostErr 0 or Idle Diag Fail 1 or Automatic Diagnostics #################
check_irq:      cp irq IRQ_stat_Reg0;                    * copy the irq status registers to a temp ALU reg
                                                        * This register contains also the sw irq ID
                                                        
*######### Check if its auto or sw interrupt        ##############################################
                ldirh 10h rst;                          * load MSB in ir reg: 0x1000 in immediate register, to use as mask for irq status                                        
                and IRQ_stat_Reg0;                      * extract the irq source from irq status register (bits 12)
                jarr auto_waitEnable0 all0;             * if the irq source is 0 => Automatic Diagnostics detected
                                                        * Else => a software interrupt occured go to next line
                
*######### Check which sw interrupt occured       ##############################################                
                cp irq IRQ_stat_Reg0;                    * copy the irq status registers to a temp ALU reg
                ldirh 0Ch rst;                          * load MSB in ir reg: 0x0C00 in immediate register, to use as mask for irq status                                        
                and IRQ_stat_Reg0;                       * extract the sw id from irq status register (bits 11-10)
                jarr Boost_waitEN0 all0;                 * if the sw id is 0 => Iboost never reached => go to Boost_waitEN
                                                        * Else => error detected in idle diag=> go to next line => seq stuck until micro write 1 in control register b8                                                        

                                                        
                ldirh 08h rst;                          * load MSB in ir reg: 0x0800 in immediate register, to use as mask for irq status  
                and IRQ_stat_Reg0;                      * extract the sw id from irq status register (bits 11-10)
                jarr Idle_waitEnable0 all0;             * if the sw id is 0 => Means IRQ = b01 => Idle diagnostics fails
                                                        * Else => Hold error => go to next line => idle diag fail                                                      

                                                        
Hold_waitEN0:   jcrr Hold_waitEN0 HoldResetBit0 low;      * Wait here until control bit register b4 is write to 1   
                jmpr restore0;
                
Idle_waitEnable0: jcrr Idle_waitEnable0 IdleDiagResetBit0 low;* Wait here until control bit register b7 is write to 1 
                jmpr restore0;
 
auto_waitEnable0: stsrb high AutoIrqBit0;                  * Set status register bit 6 when automatic diagnosis interrupt trig
                jcrr auto_waitEnable0 AutoDiagResetBit0 low;  * the sequencer is stuck here until the bit of the control register is set to '1' b6          
                jmpr restore0;                               * Jump to restore               
                
Boost_waitEN0:  jcrr Boost_waitEN0 BoostResetBit0 low;    * Wait here until control bit register b5 is write to 1

                   
                
restore0:       stirq high;                             * Set high IRQB pin
                rstreg all;                             * Reset a) control registers
                                                        *       b) status regsiter
                                                        *       c) err_seq register (status of automatic diagnosis  
                                                        *       d) re-enables irq generation from automatic diagnosis
                iret restart rst;                       * Clear interrupt queue and restart from init phase


                
*********************************************************************************************************              
*********************************************************************************************************            
*                       This microcore uc0 will control BANK3                                           *
*                       High SIde Vbat = hs5                                                            *
*                       High SIde Vboost = hs6                                                          *
*                       Low side = ls5 and ls6                                                          *
*                       current sense = cur3                                                            *
*********************************************************************************************************            
*********************************************************************************************************                
                
*********************************************************************************************************            
*                                         INIT PHASE
********************************************************************************************************* 

* ### Initialization phase ###
init0:      stgn gain8.68 sssc;                     * Set the gain of the opamp of the current measure block 1 
            ldjr1 eoinj0;                           * Load the eoinj line label Code RAM address into the register jr1 
            ldjr2 idle0;                            * Load the idle line label Code RAM address into the register jr2
            sl56dac dac5;                           * Used for the measurement function dac5L will be used to detect threshold on OA3pin
            stirq high;
            cwef jr1 _start row1;                   * If the start signal goes low, go to eoinj phase       
            
*********************************************************************************************************            
*                                         IDLE PHASE                                                    *            
********************************************************************************************************* 
             
* ### Idle phase- the uPC loops here until start signal is present ###              
idle0:      stoc on sssc;
            cwer CheckStart start row2;
WaitLoop:   wait row2;                        * uPC is stuck here for almost the whole idle time
CheckStart: joslr inj5_start start5;
            joslr inj6_start start6;
            jmpr WaitLoop;
            
*********************************************************************************************************            
*                                         SHORTCUT DEFINITION                                           *            
********************************************************************************************************* 

* ### Shortcuts definition per the injector to be actuated ###
inj5_start: dfsct HSBatB3 LS1B3 HSBoostB3;              * Set the 3 shortcuts: VBAT, VBOOST, LS2
            dfcsct dac3;                                * use current feedback1
            stab 0;                                     * Set the base address to 0 for Injector 1
            jmpr idle_diag0;                            * Jump to launch phase
* ### Shortcuts definition per the injector to be actuated ###
inj6_start: dfsct HSBatB3 LS2B3 HSBoostB3;               * Set the 3 shortcuts: VBAT, VBOOST, LS2
            dfcsct dac3;                                * use current feedback1
            stab 10;                                     * Set the base address to 10 for Injector 2
            jmpr idle_diag0;                            * Jump to launch phase
            
*********************************************************************************************************            
*                                    PRE-ACTUATION DIAG PHASE                                           *            
********************************************************************************************************* 
* All Vds should be high due to bias
* All HSs Vsrc should be high as well
idle_diag0:     stoc off sssc;                          * Disable Offset Compensation
                bias all on;                            * Enable all biasing structures, kept ON even during actuation
                jocr idle_diag_fail0 _sc1v;             * Error detected if Vds of shortcut1 (HS) is low
                jocr idle_diag_fail0 _sc2v;             * Error detected if Vds of shortcut2 (LS) is low
                jocr idle_diag_fail0 _sc3v;             * Error detected if Vds of shortcut3 (Boost) is low
                jocr idle_diag_fail0 _sc1s;             * Error detected if Vsrc of shortcut1 (HS) is low
                jocr idle_diag_fail0 _sc3s;             * Error detected if Vsrc of shortcut3 (Boost) is low
                jmpr boostT0;                           * Jump to actuation phase if no failure detected in idle phase
               
idle_diag_fail0:stsrb high IdleIrqBit0;                 * IDle diag fail we set status b7 high to let user know which error occured
                reqi 1;                                 * Go to software subroutine is fault detected in idle phase HSBat error


*********************************************************************************************************            
*                                                 BOOST PHASE                                           *            
********************************************************************************************************* 

* ### Launch phase enable boost ###
boostT0:    load Iboost dac_sssc _ofs;                      * Load the boost phase current threshold in the current DAC
            ldcd rst _ofs keep keep injMaxTBoost c3;        * Start Boost Counter in case Iboost never reached
            ldcd rst _ofs keep keep injMinTBoost c2;        * Start Boost Counter in case Iboost is reached too fast
            stf low BstFlag;                                * Set flag0 high to stop the DC-DC converter 
            stos on on on;                                  * Turn VBAT off, BOOST on, LS on
            endiags on on on on;                            * Enable auto diag

            cwer boostT1 tc2 row5;                          * After injMinBoost go to Boost T2
            cwer boost_err0 ocur row2;                      * Jump to error in case current is reached before the end of injMinBoost
            wait row125;

boostT1:    cwer peak0 ocur row2;                           * Jump to peak phase when current is over threshold 
            cwer boost_err0 tc3 row5;                       * Define Wait Table if actuation longer than injMaxGuard go to eoinj 
            wait row125;
            
            
boost_err0: stf high BstFlag;                               * set flag0 high to release DCDC regulation
            reqi 0;                                         * Go to software subroutine is fault detected in Boost phase, did not reach Iboost on time 

*********************************************************************************************************            
*                                                 PEAK PHASE                                            *            
*********************************************************************************************************
* ### Peak phase continue on Vbat ###
peak0:      store cnt3 OpenInj_record ofs;          * Store opening time in the data in DRAM with offset to separate inj1 and 2
            ldcd rst _ofs keep keep Tpeak_tot c1;   * Load the length of the total peak phase in counter 1
            stos off on off;                        * Turn VBAT off, BOOST off, LS on
            load Ipeak dac_sssc _ofs;               * Load the peak current threshold in the current DAC
            stf high BstFlag;                       * set flag0 high to release the DC-DC converter idle mode
            cwer bypass0 tc1 row2;                  * Jump to bypass phase when tc1 reaches end of count
            cwer peak_on0 tc2 row3;                 * Jump to peak_on when tc2 reaches end of count
            cwer peak_off0 ocur row4;               * Jump to peak_off when current is over threshold
peak_init0: cwer peak_off0 _ocur row5;              * Jump to peak off when current is discharged
            wait row125; 
            

peak_off0:  ldcd rst _ofs keep keep Tpeak_off c2;   * Load in the counter 2 the length of the peak_off phase
            stos off on off;                        * Turn VBAT off, BOOST off, LS on
            wait row123;   
            
peak_on0:   stos on on off;                         * Turn VBAT on, BOOST off, LS on
            wait row124;                            * Wait for one of the previously defined conditions

*********************************************************************************************************            
*                                                 BYPASS PHASE                                          *            
********************************************************************************************************* 
            
* ### Bypass phase ###
bypass0:    ldcd rst _ofs keep keep Tbypass c3;      * Load in the counter 3 the length of the off_phase phase
            stos off off off;                       * Turn VBAT off, BOOST off, LS off
            cwer hold0 tc3 row4;                    * Jump to hold when tc3 reaches end of count
            wait row14;                             * Wait for one of the previously defined conditions

*********************************************************************************************************            
*                                                 HOLD PHASE                                            *            
********************************************************************************************************* 
            
* ### Hold phase on Vbat ###    
hold0:      ldcd rst _ofs keep keep Thold_tot c1;   * Load the length of the total hold phase in counter 2 
            load Ihold dac_sssc _ofs;               * Load the hold current threshold in the DAC
            cwer hold_error0 tc1 row2;                   * Jump to eoinj phase when tc1 reaches end of count
            cwer hold_on0 tc2 row3;                 * Jump to hold_on when tc2 reaches end of count
            cwer hold_off0 ocur row4;               * Jump to hold_off when current is over threshold

hold_off0:  ldcd rst _ofs keep keep Thold_off c2;   * Load the length of the hold_off phase in counter 2
            stos off on off;                        * Turn VBAT off, BOOST off, LS on
            wait row123;            
            
hold_on0:   stos on on off;                         * Turn VBAT on, BOOST off, LS on
            wait row124;                            * Wait for one of the previously defined conditions
            
hold_error0:stsrb high HoldErrorBit0;                * Start pin stays higher longer than 10ms 
            reqi 2;                                * If Start high is longer than Thold_tot go to sw interrupt

*********************************************************************************************************            
*                                     END OF INJECTION PHASE                                            *            
*********************************************************************************************************         

* ### End of injection phase ###
  
eoinj0:     stos off off off;                       * Turn VBAT off, BOOST off, LS off
            endiaga diagoff;                        * Disable auto diagoff
            stf high BstFlag;                       * set flag0 to high to release the DC-DC converter idle mode
            jmpf jr2;                               * Go back to idle mode

* ### End of Channel 2 - uCore0 code ###      




* ### CHANNEL2 UCORE1 #####   
* Code is only there to be able to use the dual flash Enable on SPIGEN
* User can add some other code in this channel, not used in this example
* This code is not needed if the bit dual sequencer is not set to 1
init1:  cp ir ir;
        cp ir ir;
        cp ir ir;
        jmpr init1;
        
        
        
        
